/* SPDX-License-Identifier: LGPL-2.1-or-later
 * This file is generated by src/include/override/sys/generate-syscall.py. Do not edit!
 *
 * Use 'ninja -C build update-syscall-tables' to download new syscall tables,
 * and 'ninja -C build update-syscall-header' to regenerate this file.
 *
 * To add a new architecture, extend the arch_list list in meson.build
 * and the template in generate-syscall.py and then run the above commands.
 */
#pragma once

#include_next <sys/syscall.h>

#ifdef ARCH_MIPS
#include <asm/sgidefs.h>
#endif

#include <assert.h>

/* Note: if this code looks strange, this is because it is derived from the same
 * template as the per-syscall blocks below. */
#  if defined(__aarch64__)
#  elif defined(__alpha__)
#  elif defined(__arc__) || defined(__tilegx__)
#  elif defined(__arm__)
#  elif defined(__i386__)
#  elif defined(__ia64__)
#  elif defined(__loongarch_lp64)
#  elif defined(__m68k__)
#  elif defined(_MIPS_SIM)
#    if _MIPS_SIM == _MIPS_SIM_ABI32
#    elif _MIPS_SIM == _MIPS_SIM_NABI32
#    elif _MIPS_SIM == _MIPS_SIM_ABI64
#    else
#      error "Unknown MIPS ABI"
#    endif
#  elif defined(__hppa__)
#  elif defined(__powerpc__)
#  elif defined(__riscv)
#    if __riscv_xlen == 32
#    elif __riscv_xlen == 64
#    else
#      error "Unknown RISC-V ABI"
#    endif
#  elif defined(__s390__)
#  elif defined(__sh__)
#  elif defined(__sparc__)
#  elif defined(__x86_64__)
#    if defined(__ILP32__)
#    else
#    endif
#  elif !defined(missing_arch_template)
#    warning "Current architecture is missing from the template"
#    define missing_arch_template 1
#  endif

#ifndef __IGNORE_close_range
#  if defined(__aarch64__)
#    define systemd_NR_close_range 436
#  elif defined(__alpha__)
#    define systemd_NR_close_range 546
#  elif defined(__arc__) || defined(__tilegx__)
#    define systemd_NR_close_range 436
#  elif defined(__arm__)
#    define systemd_NR_close_range 436
#  elif defined(__i386__)
#    define systemd_NR_close_range 436
#  elif defined(__ia64__)
#    define systemd_NR_close_range 1460
#  elif defined(__loongarch_lp64)
#    define systemd_NR_close_range 436
#  elif defined(__m68k__)
#    define systemd_NR_close_range 436
#  elif defined(_MIPS_SIM)
#    if _MIPS_SIM == _MIPS_SIM_ABI32
#      define systemd_NR_close_range 4436
#    elif _MIPS_SIM == _MIPS_SIM_NABI32
#      define systemd_NR_close_range 6436
#    elif _MIPS_SIM == _MIPS_SIM_ABI64
#      define systemd_NR_close_range 5436
#    else
#      error "Unknown MIPS ABI"
#    endif
#  elif defined(__hppa__)
#    define systemd_NR_close_range 436
#  elif defined(__powerpc__)
#    define systemd_NR_close_range 436
#  elif defined(__riscv)
#    if __riscv_xlen == 32
#      define systemd_NR_close_range 436
#    elif __riscv_xlen == 64
#      define systemd_NR_close_range 436
#    else
#      error "Unknown RISC-V ABI"
#    endif
#  elif defined(__s390__)
#    define systemd_NR_close_range 436
#  elif defined(__sh__)
#    define systemd_NR_close_range 436
#  elif defined(__sparc__)
#    define systemd_NR_close_range 436
#  elif defined(__x86_64__)
#    if defined(__ILP32__)
#      define systemd_NR_close_range (436 | /* __X32_SYSCALL_BIT */ 0x40000000)
#    else
#      define systemd_NR_close_range 436
#    endif
#  elif !defined(missing_arch_template)
#    warning "close_range() syscall number is unknown for your architecture"
#  endif

/* may be an (invalid) negative number due to libseccomp, see PR 13319 */
#  if defined __NR_close_range && __NR_close_range >= 0
#    if defined systemd_NR_close_range
static_assert(__NR_close_range == systemd_NR_close_range, "");
#    endif
#  else
#    if defined __NR_close_range
#      undef __NR_close_range
#    endif
#    if defined systemd_NR_close_range && systemd_NR_close_range >= 0
#      define __NR_close_range systemd_NR_close_range
#    endif
#  endif
#endif

#ifndef __IGNORE_fchmodat2
#  if defined(__aarch64__)
#    define systemd_NR_fchmodat2 452
#  elif defined(__alpha__)
#    define systemd_NR_fchmodat2 562
#  elif defined(__arc__) || defined(__tilegx__)
#    define systemd_NR_fchmodat2 452
#  elif defined(__arm__)
#    define systemd_NR_fchmodat2 452
#  elif defined(__i386__)
#    define systemd_NR_fchmodat2 452
#  elif defined(__ia64__)
#    define systemd_NR_fchmodat2 1476
#  elif defined(__loongarch_lp64)
#    define systemd_NR_fchmodat2 452
#  elif defined(__m68k__)
#    define systemd_NR_fchmodat2 452
#  elif defined(_MIPS_SIM)
#    if _MIPS_SIM == _MIPS_SIM_ABI32
#      define systemd_NR_fchmodat2 4452
#    elif _MIPS_SIM == _MIPS_SIM_NABI32
#      define systemd_NR_fchmodat2 6452
#    elif _MIPS_SIM == _MIPS_SIM_ABI64
#      define systemd_NR_fchmodat2 5452
#    else
#      error "Unknown MIPS ABI"
#    endif
#  elif defined(__hppa__)
#    define systemd_NR_fchmodat2 452
#  elif defined(__powerpc__)
#    define systemd_NR_fchmodat2 452
#  elif defined(__riscv)
#    if __riscv_xlen == 32
#      define systemd_NR_fchmodat2 452
#    elif __riscv_xlen == 64
#      define systemd_NR_fchmodat2 452
#    else
#      error "Unknown RISC-V ABI"
#    endif
#  elif defined(__s390__)
#    define systemd_NR_fchmodat2 452
#  elif defined(__sh__)
#    define systemd_NR_fchmodat2 452
#  elif defined(__sparc__)
#    define systemd_NR_fchmodat2 452
#  elif defined(__x86_64__)
#    if defined(__ILP32__)
#      define systemd_NR_fchmodat2 (452 | /* __X32_SYSCALL_BIT */ 0x40000000)
#    else
#      define systemd_NR_fchmodat2 452
#    endif
#  elif !defined(missing_arch_template)
#    warning "fchmodat2() syscall number is unknown for your architecture"
#  endif

/* may be an (invalid) negative number due to libseccomp, see PR 13319 */
#  if defined __NR_fchmodat2 && __NR_fchmodat2 >= 0
#    if defined systemd_NR_fchmodat2
static_assert(__NR_fchmodat2 == systemd_NR_fchmodat2, "");
#    endif
#  else
#    if defined __NR_fchmodat2
#      undef __NR_fchmodat2
#    endif
#    if defined systemd_NR_fchmodat2 && systemd_NR_fchmodat2 >= 0
#      define __NR_fchmodat2 systemd_NR_fchmodat2
#    endif
#  endif
#endif

#ifndef __IGNORE_mount_setattr
#  if defined(__aarch64__)
#    define systemd_NR_mount_setattr 442
#  elif defined(__alpha__)
#    define systemd_NR_mount_setattr 552
#  elif defined(__arc__) || defined(__tilegx__)
#    define systemd_NR_mount_setattr 442
#  elif defined(__arm__)
#    define systemd_NR_mount_setattr 442
#  elif defined(__i386__)
#    define systemd_NR_mount_setattr 442
#  elif defined(__ia64__)
#    define systemd_NR_mount_setattr 1466
#  elif defined(__loongarch_lp64)
#    define systemd_NR_mount_setattr 442
#  elif defined(__m68k__)
#    define systemd_NR_mount_setattr 442
#  elif defined(_MIPS_SIM)
#    if _MIPS_SIM == _MIPS_SIM_ABI32
#      define systemd_NR_mount_setattr 4442
#    elif _MIPS_SIM == _MIPS_SIM_NABI32
#      define systemd_NR_mount_setattr 6442
#    elif _MIPS_SIM == _MIPS_SIM_ABI64
#      define systemd_NR_mount_setattr 5442
#    else
#      error "Unknown MIPS ABI"
#    endif
#  elif defined(__hppa__)
#    define systemd_NR_mount_setattr 442
#  elif defined(__powerpc__)
#    define systemd_NR_mount_setattr 442
#  elif defined(__riscv)
#    if __riscv_xlen == 32
#      define systemd_NR_mount_setattr 442
#    elif __riscv_xlen == 64
#      define systemd_NR_mount_setattr 442
#    else
#      error "Unknown RISC-V ABI"
#    endif
#  elif defined(__s390__)
#    define systemd_NR_mount_setattr 442
#  elif defined(__sh__)
#    define systemd_NR_mount_setattr 442
#  elif defined(__sparc__)
#    define systemd_NR_mount_setattr 442
#  elif defined(__x86_64__)
#    if defined(__ILP32__)
#      define systemd_NR_mount_setattr (442 | /* __X32_SYSCALL_BIT */ 0x40000000)
#    else
#      define systemd_NR_mount_setattr 442
#    endif
#  elif !defined(missing_arch_template)
#    warning "mount_setattr() syscall number is unknown for your architecture"
#  endif

/* may be an (invalid) negative number due to libseccomp, see PR 13319 */
#  if defined __NR_mount_setattr && __NR_mount_setattr >= 0
#    if defined systemd_NR_mount_setattr
static_assert(__NR_mount_setattr == systemd_NR_mount_setattr, "");
#    endif
#  else
#    if defined __NR_mount_setattr
#      undef __NR_mount_setattr
#    endif
#    if defined systemd_NR_mount_setattr && systemd_NR_mount_setattr >= 0
#      define __NR_mount_setattr systemd_NR_mount_setattr
#    endif
#  endif
#endif

#ifndef __IGNORE_open_tree_attr
#  if defined(__aarch64__)
#    define systemd_NR_open_tree_attr 467
#  elif defined(__alpha__)
#    define systemd_NR_open_tree_attr 577
#  elif defined(__arc__) || defined(__tilegx__)
#    define systemd_NR_open_tree_attr 467
#  elif defined(__arm__)
#    define systemd_NR_open_tree_attr 467
#  elif defined(__i386__)
#    define systemd_NR_open_tree_attr 467
#  elif defined(__ia64__)
#    define systemd_NR_open_tree_attr -1
#  elif defined(__loongarch_lp64)
#    define systemd_NR_open_tree_attr 467
#  elif defined(__m68k__)
#    define systemd_NR_open_tree_attr 467
#  elif defined(_MIPS_SIM)
#    if _MIPS_SIM == _MIPS_SIM_ABI32
#      define systemd_NR_open_tree_attr 4467
#    elif _MIPS_SIM == _MIPS_SIM_NABI32
#      define systemd_NR_open_tree_attr 6467
#    elif _MIPS_SIM == _MIPS_SIM_ABI64
#      define systemd_NR_open_tree_attr 5467
#    else
#      error "Unknown MIPS ABI"
#    endif
#  elif defined(__hppa__)
#    define systemd_NR_open_tree_attr 467
#  elif defined(__powerpc__)
#    define systemd_NR_open_tree_attr 467
#  elif defined(__riscv)
#    if __riscv_xlen == 32
#      define systemd_NR_open_tree_attr 467
#    elif __riscv_xlen == 64
#      define systemd_NR_open_tree_attr 467
#    else
#      error "Unknown RISC-V ABI"
#    endif
#  elif defined(__s390__)
#    define systemd_NR_open_tree_attr 467
#  elif defined(__sh__)
#    define systemd_NR_open_tree_attr 467
#  elif defined(__sparc__)
#    define systemd_NR_open_tree_attr 467
#  elif defined(__x86_64__)
#    if defined(__ILP32__)
#      define systemd_NR_open_tree_attr (467 | /* __X32_SYSCALL_BIT */ 0x40000000)
#    else
#      define systemd_NR_open_tree_attr 467
#    endif
#  elif !defined(missing_arch_template)
#    warning "open_tree_attr() syscall number is unknown for your architecture"
#  endif

/* may be an (invalid) negative number due to libseccomp, see PR 13319 */
#  if defined __NR_open_tree_attr && __NR_open_tree_attr >= 0
#    if defined systemd_NR_open_tree_attr
static_assert(__NR_open_tree_attr == systemd_NR_open_tree_attr, "");
#    endif
#  else
#    if defined __NR_open_tree_attr
#      undef __NR_open_tree_attr
#    endif
#    if defined systemd_NR_open_tree_attr && systemd_NR_open_tree_attr >= 0
#      define __NR_open_tree_attr systemd_NR_open_tree_attr
#    endif
#  endif
#endif

#ifndef __IGNORE_openat2
#  if defined(__aarch64__)
#    define systemd_NR_openat2 437
#  elif defined(__alpha__)
#    define systemd_NR_openat2 547
#  elif defined(__arc__) || defined(__tilegx__)
#    define systemd_NR_openat2 437
#  elif defined(__arm__)
#    define systemd_NR_openat2 437
#  elif defined(__i386__)
#    define systemd_NR_openat2 437
#  elif defined(__ia64__)
#    define systemd_NR_openat2 1461
#  elif defined(__loongarch_lp64)
#    define systemd_NR_openat2 437
#  elif defined(__m68k__)
#    define systemd_NR_openat2 437
#  elif defined(_MIPS_SIM)
#    if _MIPS_SIM == _MIPS_SIM_ABI32
#      define systemd_NR_openat2 4437
#    elif _MIPS_SIM == _MIPS_SIM_NABI32
#      define systemd_NR_openat2 6437
#    elif _MIPS_SIM == _MIPS_SIM_ABI64
#      define systemd_NR_openat2 5437
#    else
#      error "Unknown MIPS ABI"
#    endif
#  elif defined(__hppa__)
#    define systemd_NR_openat2 437
#  elif defined(__powerpc__)
#    define systemd_NR_openat2 437
#  elif defined(__riscv)
#    if __riscv_xlen == 32
#      define systemd_NR_openat2 437
#    elif __riscv_xlen == 64
#      define systemd_NR_openat2 437
#    else
#      error "Unknown RISC-V ABI"
#    endif
#  elif defined(__s390__)
#    define systemd_NR_openat2 437
#  elif defined(__sh__)
#    define systemd_NR_openat2 437
#  elif defined(__sparc__)
#    define systemd_NR_openat2 437
#  elif defined(__x86_64__)
#    if defined(__ILP32__)
#      define systemd_NR_openat2 (437 | /* __X32_SYSCALL_BIT */ 0x40000000)
#    else
#      define systemd_NR_openat2 437
#    endif
#  elif !defined(missing_arch_template)
#    warning "openat2() syscall number is unknown for your architecture"
#  endif

/* may be an (invalid) negative number due to libseccomp, see PR 13319 */
#  if defined __NR_openat2 && __NR_openat2 >= 0
#    if defined systemd_NR_openat2
static_assert(__NR_openat2 == systemd_NR_openat2, "");
#    endif
#  else
#    if defined __NR_openat2
#      undef __NR_openat2
#    endif
#    if defined systemd_NR_openat2 && systemd_NR_openat2 >= 0
#      define __NR_openat2 systemd_NR_openat2
#    endif
#  endif
#endif

#ifndef __IGNORE_quotactl_fd
#  if defined(__aarch64__)
#    define systemd_NR_quotactl_fd 443
#  elif defined(__alpha__)
#    define systemd_NR_quotactl_fd 553
#  elif defined(__arc__) || defined(__tilegx__)
#    define systemd_NR_quotactl_fd 443
#  elif defined(__arm__)
#    define systemd_NR_quotactl_fd 443
#  elif defined(__i386__)
#    define systemd_NR_quotactl_fd 443
#  elif defined(__ia64__)
#    define systemd_NR_quotactl_fd 1467
#  elif defined(__loongarch_lp64)
#    define systemd_NR_quotactl_fd 443
#  elif defined(__m68k__)
#    define systemd_NR_quotactl_fd 443
#  elif defined(_MIPS_SIM)
#    if _MIPS_SIM == _MIPS_SIM_ABI32
#      define systemd_NR_quotactl_fd 4443
#    elif _MIPS_SIM == _MIPS_SIM_NABI32
#      define systemd_NR_quotactl_fd 6443
#    elif _MIPS_SIM == _MIPS_SIM_ABI64
#      define systemd_NR_quotactl_fd 5443
#    else
#      error "Unknown MIPS ABI"
#    endif
#  elif defined(__hppa__)
#    define systemd_NR_quotactl_fd 443
#  elif defined(__powerpc__)
#    define systemd_NR_quotactl_fd 443
#  elif defined(__riscv)
#    if __riscv_xlen == 32
#      define systemd_NR_quotactl_fd 443
#    elif __riscv_xlen == 64
#      define systemd_NR_quotactl_fd 443
#    else
#      error "Unknown RISC-V ABI"
#    endif
#  elif defined(__s390__)
#    define systemd_NR_quotactl_fd 443
#  elif defined(__sh__)
#    define systemd_NR_quotactl_fd 443
#  elif defined(__sparc__)
#    define systemd_NR_quotactl_fd 443
#  elif defined(__x86_64__)
#    if defined(__ILP32__)
#      define systemd_NR_quotactl_fd (443 | /* __X32_SYSCALL_BIT */ 0x40000000)
#    else
#      define systemd_NR_quotactl_fd 443
#    endif
#  elif !defined(missing_arch_template)
#    warning "quotactl_fd() syscall number is unknown for your architecture"
#  endif

/* may be an (invalid) negative number due to libseccomp, see PR 13319 */
#  if defined __NR_quotactl_fd && __NR_quotactl_fd >= 0
#    if defined systemd_NR_quotactl_fd
static_assert(__NR_quotactl_fd == systemd_NR_quotactl_fd, "");
#    endif
#  else
#    if defined __NR_quotactl_fd
#      undef __NR_quotactl_fd
#    endif
#    if defined systemd_NR_quotactl_fd && systemd_NR_quotactl_fd >= 0
#      define __NR_quotactl_fd systemd_NR_quotactl_fd
#    endif
#  endif
#endif

#ifndef __IGNORE_removexattrat
#  if defined(__aarch64__)
#    define systemd_NR_removexattrat 466
#  elif defined(__alpha__)
#    define systemd_NR_removexattrat 576
#  elif defined(__arc__) || defined(__tilegx__)
#    define systemd_NR_removexattrat 466
#  elif defined(__arm__)
#    define systemd_NR_removexattrat 466
#  elif defined(__i386__)
#    define systemd_NR_removexattrat 466
#  elif defined(__ia64__)
#    define systemd_NR_removexattrat -1
#  elif defined(__loongarch_lp64)
#    define systemd_NR_removexattrat 466
#  elif defined(__m68k__)
#    define systemd_NR_removexattrat 466
#  elif defined(_MIPS_SIM)
#    if _MIPS_SIM == _MIPS_SIM_ABI32
#      define systemd_NR_removexattrat 4466
#    elif _MIPS_SIM == _MIPS_SIM_NABI32
#      define systemd_NR_removexattrat 6466
#    elif _MIPS_SIM == _MIPS_SIM_ABI64
#      define systemd_NR_removexattrat 5466
#    else
#      error "Unknown MIPS ABI"
#    endif
#  elif defined(__hppa__)
#    define systemd_NR_removexattrat 466
#  elif defined(__powerpc__)
#    define systemd_NR_removexattrat 466
#  elif defined(__riscv)
#    if __riscv_xlen == 32
#      define systemd_NR_removexattrat 466
#    elif __riscv_xlen == 64
#      define systemd_NR_removexattrat 466
#    else
#      error "Unknown RISC-V ABI"
#    endif
#  elif defined(__s390__)
#    define systemd_NR_removexattrat 466
#  elif defined(__sh__)
#    define systemd_NR_removexattrat 466
#  elif defined(__sparc__)
#    define systemd_NR_removexattrat 466
#  elif defined(__x86_64__)
#    if defined(__ILP32__)
#      define systemd_NR_removexattrat (466 | /* __X32_SYSCALL_BIT */ 0x40000000)
#    else
#      define systemd_NR_removexattrat 466
#    endif
#  elif !defined(missing_arch_template)
#    warning "removexattrat() syscall number is unknown for your architecture"
#  endif

/* may be an (invalid) negative number due to libseccomp, see PR 13319 */
#  if defined __NR_removexattrat && __NR_removexattrat >= 0
#    if defined systemd_NR_removexattrat
static_assert(__NR_removexattrat == systemd_NR_removexattrat, "");
#    endif
#  else
#    if defined __NR_removexattrat
#      undef __NR_removexattrat
#    endif
#    if defined systemd_NR_removexattrat && systemd_NR_removexattrat >= 0
#      define __NR_removexattrat systemd_NR_removexattrat
#    endif
#  endif
#endif

#ifndef __IGNORE_setxattrat
#  if defined(__aarch64__)
#    define systemd_NR_setxattrat 463
#  elif defined(__alpha__)
#    define systemd_NR_setxattrat 573
#  elif defined(__arc__) || defined(__tilegx__)
#    define systemd_NR_setxattrat 463
#  elif defined(__arm__)
#    define systemd_NR_setxattrat 463
#  elif defined(__i386__)
#    define systemd_NR_setxattrat 463
#  elif defined(__ia64__)
#    define systemd_NR_setxattrat -1
#  elif defined(__loongarch_lp64)
#    define systemd_NR_setxattrat 463
#  elif defined(__m68k__)
#    define systemd_NR_setxattrat 463
#  elif defined(_MIPS_SIM)
#    if _MIPS_SIM == _MIPS_SIM_ABI32
#      define systemd_NR_setxattrat 4463
#    elif _MIPS_SIM == _MIPS_SIM_NABI32
#      define systemd_NR_setxattrat 6463
#    elif _MIPS_SIM == _MIPS_SIM_ABI64
#      define systemd_NR_setxattrat 5463
#    else
#      error "Unknown MIPS ABI"
#    endif
#  elif defined(__hppa__)
#    define systemd_NR_setxattrat 463
#  elif defined(__powerpc__)
#    define systemd_NR_setxattrat 463
#  elif defined(__riscv)
#    if __riscv_xlen == 32
#      define systemd_NR_setxattrat 463
#    elif __riscv_xlen == 64
#      define systemd_NR_setxattrat 463
#    else
#      error "Unknown RISC-V ABI"
#    endif
#  elif defined(__s390__)
#    define systemd_NR_setxattrat 463
#  elif defined(__sh__)
#    define systemd_NR_setxattrat 463
#  elif defined(__sparc__)
#    define systemd_NR_setxattrat 463
#  elif defined(__x86_64__)
#    if defined(__ILP32__)
#      define systemd_NR_setxattrat (463 | /* __X32_SYSCALL_BIT */ 0x40000000)
#    else
#      define systemd_NR_setxattrat 463
#    endif
#  elif !defined(missing_arch_template)
#    warning "setxattrat() syscall number is unknown for your architecture"
#  endif

/* may be an (invalid) negative number due to libseccomp, see PR 13319 */
#  if defined __NR_setxattrat && __NR_setxattrat >= 0
#    if defined systemd_NR_setxattrat
static_assert(__NR_setxattrat == systemd_NR_setxattrat, "");
#    endif
#  else
#    if defined __NR_setxattrat
#      undef __NR_setxattrat
#    endif
#    if defined systemd_NR_setxattrat && systemd_NR_setxattrat >= 0
#      define __NR_setxattrat systemd_NR_setxattrat
#    endif
#  endif
#endif
