[comment {-*- tcl -*- doctools manpage}]
[manpage_begin fileutil::multi n 0.1]
[keywords copy]
[keywords {file utilities}]
[keywords move]
[keywords multi-file]
[keywords remove]
[moddesc   {file utilities}]
[titledesc {Multi-file operation, scatter/gather, standard object}]
[category  {Programming tools}]
[require Tcl 8.4]
[require fileutil::multi [opt 0.1]]
[require fileutil::multi::op [opt 0.1]]
[require wip [opt 1.0]]
[description]
[para]

This package provides a single command to perform actions on multiple
files selected by glob patterns. It is a thin layer over the package
[package fileutil::multi::op] which provides objects for the
same. This package simply creates a single such object and directs all
file commands to it.

[para]

At the core is a domain specific language allowing the easy
specification of multi-file copy and/or move and/or deletion
operations. Alternate names would be scatter/gather processor, or
maybe even assembler.

For the detailed specification of this language, and examples, please
see the documention for the package [package fileutil::multi::op].

[section {PUBLIC API}]

The main command of the package is:

[list_begin definitions]

[call [cmd ::fileutil::multi] [opt [arg word]...]]

This command interprets the specified words as file commands to
execute. See the section [sectref-external {FILE API}] of the
documentation for the package [package fileutil::multi::op] for
the set of acceptable commands, their syntax, and semantics.

[para]

The result of the command is the result generated by the last file
command it executed.

[list_end]

[vset CATEGORY fileutil]
[include ../common-text/feedback.inc]
[manpage_end]
