.\" Text automatically generated by txt2man
'\"
'\" Copyright (c) 2021 Kevin Walzer/WordTech Communications LLC.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.

.TH tk print n "" Tk "Tk Built-in Commands"
.so man.macros
.SH NAME
print \- Print canvas and text widgets using native dialogs and APIs.
.SH SYNOPSIS
\fBtk print \fIwindow\fR
.
.SH DESCRIPTION
.PP
The \fBtk print\fR command posts a dialog that allows users to print output
from the \fBcanvas\fR and \fBtext\fR widgets. The printing will be done using
platform-native APIs and dialogs where available.
.PP
The \fBcanvas\fR widget has long supported PostScript export and both
PostScript and text files can be sent directly to a printer on Unix-like
systems using the
.QW "lp"
and
.QW "lpr"
Unix commands, and the \fBtk print\fR command does not supersede that
functionality; it builds on it. The \fBtk print\fR command is a fuller
implementation that uses native dialogs on macOS and Windows, and a Tk-based
dialog that provides parallel functionality on X11.
.SH PLATFORM NOTES
.TP
\fBmacOS\fR
.
The Mac implementation uses native print dialogs and relies on the underlying
Common Unix Printing System (CUPS) to render text output from the text widget
and PDF conversion of the canvas data to the printer or to a PDF file.
.TP
\fBWindows\fR
.
The Windows implementation is based on the GDI (Graphics Device Interface)
API. Because there are slight differences in how GDI and Tk's \fBcanvas\fR
widget display graphics, printed output from the \fBcanvas\fR on Windows may
not be identical to screen rendering.
.TP
\fBX11\fR
.
The X11 implementation uses a Tk GUI to configure print jobs for sending to a
printer via the
.QW "lpr"
or
.QW "lp"
commands. While these commands have a large number of parameters for
configuring print jobs, printers vary widely in how they support these
parameters. As a result, only printer selection and number of copies are
configured as arguments to the print command; many aspects of print rendering,
such as grayscale or color for the canvas, are instead configured when
PostScript is generated.
.SH "SEE ALSO"
canvas(n), text(n), tk(n)
.SH KEYWORDS
print, output, graphics, text, canvas
