.\" @(#)xtapemon.1 1.1 11-Dec-96 MJF
.TH XTAPEMON 1 "11 Dec 1996" "X11IRAF Project"
.SH NAME
XTapemon \- magtape I/O status monitor and display utility for IRAF
.SH SYNOPSIS
\fBxtapemon\fP 
[\-\fItoolkitoption\fP ...] [ \fI-port\fP <port> ] [ \fI\-a\fP ] [ \fI-d\fP ] 
.SH OPTIONS
In addition to the X Toolkit options, the following are supported:
.TP 5
.B "-port \fIport\fP"
Set the primary port to listen on for client connections.  The default
is 5138.
.TP 5
.B "-a"
Listen on alternate port, this is the primary port number plus one.
The default is 5139.
.TP 5
.B "-d"
Debug mode, pass client message to the standard out.  The default is false.

.SH "X RESOURCES"
\fBXTapemon\fP options can appear on the command line or in your X
resource file.  Options on the command line supercede values
specified in your X resource file.

.TP 12
.B "port"
Set the primary port to listen on for client connections.  The default
is 5138.
.TP 12
.B "alternate"
Listen on alternate port, this is the primary port number plus one.
The default is 5139.
.TP 12
.B "debug"
Debug mode, pass client message to the standard out.  The default is false.
.SH DESCRIPTION
.LP
Xtapemon is a magtape status monitor and display utility.  You use it to
display the status of a IRAF tape job while it is running.  TCP/IP sockets
are used for communication, so the IRAF tape job and xtapemon may be on
the same host machine or on different hosts.  All V2.10 versions of IRAF
support tape status output (including even VMS/IRAF).  For example, suppose
our workstation is named \fIcygnus\fP and we are running IRAF on host 
\fIregulus\fP, using magtape device mta.  The first step is to
start xtapemon on cygnus:

        % xtapemon &

Then in IRAF on regulus we might do the following:

        cl> set tapecap = ":so=cygnus"
        cl> allocate mta
        cl> rewind mta

At this point the IRAF magtape i/o driver executing on regulus should open
a connection to the xtapemon tape monitoring server running on cygnus, and
indicate that a rewind operation is taking place.

If both xtapemon and the IRAF tape job are running on the same host then
the hostname can be omitted, e.g. "set tapecap = :so".  The use of
"set tapecap" assumes that the default IRAF tapecap is being used.  If
the user has a private tapecap, the syntax is

        cl> set tapecap = "<my-tapecap-file>:so=hostname"

In general you can append any number of tapecap device capability overrides
(the :xx fields) to the tapecap environment specification.  Alternatively, 
the :so can be specified on the command line, e.g.

        cl> rewind "mta[:so=cygnus]"

But in general it will be more convenient to use set tapecap.

It is safe to have :so (status output) enabled even if there is no xtapemon
server;  IRAF will try to make the connection but will proceed without any
indication of an error if the status output connection cannot be established.


The amount of tape read or written in Mb will be accurate only if the IRAF
magtape driver actually reads or writes all the data between the beginning
of tape and the current position of the tape.  Hence, if one rewinds the
tape and then reads or writes a number of tiles, the Mb used field will be
accurate.  If however one does a skip to a random file somewhere far down on
the tape, IRAF will not have read the data and the tape used field will
indicate only the data actually read or written.  For example, a rewind
followed by a \fImtexamine\fP will reliably indicate the actual amount of data
on the tape, leaving the tape positioned to EOT.  If one then appends new files
to the tape the tape used field will still be accurate.  If however one pops
in a new tape and then appends a file at EOT, tape used will be invalid as
the drive will rapidly skip forward to the EOT.

.SH "ADVANCED USAGE"

By default xtapemon listens on the port 5138, called port A.  If when you
start the xtapemon server this port is already busy, xtapemon will
automatically switch to port B instead (the alternate port, 5139).  This 
makes it possible to monitor two tape jobs at the same time.

If you have xtapemon servers running on two ports it will be necessary to
tell the second IRAF tape job what port to use, since the magtape driver
will use port A by default.  For example,

        cl> set tapecap = ":so=cygnus,5139"
or
        cl> mtexamine "mta[:so=,5139]"

If there is some problem using the builtin port defaults you can use any
port you want.  The following resources tell which port to use.

        XTapemon.port		# port A
        XTapemon.alternate		# port B

Or you can specify the ports with the argument "-port" or "-a" (alternate)
on the command line when xtapemon is started.
.SH BUGS
You can't necessarily trust displayed information such as the device type and
tape type.  On most platforms this information is taken from the tapecap
entry for the device, and the accuracy of this information will depend upon
the diligence of your IRAF system adminstrator when they configured tapecap
for your site (and on whether you use the correct logical device name for
the drive and tape capacity you are using).

Xtapemon tries to keep track of the amount of tape used: the number of Mb
(megabytes) read or written is displayed, along with the percent of the tape
used.  Whether or not the percent used field is accurate depends upon a
number of factors.  First the tape capacity given in the tapecap file must
match the actual tape being used.  Second, if data compression is in use on
the drive, xtapemon will display the uncompressed quantity of data written.
On a compression drive percent used can be greater than 100%!
.SH SEE ALSO
xgterm(1), ximtool(1)
.SH COPYRIGHT
Copyright(c) 1986 Association of Universities for Research in Astronomy Inc.
