/*
Copyright (c) 2014-2018, Tom Schoonjans
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    * The names of the contributors may not be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY Tom Schoonjans ''AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL Tom Schoonjans BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
 * This file was automatically generated by nuclides.pl
 * Modify at your own risk...
 */


#ifndef XRAYLIB_RADIO_NUCLIDES_H
#define XRAYLIB_RADIO_NUCLIDES_H

#include "xraylib-error.h"

/* 
 * name: a string containing the mass number (A), followed by the chemical element (e.g. 55Fe)
 * Z: atomic number of the radionuclide
 * A: mass number of the radionuclide
 * N: number of neutrons of the radionuclide
 * Z_xray: atomic number of the nuclide after decay, and which should be used in calculating the energy of the emitted X-ray lines
 * nXrays: number of emitted characteristic X-rays
 * XrayLines: array of *_LINE macros, identifying the emitted X-rays
 * XrayIntensities: array of photons per disintegration, one value per emitted X-ray
 * nGammas: number of emitted gamma-rays
 * GammaEnergies: array of emitted gamma-ray energies
 * GammaIntensities: array of emitted gamma-ray photons per disintegration
 */

struct radioNuclideData{
	char *name;
	int Z;
	int A;
	int N;
	int Z_xray;
	int nXrays;
	int *XrayLines;
	double *XrayIntensities;
	int nGammas;
	double *GammaEnergies;
	double *GammaIntensities;
};


/*
 *
 * Returns a pointer to a newly allocated struct containing
 * the requested radionuclide on success, or NULL when the radionuclide 
 * was not found in the list. The radionuclide is requested by providing
 * its name as argument to the function. For a list of available names,
 * use GetRadioNuclideList.
 *
 * The returned struct should be freed after usage with FreeRadioNuclideData.
 *
 */
XRL_EXTERN
struct radioNuclideData *GetRadioNuclideDataByName(const char radioNuclideString[], xrl_error **error);

/*
 *
 * Returns a pointer to a newly allocated struct containing
 * the requested radionuclide on success, or NULL when the radionuclide
 * was not found in the list. The radionuclide is requested by providing
 * its index in the internal table to the function. Typically this would
 * be done using the RADIO_NUCLIDE_* macros in this file.
 *
 * The returned struct should be freed after usage with FreeRadioNuclideData.
 *
 */
XRL_EXTERN
struct radioNuclideData *GetRadioNuclideDataByIndex(int radioNuclideIndex, xrl_error **error);

/*
 *
 * Returns a NULL-terminated array of strings of all the radionuclides in the
 * internal table. If nRadioNuclides is not NULL, it shall receive the number 
 * of radionuclides.
 *
 * The returned array should be freed firstly by using xrlFree to deallocate
 * all individual strings, and subsequently by using xrlFree to deallocate the array
 *
 */
XRL_EXTERN
char **GetRadioNuclideDataList(int *nRadioNuclides, xrl_error **error);

/*
 *
 * Deallocates a pointer to a radioNuclideData struct completely.
 * It is recommended to set the pointer to NULL after calling this function.
 *
 */
XRL_EXTERN
void FreeRadioNuclideData(struct radioNuclideData *radioNuclideData);

#define RADIO_NUCLIDE_55FE 0
#define RADIO_NUCLIDE_57CO 1
#define RADIO_NUCLIDE_109CD 2
#define RADIO_NUCLIDE_125I 3
#define RADIO_NUCLIDE_137CS 4
#define RADIO_NUCLIDE_133BA 5
#define RADIO_NUCLIDE_153GD 6
#define RADIO_NUCLIDE_238PU 7
#define RADIO_NUCLIDE_241AM 8
#define RADIO_NUCLIDE_244CM 9

#endif
