/*------------------------------------------------------------------------------
 *
 * Copyright (c) 2011-2025, EURid vzw. All rights reserved.
 * The YADIFA TM software product is provided under the BSD 3-clause license:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *        * Redistributions of source code must retain the above copyright
 *          notice, this list of conditions and the following disclaimer.
 *        * Redistributions in binary form must reproduce the above copyright
 *          notice, this list of conditions and the following disclaimer in the
 *          documentation and/or other materials provided with the distribution.
 *        * Neither the name of EURid nor the names of its contributors may be
 *          used to endorse or promote products derived from this software
 *          without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *----------------------------------------------------------------------------*/

#include "yatest.h"
#include "yatest_stream.h"
#include <dnscore/dnscore.h>
#include <dnscore/zone_reader_axfr.h>

#define ZONE_FILE_NAME "/tmp/dnscore-zone_reader_axfr-test.zone"

static const uint8_t axfr_wire[] = {
    // SOA
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x06,
    0x00,
    0x01,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x35,
    0x03,
    0x6e,
    0x73,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x0a,
    0x68,
    0x6f,
    0x73,
    0x74,
    0x6d,
    0x61,
    0x73,
    0x74,
    0x65,
    0x72,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x53,
    0x45,
    0x52,
    0x30,
    0x00,
    0x00,
    0x00,
    0x05,
    0x00,
    0x00,
    0x00,
    0x05,
    0x00,
    0x1b,
    0xaf,
    0x80,
    0x00,
    0x00,
    0x0e,
    0x10,
    // NS
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x02,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0d,
    0x03,
    0x6e,
    0x73,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    // NS
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x02,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0d,
    0x03,
    0x6e,
    0x73,
    0x33,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    // A
    0x03,
    0x61,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x01,
    0x00,
    0x01,
    0x00,
    0x00,
    0x03,
    0x6e,
    0x00,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    // A
    0x03,
    0x61,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x01,
    0x00,
    0x01,
    0x00,
    0x00,
    0x03,
    0x6e,
    0x00,
    0x04,
    0xff,
    0xff,
    0xff,
    0xff,
    // AAAA
    0x06,
    0x61,
    0x61,
    0x61,
    0x61,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x1c,
    0x00,
    0x01,
    0x00,
    0x00,
    0x04,
    0xff,
    0x00,
    0x10,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    // AAAA
    0x06,
    0x61,
    0x61,
    0x61,
    0x61,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x1c,
    0x00,
    0x01,
    0x00,
    0x00,
    0x04,
    0xff,
    0x00,
    0x10,
    0xfd,
    0x92,
    0x70,
    0x65,
    0x0b,
    0x8e,
    0xff,
    0xff,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x05,
    // AFSDB
    0x07,
    0x61,
    0x66,
    0x73,
    0x64,
    0x62,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x12,
    0x00,
    0x01,
    0x00,
    0x00,
    0xff,
    0x00,
    0x00,
    0x14,
    0x00,
    0x00,
    0x08,
    0x68,
    0x6f,
    0x73,
    0x74,
    0x6e,
    0x61,
    0x6d,
    0x65,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    // AFSDB
    0x07,
    0x61,
    0x66,
    0x73,
    0x64,
    0x62,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x12,
    0x00,
    0x01,
    0x00,
    0x00,
    0xff,
    0x00,
    0x00,
    0x03,
    0xff,
    0xff,
    0x00,
    // CAA
    0x05,
    0x63,
    0x61,
    0x61,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x01,
    0x01,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x20,
    0x00,
    0x05,
    0x69,
    0x73,
    0x73,
    0x75,
    0x65,
    0x63,
    0x61,
    0x2e,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x2e,
    0x6e,
    0x65,
    0x74,
    0x3b,
    0x20,
    0x70,
    0x6f,
    0x6c,
    0x69,
    0x63,
    0x79,
    0x3d,
    0x65,
    0x76,

    // CAA
    0x05,
    0x63,
    0x61,
    0x61,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x01,
    0x01,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0c,
    0x80,
    0x03,
    0x74,
    0x62,
    0x73,
    0x55,
    0x6e,
    0x6b,
    0x6e,
    0x6f,
    0x77,
    0x6e,
    // CAA
    0x05,
    0x63,
    0x61,
    0x61,
    0x30,
    0x33,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x01,
    0x01,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x05,
    0x80,
    0x03,
    0x74,
    0x62,
    0x73,
    // CDNSKEY
    0x09,
    0x63,
    0x64,
    0x6e,
    0x73,
    0x6b,
    0x65,
    0x79,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x3c,
    0x00,
    0x01,
    0x00,
    0x00,
    0x80,
    0x03,
    0x00,
    0x6f,
    0x02,
    0x00,
    0xff,
    0x01,
    0x01,
    0x03,
    0x05,
    0x0f,
    0x9a,
    0xda,
    0x73,
    0x30,
    0x89,
    0x1d,
    0x58,
    0x8a,
    0xb4,
    0xb6,
    0x21,
    0x58,
    0x6c,
    0xfc,
    0x84,
    0xc6,
    0x3d,
    0x50,
    0x64,
    0x6e,
    0x9e,
    0x22,
    0x43,
    0x07,
    0x30,
    0xbb,
    0xc3,
    0x46,
    0x91,
    0xcb,
    0x35,
    0x99,
    0xae,
    0x23,
    0xba,
    0x8b,
    0x6a,
    0x1d,
    0x19,
    0x65,
    0x90,
    0x56,
    0xe7,
    0x19,
    0xa8,
    0xa5,
    0x6c,
    0x10,
    0xd5,
    0xbd,
    0xd4,
    0x83,
    0x96,
    0xe2,
    0xfa,
    0xae,
    0x76,
    0x78,
    0x0f,
    0x66,
    0xc6,
    0x37,
    0x1a,
    0xf4,
    0x3f,
    0xc5,
    0x50,
    0x3c,
    0xff,
    0xba,
    0x72,
    0x16,
    0x3e,
    0x9b,
    0xec,
    0x4b,
    0x20,
    0x6b,
    0xad,
    0x33,
    0xc8,
    0x65,
    0xba,
    0x2c,
    0x57,
    0xbd,
    0xaf,
    0xc9,
    0xfa,
    0xa5,
    0xa1,
    0xeb,
    0x94,
    0x6e,
    0x68,
    0x8e,
    0xa7,
    0xf4,
    0x05,
    0xaa,
    0x87,
    0x4f,
    0xef,
    // CDS
    0x05,
    0x63,
    0x64,
    0x73,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x3b,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x18,
    0x78,
    0x4b,
    0x01,
    0x01,
    0x31,
    0x0d,
    0x27,
    0xf4,
    0xd8,
    0x2c,
    0x1f,
    0xc2,
    0x40,
    0x07,
    0x04,
    0xea,
    0x99,
    0x39,
    0xfe,
    0x6e,
    0x1c,
    0xea,
    0xa3,
    0xb9,
    // CERT
    0x06,
    0x63,
    0x65,
    0x72,
    0x74,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x25,
    0x00,
    0x01,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x55,
    0xff,
    0xfe,
    0xff,
    0xff,
    0xfe,
    0x33,
    0x11,
    0x5c,
    0x6f,
    0x2f,
    0x64,
    0xff,
    0x2b,
    0xde,
    0x74,
    0xc7,
    0xd0,
    0x80,
    0xac,
    0xe1,
    0x1f,
    0x97,
    0xab,
    0xd0,
    0xcb,
    0xbf,
    0xbc,
    0x82,
    0xf3,
    0xe3,
    0x92,
    0x24,
    0xb2,
    0x47,
    0x1e,
    0x14,
    0x68,
    0x22,
    0x58,
    0x29,
    0xff,
    0x1b,
    0x11,
    0xe1,
    0x6a,
    0x2e,
    0x95,
    0x02,
    0xe1,
    0xc0,
    0xa0,
    0xd5,
    0x33,
    0xe1,
    0x8a,
    0x14,
    0xd6,
    0xd5,
    0x5f,
    0x48,
    0x24,
    0xaa,
    0x41,
    0x89,
    0xfa,
    0xff,
    0xfd,
    0x75,
    0x53,
    0xa3,
    0x65,
    0x77,
    0xcd,
    0x23,
    0x11,
    0xe0,
    0xbc,
    0x69,
    0x3a,
    0xce,
    0xf8,
    0xa2,
    0xa6,
    0x09,
    0xa6,
    // CNAME
    0x07,
    0x63,
    0x6e,
    0x61,
    0x6d,
    0x65,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x05,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0e,
    0x0c,
    0x63,
    0x6e,
    0x61,
    0x6d,
    0x65,
    0x2d,
    0x74,
    0x61,
    0x72,
    0x67,
    0x65,
    0x74,
    0x00,
    // CNAME
    0x07,
    0x63,
    0x6e,
    0x61,
    0x6d,
    0x65,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x05,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x16,
    0x0c,
    0x63,
    0x6e,
    0x61,
    0x6d,
    0x65,
    0x2d,
    0x74,
    0x61,
    0x72,
    0x67,
    0x65,
    0x74,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    // CNAME
    0x07,
    0x63,
    0x6e,
    0x61,
    0x6d,
    0x65,
    0x30,
    0x33,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x05,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    // (null)
    0x07,
    0x63,
    0x73,
    0x79,
    0x6e,
    0x63,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x3e,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0c,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x60,
    0x00,
    0x00,
    0x08,
    // (null)
    0x07,
    0x63,
    0x73,
    0x79,
    0x6e,
    0x63,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x3e,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x06,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    // DLV
    0x03,
    0x64,
    0x6c,
    0x76,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x80,
    0x01,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x18,
    0x78,
    0x4b,
    0x01,
    0x01,
    0x31,
    0x0d,
    0x27,
    0xf4,
    0xd8,
    0x2c,
    0x1f,
    0xc2,
    0x40,
    0x07,
    0x04,
    0xea,
    0x99,
    0x39,
    0xfe,
    0x6e,
    0x1c,
    0xea,
    0xa3,
    0xb9,
    // DNSKEY
    0x08,
    0x64,
    0x6e,
    0x73,
    0x6b,
    0x65,
    0x79,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x30,
    0x00,
    0x01,
    0x00,
    0x00,
    0x4b,
    0x01,
    0x00,
    0x6f,
    0x02,
    0x00,
    0xff,
    0x01,
    0x01,
    0x03,
    0x05,
    0x0f,
    0x9a,
    0xda,
    0x73,
    0x30,
    0x89,
    0x1d,
    0x58,
    0x8a,
    0xb4,
    0xb6,
    0x21,
    0x58,
    0x6c,
    0xfc,
    0x84,
    0xc6,
    0x3d,
    0x50,
    0x64,
    0x6e,
    0x9e,
    0x22,
    0x43,
    0x07,
    0x30,
    0xbb,
    0xc3,
    0x46,
    0x91,
    0xcb,
    0x35,
    0x99,
    0xae,
    0x23,
    0xba,
    0x8b,
    0x6a,
    0x1d,
    0x19,
    0x65,
    0x90,
    0x56,
    0xe7,
    0x19,
    0xa8,
    0xa5,
    0x6c,
    0x10,
    0xd5,
    0xbd,
    0xd4,
    0x83,
    0x96,
    0xe2,
    0xfa,
    0xae,
    0x76,
    0x78,
    0x0f,
    0x66,
    0xc6,
    0x37,
    0x1a,
    0xf4,
    0x3f,
    0xc5,
    0x50,
    0x3c,
    0xff,
    0xba,
    0x72,
    0x16,
    0x3e,
    0x9b,
    0xec,
    0x4b,
    0x20,
    0x6b,
    0xad,
    0x33,
    0xc8,
    0x65,
    0xba,
    0x2c,
    0x57,
    0xbd,
    0xaf,
    0xc9,
    0xfa,
    0xa5,
    0xa1,
    0xeb,
    0x94,
    0x6e,
    0x68,
    0x8e,
    0xa7,
    0xf4,
    0x05,
    0xaa,
    0x87,
    0x4f,
    0xef,
    // DS
    0x04,
    0x64,
    0x73,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x2b,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x24,
    0x32,
    0x5c,
    0x05,
    0x02,
    0x26,
    0x58,
    0x48,
    0x35,
    0xca,
    0x80,
    0xc8,
    0x1c,
    0x91,
    0x99,
    0x9f,
    0x31,
    0xcf,
    0xaf,
    0x2a,
    0x0e,
    0x89,
    0xd4,
    0xff,
    0x1c,
    0x8f,
    0xaf,
    0xd0,
    0xdd,
    0xb3,
    0x1a,
    0x85,
    0xc7,
    0x19,
    0x27,
    0x7c,
    0x13,
    // NS
    0x04,
    0x64,
    0x73,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x02,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x0e,
    0x04,
    0x6e,
    0x73,
    0x34,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,

    // DS
    0x04,
    0x64,
    0x73,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x2b,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x18,
    0x32,
    0x5c,
    0x05,
    0x01,
    0x7a,
    0xa4,
    0xa3,
    0xf4,
    0x16,
    0xc2,
    0xf2,
    0x39,
    0x1f,
    0xb7,
    0xab,
    0x0d,
    0x43,
    0x4f,
    0x76,
    0x2c,
    0xd6,
    0x2d,
    0x13,
    0x90,
    // NS
    0x04,
    0x64,
    0x73,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x02,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x0e,
    0x04,
    0x6e,
    0x73,
    0x34,
    0x33,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,

    // EUI48
    0x05,
    0x65,
    0x75,
    0x69,
    0x34,
    0x38,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x6c,
    0x00,
    0x01,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x06,
    0x01,
    0x23,
    0x45,
    0x67,
    0x89,
    0xab,
    // EUI64
    0x05,
    0x65,
    0x75,
    0x69,
    0x36,
    0x34,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x6d,
    0x00,
    0x01,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x08,
    0x01,
    0x23,
    0x45,
    0x67,
    0x89,
    0xab,
    0xcd,
    0xef,
    // GID
    0x05,
    0x67,
    0x69,
    0x64,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x66,
    0x00,
    0x01,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x01,
    0x03,
    // HINFO
    0x07,
    0x68,
    0x69,
    0x6e,
    0x66,
    0x6f,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x0d,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x1c,
    0x10,
    0x47,
    0x65,
    0x6e,
    0x65,
    0x72,
    0x69,
    0x63,
    0x20,
    0x50,
    0x43,
    0x20,
    0x63,
    0x6c,
    0x6f,
    0x6e,
    0x65,
    0x0a,
    0x4e,
    0x65,
    0x74,
    0x42,
    0x53,
    0x44,
    0x2d,
    0x31,
    0x2e,
    0x34,
    // HINFO
    0x07,
    0x68,
    0x69,
    0x6e,
    0x66,
    0x6f,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x0d,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x0a,
    0x02,
    0x50,
    0x43,
    0x06,
    0x4e,
    0x65,
    0x74,
    0x42,
    0x53,
    0x44,
    // (null)
    0x07,
    0x6b,
    0x65,
    0x79,
    0x64,
    0x61,
    0x74,
    0x61,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0xff,
    0xfd,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    // (null)
    0x07,
    0x6b,
    0x65,
    0x79,
    0x64,
    0x61,
    0x74,
    0x61,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0xff,
    0xfd,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x06,
    0x01,
    0x02,
    0x03,
    0x04,
    0x05,
    0x06,
    // (null)
    0x07,
    0x6b,
    0x65,
    0x79,
    0x64,
    0x61,
    0x74,
    0x61,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0xff,
    0xfd,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x12,
    0x01,
    0x02,
    0x03,
    0x04,
    0x05,
    0x06,
    0x01,
    0x02,
    0x03,
    0x04,
    0x05,
    0x06,
    0x01,
    0x02,
    0x03,
    0x04,
    0x05,
    0x06,
    // L32
    0x03,
    0x6c,
    0x33,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x69,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x06,
    0x00,
    0x0a,
    0x01,
    0x02,
    0x03,
    0x04,
    // L64
    0x03,
    0x6c,
    0x36,
    0x34,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x6a,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x0a,
    0x00,
    0x0a,
    0x00,
    0x14,
    0x4f,
    0xff,
    0xff,
    0x20,
    0xee,
    0x64,
    // LP
    0x02,
    0x6c,
    0x70,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x6b,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0f,
    0x00,
    0x0a,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x03,
    0x6e,
    0x65,
    0x74,
    0x00,
    // MG
    0x04,
    0x6d,
    0x62,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x08,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x0f,
    0x00,
    0x11,
    0x07,
    0x6d,
    0x61,
    0x64,
    0x6e,
    0x61,
    0x6d,
    0x65,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    // MG
    0x04,
    0x6d,
    0x62,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x08,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x0f,
    0x00,
    0x01,
    0x00,
    // MG
    0x04,
    0x6d,
    0x67,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x08,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x0f,
    0x00,
    0x11,
    0x07,
    0x6d,
    0x67,
    0x6d,
    0x6e,
    0x61,
    0x6d,
    0x65,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    // MG
    0x04,
    0x6d,
    0x67,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x08,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x0f,
    0x00,
    0x01,
    0x00,
    // MR
    0x04,
    0x6d,
    0x72,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x09,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x0f,
    0x00,
    0x10,
    0x06,
    0x6d,
    0x72,
    0x6e,
    0x61,
    0x6d,
    0x65,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    // MR
    0x04,
    0x6d,
    0x72,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x09,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x0f,
    0x00,
    0x01,
    0x00,
    // MX
    0x04,
    0x6d,
    0x78,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x0f,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x0f,
    0x00,
    0x10,
    0x00,
    0x0a,
    0x04,
    0x6d,
    0x61,
    0x69,
    0x6c,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    // MX
    0x04,
    0x6d,
    0x78,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x0f,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x0f,
    0x00,
    0x03,
    0x00,
    0x0a,
    0x00,
    // NID
    0x03,
    0x6e,
    0x69,
    0x64,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x68,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0a,
    0x00,
    0x0a,
    0x00,
    0x14,
    0x4f,
    0xff,
    0xff,
    0x20,
    0xee,
    0x64,
    // A
    0x03,
    0x6e,
    0x73,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x01,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x0a,
    0x35,
    0x00,
    0x02,
    // A
    0x03,
    0x6e,
    0x73,
    0x33,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x01,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x0a,
    0x35,
    0x00,
    0x03,
    // NSEC
    0x06,
    0x6e,
    0x73,
    0x65,
    0x63,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x2f,
    0x00,
    0x01,
    0x00,
    0x00,
    0x04,
    0x0a,
    0x00,
    0x17,
    0x01,
    0x61,
    0x06,
    0x73,
    0x65,
    0x63,
    0x75,
    0x72,
    0x65,
    0x03,
    0x6e,
    0x69,
    0x6c,
    0x00,
    0x00,
    0x07,
    0x22,
    0x01,
    0x00,
    0x04,
    0x00,
    0x03,
    0x80,
    // NSEC
    0x06,
    0x6e,
    0x73,
    0x65,
    0x63,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x2f,
    0x00,
    0x01,
    0x00,
    0x00,
    0x04,
    0x0a,
    0x00,
    0x09,
    0x00,
    0x00,
    0x06,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x01,
    // NSEC
    0x06,
    0x6e,
    0x73,
    0x65,
    0x63,
    0x30,
    0x33,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x2f,
    0x00,
    0x01,
    0x00,
    0x00,
    0x04,
    0x0a,
    0x00,
    0x04,
    0x00,
    0x00,
    0x01,
    0x40,
    // NSEC
    0x06,
    0x6e,
    0x73,
    0x65,
    0x63,
    0x30,
    0x34,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x2f,
    0x00,
    0x01,
    0x00,
    0x00,
    0x04,
    0x0a,
    0x00,
    0x13,
    0x00,
    0x00,
    0x10,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    // OPENPGPKEY
    0x0a,
    0x6f,
    0x70,
    0x65,
    0x6e,
    0x70,
    0x67,
    0x70,
    0x6b,
    0x65,
    0x79,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x3d,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x6b,
    0x01,
    0x03,
    0x05,
    0x0f,
    0x9a,
    0xda,
    0x73,
    0x30,
    0x89,
    0x1d,
    0x58,
    0x8a,
    0xb4,
    0xb6,
    0x21,
    0x58,
    0x6c,
    0xfc,
    0x84,
    0xc6,
    0x3d,
    0x50,
    0x64,
    0x6e,
    0x9e,
    0x22,
    0x43,
    0x07,
    0x30,
    0xbb,
    0xc3,
    0x46,
    0x91,
    0xcb,
    0x35,
    0x99,
    0xae,
    0x23,
    0xba,
    0x8b,
    0x6a,
    0x1d,
    0x19,
    0x65,
    0x90,
    0x56,
    0xe7,
    0x19,
    0xa8,
    0xa5,
    0x6c,
    0x10,
    0xd5,
    0xbd,
    0xd4,
    0x83,
    0x96,
    0xe2,
    0xfa,
    0xae,
    0x76,
    0x78,
    0x0f,
    0x66,
    0xc6,
    0x37,
    0x1a,
    0xf4,
    0x3f,
    0xc5,
    0x50,
    0x3c,
    0xff,
    0xba,
    0x72,
    0x16,
    0x3e,
    0x9b,
    0xec,
    0x4b,
    0x20,
    0x6b,
    0xad,
    0x33,
    0xc8,
    0x65,
    0xba,
    0x2c,
    0x57,
    0xbd,
    0xaf,
    0xc9,
    0xfa,
    0xa5,
    0xa1,
    0xeb,
    0x94,
    0x6e,
    0x68,
    0x8e,
    0xa7,
    0xf4,
    0x05,
    0xaa,
    0x87,
    0x4f,
    0xef,
    // PTR
    0x05,
    0x70,
    0x74,
    0x72,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x0c,
    0x00,
    0x01,
    0x00,
    0x00,
    0x3d,
    0x00,
    0x00,
    0x09,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    // RP
    0x04,
    0x72,
    0x70,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x11,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x3d,
    0x00,
    0x27,
    0x0a,
    0x6d,
    0x62,
    0x6f,
    0x78,
    0x2d,
    0x64,
    0x6e,
    0x61,
    0x6d,
    0x65,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x09,
    0x74,
    0x78,
    0x74,
    0x2d,
    0x64,
    0x6e,
    0x61,
    0x6d,
    0x65,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    // RP
    0x04,
    0x72,
    0x70,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x11,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x3d,
    0x00,
    0x02,
    0x00,
    0x00,
    // RRSIG
    0x07,
    0x72,
    0x72,
    0x73,
    0x69,
    0x67,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x2e,
    0x00,
    0x01,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x6b,
    0x00,
    0x2f,
    0x01,
    0x03,
    0x00,
    0x00,
    0x0e,
    0x10,
    0x38,
    0x6e,
    0xc0,
    0x25,
    0x32,
    0xae,
    0x88,
    0x44,
    0x08,
    0x5f,
    0x03,
    0x66,
    0x6f,
    0x6f,
    0x03,
    0x6e,
    0x69,
    0x6c,
    0x00,
    0x33,
    0x11,
    0x5c,
    0x6f,
    0x2f,
    0x64,
    0xff,
    0x2b,
    0xde,
    0x74,
    0xc7,
    0xd0,
    0x80,
    0xac,
    0xe1,
    0x1f,
    0x97,
    0xab,
    0xd0,
    0xcb,
    0xbf,
    0xbc,
    0x82,
    0xf3,
    0xe3,
    0x92,
    0x24,
    0xb2,
    0x47,
    0x1e,
    0x14,
    0x68,
    0x22,
    0x58,
    0x29,
    0xff,
    0x1b,
    0x11,
    0xe1,
    0x6a,
    0x2e,
    0x95,
    0x02,
    0xe1,
    0xc0,
    0xa0,
    0xd5,
    0x33,
    0xe1,
    0x8a,
    0x14,
    0xd6,
    0xd5,
    0x5f,
    0x48,
    0x24,
    0xaa,
    0x41,
    0x89,
    0xfa,
    0xff,
    0xfd,
    0x75,
    0x53,
    0xa3,
    0x65,
    0x77,
    0xcd,
    0x23,
    0x11,
    0xe0,
    0xbc,
    0x69,
    0x3a,
    0xce,
    0xf8,
    0xa2,
    0xa6,
    0x09,
    0xa6,
    // SPF
    0x05,
    0x73,
    0x70,
    0x66,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x63,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0c,
    0x0b,
    0x76,
    0x3d,
    0x73,
    0x70,
    0x66,
    0x31,
    0x20,
    0x2d,
    0x61,
    0x6c,
    0x6c,
    // SPF
    0x05,
    0x73,
    0x70,
    0x66,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x63,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0d,
    0x06,
    0x76,
    0x3d,
    0x73,
    0x70,
    0x66,
    0x31,
    0x05,
    0x20,
    0x2d,
    0x61,
    0x6c,
    0x6c,

    // SRV
    0x05,
    0x73,
    0x72,
    0x76,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x21,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x07,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    // SRV
    0x05,
    0x73,
    0x72,
    0x76,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x21,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x1c,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0x0c,
    0x6f,
    0x6c,
    0x64,
    0x2d,
    0x73,
    0x6c,
    0x6f,
    0x77,
    0x2d,
    0x62,
    0x6f,
    0x78,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    // SSHFP
    0x07,
    0x73,
    0x73,
    0x68,
    0x66,
    0x70,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x2c,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x1c,
    0x00,
    0x22,
    0x04,
    0x02,
    0xc7,
    0x6d,
    0x83,
    0x29,
    0x95,
    0x4d,
    0xa2,
    0x83,
    0x57,
    0x51,
    0xe3,
    0x71,
    0x54,
    0x4e,
    0x96,
    0x3e,
    0xfd,
    0xa0,
    0x99,
    0x08,
    0x0d,
    0x6c,
    0x58,
    0xdd,
    0x2b,
    0xfd,
    0x9a,
    0x31,
    0x6e,
    0x16,
    0x2c,
    0x83,
    // SSHFP
    0x07,
    0x73,
    0x73,
    0x68,
    0x66,
    0x70,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x2c,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x1c,
    0x00,
    0x22,
    0x01,
    0x02,
    0xbf,
    0x29,
    0x46,
    0x8c,
    0x83,
    0xac,
    0x58,
    0xcc,
    0xf8,
    0xc8,
    0x5a,
    0xb7,
    0xb3,
    0xbe,
    0xb0,
    0x54,
    0xec,
    0xf1,
    0xe3,
    0x85,
    0x12,
    0xb8,
    0x35,
    0x3a,
    0xb3,
    0x64,
    0x71,
    0xfa,
    0x88,
    0x96,
    0x1d,
    0xcc,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x03,
    0x66,
    0x6f,
    0x6f,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x03,
    0x66,
    0x6f,
    0x6f,
    0x03,
    0x62,
    0x61,
    0x72,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x30,
    0x33,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x03,
    0x66,
    0x6f,
    0x6f,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x30,
    0x34,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x03,
    0x66,
    0x6f,
    0x6f,
    0x03,
    0x62,
    0x61,
    0x72,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x30,
    0x35,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x07,
    0x66,
    0x6f,
    0x6f,
    0x20,
    0x62,
    0x61,
    0x72,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x30,
    0x36,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x07,
    0x66,
    0x6f,
    0x6f,
    0x20,
    0x62,
    0x61,
    0x72,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x30,
    0x37,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x07,
    0x66,
    0x6f,
    0x6f,
    0x20,
    0x62,
    0x61,
    0x72,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x30,
    0x38,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x07,
    0x66,
    0x6f,
    0x6f,
    0x0a,
    0x62,
    0x61,
    0x72,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x30,
    0x39,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x07,
    0x66,
    0x6f,
    0x6f,
    0x0a,
    0x62,
    0x61,
    0x72,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x31,
    0x30,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x07,
    0x66,
    0x6f,
    0x6f,
    0x20,
    0x62,
    0x61,
    0x72,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x31,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x06,
    0x05,
    0x22,
    0x66,
    0x6f,
    0x6f,
    0x22,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x31,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x06,
    0x05,
    0x22,
    0x66,
    0x6f,
    0x6f,
    0x22,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x31,
    0x33,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x05,
    0x04,
    0x66,
    0x6f,
    0x6f,
    0x3b,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x31,
    0x34,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x05,
    0x04,
    0x66,
    0x6f,
    0x6f,
    0x3b,
    // TXT
    0x05,
    0x74,
    0x78,
    0x74,
    0x31,
    0x35,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x10,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x06,
    0x05,
    0x62,
    0x61,
    0x72,
    0x5c,
    0x3b,
    // UID
    0x05,
    0x75,
    0x69,
    0x64,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x65,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x02,
    // UINFO
    0x07,
    0x75,
    0x69,
    0x6e,
    0x66,
    0x6f,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x64,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x01,
    0x01,
    // UNSPEC
    0x08,
    0x75,
    0x6e,
    0x73,
    0x70,
    0x65,
    0x63,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x67,
    0x00,
    0x01,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x01,
    0x04,
    // WKS
    0x05,
    0x77,
    0x6b,
    0x73,
    0x30,
    0x31,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x0b,
    0x00,
    0x01,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x08,
    0x0a,
    0x00,
    0x00,
    0x01,
    0x06,
    0xe0,
    0x00,
    0x05,
    // WKS
    0x05,
    0x77,
    0x6b,
    0x73,
    0x30,
    0x32,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x0b,
    0x00,
    0x01,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x0c,
    0x0a,
    0x00,
    0x00,
    0x01,
    0x11,
    0xe0,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    // WKS
    0x05,
    0x77,
    0x6b,
    0x73,
    0x30,
    0x33,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x0b,
    0x00,
    0x01,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x07,
    0x0a,
    0x00,
    0x00,
    0x02,
    0x06,
    0x01,
    0x80,
    // NSEC3PARAM
    0x0a,
    0x6e,
    0x73,
    0x65,
    0x63,
    0x33,
    0x70,
    0x61,
    0x72,
    0x61,
    0x6d,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x33,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x05,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    // DHCID
    0x05,
    0x64,
    0x68,
    0x63,
    0x69,
    0x64,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x31,
    0x00,
    0x01,
    0x00,
    0x00,
    0x33,
    0x00,
    0x00,
    0x23,
    0x00,
    0x02,
    0x01,
    0x63,
    0x6f,
    0xc0,
    0xb8,
    0x27,
    0x1c,
    0x82,
    0x82,
    0x5b,
    0xb1,
    0xac,
    0x5c,
    0x41,
    0xcf,
    0x53,
    0x51,
    0xaa,
    0x69,
    0xb4,
    0xfe,
    0xbd,
    0x94,
    0xe8,
    0xf1,
    0x7c,
    0xdb,
    0x95,
    0x00,
    0x0d,
    0xa4,
    0x8c,
    0x40,
    // NAPTR
    0x05,
    0x6e,
    0x61,
    0x70,
    0x74,
    0x72,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x23,
    0x00,
    0x01,
    0x00,
    0x00,
    0x33,
    0x00,
    0x00,
    0x24,
    0x00,
    0x64,
    0x00,
    0x64,
    0x01,
    0x73,
    0x08,
    0x68,
    0x74,
    0x74,
    0x70,
    0x2b,
    0x49,
    0x32,
    0x52,
    0x00,
    0x05,
    0x5f,
    0x68,
    0x74,
    0x74,
    0x70,
    0x04,
    0x5f,
    0x74,
    0x63,
    0x70,
    0x03,
    0x66,
    0x6f,
    0x6f,
    0x03,
    0x63,
    0x6f,
    0x6d,
    0x00,
    // TLSA
    0x04,
    0x74,
    0x6c,
    0x73,
    0x61,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x34,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x33,
    0x00,
    0x23,
    0x03,
    0x01,
    0x01,
    0xef,
    0xdd,
    0xf0,
    0xd9,
    0x15,
    0xc7,
    0xbd,
    0xc5,
    0x78,
    0x2c,
    0x08,
    0x81,
    0xe1,
    0xb2,
    0xa9,
    0x5a,
    0xd0,
    0x99,
    0xfb,
    0xdd,
    0x06,
    0xd7,
    0xb1,
    0xf7,
    0x79,
    0x82,
    0xd9,
    0x36,
    0x43,
    0x38,
    0xd9,
    0x55,
    // NSEC3
    0x20,
    0x38,
    0x66,
    0x31,
    0x74,
    0x6d,
    0x69,
    0x6f,
    0x39,
    0x61,
    0x76,
    0x63,
    0x6f,
    0x6d,
    0x32,
    0x6b,
    0x30,
    0x66,
    0x72,
    0x70,
    0x39,
    0x32,
    0x6c,
    0x67,
    0x63,
    0x75,
    0x6d,
    0x61,
    0x6b,
    0x30,
    0x63,
    0x61,
    0x64,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x32,
    0x00,
    0x01,
    0x00,
    0x00,
    0xd7,
    0xb1,
    0x00,
    0x2b,
    0x01,
    0x00,
    0x00,
    0x0a,
    0x08,
    0xd2,
    0xcf,
    0x02,
    0x94,
    0xc0,
    0x20,
    0xce,
    0x6c,
    0x14,
    0x43,
    0xf3,
    0x7e,
    0x0b,
    0xcc,
    0xe9,
    0xde,
    0xbe,
    0x18,
    0x83,
    0xec,
    0x72,
    0x25,
    0x9c,
    0xf9,
    0x76,
    0x8e,
    0x7a,
    0x1a,
    0x5e,
    0x00,
    0x07,
    0x62,
    0x01,
    0x00,
    0x08,
    0x00,
    0x02,
    0x90,

    // NSEC3
    0x20,
    0x6b,
    0x63,
    0x64,
    0x33,
    0x6a,
    0x75,
    0x61,
    0x65,
    0x36,
    0x34,
    0x66,
    0x39,
    0x63,
    0x35,
    0x63,
    0x73,
    0x6c,
    0x31,
    0x6b,
    0x69,
    0x66,
    0x31,
    0x68,
    0x74,
    0x61,
    0x75,
    0x69,
    0x37,
    0x75,
    0x6e,
    0x30,
    0x67,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x32,
    0x00,
    0x01,
    0x00,
    0x00,
    0xd7,
    0xb1,
    0x00,
    0x22,
    0x01,
    0x00,
    0x00,
    0x0a,
    0x08,
    0xd2,
    0xcf,
    0x02,
    0x94,
    0xc0,
    0x20,
    0xce,
    0x6c,
    0x14,
    0xa3,
    0x4b,
    0x6b,
    0x8a,
    0xc2,
    0x00,
    0xc8,
    0x06,
    0xc3,
    0x00,
    0x5d,
    0x4f,
    0x7e,
    0xf1,
    0x68,
    0x9e,
    0x48,
    0xbe,
    0x30,
    0xee,
    // NSEC3
    0x20,
    0x6d,
    0x72,
    0x35,
    0x75,
    0x6b,
    0x76,
    0x73,
    0x6b,
    0x31,
    0x6c,
    0x33,
    0x37,
    0x62,
    0x74,
    0x75,
    0x34,
    0x71,
    0x37,
    0x62,
    0x31,
    0x64,
    0x66,
    0x65,
    0x76,
    0x66,
    0x74,
    0x34,
    0x68,
    0x6b,
    0x71,
    0x64,
    0x6b,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x32,
    0x00,
    0x01,
    0x00,
    0x00,
    0xd7,
    0xb1,
    0x00,
    0x2a,
    0x01,
    0x00,
    0x00,
    0x0a,
    0x08,
    0xd2,
    0xcf,
    0x02,
    0x94,
    0xc0,
    0x20,
    0xce,
    0x6c,
    0x14,
    0xb7,
    0x46,
    0x89,
    0x9b,
    0xf0,
    0x3f,
    0x01,
    0xcb,
    0x96,
    0x01,
    0x3d,
    0x99,
    0xe7,
    0x9a,
    0x5a,
    0x95,
    0x1f,
    0xe5,
    0x4c,
    0x05,
    0x00,
    0x06,
    0x40,
    0x00,
    0x00,
    0x08,
    0x00,
    0x02,
    // NSEC3
    0x20,
    0x6d,
    0x72,
    0x35,
    0x75,
    0x6b,
    0x76,
    0x73,
    0x6b,
    0x31,
    0x6c,
    0x33,
    0x37,
    0x62,
    0x74,
    0x75,
    0x34,
    0x71,
    0x37,
    0x62,
    0x31,
    0x64,
    0x66,
    0x65,
    0x76,
    0x66,
    0x74,
    0x34,
    0x68,
    0x6b,
    0x71,
    0x64,
    0x6b,
    0x07,
    0x65,
    0x78,
    0x61,
    0x6d,
    0x70,
    0x6c,
    0x65,
    0x00,
    0x00,
    0x32,
    0x00,
    0x01,
    0x00,
    0x00,
    0xd7,
    0xb1,
    0x00,
    0x00};

static int zone_reader_axfr_test()
{
    int ret;
    yatest_file_create_with(ZONE_FILE_NAME, axfr_wire, sizeof(axfr_wire));
    dnscore_init();
    zone_reader_t zr;
    ret = zone_reader_axfr_open(&zr, ZONE_FILE_NAME); // will close the stream
    if(ret < 0)
    {
        yatest_err("zone_reader_text_open failed with %08x = %s", ret, error_gettext(ret));
        return 1;
    }
    if(!zone_reader_canwriteback(&zr))
    {
        yatest_err("zone_reader_canwriteback returned false");
        return 1;
    }

    resource_record_t rr;
    resource_record_init(&rr);

    bool soa_replaying = false;
    bool soa_replayed = false;

    for(;;)
    {
        ret = zone_reader_read_record(&zr, &rr);
        if(ret <= 0)
        {
            if(ret == 0)
            {
                break;
            }
            yatest_err("zone_reader_read_record returned %08x = %s", ret, error_gettext(ret));
            return 1;
        }
        yatest_log("parsed %s type record", dns_type_get_name(rr.type));

        if(!soa_replayed)
        {
            if(rr.type == TYPE_SOA)
            {
                zone_reader_unread_record(&zr, &rr);
                soa_replaying = true;
                soa_replayed = true;
            }
        }
        else if(soa_replaying)
        {
            if(rr.type != TYPE_SOA)
            {
                yatest_err("replay failed");
                return 1;
            }
            soa_replaying = false;
        }

        resource_record_resetcontent(&rr);
    }

    resource_record_freecontent(&rr);

    zone_reader_free_record(&zr, &rr);
    zone_reader_close(&zr);
    dnscore_finalize();
    return 0;
}

YATEST_TABLE_BEGIN
YATEST(zone_reader_axfr_test)
YATEST_TABLE_END
