#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Gemini Rue
# send your bug reports to contact@dotslashplay.it
###

script_version=20250110.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='gemini-rue'
GAME_NAME='Gemini Rue'

ARCHIVE_BASE_5_NAME='gemini_rue_3_5_78970.sh'
ARCHIVE_BASE_5_MD5='6cf61489438b0155fc1a4a74261b2fde'
ARCHIVE_BASE_5_SIZE='342040'
ARCHIVE_BASE_5_VERSION='3.5-gog78970'
ARCHIVE_BASE_5_URL='https://www.gog.com/game/gemini_rue'

ARCHIVE_BASE_4_NAME='gemini_rue_3_2_76543.sh'
ARCHIVE_BASE_4_MD5='c7a2ad8123a234c168971d76232cf472'
ARCHIVE_BASE_4_SIZE='342040'
ARCHIVE_BASE_4_VERSION='3.2-gog76543'

ARCHIVE_BASE_3_NAME='gemini_rue_3_0_1_66504.sh'
ARCHIVE_BASE_3_MD5='e117463c6b002dbfc57b2adf4d26161b'
ARCHIVE_BASE_3_SIZE='350000'
ARCHIVE_BASE_3_VERSION='3.0.1-gog66504'

ARCHIVE_BASE_2_NAME='gemini_rue_3_0_66190.sh'
ARCHIVE_BASE_2_MD5='3ad7b458713f1ba1d187d90b0dee8eaa'
ARCHIVE_BASE_2_SIZE='350000'
ARCHIVE_BASE_2_VERSION='3.0-gog66190'

ARCHIVE_BASE_1_NAME='gemini_rue_2_3_56797.sh'
ARCHIVE_BASE_1_MD5='f7883371b14f945163ffa040ee47806e'
ARCHIVE_BASE_1_SIZE='340000'
ARCHIVE_BASE_1_VERSION='2.3-gog56797'

ARCHIVE_BASE_0_NAME='gemini_rue_2_0a_53346.sh'
ARCHIVE_BASE_0_MD5='9626ba73b964458b26e25ed9e1ec737d'
ARCHIVE_BASE_0_SIZE='340000'
ARCHIVE_BASE_0_VERSION='2.0a-gog53346'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_NAME='gemini-rue_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_MD5='329019f63b1acdfe7c4d5219a562efab'
## FIXME: Despite its file extension, this is a plain uncompressed tar archive.
ARCHIVE_OPTIONAL_ICONS_TYPE='tar'
ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/gemini-rue/'
CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
256x256'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
ENGV.tmp
Music
Sounds
*.ags
*.cfg
*.exe
*.ogv
*.tra
*.vox'
CONTENT_DOC_MAIN_FILES='
licenses'

APP_MAIN_SCUMMID='ags:geminirue'
APP_MAIN_ICON='../support/icon.png'
APP_MAIN_ICON_1='Gemini Rue.exe'
APP_MAIN_ICON_0='Gemini Rue.exe'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
