/* player.h - low-level audio file player interface
 *
 * Copyright 2010, 2016 Petteri Hintsanen <petterih@iki.fi>
 *
 * This file is part of abx.
 *
 * abx is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * abx is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with abx.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ABX_PLAYER_H
#define ABX_PLAYER_H

#include "soundfile.h"
#include <portaudio.h>

/* Current playback state. */
typedef struct {
    enum { PLAYING, PAUSED, STOPPED } playback;
    double location;
} Player_state;

extern int init_player(PaDeviceIndex outdev, unsigned int latency);
extern void close_player(void);

extern int start_player(Sound_file* f, double offset);
extern void stop_player(void);
extern Player_state pause_or_resume_player(void);
extern double seek_player(double offset, int whence);
extern Player_state get_player_state(void);

#endif
