/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.Pair;
import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgConstraint;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgInheritedColumn;
import cz.startnet.utils.pgdiff.schema.PgPolicy;
import cz.startnet.utils.pgdiff.schema.PgRelation;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PgTable
extends PgRelation {
    private final List<PgInheritedColumn> inheritedColumns = new ArrayList<PgInheritedColumn>();
    private final List<PgConstraint> constraints = new ArrayList<PgConstraint>();
    private final List<Pair<String, String>> inherits = new ArrayList<Pair<String, String>>();
    private String with;
    private boolean unlogged;
    private boolean foreign;
    private Boolean rlsEnabled;
    private Boolean rlsForced;
    private String foreignServer;
    private List<PgPolicy> policies = new ArrayList<PgPolicy>();
    private final PgDatabase database;
    private final PgSchema schema;

    public PgTable(String string, PgDatabase pgDatabase, PgSchema pgSchema) {
        this.setName(string);
        this.database = pgDatabase;
        this.schema = pgSchema;
    }

    public PgConstraint getConstraint(String string) {
        for (PgConstraint pgConstraint : this.constraints) {
            if (!pgConstraint.getName().equals(string)) continue;
            return pgConstraint;
        }
        return null;
    }

    public List<PgConstraint> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    @Override
    public String getRelationKind() {
        return "TABLE";
    }

    public String getCreationSQL(PgSchema pgSchema) {
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append("CREATE ");
        if (this.isUnlogged()) {
            stringBuilder.append("UNLOGGED ");
        }
        if (this.isForeign()) {
            stringBuilder.append("FOREIGN ");
        }
        stringBuilder.append("TABLE ");
        stringBuilder.append(PgDiffUtils.getCreateIfNotExists());
        stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
        stringBuilder.append(" (");
        stringBuilder.append(System.getProperty("line.separator"));
        boolean bl = true;
        if (this.columns.isEmpty()) {
            stringBuilder.append(')');
        } else {
            for (PgColumn object : this.columns) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                    stringBuilder.append(System.getProperty("line.separator"));
                }
                stringBuilder.append("\t");
                stringBuilder.append(object.getFullDefinition(false));
            }
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(")");
        }
        if (this.inherits != null && !this.inherits.isEmpty()) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("INHERITS (");
            bl = true;
            for (Pair pair : this.inherits) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                String string = null;
                string = pgSchema.getName().equals(pair.getL()) ? (String)pair.getR() : String.format("%s.%s", pair.getL(), pair.getR());
                stringBuilder.append(string);
            }
            stringBuilder.append(")");
        }
        if (this.with != null && !this.with.isEmpty()) {
            stringBuilder.append(System.getProperty("line.separator"));
            if ("OIDS=false".equalsIgnoreCase(this.with)) {
                stringBuilder.append("WITHOUT OIDS");
            } else {
                stringBuilder.append("WITH ");
                if ("OIDS".equalsIgnoreCase(this.with) || "OIDS=true".equalsIgnoreCase(this.with)) {
                    stringBuilder.append("OIDS");
                } else {
                    stringBuilder.append(this.with);
                }
            }
        }
        if (this.isForeign()) {
            stringBuilder.append("SERVER ");
            stringBuilder.append(this.getForeignServer());
        }
        if (this.tablespace != null && !this.tablespace.isEmpty()) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("TABLESPACE ");
            stringBuilder.append(this.tablespace);
        }
        stringBuilder.append(';');
        for (PgInheritedColumn pgInheritedColumn : this.getInheritedColumns()) {
            if (pgInheritedColumn.getDefaultValue() == null) continue;
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("ALTER TABLE ONLY ");
            stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("\tALTER COLUMN ");
            stringBuilder.append(PgDiffUtils.getQuotedName(pgInheritedColumn.getInheritedColumn().getName()));
            stringBuilder.append(" SET DEFAULT ");
            stringBuilder.append(pgInheritedColumn.getDefaultValue());
            stringBuilder.append(';');
        }
        for (PgColumn pgColumn : this.getColumnsWithStatistics()) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("ALTER TABLE ONLY ");
            stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
            stringBuilder.append(" ALTER COLUMN ");
            stringBuilder.append(PgDiffUtils.getQuotedName(pgColumn.getName()));
            stringBuilder.append(" SET STATISTICS ");
            stringBuilder.append(pgColumn.getStatistics());
            stringBuilder.append(';');
        }
        stringBuilder.append(this.getCommentDefinitionSQL());
        return stringBuilder.toString();
    }

    public void addInherits(String string, String string2) {
        PgInheritedColumn pgInheritedColumn;
        this.inherits.add(new Pair<String, String>(string, string2));
        PgTable pgTable = this.database.getSchema(string).getTable(string2);
        for (PgColumn object : pgTable.getColumns()) {
            pgInheritedColumn = new PgInheritedColumn(object);
            this.inheritedColumns.add(pgInheritedColumn);
        }
        for (PgInheritedColumn pgInheritedColumn2 : pgTable.getInheritedColumns()) {
            pgInheritedColumn = new PgInheritedColumn(pgInheritedColumn2.getInheritedColumn());
            this.inheritedColumns.add(pgInheritedColumn);
        }
    }

    public List<Pair<String, String>> getInherits() {
        return Collections.unmodifiableList(this.inherits);
    }

    public void setWith(String string) {
        this.with = string;
    }

    public String getWith() {
        return this.with;
    }

    @Override
    public String getTablespace() {
        return this.tablespace;
    }

    @Override
    public void setTablespace(String string) {
        this.tablespace = string;
    }

    @Override
    public void addColumn(PgColumn pgColumn) {
        this.columns.add(pgColumn);
    }

    public void addInheritedColumn(PgInheritedColumn pgInheritedColumn) {
        this.inheritedColumns.add(pgInheritedColumn);
    }

    @Override
    public PgInheritedColumn getInheritedColumn(String string) {
        if (this.inherits != null && !this.inherits.isEmpty()) {
            for (PgInheritedColumn pgInheritedColumn : this.inheritedColumns) {
                if (!pgInheritedColumn.getInheritedColumn().getName().equals(string)) continue;
                return pgInheritedColumn;
            }
        }
        return null;
    }

    public List<PgInheritedColumn> getInheritedColumns() {
        return Collections.unmodifiableList(this.inheritedColumns);
    }

    public void addConstraint(PgConstraint pgConstraint) {
        this.constraints.add(pgConstraint);
    }

    @Override
    public boolean containsInheritedColumn(String string) {
        if (this.inherits != null && !this.inherits.isEmpty()) {
            for (PgInheritedColumn pgInheritedColumn : this.inheritedColumns) {
                if (!pgInheritedColumn.getInheritedColumn().getName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsConstraint(String string) {
        for (PgConstraint pgConstraint : this.constraints) {
            if (!pgConstraint.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private List<PgColumn> getColumnsWithStatistics() {
        ArrayList<PgColumn> arrayList = new ArrayList<PgColumn>();
        for (PgColumn pgColumn : this.columns) {
            if (pgColumn.getStatistics() == null) continue;
            arrayList.add(pgColumn);
        }
        return arrayList;
    }

    public boolean isUnlogged() {
        return this.unlogged;
    }

    public void setUnlogged(boolean bl) {
        this.unlogged = bl;
    }

    @Override
    public String getDropSQL() {
        return "DROP " + (this.isForeign() ? "FOREIGN " : "") + this.getRelationKind() + " " + PgDiffUtils.getDropIfExists() + PgDiffUtils.getQuotedName(this.getName()) + ";";
    }

    public boolean isForeign() {
        return this.foreign;
    }

    public void setForeign(boolean bl) {
        this.foreign = bl;
    }

    public void setForeignServer(String string) {
        this.foreignServer = string;
    }

    public String getForeignServer() {
        return this.foreignServer;
    }

    public Boolean hasRLSEnabled() {
        return this.rlsEnabled;
    }

    public void setRLSEnabled(Boolean bl) {
        this.rlsEnabled = bl;
    }

    public Boolean hasRLSForced() {
        return this.rlsForced;
    }

    public void setRLSForced(Boolean bl) {
        this.rlsForced = bl;
    }

    public void addPolicy(PgPolicy pgPolicy) {
        this.policies.add(pgPolicy);
    }

    public PgPolicy getPolicy(String string) {
        for (PgPolicy pgPolicy : this.policies) {
            if (!pgPolicy.getName().equals(string)) continue;
            return pgPolicy;
        }
        return null;
    }

    public List<PgPolicy> getPolicies() {
        return Collections.unmodifiableList(this.policies);
    }
}

