info = {
    "name": "sr-Latn",
    "date_order": "DMY",
    "january": [
        "januar",
        "jan"
    ],
    "february": [
        "februar",
        "feb"
    ],
    "march": [
        "mart",
        "mar"
    ],
    "april": [
        "april",
        "apr"
    ],
    "may": [
        "maj"
    ],
    "june": [
        "jun"
    ],
    "july": [
        "jul"
    ],
    "august": [
        "avgust",
        "avg"
    ],
    "september": [
        "septembar",
        "sep"
    ],
    "october": [
        "oktobar",
        "okt"
    ],
    "november": [
        "novembar",
        "nov"
    ],
    "december": [
        "decembar",
        "dec"
    ],
    "monday": [
        "ponedeljak",
        "pon"
    ],
    "tuesday": [
        "utorak",
        "uto"
    ],
    "wednesday": [
        "sreda",
        "sre"
    ],
    "thursday": [
        "četvrtak",
        "čet"
    ],
    "friday": [
        "petak",
        "pet"
    ],
    "saturday": [
        "subota",
        "sub"
    ],
    "sunday": [
        "nedelja",
        "ned"
    ],
    "am": [
        "pre podne"
    ],
    "pm": [
        "po podne"
    ],
    "year": [
        "godina",
        "god",
        "g"
    ],
    "month": [
        "mesec",
        "mes",
        "m"
    ],
    "week": [
        "nedelja",
        "ned",
        "n"
    ],
    "day": [
        "dan",
        "d"
    ],
    "hour": [
        "sat",
        "č"
    ],
    "minute": [
        "minut",
        "min"
    ],
    "second": [
        "sekund",
        "sek",
        "s"
    ],
    "relative-type": {
        "1 year ago": [
            "prošle godine"
        ],
        "0 year ago": [
            "ove godine"
        ],
        "in 1 year": [
            "sledeće godine"
        ],
        "1 month ago": [
            "prošlog meseca"
        ],
        "0 month ago": [
            "ovog meseca"
        ],
        "in 1 month": [
            "sledećeg meseca"
        ],
        "1 week ago": [
            "prošle nedelje"
        ],
        "0 week ago": [
            "ove nedelje"
        ],
        "in 1 week": [
            "sledeće nedelje"
        ],
        "1 day ago": [
            "juče"
        ],
        "0 day ago": [
            "danas"
        ],
        "in 1 day": [
            "sutra"
        ],
        "0 hour ago": [
            "ovog sata"
        ],
        "0 minute ago": [
            "ovog minuta"
        ],
        "0 second ago": [
            "sada"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "za (\\d+) godinu",
            "za (\\d+) godina",
            "za (\\d+) god",
            "za (\\d+) g"
        ],
        "\\1 year ago": [
            "pre (\\d+) godine",
            "pre (\\d+) godina",
            "pre (\\d+) god",
            "pre (\\d+) g"
        ],
        "in \\1 month": [
            "za (\\d+) mesec",
            "za (\\d+) meseci",
            "za (\\d+) mes",
            "za (\\d+) m"
        ],
        "\\1 month ago": [
            "pre (\\d+) meseca",
            "pre (\\d+) meseci",
            "pre (\\d+) mes",
            "pre (\\d+) m"
        ],
        "in \\1 week": [
            "za (\\d+) nedelju",
            "za (\\d+) nedelja",
            "za (\\d+) ned",
            "za (\\d+) n"
        ],
        "\\1 week ago": [
            "pre (\\d+) nedelje",
            "pre (\\d+) nedelja",
            "pre (\\d+) ned",
            "pre (\\d+) n"
        ],
        "in \\1 day": [
            "za (\\d+) dan",
            "za (\\d+) dana",
            "za (\\d+) d"
        ],
        "\\1 day ago": [
            "pre (\\d+) dana",
            "pre (\\d+) d"
        ],
        "in \\1 hour": [
            "za (\\d+) sat",
            "za (\\d+) sati",
            "za (\\d+) č"
        ],
        "\\1 hour ago": [
            "pre (\\d+) sata",
            "pre (\\d+) sati",
            "pre (\\d+) č"
        ],
        "in \\1 minute": [
            "za (\\d+) minut",
            "za (\\d+) minuta",
            "za (\\d+) min"
        ],
        "\\1 minute ago": [
            "pre (\\d+) minuta",
            "pre (\\d+) min"
        ],
        "in \\1 second": [
            "za (\\d+) sekundu",
            "za (\\d+) sekundi",
            "za (\\d+) sek",
            "za (\\d+) s"
        ],
        "\\1 second ago": [
            "pre (\\d+) sekunde",
            "pre (\\d+) sekundi",
            "pre (\\d+) sek",
            "pre (\\d+) s"
        ]
    },
    "locale_specific": {
        "sr-Latn-XK": {
            "name": "sr-Latn-XK",
            "september": [
                "sept"
            ],
            "tuesday": [
                "ut"
            ],
            "wednesday": [
                "sr"
            ]
        },
        "sr-Latn-ME": {
            "name": "sr-Latn-ME",
            "september": [
                "sept"
            ],
            "tuesday": [
                "ut"
            ],
            "wednesday": [
                "srijeda",
                "sr"
            ],
            "sunday": [
                "nedjelja"
            ],
            "am": [
                "prije podne"
            ]
        },
        "sr-Latn-BA": {
            "name": "sr-Latn-BA",
            "september": [
                "sept"
            ],
            "tuesday": [
                "ut"
            ],
            "wednesday": [
                "srijeda",
                "sr"
            ],
            "sunday": [
                "nedjelja"
            ],
            "am": [
                "prije podne"
            ]
        }
    },
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
