info = {
    "name": "ar",
    "date_order": "DMY",
    "january": [
        "يناير"
    ],
    "february": [
        "فبراير"
    ],
    "march": [
        "مارس"
    ],
    "april": [
        "أبريل"
    ],
    "may": [
        "مايو"
    ],
    "june": [
        "يونيو"
    ],
    "july": [
        "يوليو"
    ],
    "august": [
        "أغسطس"
    ],
    "september": [
        "سبتمبر"
    ],
    "october": [
        "أكتوبر"
    ],
    "november": [
        "نوفمبر"
    ],
    "december": [
        "ديسمبر"
    ],
    "monday": [
        "الاثنين",
        "الإثنين"
    ],
    "tuesday": [
        "الثلاثاء"
    ],
    "wednesday": [
        "الأربعاء"
    ],
    "thursday": [
        "الخميس"
    ],
    "friday": [
        "الجمعة"
    ],
    "saturday": [
        "السبت"
    ],
    "sunday": [
        "الأحد"
    ],
    "am": [
        "ص",
        "صباحًا",
        "صباحاً"
    ],
    "pm": [
        "م",
        "مساءً"
    ],
    "year": [
        "السنة",
        "عام",
        "سنة"
    ],
    "month": [
        "الشهر",
        "شهر"
    ],
    "week": [
        "الأسبوع",
        "أسبوع"
    ],
    "day": [
        "يوم",
        "أيام"
    ],
    "hour": [
        "الساعات",
        "ساعة",
        "ساعات"
    ],
    "minute": [
        "الدقائق",
        "دقيقة",
        "دقائق"
    ],
    "second": [
        "الثواني",
        "ثانية"
    ],
    "relative-type": {
        "0 day ago": [
            "اليوم"
        ],
        "0 hour ago": [
            "الساعة الحالية"
        ],
        "0 minute ago": [
            "هذه الدقيقة"
        ],
        "0 month ago": [
            "هذا الشهر"
        ],
        "0 second ago": [
            "الآن"
        ],
        "0 week ago": [
            "هذا الأسبوع"
        ],
        "0 year ago": [
            "السنة الحالية"
        ],
        "1 day ago": [
            "أمس",
            "اليوم السابق",
            "الأمس"
        ],
        "1 month ago": [
            "الشهر الماضي"
        ],
        "1 week ago": [
            "الأسبوع الماضي"
        ],
        "1 year ago": [
            "السنة الماضية"
        ],
        "in 1 day": [
            "غدًا"
        ],
        "in 1 month": [
            "الشهر القادم"
        ],
        "in 1 week": [
            "الأسبوع القادم"
        ],
        "in 1 year": [
            "السنة القادمة"
        ],
        "2 day": [
            "يومين"
        ],
        "2 hour": [
            "ساعتين"
        ],
        "1 hour ago": [
            "ساعة واحدة"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "قبل (\\d+[.,]?\\d*) يوم"
        ],
        "\\1 hour ago": [
            "قبل (\\d+[.,]?\\d*) ساعة"
        ],
        "\\1 minute ago": [
            "قبل (\\d+[.,]?\\d*) دقيقة"
        ],
        "\\1 month ago": [
            "قبل (\\d+[.,]?\\d*) شهر"
        ],
        "\\1 second ago": [
            "قبل (\\d+[.,]?\\d*) ثانية"
        ],
        "\\1 week ago": [
            "قبل (\\d+[.,]?\\d*) أسبوع"
        ],
        "\\1 year ago": [
            "قبل (\\d+[.,]?\\d*) سنة"
        ],
        "in \\1 day": [
            "خلال (\\d+[.,]?\\d*) يوم"
        ],
        "in \\1 hour": [
            "خلال (\\d+[.,]?\\d*) ساعة"
        ],
        "in \\1 minute": [
            "خلال (\\d+[.,]?\\d*) دقيقة"
        ],
        "in \\1 month": [
            "خلال (\\d+[.,]?\\d*) شهر"
        ],
        "in \\1 second": [
            "خلال (\\d+[.,]?\\d*) ثانية"
        ],
        "in \\1 week": [
            "خلال (\\d+[.,]?\\d*) أسبوع"
        ],
        "in \\1 year": [
            "خلال (\\d+[.,]?\\d*) سنة"
        ]
    },
    "locale_specific": {
        "ar-AE": {
            "name": "ar-AE",
            "relative-type": {
                "0 year ago": [
                    "هذه السنة"
                ],
                "in 1 year": [
                    "السنة التالية"
                ]
            }
        },
        "ar-BH": {
            "name": "ar-BH"
        },
        "ar-DJ": {
            "name": "ar-DJ"
        },
        "ar-DZ": {
            "name": "ar-DZ",
            "january": [
                "جانفي"
            ],
            "february": [
                "فيفري"
            ],
            "april": [
                "أفريل"
            ],
            "may": [
                "ماي"
            ],
            "june": [
                "جوان"
            ],
            "july": [
                "جويلية"
            ],
            "august": [
                "أوت"
            ]
        },
        "ar-EG": {
            "name": "ar-EG"
        },
        "ar-EH": {
            "name": "ar-EH"
        },
        "ar-ER": {
            "name": "ar-ER"
        },
        "ar-IL": {
            "name": "ar-IL"
        },
        "ar-IQ": {
            "name": "ar-IQ",
            "january": [
                "كانون الثاني"
            ],
            "february": [
                "شباط"
            ],
            "march": [
                "آذار"
            ],
            "april": [
                "نيسان"
            ],
            "may": [
                "أيار"
            ],
            "june": [
                "حزيران"
            ],
            "july": [
                "تموز"
            ],
            "august": [
                "آب"
            ],
            "september": [
                "أيلول"
            ],
            "october": [
                "تشرين الأول",
                "تشرین الأول"
            ],
            "november": [
                "تشرين الثاني"
            ],
            "december": [
                "كانون الأول"
            ]
        },
        "ar-JO": {
            "name": "ar-JO",
            "january": [
                "كانون الثاني"
            ],
            "february": [
                "شباط"
            ],
            "march": [
                "آذار"
            ],
            "april": [
                "نيسان"
            ],
            "may": [
                "أيار"
            ],
            "june": [
                "حزيران"
            ],
            "july": [
                "تموز"
            ],
            "august": [
                "آب"
            ],
            "september": [
                "أيلول"
            ],
            "october": [
                "تشرين الأول"
            ],
            "november": [
                "تشرين الثاني"
            ],
            "december": [
                "كانون الأول"
            ]
        },
        "ar-KM": {
            "name": "ar-KM"
        },
        "ar-KW": {
            "name": "ar-KW"
        },
        "ar-LB": {
            "name": "ar-LB",
            "january": [
                "كانون الثاني"
            ],
            "february": [
                "شباط"
            ],
            "march": [
                "آذار"
            ],
            "april": [
                "نيسان"
            ],
            "may": [
                "أيار"
            ],
            "june": [
                "حزيران"
            ],
            "july": [
                "تموز"
            ],
            "august": [
                "آب"
            ],
            "september": [
                "أيلول"
            ],
            "october": [
                "تشرين الأول"
            ],
            "november": [
                "تشرين الثاني"
            ],
            "december": [
                "كانون الأول"
            ]
        },
        "ar-LY": {
            "name": "ar-LY"
        },
        "ar-MA": {
            "name": "ar-MA",
            "may": [
                "ماي"
            ],
            "july": [
                "يوليوز"
            ],
            "august": [
                "غشت"
            ],
            "september": [
                "شتنبر"
            ],
            "november": [
                "نونبر"
            ],
            "december": [
                "دجنبر"
            ]
        },
        "ar-MR": {
            "name": "ar-MR",
            "april": [
                "إبريل"
            ],
            "august": [
                "أغشت"
            ],
            "september": [
                "شتمبر"
            ],
            "december": [
                "دجمبر"
            ]
        },
        "ar-OM": {
            "name": "ar-OM"
        },
        "ar-PS": {
            "name": "ar-PS",
            "january": [
                "كانون الثاني"
            ],
            "february": [
                "شباط"
            ],
            "march": [
                "آذار"
            ],
            "april": [
                "نيسان"
            ],
            "may": [
                "أيار"
            ],
            "june": [
                "حزيران"
            ],
            "july": [
                "تموز"
            ],
            "august": [
                "آب"
            ],
            "september": [
                "أيلول"
            ],
            "october": [
                "تشرين الأول"
            ],
            "november": [
                "تشرين الثاني"
            ],
            "december": [
                "كانون الأول"
            ]
        },
        "ar-QA": {
            "name": "ar-QA"
        },
        "ar-SA": {
            "name": "ar-SA"
        },
        "ar-SD": {
            "name": "ar-SD"
        },
        "ar-SO": {
            "name": "ar-SO"
        },
        "ar-SS": {
            "name": "ar-SS"
        },
        "ar-SY": {
            "name": "ar-SY",
            "january": [
                "كانون الثاني"
            ],
            "february": [
                "شباط"
            ],
            "march": [
                "آذار"
            ],
            "april": [
                "نيسان"
            ],
            "may": [
                "أيار"
            ],
            "june": [
                "حزيران"
            ],
            "july": [
                "تموز"
            ],
            "august": [
                "آب"
            ],
            "september": [
                "أيلول"
            ],
            "october": [
                "تشرين الأول"
            ],
            "november": [
                "تشرين الثاني"
            ],
            "december": [
                "كانون الأول"
            ]
        },
        "ar-TD": {
            "name": "ar-TD"
        },
        "ar-TN": {
            "name": "ar-TN",
            "january": [
                "جانفي"
            ],
            "february": [
                "فيفري"
            ],
            "april": [
                "أفريل"
            ],
            "may": [
                "ماي"
            ],
            "june": [
                "جوان"
            ],
            "july": [
                "جويلية"
            ],
            "august": [
                "أوت"
            ]
        },
        "ar-YE": {
            "name": "ar-YE"
        }
    },
    "sentence_splitter_group": 6,
    "skip": [
        "الساعة",
        "في",
        "مساءً",
        "هـ",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "ago": [
        "منذ"
    ],
    "in": [
        "خلال"
    ]
}
