;;;;AddMovement
(let ()
     (define (do-movement field)
     	(define ret #f)
     	(d-PreviousMovement)
        (set! ret (d-Directive-movementcontrol?  field))
        (d-NextMovement)
        ret)
    (define (get-data)
        (define ret #f)
     	(d-PreviousMovement)
        (set! ret (d-DirectiveGet-header-data "MovementTitles"))
        (d-NextMovement)
        ret)
    (define (do-simple-titles tag data)
        (define (do-one field)
            (if (assq-ref data field)
                    (DenemoSetTitles tag field #t)))
        (if data 
            (begin
                (set! data (eval-string data))
                
                (do-one 'dedication)
                (do-one 'title)
                (do-one 'subtitle)
                (do-one 'subsubtitle)
                (do-one 'instrument)
                (do-one 'poet)
                (do-one 'composer)
                (do-one 'meter)
                (do-one 'arranger)
                (do-one 'tagline)
                (do-one 'copyright)
                (do-one 'piece)
                (do-one 'opus))))
    (d-NewMovement)
    (let ()
        (let ((time (d-GetPrevailingTimesig)))
            (set! time (d-GetUserInput (_ "Add Movement") (_ "Give time signature") time))
            (if time
                (begin
                    (d-InitialTimeSig time)
                    (while (d-StaffDown)
                        (d-InitialTimeSig time))
                    (while (d-StaffUp)))))
                    
        (if (do-movement "TitledPiece")
            (d-TitledPiece))
        (if (do-movement "Section")
            (d-Section))
        (if (do-movement "Chapter")
            (d-Chapter))
        (do-simple-titles "MovementTitles" (get-data))))