/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains interfaces for {@link org.eclipse.collections.api.partition.bag.PartitionBag}.
 * <p>
 *     A PartitionBag is the result of splitting a {@link org.eclipse.collections.api.bag.Bag} into two bags based on a Predicate.
 * <p>
 *      This package contains 3 interfaces:
 * <ul>
 *     <li>
 *         {@link org.eclipse.collections.api.partition.bag.PartitionBag} - a read-only PartitionBag API.
 *     </li>
 *     <li>
 *         {@link org.eclipse.collections.api.partition.bag.PartitionMutableBag} - a modifiable PartitionBag.
 *     </li>
 *     <li>
 *         {@link org.eclipse.collections.api.partition.bag.PartitionImmutableBag} - the non-modifiable equivalent interface to {@link org.eclipse.collections.api.partition.bag.PartitionMutableBag}.
 *     </li>
 * </ul>
 */
package org.eclipse.collections.api.partition.bag;
