// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file typesCdrAux.ipp
 * This source file contains some declarations of CDR related functions.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__EPROSIMA_FASTDDS_STATISTICS_TYPESCDRAUX_IPP
#define FAST_DDS_GENERATED__EPROSIMA_FASTDDS_STATISTICS_TYPESCDRAUX_IPP

#include "typesCdrAux.hpp"

#include <fastcdr/Cdr.h>
#include <fastcdr/CdrSizeCalculator.hpp>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

namespace eprosima {
namespace fastcdr {

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::detail::EntityId_s& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.value(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::detail::EntityId_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.value()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::detail::EntityId_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.value();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::detail::EntityId_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.value();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::detail::GuidPrefix_s& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.value(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::detail::GuidPrefix_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.value()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::detail::GuidPrefix_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.value();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::detail::GuidPrefix_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.value();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::detail::GUID_s& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.guidPrefix(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.entityId(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::detail::GUID_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.guidPrefix()
        << eprosima::fastcdr::MemberId(1) << data.entityId()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::detail::GUID_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.guidPrefix();
                                            break;

                                        case 1:
                                                dcdr >> data.entityId();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::detail::GUID_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::GuidPrefix_s& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::EntityId_s& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.guidPrefix());

                        serialize_key(scdr, data.entityId());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::detail::SequenceNumber_s& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.high(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.low(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::detail::SequenceNumber_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.high()
        << eprosima::fastcdr::MemberId(1) << data.low()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::detail::SequenceNumber_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.high();
                                            break;

                                        case 1:
                                                dcdr >> data.low();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::detail::SequenceNumber_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.high();

                        scdr << data.low();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::detail::SampleIdentity_s& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.writer_guid(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.sequence_number(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::detail::SampleIdentity_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.writer_guid()
        << eprosima::fastcdr::MemberId(1) << data.sequence_number()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::detail::SampleIdentity_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.writer_guid();
                                            break;

                                        case 1:
                                                dcdr >> data.sequence_number();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::detail::SampleIdentity_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::GUID_s& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::SequenceNumber_s& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.writer_guid());

                        serialize_key(scdr, data.sequence_number());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::detail::Locator_s& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics::detail;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.kind(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.port(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.address(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::detail::Locator_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.kind()
        << eprosima::fastcdr::MemberId(1) << data.port()
        << eprosima::fastcdr::MemberId(2) << data.address()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::detail::Locator_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.kind();
                                            break;

                                        case 1:
                                                dcdr >> data.port();
                                            break;

                                        case 2:
                                                dcdr >> data.address();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::detail::Locator_s& data)
{
    using namespace eprosima::fastdds::statistics::detail;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.kind();

                        scdr << data.port();

                        scdr << data.address();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::DiscoveryTime& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.local_participant_guid(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.remote_entity_guid(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.time(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.host(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.user(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                data.process(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::DiscoveryTime& data)
{
    using namespace eprosima::fastdds::statistics;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.local_participant_guid()
        << eprosima::fastcdr::MemberId(1) << data.remote_entity_guid()
        << eprosima::fastcdr::MemberId(2) << data.time()
        << eprosima::fastcdr::MemberId(3) << data.host()
        << eprosima::fastcdr::MemberId(4) << data.user()
        << eprosima::fastcdr::MemberId(5) << data.process()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::DiscoveryTime& data)
{
    using namespace eprosima::fastdds::statistics;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.local_participant_guid();
                                            break;

                                        case 1:
                                                dcdr >> data.remote_entity_guid();
                                            break;

                                        case 2:
                                                dcdr >> data.time();
                                            break;

                                        case 3:
                                                dcdr >> data.host();
                                            break;

                                        case 4:
                                                dcdr >> data.user();
                                            break;

                                        case 5:
                                                dcdr >> data.process();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::DiscoveryTime& data)
{
    using namespace eprosima::fastdds::statistics;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::GUID_s& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::GUID_s& data);






    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.local_participant_guid());

                        serialize_key(scdr, data.remote_entity_guid());





}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::EntityCount& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.guid(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.count(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::EntityCount& data)
{
    using namespace eprosima::fastdds::statistics;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.guid()
        << eprosima::fastcdr::MemberId(1) << data.count()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::EntityCount& data)
{
    using namespace eprosima::fastdds::statistics;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.guid();
                                            break;

                                        case 1:
                                                dcdr >> data.count();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::EntityCount& data)
{
    using namespace eprosima::fastdds::statistics;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::GUID_s& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.guid());


}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::SampleIdentityCount& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.sample_id(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.count(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::SampleIdentityCount& data)
{
    using namespace eprosima::fastdds::statistics;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.sample_id()
        << eprosima::fastcdr::MemberId(1) << data.count()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::SampleIdentityCount& data)
{
    using namespace eprosima::fastdds::statistics;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.sample_id();
                                            break;

                                        case 1:
                                                dcdr >> data.count();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::SampleIdentityCount& data)
{
    using namespace eprosima::fastdds::statistics;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::SampleIdentity_s& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.sample_id());


}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::Entity2LocatorTraffic& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.src_guid(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.dst_locator(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.packet_count(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.byte_count(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.byte_magnitude_order(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::Entity2LocatorTraffic& data)
{
    using namespace eprosima::fastdds::statistics;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.src_guid()
        << eprosima::fastcdr::MemberId(1) << data.dst_locator()
        << eprosima::fastcdr::MemberId(2) << data.packet_count()
        << eprosima::fastcdr::MemberId(3) << data.byte_count()
        << eprosima::fastcdr::MemberId(4) << data.byte_magnitude_order()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::Entity2LocatorTraffic& data)
{
    using namespace eprosima::fastdds::statistics;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.src_guid();
                                            break;

                                        case 1:
                                                dcdr >> data.dst_locator();
                                            break;

                                        case 2:
                                                dcdr >> data.packet_count();
                                            break;

                                        case 3:
                                                dcdr >> data.byte_count();
                                            break;

                                        case 4:
                                                dcdr >> data.byte_magnitude_order();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::Entity2LocatorTraffic& data)
{
    using namespace eprosima::fastdds::statistics;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::GUID_s& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::Locator_s& data);





    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.src_guid());

                        serialize_key(scdr, data.dst_locator());




}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::WriterReaderData& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.writer_guid(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.reader_guid(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.data(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::WriterReaderData& data)
{
    using namespace eprosima::fastdds::statistics;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.writer_guid()
        << eprosima::fastcdr::MemberId(1) << data.reader_guid()
        << eprosima::fastcdr::MemberId(2) << data.data()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::WriterReaderData& data)
{
    using namespace eprosima::fastdds::statistics;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.writer_guid();
                                            break;

                                        case 1:
                                                dcdr >> data.reader_guid();
                                            break;

                                        case 2:
                                                dcdr >> data.data();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::WriterReaderData& data)
{
    using namespace eprosima::fastdds::statistics;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::GUID_s& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::GUID_s& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.writer_guid());

                        serialize_key(scdr, data.reader_guid());


}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::Locator2LocatorData& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.src_locator(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.dst_locator(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.data(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::Locator2LocatorData& data)
{
    using namespace eprosima::fastdds::statistics;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.src_locator()
        << eprosima::fastcdr::MemberId(1) << data.dst_locator()
        << eprosima::fastcdr::MemberId(2) << data.data()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::Locator2LocatorData& data)
{
    using namespace eprosima::fastdds::statistics;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.src_locator();
                                            break;

                                        case 1:
                                                dcdr >> data.dst_locator();
                                            break;

                                        case 2:
                                                dcdr >> data.data();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::Locator2LocatorData& data)
{
    using namespace eprosima::fastdds::statistics;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::Locator_s& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::Locator_s& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.src_locator());

                        serialize_key(scdr, data.dst_locator());


}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::EntityData& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.guid(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.data(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::EntityData& data)
{
    using namespace eprosima::fastdds::statistics;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.guid()
        << eprosima::fastcdr::MemberId(1) << data.data()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::EntityData& data)
{
    using namespace eprosima::fastdds::statistics;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.guid();
                                            break;

                                        case 1:
                                                dcdr >> data.data();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::EntityData& data)
{
    using namespace eprosima::fastdds::statistics;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::GUID_s& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.guid());


}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::PhysicalData& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.participant_guid(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.host(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.user(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.process(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::PhysicalData& data)
{
    using namespace eprosima::fastdds::statistics;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.participant_guid()
        << eprosima::fastcdr::MemberId(1) << data.host()
        << eprosima::fastcdr::MemberId(2) << data.user()
        << eprosima::fastcdr::MemberId(3) << data.process()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::PhysicalData& data)
{
    using namespace eprosima::fastdds::statistics;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.participant_guid();
                                            break;

                                        case 1:
                                                dcdr >> data.host();
                                            break;

                                        case 2:
                                                dcdr >> data.user();
                                            break;

                                        case 3:
                                                dcdr >> data.process();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::PhysicalData& data)
{
    using namespace eprosima::fastdds::statistics;
            extern void serialize_key(
                    Cdr& scdr,
                    const eprosima::fastdds::statistics::detail::GUID_s& data);





    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.participant_guid());




}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const eprosima::fastdds::statistics::Data& data,
        size_t& current_alignment)
{
    using namespace eprosima::fastdds::statistics;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};

    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0), data._d(),
                    current_alignment);

    switch (data._d())
    {
                case EventKind::HISTORY2HISTORY_LATENCY:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                                data.writer_reader_data(), current_alignment);
                    break;

                case EventKind::NETWORK_LATENCY:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                                data.locator2locator_data(), current_alignment);
                    break;

                case EventKind::PUBLICATION_THROUGHPUT:
                case EventKind::SUBSCRIPTION_THROUGHPUT:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                                data.entity_data(), current_alignment);
                    break;

                case EventKind::RTPS_SENT:
                case EventKind::RTPS_LOST:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                                data.entity2locator_traffic(), current_alignment);
                    break;

                case EventKind::RESENT_DATAS:
                case EventKind::HEARTBEAT_COUNT:
                case EventKind::ACKNACK_COUNT:
                case EventKind::NACKFRAG_COUNT:
                case EventKind::GAP_COUNT:
                case EventKind::DATA_COUNT:
                case EventKind::PDP_PACKETS:
                case EventKind::EDP_PACKETS:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                                data.entity_count(), current_alignment);
                    break;

                case EventKind::DISCOVERED_ENTITY:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(6),
                                data.discovery_time(), current_alignment);
                    break;

                case EventKind::SAMPLE_DATAS:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(7),
                                data.sample_identity_count(), current_alignment);
                    break;

                case EventKind::PHYSICAL_DATA:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(8),
                                data.physical_data(), current_alignment);
                    break;

        default:
            break;
    }

    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}


template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const eprosima::fastdds::statistics::Data& data)
{
    using namespace eprosima::fastdds::statistics;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr << eprosima::fastcdr::MemberId(0) << data._d();

    switch (data._d())
    {
                case EventKind::HISTORY2HISTORY_LATENCY:
                    scdr << eprosima::fastcdr::MemberId(1) << data.writer_reader_data();
                    break;

                case EventKind::NETWORK_LATENCY:
                    scdr << eprosima::fastcdr::MemberId(2) << data.locator2locator_data();
                    break;

                case EventKind::PUBLICATION_THROUGHPUT:
                case EventKind::SUBSCRIPTION_THROUGHPUT:
                    scdr << eprosima::fastcdr::MemberId(3) << data.entity_data();
                    break;

                case EventKind::RTPS_SENT:
                case EventKind::RTPS_LOST:
                    scdr << eprosima::fastcdr::MemberId(4) << data.entity2locator_traffic();
                    break;

                case EventKind::RESENT_DATAS:
                case EventKind::HEARTBEAT_COUNT:
                case EventKind::ACKNACK_COUNT:
                case EventKind::NACKFRAG_COUNT:
                case EventKind::GAP_COUNT:
                case EventKind::DATA_COUNT:
                case EventKind::PDP_PACKETS:
                case EventKind::EDP_PACKETS:
                    scdr << eprosima::fastcdr::MemberId(5) << data.entity_count();
                    break;

                case EventKind::DISCOVERED_ENTITY:
                    scdr << eprosima::fastcdr::MemberId(6) << data.discovery_time();
                    break;

                case EventKind::SAMPLE_DATAS:
                    scdr << eprosima::fastcdr::MemberId(7) << data.sample_identity_count();
                    break;

                case EventKind::PHYSICAL_DATA:
                    scdr << eprosima::fastcdr::MemberId(8) << data.physical_data();
                    break;

        default:
            break;
    }

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        eprosima::fastdds::statistics::Data& data)
{
    using namespace eprosima::fastdds::statistics;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                if (0 == mid.id)
                {
                    uint32_t discriminator;
                    dcdr >> discriminator;

                    switch (discriminator)
                    {
                                                case EventKind::HISTORY2HISTORY_LATENCY:
                                                    {
                                                        eprosima::fastdds::statistics::WriterReaderData writer_reader_data_value;
                                                        data.writer_reader_data(std::move(writer_reader_data_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case EventKind::NETWORK_LATENCY:
                                                    {
                                                        eprosima::fastdds::statistics::Locator2LocatorData locator2locator_data_value;
                                                        data.locator2locator_data(std::move(locator2locator_data_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case EventKind::PUBLICATION_THROUGHPUT:
                                                case EventKind::SUBSCRIPTION_THROUGHPUT:
                                                    {
                                                        eprosima::fastdds::statistics::EntityData entity_data_value;
                                                        data.entity_data(std::move(entity_data_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case EventKind::RTPS_SENT:
                                                case EventKind::RTPS_LOST:
                                                    {
                                                        eprosima::fastdds::statistics::Entity2LocatorTraffic entity2locator_traffic_value;
                                                        data.entity2locator_traffic(std::move(entity2locator_traffic_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case EventKind::RESENT_DATAS:
                                                case EventKind::HEARTBEAT_COUNT:
                                                case EventKind::ACKNACK_COUNT:
                                                case EventKind::NACKFRAG_COUNT:
                                                case EventKind::GAP_COUNT:
                                                case EventKind::DATA_COUNT:
                                                case EventKind::PDP_PACKETS:
                                                case EventKind::EDP_PACKETS:
                                                    {
                                                        eprosima::fastdds::statistics::EntityCount entity_count_value;
                                                        data.entity_count(std::move(entity_count_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case EventKind::DISCOVERED_ENTITY:
                                                    {
                                                        eprosima::fastdds::statistics::DiscoveryTime discovery_time_value;
                                                        data.discovery_time(std::move(discovery_time_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case EventKind::SAMPLE_DATAS:
                                                    {
                                                        eprosima::fastdds::statistics::SampleIdentityCount sample_identity_count_value;
                                                        data.sample_identity_count(std::move(sample_identity_count_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case EventKind::PHYSICAL_DATA:
                                                    {
                                                        eprosima::fastdds::statistics::PhysicalData physical_data_value;
                                                        data.physical_data(std::move(physical_data_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                        default:
                            data._default();
                            break;
                    }
                }
                else
                {
                    switch (data._d())
                    {
                                                case EventKind::HISTORY2HISTORY_LATENCY:
                                                    dcdr >> data.writer_reader_data();
                                                    break;

                                                case EventKind::NETWORK_LATENCY:
                                                    dcdr >> data.locator2locator_data();
                                                    break;

                                                case EventKind::PUBLICATION_THROUGHPUT:
                                                case EventKind::SUBSCRIPTION_THROUGHPUT:
                                                    dcdr >> data.entity_data();
                                                    break;

                                                case EventKind::RTPS_SENT:
                                                case EventKind::RTPS_LOST:
                                                    dcdr >> data.entity2locator_traffic();
                                                    break;

                                                case EventKind::RESENT_DATAS:
                                                case EventKind::HEARTBEAT_COUNT:
                                                case EventKind::ACKNACK_COUNT:
                                                case EventKind::NACKFRAG_COUNT:
                                                case EventKind::GAP_COUNT:
                                                case EventKind::DATA_COUNT:
                                                case EventKind::PDP_PACKETS:
                                                case EventKind::EDP_PACKETS:
                                                    dcdr >> data.entity_count();
                                                    break;

                                                case EventKind::DISCOVERED_ENTITY:
                                                    dcdr >> data.discovery_time();
                                                    break;

                                                case EventKind::SAMPLE_DATAS:
                                                    dcdr >> data.sample_identity_count();
                                                    break;

                                                case EventKind::PHYSICAL_DATA:
                                                    dcdr >> data.physical_data();
                                                    break;

                        default:
                            break;
                    }
                    ret_value = false;
                }
                return ret_value;
            });
}


} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__EPROSIMA_FASTDDS_STATISTICS_TYPESCDRAUX_IPP

