/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Thu May 24 08:06:31 EDT 2018 */

#include "rdft/codelet-rdft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_hc2hc.native -fma -compact -variables 4 -pipeline-latency 4 -n 64 -dit -name hf_64 -include rdft/scalar/hf.h */

/*
 * This function contains 1038 FP additions, 644 FP multiplications,
 * (or, 520 additions, 126 multiplications, 518 fused multiply/add),
 * 190 stack variables, 15 constants, and 256 memory accesses
 */
#include "rdft/scalar/hf.h"

static void hf_64(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 126); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 126, MAKE_VOLATILE_STRIDE(128, rs)) {
	       E Tm, TeM, TjR, Tkl, T7e, TcA, TiV, Tjm, T1G, TeW, TeZ, Thr, T7Q, TcI, T7X;
	       E TcJ, T29, Tf8, Tf5, Thw, T87, TcN, T8u, TcQ, T5K, TfS, Tgc, ThX, Taq, Tdm;
	       E Tbj, Tdx, TN, Tjl, TeP, TiP, T7l, TcB, T7s, TcC, T1f, TeR, TeU, Ths, T7B;
	       E TcF, T7I, TcG, T32, Tfj, Tfg, ThB, T8G, TcU, T93, TcX, T3X, Tfr, TfK, ThM;
	       E T9h, Td3, Taa, Tde, T2A, Tf6, Tfb, Thx, T8m, TcR, T8x, TcO, T3t, Tfh, Tfm;
	       E ThC, T8V, TcY, T96, TcV, T4o, TfL, Tfu, ThN, T9w, Tdf, Tad, Td4, T6b, Tg9;
	       E TfV, ThY, TaF, Tdy, Tbm, Tdn, T4Q, ThJ, TfA, TfN, T9M, Tdh, Taf, Td8, T5h;
	       E ThI, TfF, TfO, Ta1, Tdi, Tag, Tdb, T6D, ThU, Tg1, Tgf, TaV, TdA, Tbo, Tdr;
	       E T74, ThT, Tg6, Tge, Tba, TdB, Tbp, Tdu;
	       {
		    E T1, TiT, T7, TiS, Te, T7a, Tk, T7c;
		    T1 = cr[0];
		    TiT = ci[0];
		    {
			 E T3, T6, T4, TiR, T2, T5;
			 T3 = cr[WS(rs, 32)];
			 T6 = ci[WS(rs, 32)];
			 T2 = W[62];
			 T4 = T2 * T3;
			 TiR = T2 * T6;
			 T5 = W[63];
			 T7 = FMA(T5, T6, T4);
			 TiS = FNMS(T5, T3, TiR);
		    }
		    {
			 E Ta, Td, Tb, T79, T9, Tc;
			 Ta = cr[WS(rs, 16)];
			 Td = ci[WS(rs, 16)];
			 T9 = W[30];
			 Tb = T9 * Ta;
			 T79 = T9 * Td;
			 Tc = W[31];
			 Te = FMA(Tc, Td, Tb);
			 T7a = FNMS(Tc, Ta, T79);
		    }
		    {
			 E Tg, Tj, Th, T7b, Tf, Ti;
			 Tg = cr[WS(rs, 48)];
			 Tj = ci[WS(rs, 48)];
			 Tf = W[94];
			 Th = Tf * Tg;
			 T7b = Tf * Tj;
			 Ti = W[95];
			 Tk = FMA(Ti, Tj, Th);
			 T7c = FNMS(Ti, Tg, T7b);
		    }
		    {
			 E T8, Tl, TjP, TjQ;
			 T8 = T1 + T7;
			 Tl = Te + Tk;
			 Tm = T8 + Tl;
			 TeM = T8 - Tl;
			 TjP = Te - Tk;
			 TjQ = TiT - TiS;
			 TjR = TjP + TjQ;
			 Tkl = TjQ - TjP;
		    }
		    {
			 E T78, T7d, TiQ, TiU;
			 T78 = T1 - T7;
			 T7d = T7a - T7c;
			 T7e = T78 - T7d;
			 TcA = T78 + T7d;
			 TiQ = T7a + T7c;
			 TiU = TiS + TiT;
			 TiV = TiQ + TiU;
			 Tjm = TiU - TiQ;
		    }
	       }
	       {
		    E T1l, T7S, T1E, T7O, T1r, T7U, T1y, T7M;
		    {
			 E T1h, T1k, T1i, T7R, T1g, T1j;
			 T1h = cr[WS(rs, 60)];
			 T1k = ci[WS(rs, 60)];
			 T1g = W[118];
			 T1i = T1g * T1h;
			 T7R = T1g * T1k;
			 T1j = W[119];
			 T1l = FMA(T1j, T1k, T1i);
			 T7S = FNMS(T1j, T1h, T7R);
		    }
		    {
			 E T1A, T1D, T1B, T7N, T1z, T1C;
			 T1A = cr[WS(rs, 44)];
			 T1D = ci[WS(rs, 44)];
			 T1z = W[86];
			 T1B = T1z * T1A;
			 T7N = T1z * T1D;
			 T1C = W[87];
			 T1E = FMA(T1C, T1D, T1B);
			 T7O = FNMS(T1C, T1A, T7N);
		    }
		    {
			 E T1n, T1q, T1o, T7T, T1m, T1p;
			 T1n = cr[WS(rs, 28)];
			 T1q = ci[WS(rs, 28)];
			 T1m = W[54];
			 T1o = T1m * T1n;
			 T7T = T1m * T1q;
			 T1p = W[55];
			 T1r = FMA(T1p, T1q, T1o);
			 T7U = FNMS(T1p, T1n, T7T);
		    }
		    {
			 E T1u, T1x, T1v, T7L, T1t, T1w;
			 T1u = cr[WS(rs, 12)];
			 T1x = ci[WS(rs, 12)];
			 T1t = W[22];
			 T1v = T1t * T1u;
			 T7L = T1t * T1x;
			 T1w = W[23];
			 T1y = FMA(T1w, T1x, T1v);
			 T7M = FNMS(T1w, T1u, T7L);
		    }
		    {
			 E T1s, T1F, TeX, TeY;
			 T1s = T1l + T1r;
			 T1F = T1y + T1E;
			 T1G = T1s + T1F;
			 TeW = T1s - T1F;
			 TeX = T7S + T7U;
			 TeY = T7M + T7O;
			 TeZ = TeX - TeY;
			 Thr = TeX + TeY;
		    }
		    {
			 E T7K, T7P, T7V, T7W;
			 T7K = T1l - T1r;
			 T7P = T7M - T7O;
			 T7Q = T7K - T7P;
			 TcI = T7K + T7P;
			 T7V = T7S - T7U;
			 T7W = T1y - T1E;
			 T7X = T7V + T7W;
			 TcJ = T7V - T7W;
		    }
	       }
	       {
		    E T1O, T8p, T27, T85, T1U, T8r, T21, T83;
		    {
			 E T1K, T1N, T1L, T8o, T1J, T1M;
			 T1K = cr[WS(rs, 2)];
			 T1N = ci[WS(rs, 2)];
			 T1J = W[2];
			 T1L = T1J * T1K;
			 T8o = T1J * T1N;
			 T1M = W[3];
			 T1O = FMA(T1M, T1N, T1L);
			 T8p = FNMS(T1M, T1K, T8o);
		    }
		    {
			 E T23, T26, T24, T84, T22, T25;
			 T23 = cr[WS(rs, 50)];
			 T26 = ci[WS(rs, 50)];
			 T22 = W[98];
			 T24 = T22 * T23;
			 T84 = T22 * T26;
			 T25 = W[99];
			 T27 = FMA(T25, T26, T24);
			 T85 = FNMS(T25, T23, T84);
		    }
		    {
			 E T1Q, T1T, T1R, T8q, T1P, T1S;
			 T1Q = cr[WS(rs, 34)];
			 T1T = ci[WS(rs, 34)];
			 T1P = W[66];
			 T1R = T1P * T1Q;
			 T8q = T1P * T1T;
			 T1S = W[67];
			 T1U = FMA(T1S, T1T, T1R);
			 T8r = FNMS(T1S, T1Q, T8q);
		    }
		    {
			 E T1X, T20, T1Y, T82, T1W, T1Z;
			 T1X = cr[WS(rs, 18)];
			 T20 = ci[WS(rs, 18)];
			 T1W = W[34];
			 T1Y = T1W * T1X;
			 T82 = T1W * T20;
			 T1Z = W[35];
			 T21 = FMA(T1Z, T20, T1Y);
			 T83 = FNMS(T1Z, T1X, T82);
		    }
		    {
			 E T1V, T28, Tf3, Tf4;
			 T1V = T1O + T1U;
			 T28 = T21 + T27;
			 T29 = T1V + T28;
			 Tf8 = T1V - T28;
			 Tf3 = T8p + T8r;
			 Tf4 = T83 + T85;
			 Tf5 = Tf3 - Tf4;
			 Thw = Tf3 + Tf4;
		    }
		    {
			 E T81, T86, T8s, T8t;
			 T81 = T1O - T1U;
			 T86 = T83 - T85;
			 T87 = T81 - T86;
			 TcN = T81 + T86;
			 T8s = T8p - T8r;
			 T8t = T21 - T27;
			 T8u = T8s + T8t;
			 TcQ = T8s - T8t;
		    }
	       }
	       {
		    E T5p, Tbf, T5I, Tao, T5v, Tbh, T5C, Tam;
		    {
			 E T5l, T5o, T5m, Tbe, T5k, T5n;
			 T5l = cr[WS(rs, 63)];
			 T5o = ci[WS(rs, 63)];
			 T5k = W[124];
			 T5m = T5k * T5l;
			 Tbe = T5k * T5o;
			 T5n = W[125];
			 T5p = FMA(T5n, T5o, T5m);
			 Tbf = FNMS(T5n, T5l, Tbe);
		    }
		    {
			 E T5E, T5H, T5F, Tan, T5D, T5G;
			 T5E = cr[WS(rs, 47)];
			 T5H = ci[WS(rs, 47)];
			 T5D = W[92];
			 T5F = T5D * T5E;
			 Tan = T5D * T5H;
			 T5G = W[93];
			 T5I = FMA(T5G, T5H, T5F);
			 Tao = FNMS(T5G, T5E, Tan);
		    }
		    {
			 E T5r, T5u, T5s, Tbg, T5q, T5t;
			 T5r = cr[WS(rs, 31)];
			 T5u = ci[WS(rs, 31)];
			 T5q = W[60];
			 T5s = T5q * T5r;
			 Tbg = T5q * T5u;
			 T5t = W[61];
			 T5v = FMA(T5t, T5u, T5s);
			 Tbh = FNMS(T5t, T5r, Tbg);
		    }
		    {
			 E T5y, T5B, T5z, Tal, T5x, T5A;
			 T5y = cr[WS(rs, 15)];
			 T5B = ci[WS(rs, 15)];
			 T5x = W[28];
			 T5z = T5x * T5y;
			 Tal = T5x * T5B;
			 T5A = W[29];
			 T5C = FMA(T5A, T5B, T5z);
			 Tam = FNMS(T5A, T5y, Tal);
		    }
		    {
			 E T5w, T5J, Tga, Tgb;
			 T5w = T5p + T5v;
			 T5J = T5C + T5I;
			 T5K = T5w + T5J;
			 TfS = T5w - T5J;
			 Tga = Tbf + Tbh;
			 Tgb = Tam + Tao;
			 Tgc = Tga - Tgb;
			 ThX = Tga + Tgb;
		    }
		    {
			 E Tak, Tap, Tbd, Tbi;
			 Tak = T5p - T5v;
			 Tap = Tam - Tao;
			 Taq = Tak - Tap;
			 Tdm = Tak + Tap;
			 Tbd = T5I - T5C;
			 Tbi = Tbf - Tbh;
			 Tbj = Tbd - Tbi;
			 Tdx = Tbi + Tbd;
		    }
	       }
	       {
		    E Ts, T7h, TL, T7q, Ty, T7j, TF, T7o;
		    {
			 E To, Tr, Tp, T7g, Tn, Tq;
			 To = cr[WS(rs, 8)];
			 Tr = ci[WS(rs, 8)];
			 Tn = W[14];
			 Tp = Tn * To;
			 T7g = Tn * Tr;
			 Tq = W[15];
			 Ts = FMA(Tq, Tr, Tp);
			 T7h = FNMS(Tq, To, T7g);
		    }
		    {
			 E TH, TK, TI, T7p, TG, TJ;
			 TH = cr[WS(rs, 24)];
			 TK = ci[WS(rs, 24)];
			 TG = W[46];
			 TI = TG * TH;
			 T7p = TG * TK;
			 TJ = W[47];
			 TL = FMA(TJ, TK, TI);
			 T7q = FNMS(TJ, TH, T7p);
		    }
		    {
			 E Tu, Tx, Tv, T7i, Tt, Tw;
			 Tu = cr[WS(rs, 40)];
			 Tx = ci[WS(rs, 40)];
			 Tt = W[78];
			 Tv = Tt * Tu;
			 T7i = Tt * Tx;
			 Tw = W[79];
			 Ty = FMA(Tw, Tx, Tv);
			 T7j = FNMS(Tw, Tu, T7i);
		    }
		    {
			 E TB, TE, TC, T7n, TA, TD;
			 TB = cr[WS(rs, 56)];
			 TE = ci[WS(rs, 56)];
			 TA = W[110];
			 TC = TA * TB;
			 T7n = TA * TE;
			 TD = W[111];
			 TF = FMA(TD, TE, TC);
			 T7o = FNMS(TD, TB, T7n);
		    }
		    {
			 E Tz, TM, TeN, TeO;
			 Tz = Ts + Ty;
			 TM = TF + TL;
			 TN = Tz + TM;
			 Tjl = Tz - TM;
			 TeN = T7o + T7q;
			 TeO = T7h + T7j;
			 TeP = TeN - TeO;
			 TiP = TeO + TeN;
		    }
		    {
			 E T7f, T7k, T7m, T7r;
			 T7f = Ts - Ty;
			 T7k = T7h - T7j;
			 T7l = T7f - T7k;
			 TcB = T7f + T7k;
			 T7m = TF - TL;
			 T7r = T7o - T7q;
			 T7s = T7m + T7r;
			 TcC = T7m - T7r;
		    }
	       }
	       {
		    E TU, T7D, T1d, T7z, T10, T7F, T17, T7x;
		    {
			 E TQ, TT, TR, T7C, TP, TS;
			 TQ = cr[WS(rs, 4)];
			 TT = ci[WS(rs, 4)];
			 TP = W[6];
			 TR = TP * TQ;
			 T7C = TP * TT;
			 TS = W[7];
			 TU = FMA(TS, TT, TR);
			 T7D = FNMS(TS, TQ, T7C);
		    }
		    {
			 E T19, T1c, T1a, T7y, T18, T1b;
			 T19 = cr[WS(rs, 52)];
			 T1c = ci[WS(rs, 52)];
			 T18 = W[102];
			 T1a = T18 * T19;
			 T7y = T18 * T1c;
			 T1b = W[103];
			 T1d = FMA(T1b, T1c, T1a);
			 T7z = FNMS(T1b, T19, T7y);
		    }
		    {
			 E TW, TZ, TX, T7E, TV, TY;
			 TW = cr[WS(rs, 36)];
			 TZ = ci[WS(rs, 36)];
			 TV = W[70];
			 TX = TV * TW;
			 T7E = TV * TZ;
			 TY = W[71];
			 T10 = FMA(TY, TZ, TX);
			 T7F = FNMS(TY, TW, T7E);
		    }
		    {
			 E T13, T16, T14, T7w, T12, T15;
			 T13 = cr[WS(rs, 20)];
			 T16 = ci[WS(rs, 20)];
			 T12 = W[38];
			 T14 = T12 * T13;
			 T7w = T12 * T16;
			 T15 = W[39];
			 T17 = FMA(T15, T16, T14);
			 T7x = FNMS(T15, T13, T7w);
		    }
		    {
			 E T11, T1e, TeS, TeT;
			 T11 = TU + T10;
			 T1e = T17 + T1d;
			 T1f = T11 + T1e;
			 TeR = T11 - T1e;
			 TeS = T7D + T7F;
			 TeT = T7x + T7z;
			 TeU = TeS - TeT;
			 Ths = TeS + TeT;
		    }
		    {
			 E T7v, T7A, T7G, T7H;
			 T7v = TU - T10;
			 T7A = T7x - T7z;
			 T7B = T7v - T7A;
			 TcF = T7v + T7A;
			 T7G = T7D - T7F;
			 T7H = T17 - T1d;
			 T7I = T7G + T7H;
			 TcG = T7G - T7H;
		    }
	       }
	       {
		    E T2H, T8Y, T30, T8E, T2N, T90, T2U, T8C;
		    {
			 E T2D, T2G, T2E, T8X, T2C, T2F;
			 T2D = cr[WS(rs, 62)];
			 T2G = ci[WS(rs, 62)];
			 T2C = W[122];
			 T2E = T2C * T2D;
			 T8X = T2C * T2G;
			 T2F = W[123];
			 T2H = FMA(T2F, T2G, T2E);
			 T8Y = FNMS(T2F, T2D, T8X);
		    }
		    {
			 E T2W, T2Z, T2X, T8D, T2V, T2Y;
			 T2W = cr[WS(rs, 46)];
			 T2Z = ci[WS(rs, 46)];
			 T2V = W[90];
			 T2X = T2V * T2W;
			 T8D = T2V * T2Z;
			 T2Y = W[91];
			 T30 = FMA(T2Y, T2Z, T2X);
			 T8E = FNMS(T2Y, T2W, T8D);
		    }
		    {
			 E T2J, T2M, T2K, T8Z, T2I, T2L;
			 T2J = cr[WS(rs, 30)];
			 T2M = ci[WS(rs, 30)];
			 T2I = W[58];
			 T2K = T2I * T2J;
			 T8Z = T2I * T2M;
			 T2L = W[59];
			 T2N = FMA(T2L, T2M, T2K);
			 T90 = FNMS(T2L, T2J, T8Z);
		    }
		    {
			 E T2Q, T2T, T2R, T8B, T2P, T2S;
			 T2Q = cr[WS(rs, 14)];
			 T2T = ci[WS(rs, 14)];
			 T2P = W[26];
			 T2R = T2P * T2Q;
			 T8B = T2P * T2T;
			 T2S = W[27];
			 T2U = FMA(T2S, T2T, T2R);
			 T8C = FNMS(T2S, T2Q, T8B);
		    }
		    {
			 E T2O, T31, Tfe, Tff;
			 T2O = T2H + T2N;
			 T31 = T2U + T30;
			 T32 = T2O + T31;
			 Tfj = T2O - T31;
			 Tfe = T8Y + T90;
			 Tff = T8C + T8E;
			 Tfg = Tfe - Tff;
			 ThB = Tfe + Tff;
		    }
		    {
			 E T8A, T8F, T91, T92;
			 T8A = T2H - T2N;
			 T8F = T8C - T8E;
			 T8G = T8A - T8F;
			 TcU = T8A + T8F;
			 T91 = T8Y - T90;
			 T92 = T2U - T30;
			 T93 = T91 + T92;
			 TcX = T91 - T92;
		    }
	       }
	       {
		    E T3C, Ta5, T3V, T9f, T3I, Ta7, T3P, T9d;
		    {
			 E T3y, T3B, T3z, Ta4, T3x, T3A;
			 T3y = cr[WS(rs, 1)];
			 T3B = ci[WS(rs, 1)];
			 T3x = W[0];
			 T3z = T3x * T3y;
			 Ta4 = T3x * T3B;
			 T3A = W[1];
			 T3C = FMA(T3A, T3B, T3z);
			 Ta5 = FNMS(T3A, T3y, Ta4);
		    }
		    {
			 E T3R, T3U, T3S, T9e, T3Q, T3T;
			 T3R = cr[WS(rs, 49)];
			 T3U = ci[WS(rs, 49)];
			 T3Q = W[96];
			 T3S = T3Q * T3R;
			 T9e = T3Q * T3U;
			 T3T = W[97];
			 T3V = FMA(T3T, T3U, T3S);
			 T9f = FNMS(T3T, T3R, T9e);
		    }
		    {
			 E T3E, T3H, T3F, Ta6, T3D, T3G;
			 T3E = cr[WS(rs, 33)];
			 T3H = ci[WS(rs, 33)];
			 T3D = W[64];
			 T3F = T3D * T3E;
			 Ta6 = T3D * T3H;
			 T3G = W[65];
			 T3I = FMA(T3G, T3H, T3F);
			 Ta7 = FNMS(T3G, T3E, Ta6);
		    }
		    {
			 E T3L, T3O, T3M, T9c, T3K, T3N;
			 T3L = cr[WS(rs, 17)];
			 T3O = ci[WS(rs, 17)];
			 T3K = W[32];
			 T3M = T3K * T3L;
			 T9c = T3K * T3O;
			 T3N = W[33];
			 T3P = FMA(T3N, T3O, T3M);
			 T9d = FNMS(T3N, T3L, T9c);
		    }
		    {
			 E T3J, T3W, TfI, TfJ;
			 T3J = T3C + T3I;
			 T3W = T3P + T3V;
			 T3X = T3J + T3W;
			 Tfr = T3J - T3W;
			 TfI = Ta5 + Ta7;
			 TfJ = T9d + T9f;
			 TfK = TfI - TfJ;
			 ThM = TfI + TfJ;
		    }
		    {
			 E T9b, T9g, Ta8, Ta9;
			 T9b = T3C - T3I;
			 T9g = T9d - T9f;
			 T9h = T9b - T9g;
			 Td3 = T9b + T9g;
			 Ta8 = Ta5 - Ta7;
			 Ta9 = T3P - T3V;
			 Taa = Ta8 + Ta9;
			 Tde = Ta8 - Ta9;
		    }
	       }
	       {
		    E T2f, T8a, T2y, T8j, T2l, T8c, T2s, T8h;
		    {
			 E T2b, T2e, T2c, T89, T2a, T2d;
			 T2b = cr[WS(rs, 10)];
			 T2e = ci[WS(rs, 10)];
			 T2a = W[18];
			 T2c = T2a * T2b;
			 T89 = T2a * T2e;
			 T2d = W[19];
			 T2f = FMA(T2d, T2e, T2c);
			 T8a = FNMS(T2d, T2b, T89);
		    }
		    {
			 E T2u, T2x, T2v, T8i, T2t, T2w;
			 T2u = cr[WS(rs, 26)];
			 T2x = ci[WS(rs, 26)];
			 T2t = W[50];
			 T2v = T2t * T2u;
			 T8i = T2t * T2x;
			 T2w = W[51];
			 T2y = FMA(T2w, T2x, T2v);
			 T8j = FNMS(T2w, T2u, T8i);
		    }
		    {
			 E T2h, T2k, T2i, T8b, T2g, T2j;
			 T2h = cr[WS(rs, 42)];
			 T2k = ci[WS(rs, 42)];
			 T2g = W[82];
			 T2i = T2g * T2h;
			 T8b = T2g * T2k;
			 T2j = W[83];
			 T2l = FMA(T2j, T2k, T2i);
			 T8c = FNMS(T2j, T2h, T8b);
		    }
		    {
			 E T2o, T2r, T2p, T8g, T2n, T2q;
			 T2o = cr[WS(rs, 58)];
			 T2r = ci[WS(rs, 58)];
			 T2n = W[114];
			 T2p = T2n * T2o;
			 T8g = T2n * T2r;
			 T2q = W[115];
			 T2s = FMA(T2q, T2r, T2p);
			 T8h = FNMS(T2q, T2o, T8g);
		    }
		    {
			 E T2m, T2z, Tf9, Tfa;
			 T2m = T2f + T2l;
			 T2z = T2s + T2y;
			 T2A = T2m + T2z;
			 Tf6 = T2m - T2z;
			 Tf9 = T8h + T8j;
			 Tfa = T8a + T8c;
			 Tfb = Tf9 - Tfa;
			 Thx = Tfa + Tf9;
			 {
			      E T8e, T8v, T8l, T8w;
			      {
				   E T88, T8d, T8f, T8k;
				   T88 = T2f - T2l;
				   T8d = T8a - T8c;
				   T8e = T88 - T8d;
				   T8v = T88 + T8d;
				   T8f = T2s - T2y;
				   T8k = T8h - T8j;
				   T8l = T8f + T8k;
				   T8w = T8k - T8f;
			      }
			      T8m = T8e + T8l;
			      TcR = T8l - T8e;
			      T8x = T8v + T8w;
			      TcO = T8v - T8w;
			 }
		    }
	       }
	       {
		    E T38, T8J, T3r, T8S, T3e, T8L, T3l, T8Q;
		    {
			 E T34, T37, T35, T8I, T33, T36;
			 T34 = cr[WS(rs, 6)];
			 T37 = ci[WS(rs, 6)];
			 T33 = W[10];
			 T35 = T33 * T34;
			 T8I = T33 * T37;
			 T36 = W[11];
			 T38 = FMA(T36, T37, T35);
			 T8J = FNMS(T36, T34, T8I);
		    }
		    {
			 E T3n, T3q, T3o, T8R, T3m, T3p;
			 T3n = cr[WS(rs, 22)];
			 T3q = ci[WS(rs, 22)];
			 T3m = W[42];
			 T3o = T3m * T3n;
			 T8R = T3m * T3q;
			 T3p = W[43];
			 T3r = FMA(T3p, T3q, T3o);
			 T8S = FNMS(T3p, T3n, T8R);
		    }
		    {
			 E T3a, T3d, T3b, T8K, T39, T3c;
			 T3a = cr[WS(rs, 38)];
			 T3d = ci[WS(rs, 38)];
			 T39 = W[74];
			 T3b = T39 * T3a;
			 T8K = T39 * T3d;
			 T3c = W[75];
			 T3e = FMA(T3c, T3d, T3b);
			 T8L = FNMS(T3c, T3a, T8K);
		    }
		    {
			 E T3h, T3k, T3i, T8P, T3g, T3j;
			 T3h = cr[WS(rs, 54)];
			 T3k = ci[WS(rs, 54)];
			 T3g = W[106];
			 T3i = T3g * T3h;
			 T8P = T3g * T3k;
			 T3j = W[107];
			 T3l = FMA(T3j, T3k, T3i);
			 T8Q = FNMS(T3j, T3h, T8P);
		    }
		    {
			 E T3f, T3s, Tfk, Tfl;
			 T3f = T38 + T3e;
			 T3s = T3l + T3r;
			 T3t = T3f + T3s;
			 Tfh = T3f - T3s;
			 Tfk = T8Q + T8S;
			 Tfl = T8J + T8L;
			 Tfm = Tfk - Tfl;
			 ThC = Tfl + Tfk;
			 {
			      E T8N, T94, T8U, T95;
			      {
				   E T8H, T8M, T8O, T8T;
				   T8H = T38 - T3e;
				   T8M = T8J - T8L;
				   T8N = T8H - T8M;
				   T94 = T8H + T8M;
				   T8O = T3l - T3r;
				   T8T = T8Q - T8S;
				   T8U = T8O + T8T;
				   T95 = T8T - T8O;
			      }
			      T8V = T8N + T8U;
			      TcY = T8U - T8N;
			      T96 = T94 + T95;
			      TcV = T94 - T95;
			 }
		    }
	       }
	       {
		    E T43, T9k, T4m, T9t, T49, T9m, T4g, T9r;
		    {
			 E T3Z, T42, T40, T9j, T3Y, T41;
			 T3Z = cr[WS(rs, 9)];
			 T42 = ci[WS(rs, 9)];
			 T3Y = W[16];
			 T40 = T3Y * T3Z;
			 T9j = T3Y * T42;
			 T41 = W[17];
			 T43 = FMA(T41, T42, T40);
			 T9k = FNMS(T41, T3Z, T9j);
		    }
		    {
			 E T4i, T4l, T4j, T9s, T4h, T4k;
			 T4i = cr[WS(rs, 25)];
			 T4l = ci[WS(rs, 25)];
			 T4h = W[48];
			 T4j = T4h * T4i;
			 T9s = T4h * T4l;
			 T4k = W[49];
			 T4m = FMA(T4k, T4l, T4j);
			 T9t = FNMS(T4k, T4i, T9s);
		    }
		    {
			 E T45, T48, T46, T9l, T44, T47;
			 T45 = cr[WS(rs, 41)];
			 T48 = ci[WS(rs, 41)];
			 T44 = W[80];
			 T46 = T44 * T45;
			 T9l = T44 * T48;
			 T47 = W[81];
			 T49 = FMA(T47, T48, T46);
			 T9m = FNMS(T47, T45, T9l);
		    }
		    {
			 E T4c, T4f, T4d, T9q, T4b, T4e;
			 T4c = cr[WS(rs, 57)];
			 T4f = ci[WS(rs, 57)];
			 T4b = W[112];
			 T4d = T4b * T4c;
			 T9q = T4b * T4f;
			 T4e = W[113];
			 T4g = FMA(T4e, T4f, T4d);
			 T9r = FNMS(T4e, T4c, T9q);
		    }
		    {
			 E T4a, T4n, Tfs, Tft;
			 T4a = T43 + T49;
			 T4n = T4g + T4m;
			 T4o = T4a + T4n;
			 TfL = T4a - T4n;
			 Tfs = T9r + T9t;
			 Tft = T9k + T9m;
			 Tfu = Tfs - Tft;
			 ThN = Tft + Tfs;
			 {
			      E T9o, Tab, T9v, Tac;
			      {
				   E T9i, T9n, T9p, T9u;
				   T9i = T43 - T49;
				   T9n = T9k - T9m;
				   T9o = T9i - T9n;
				   Tab = T9i + T9n;
				   T9p = T4g - T4m;
				   T9u = T9r - T9t;
				   T9v = T9p + T9u;
				   Tac = T9u - T9p;
			      }
			      T9w = T9o + T9v;
			      Tdf = T9v - T9o;
			      Tad = Tab + Tac;
			      Td4 = Tab - Tac;
			 }
		    }
	       }
	       {
		    E T5Q, Tat, T69, TaC, T5W, Tav, T63, TaA;
		    {
			 E T5M, T5P, T5N, Tas, T5L, T5O;
			 T5M = cr[WS(rs, 7)];
			 T5P = ci[WS(rs, 7)];
			 T5L = W[12];
			 T5N = T5L * T5M;
			 Tas = T5L * T5P;
			 T5O = W[13];
			 T5Q = FMA(T5O, T5P, T5N);
			 Tat = FNMS(T5O, T5M, Tas);
		    }
		    {
			 E T65, T68, T66, TaB, T64, T67;
			 T65 = cr[WS(rs, 23)];
			 T68 = ci[WS(rs, 23)];
			 T64 = W[44];
			 T66 = T64 * T65;
			 TaB = T64 * T68;
			 T67 = W[45];
			 T69 = FMA(T67, T68, T66);
			 TaC = FNMS(T67, T65, TaB);
		    }
		    {
			 E T5S, T5V, T5T, Tau, T5R, T5U;
			 T5S = cr[WS(rs, 39)];
			 T5V = ci[WS(rs, 39)];
			 T5R = W[76];
			 T5T = T5R * T5S;
			 Tau = T5R * T5V;
			 T5U = W[77];
			 T5W = FMA(T5U, T5V, T5T);
			 Tav = FNMS(T5U, T5S, Tau);
		    }
		    {
			 E T5Z, T62, T60, Taz, T5Y, T61;
			 T5Z = cr[WS(rs, 55)];
			 T62 = ci[WS(rs, 55)];
			 T5Y = W[108];
			 T60 = T5Y * T5Z;
			 Taz = T5Y * T62;
			 T61 = W[109];
			 T63 = FMA(T61, T62, T60);
			 TaA = FNMS(T61, T5Z, Taz);
		    }
		    {
			 E T5X, T6a, TfT, TfU;
			 T5X = T5Q + T5W;
			 T6a = T63 + T69;
			 T6b = T5X + T6a;
			 Tg9 = T6a - T5X;
			 TfT = TaA + TaC;
			 TfU = Tat + Tav;
			 TfV = TfT - TfU;
			 ThY = TfU + TfT;
			 {
			      E Tax, Tbl, TaE, Tbk;
			      {
				   E Tar, Taw, Tay, TaD;
				   Tar = T5Q - T5W;
				   Taw = Tat - Tav;
				   Tax = Tar - Taw;
				   Tbl = Tar + Taw;
				   Tay = T63 - T69;
				   TaD = TaA - TaC;
				   TaE = Tay + TaD;
				   Tbk = Tay - TaD;
			      }
			      TaF = Tax + TaE;
			      Tdy = TaE - Tax;
			      Tbm = Tbk - Tbl;
			      Tdn = Tbl + Tbk;
			 }
		    }
	       }
	       {
		    E T4v, T9G, T4O, T9C, T4B, T9I, T4I, T9A;
		    {
			 E T4r, T4u, T4s, T9F, T4q, T4t;
			 T4r = cr[WS(rs, 5)];
			 T4u = ci[WS(rs, 5)];
			 T4q = W[8];
			 T4s = T4q * T4r;
			 T9F = T4q * T4u;
			 T4t = W[9];
			 T4v = FMA(T4t, T4u, T4s);
			 T9G = FNMS(T4t, T4r, T9F);
		    }
		    {
			 E T4K, T4N, T4L, T9B, T4J, T4M;
			 T4K = cr[WS(rs, 53)];
			 T4N = ci[WS(rs, 53)];
			 T4J = W[104];
			 T4L = T4J * T4K;
			 T9B = T4J * T4N;
			 T4M = W[105];
			 T4O = FMA(T4M, T4N, T4L);
			 T9C = FNMS(T4M, T4K, T9B);
		    }
		    {
			 E T4x, T4A, T4y, T9H, T4w, T4z;
			 T4x = cr[WS(rs, 37)];
			 T4A = ci[WS(rs, 37)];
			 T4w = W[72];
			 T4y = T4w * T4x;
			 T9H = T4w * T4A;
			 T4z = W[73];
			 T4B = FMA(T4z, T4A, T4y);
			 T9I = FNMS(T4z, T4x, T9H);
		    }
		    {
			 E T4E, T4H, T4F, T9z, T4D, T4G;
			 T4E = cr[WS(rs, 21)];
			 T4H = ci[WS(rs, 21)];
			 T4D = W[40];
			 T4F = T4D * T4E;
			 T9z = T4D * T4H;
			 T4G = W[41];
			 T4I = FMA(T4G, T4H, T4F);
			 T9A = FNMS(T4G, T4E, T9z);
		    }
		    {
			 E T4C, T4P, Tfw, Tfx, Tfy, Tfz;
			 T4C = T4v + T4B;
			 T4P = T4I + T4O;
			 Tfw = T4C - T4P;
			 Tfx = T9G + T9I;
			 Tfy = T9A + T9C;
			 Tfz = Tfx - Tfy;
			 T4Q = T4C + T4P;
			 ThJ = Tfx + Tfy;
			 TfA = Tfw - Tfz;
			 TfN = Tfw + Tfz;
		    }
		    {
			 E T9E, Td6, T9L, Td7;
			 {
			      E T9y, T9D, T9J, T9K;
			      T9y = T4v - T4B;
			      T9D = T9A - T9C;
			      T9E = T9y - T9D;
			      Td6 = T9y + T9D;
			      T9J = T9G - T9I;
			      T9K = T4I - T4O;
			      T9L = T9J + T9K;
			      Td7 = T9J - T9K;
			 }
			 T9M = FNMS(KP414213562, T9L, T9E);
			 Tdh = FNMS(KP414213562, Td6, Td7);
			 Taf = FMA(KP414213562, T9E, T9L);
			 Td8 = FMA(KP414213562, Td7, Td6);
		    }
	       }
	       {
		    E T4W, T9V, T5f, T9R, T52, T9X, T59, T9P;
		    {
			 E T4S, T4V, T4T, T9U, T4R, T4U;
			 T4S = cr[WS(rs, 61)];
			 T4V = ci[WS(rs, 61)];
			 T4R = W[120];
			 T4T = T4R * T4S;
			 T9U = T4R * T4V;
			 T4U = W[121];
			 T4W = FMA(T4U, T4V, T4T);
			 T9V = FNMS(T4U, T4S, T9U);
		    }
		    {
			 E T5b, T5e, T5c, T9Q, T5a, T5d;
			 T5b = cr[WS(rs, 45)];
			 T5e = ci[WS(rs, 45)];
			 T5a = W[88];
			 T5c = T5a * T5b;
			 T9Q = T5a * T5e;
			 T5d = W[89];
			 T5f = FMA(T5d, T5e, T5c);
			 T9R = FNMS(T5d, T5b, T9Q);
		    }
		    {
			 E T4Y, T51, T4Z, T9W, T4X, T50;
			 T4Y = cr[WS(rs, 29)];
			 T51 = ci[WS(rs, 29)];
			 T4X = W[56];
			 T4Z = T4X * T4Y;
			 T9W = T4X * T51;
			 T50 = W[57];
			 T52 = FMA(T50, T51, T4Z);
			 T9X = FNMS(T50, T4Y, T9W);
		    }
		    {
			 E T55, T58, T56, T9O, T54, T57;
			 T55 = cr[WS(rs, 13)];
			 T58 = ci[WS(rs, 13)];
			 T54 = W[24];
			 T56 = T54 * T55;
			 T9O = T54 * T58;
			 T57 = W[25];
			 T59 = FMA(T57, T58, T56);
			 T9P = FNMS(T57, T55, T9O);
		    }
		    {
			 E T53, T5g, TfB, TfC, TfD, TfE;
			 T53 = T4W + T52;
			 T5g = T59 + T5f;
			 TfB = T53 - T5g;
			 TfC = T9V + T9X;
			 TfD = T9P + T9R;
			 TfE = TfC - TfD;
			 T5h = T53 + T5g;
			 ThI = TfC + TfD;
			 TfF = TfB + TfE;
			 TfO = TfE - TfB;
		    }
		    {
			 E T9T, Td9, Ta0, Tda;
			 {
			      E T9N, T9S, T9Y, T9Z;
			      T9N = T4W - T52;
			      T9S = T9P - T9R;
			      T9T = T9N - T9S;
			      Td9 = T9N + T9S;
			      T9Y = T9V - T9X;
			      T9Z = T59 - T5f;
			      Ta0 = T9Y + T9Z;
			      Tda = T9Y - T9Z;
			 }
			 Ta1 = FMA(KP414213562, Ta0, T9T);
			 Tdi = FMA(KP414213562, Td9, Tda);
			 Tag = FNMS(KP414213562, T9T, Ta0);
			 Tdb = FNMS(KP414213562, Tda, Td9);
		    }
	       }
	       {
		    E T6i, TaQ, T6B, TaL, T6o, TaS, T6v, TaJ;
		    {
			 E T6e, T6h, T6f, TaP, T6d, T6g;
			 T6e = cr[WS(rs, 3)];
			 T6h = ci[WS(rs, 3)];
			 T6d = W[4];
			 T6f = T6d * T6e;
			 TaP = T6d * T6h;
			 T6g = W[5];
			 T6i = FMA(T6g, T6h, T6f);
			 TaQ = FNMS(T6g, T6e, TaP);
		    }
		    {
			 E T6x, T6A, T6y, TaK, T6w, T6z;
			 T6x = cr[WS(rs, 51)];
			 T6A = ci[WS(rs, 51)];
			 T6w = W[100];
			 T6y = T6w * T6x;
			 TaK = T6w * T6A;
			 T6z = W[101];
			 T6B = FMA(T6z, T6A, T6y);
			 TaL = FNMS(T6z, T6x, TaK);
		    }
		    {
			 E T6k, T6n, T6l, TaR, T6j, T6m;
			 T6k = cr[WS(rs, 35)];
			 T6n = ci[WS(rs, 35)];
			 T6j = W[68];
			 T6l = T6j * T6k;
			 TaR = T6j * T6n;
			 T6m = W[69];
			 T6o = FMA(T6m, T6n, T6l);
			 TaS = FNMS(T6m, T6k, TaR);
		    }
		    {
			 E T6r, T6u, T6s, TaI, T6q, T6t;
			 T6r = cr[WS(rs, 19)];
			 T6u = ci[WS(rs, 19)];
			 T6q = W[36];
			 T6s = T6q * T6r;
			 TaI = T6q * T6u;
			 T6t = W[37];
			 T6v = FMA(T6t, T6u, T6s);
			 TaJ = FNMS(T6t, T6r, TaI);
		    }
		    {
			 E T6p, T6C, TfX, TfY, TfZ, Tg0;
			 T6p = T6i + T6o;
			 T6C = T6v + T6B;
			 TfX = T6p - T6C;
			 TfY = TaQ + TaS;
			 TfZ = TaJ + TaL;
			 Tg0 = TfY - TfZ;
			 T6D = T6p + T6C;
			 ThU = TfY + TfZ;
			 Tg1 = TfX - Tg0;
			 Tgf = TfX + Tg0;
		    }
		    {
			 E TaN, Tdp, TaU, Tdq;
			 {
			      E TaH, TaM, TaO, TaT;
			      TaH = T6i - T6o;
			      TaM = TaJ - TaL;
			      TaN = TaH - TaM;
			      Tdp = TaH + TaM;
			      TaO = T6B - T6v;
			      TaT = TaQ - TaS;
			      TaU = TaO - TaT;
			      Tdq = TaT + TaO;
			 }
			 TaV = FMA(KP414213562, TaU, TaN);
			 TdA = FNMS(KP414213562, Tdp, Tdq);
			 Tbo = FNMS(KP414213562, TaN, TaU);
			 Tdr = FMA(KP414213562, Tdq, Tdp);
		    }
	       }
	       {
		    E T6J, Tb5, T72, Tb0, T6P, Tb7, T6W, TaY;
		    {
			 E T6F, T6I, T6G, Tb4, T6E, T6H;
			 T6F = cr[WS(rs, 59)];
			 T6I = ci[WS(rs, 59)];
			 T6E = W[116];
			 T6G = T6E * T6F;
			 Tb4 = T6E * T6I;
			 T6H = W[117];
			 T6J = FMA(T6H, T6I, T6G);
			 Tb5 = FNMS(T6H, T6F, Tb4);
		    }
		    {
			 E T6Y, T71, T6Z, TaZ, T6X, T70;
			 T6Y = cr[WS(rs, 43)];
			 T71 = ci[WS(rs, 43)];
			 T6X = W[84];
			 T6Z = T6X * T6Y;
			 TaZ = T6X * T71;
			 T70 = W[85];
			 T72 = FMA(T70, T71, T6Z);
			 Tb0 = FNMS(T70, T6Y, TaZ);
		    }
		    {
			 E T6L, T6O, T6M, Tb6, T6K, T6N;
			 T6L = cr[WS(rs, 27)];
			 T6O = ci[WS(rs, 27)];
			 T6K = W[52];
			 T6M = T6K * T6L;
			 Tb6 = T6K * T6O;
			 T6N = W[53];
			 T6P = FMA(T6N, T6O, T6M);
			 Tb7 = FNMS(T6N, T6L, Tb6);
		    }
		    {
			 E T6S, T6V, T6T, TaX, T6R, T6U;
			 T6S = cr[WS(rs, 11)];
			 T6V = ci[WS(rs, 11)];
			 T6R = W[20];
			 T6T = T6R * T6S;
			 TaX = T6R * T6V;
			 T6U = W[21];
			 T6W = FMA(T6U, T6V, T6T);
			 TaY = FNMS(T6U, T6S, TaX);
		    }
		    {
			 E T6Q, T73, Tg2, Tg3, Tg4, Tg5;
			 T6Q = T6J + T6P;
			 T73 = T6W + T72;
			 Tg2 = T6Q - T73;
			 Tg3 = Tb5 + Tb7;
			 Tg4 = TaY + Tb0;
			 Tg5 = Tg3 - Tg4;
			 T74 = T6Q + T73;
			 ThT = Tg3 + Tg4;
			 Tg6 = Tg2 + Tg5;
			 Tge = Tg2 - Tg5;
		    }
		    {
			 E Tb2, Tds, Tb9, Tdt;
			 {
			      E TaW, Tb1, Tb3, Tb8;
			      TaW = T6J - T6P;
			      Tb1 = TaY - Tb0;
			      Tb2 = TaW - Tb1;
			      Tds = TaW + Tb1;
			      Tb3 = T72 - T6W;
			      Tb8 = Tb5 - Tb7;
			      Tb9 = Tb3 - Tb8;
			      Tdt = Tb8 + Tb3;
			 }
			 Tba = FNMS(KP414213562, Tb9, Tb2);
			 TdB = FMA(KP414213562, Tds, Tdt);
			 Tbp = FMA(KP414213562, Tb2, Tb9);
			 Tdu = FNMS(KP414213562, Tdt, Tds);
		    }
	       }
	       {
		    E T1I, Tio, T3v, Tj1, TiX, Tj2, Tir, TiN, T76, TiJ, TiC, TiG, T5j, TiK, Tix;
		    E TiF;
		    {
			 E TO, T1H, Tip, Tiq;
			 TO = Tm + TN;
			 T1H = T1f + T1G;
			 T1I = TO + T1H;
			 Tio = TO - T1H;
			 {
			      E T2B, T3u, TiO, TiW;
			      T2B = T29 + T2A;
			      T3u = T32 + T3t;
			      T3v = T2B + T3u;
			      Tj1 = T2B - T3u;
			      TiO = Ths + Thr;
			      TiW = TiP + TiV;
			      TiX = TiO + TiW;
			      Tj2 = TiW - TiO;
			 }
			 Tip = ThB + ThC;
			 Tiq = Thw + Thx;
			 Tir = Tip - Tiq;
			 TiN = Tiq + Tip;
			 {
			      E T6c, T75, Tiy, Tiz, TiA, TiB;
			      T6c = T5K + T6b;
			      T75 = T6D + T74;
			      Tiy = T6c - T75;
			      Tiz = ThX + ThY;
			      TiA = ThU + ThT;
			      TiB = Tiz - TiA;
			      T76 = T6c + T75;
			      TiJ = Tiz + TiA;
			      TiC = Tiy - TiB;
			      TiG = Tiy + TiB;
			 }
			 {
			      E T4p, T5i, Tit, Tiu, Tiv, Tiw;
			      T4p = T3X + T4o;
			      T5i = T4Q + T5h;
			      Tit = T4p - T5i;
			      Tiu = ThM + ThN;
			      Tiv = ThJ + ThI;
			      Tiw = Tiu - Tiv;
			      T5j = T4p + T5i;
			      TiK = Tiu + Tiv;
			      Tix = Tit + Tiw;
			      TiF = Tit - Tiw;
			 }
		    }
		    {
			 E T3w, T77, Tj3, Tj4;
			 T3w = T1I + T3v;
			 T77 = T5j + T76;
			 ci[WS(rs, 31)] = T3w - T77;
			 cr[0] = T3w + T77;
			 Tj3 = Tj1 + Tj2;
			 Tj4 = TiC - Tix;
			 cr[WS(rs, 56)] = FMS(KP707106781, Tj4, Tj3);
			 ci[WS(rs, 39)] = FMA(KP707106781, Tj4, Tj3);
		    }
		    {
			 E Tj5, Tj6, Tis, TiD;
			 Tj5 = Tj2 - Tj1;
			 Tj6 = TiG - TiF;
			 cr[WS(rs, 40)] = FMS(KP707106781, Tj6, Tj5);
			 ci[WS(rs, 55)] = FMA(KP707106781, Tj6, Tj5);
			 Tis = Tio - Tir;
			 TiD = Tix + TiC;
			 ci[WS(rs, 23)] = FNMS(KP707106781, TiD, Tis);
			 cr[WS(rs, 8)] = FMA(KP707106781, TiD, Tis);
		    }
		    {
			 E TiE, TiH, TiM, TiY;
			 TiE = Tio + Tir;
			 TiH = TiF + TiG;
			 cr[WS(rs, 24)] = FNMS(KP707106781, TiH, TiE);
			 ci[WS(rs, 7)] = FMA(KP707106781, TiH, TiE);
			 TiM = TiK + TiJ;
			 TiY = TiN + TiX;
			 cr[WS(rs, 32)] = TiM - TiY;
			 ci[WS(rs, 63)] = TiM + TiY;
		    }
		    {
			 E TiZ, Tj0, TiI, TiL;
			 TiZ = T76 - T5j;
			 Tj0 = TiX - TiN;
			 cr[WS(rs, 48)] = TiZ - Tj0;
			 ci[WS(rs, 47)] = TiZ + Tj0;
			 TiI = T1I - T3v;
			 TiL = TiJ - TiK;
			 cr[WS(rs, 16)] = TiI - TiL;
			 ci[WS(rs, 15)] = TiI + TiL;
		    }
	       }
	       {
		    E T99, Tk2, TbB, TjW, Taj, TbL, Tbv, TbF, Tce, Tcy, Tci, Tcu, Tc7, Tcx, Tch;
		    E Tcr, TbZ, Tkg, Tcn, Tka, Tbs, TbM, Tbw, TbI, T80, Tk9, Tkf, Tby, TbS, TjV;
		    E Tk1, Tck;
		    {
			 E T8z, Tbz, T98, TbA;
			 {
			      E T8n, T8y, T8W, T97;
			      T8n = FMA(KP707106781, T8m, T87);
			      T8y = FMA(KP707106781, T8x, T8u);
			      T8z = FNMS(KP198912367, T8y, T8n);
			      Tbz = FMA(KP198912367, T8n, T8y);
			      T8W = FMA(KP707106781, T8V, T8G);
			      T97 = FMA(KP707106781, T96, T93);
			      T98 = FMA(KP198912367, T97, T8W);
			      TbA = FNMS(KP198912367, T8W, T97);
			 }
			 T99 = T8z + T98;
			 Tk2 = T98 - T8z;
			 TbB = Tbz - TbA;
			 TjW = Tbz + TbA;
		    }
		    {
			 E Ta3, TbD, Tai, TbE;
			 {
			      E T9x, Ta2, Tae, Tah;
			      T9x = FMA(KP707106781, T9w, T9h);
			      Ta2 = T9M + Ta1;
			      Ta3 = FMA(KP923879532, Ta2, T9x);
			      TbD = FNMS(KP923879532, Ta2, T9x);
			      Tae = FMA(KP707106781, Tad, Taa);
			      Tah = Taf + Tag;
			      Tai = FMA(KP923879532, Tah, Tae);
			      TbE = FNMS(KP923879532, Tah, Tae);
			 }
			 Taj = FNMS(KP098491403, Tai, Ta3);
			 TbL = FNMS(KP820678790, TbD, TbE);
			 Tbv = FMA(KP098491403, Ta3, Tai);
			 TbF = FMA(KP820678790, TbE, TbD);
		    }
		    {
			 E Tca, Tcs, Tcd, Tct;
			 {
			      E Tc8, Tc9, Tcb, Tcc;
			      Tc8 = FNMS(KP707106781, TaF, Taq);
			      Tc9 = Tbp - Tbo;
			      Tca = FNMS(KP923879532, Tc9, Tc8);
			      Tcs = FMA(KP923879532, Tc9, Tc8);
			      Tcb = FNMS(KP707106781, Tbm, Tbj);
			      Tcc = Tba - TaV;
			      Tcd = FMA(KP923879532, Tcc, Tcb);
			      Tct = FNMS(KP923879532, Tcc, Tcb);
			 }
			 Tce = FNMS(KP534511135, Tcd, Tca);
			 Tcy = FNMS(KP303346683, Tcs, Tct);
			 Tci = FMA(KP534511135, Tca, Tcd);
			 Tcu = FMA(KP303346683, Tct, Tcs);
		    }
		    {
			 E Tc3, Tcp, Tc6, Tcq;
			 {
			      E Tc1, Tc2, Tc4, Tc5;
			      Tc1 = FNMS(KP707106781, T9w, T9h);
			      Tc2 = Taf - Tag;
			      Tc3 = FNMS(KP923879532, Tc2, Tc1);
			      Tcp = FMA(KP923879532, Tc2, Tc1);
			      Tc4 = FNMS(KP707106781, Tad, Taa);
			      Tc5 = Ta1 - T9M;
			      Tc6 = FNMS(KP923879532, Tc5, Tc4);
			      Tcq = FMA(KP923879532, Tc5, Tc4);
			 }
			 Tc7 = FNMS(KP534511135, Tc6, Tc3);
			 Tcx = FNMS(KP303346683, Tcp, Tcq);
			 Tch = FMA(KP534511135, Tc3, Tc6);
			 Tcr = FMA(KP303346683, Tcq, Tcp);
		    }
		    {
			 E TbV, Tcm, TbY, Tcl;
			 {
			      E TbT, TbU, TbW, TbX;
			      TbT = FNMS(KP707106781, T96, T93);
			      TbU = FNMS(KP707106781, T8V, T8G);
			      TbV = FMA(KP668178637, TbU, TbT);
			      Tcm = FNMS(KP668178637, TbT, TbU);
			      TbW = FNMS(KP707106781, T8x, T8u);
			      TbX = FNMS(KP707106781, T8m, T87);
			      TbY = FNMS(KP668178637, TbX, TbW);
			      Tcl = FMA(KP668178637, TbW, TbX);
			 }
			 TbZ = TbV - TbY;
			 Tkg = Tcl - Tcm;
			 Tcn = Tcl + Tcm;
			 Tka = TbY + TbV;
		    }
		    {
			 E Tbc, TbG, Tbr, TbH;
			 {
			      E TaG, Tbb, Tbn, Tbq;
			      TaG = FMA(KP707106781, TaF, Taq);
			      Tbb = TaV + Tba;
			      Tbc = FMA(KP923879532, Tbb, TaG);
			      TbG = FNMS(KP923879532, Tbb, TaG);
			      Tbn = FMA(KP707106781, Tbm, Tbj);
			      Tbq = Tbo + Tbp;
			      Tbr = FMA(KP923879532, Tbq, Tbn);
			      TbH = FNMS(KP923879532, Tbq, Tbn);
			 }
			 Tbs = FNMS(KP098491403, Tbr, Tbc);
			 TbM = FNMS(KP820678790, TbG, TbH);
			 Tbw = FMA(KP098491403, Tbc, Tbr);
			 TbI = FMA(KP820678790, TbH, TbG);
		    }
		    {
			 E T7u, TbO, TjT, Tk7, T7Z, Tk8, TbR, TjU, T7t, TjS;
			 T7t = T7l + T7s;
			 T7u = FMA(KP707106781, T7t, T7e);
			 TbO = FNMS(KP707106781, T7t, T7e);
			 TjS = TcB - TcC;
			 TjT = FMA(KP707106781, TjS, TjR);
			 Tk7 = FNMS(KP707106781, TjS, TjR);
			 {
			      E T7J, T7Y, TbP, TbQ;
			      T7J = FNMS(KP414213562, T7I, T7B);
			      T7Y = FMA(KP414213562, T7X, T7Q);
			      T7Z = T7J + T7Y;
			      Tk8 = T7Y - T7J;
			      TbP = FMA(KP414213562, T7B, T7I);
			      TbQ = FNMS(KP414213562, T7Q, T7X);
			      TbR = TbP - TbQ;
			      TjU = TbP + TbQ;
			 }
			 T80 = FMA(KP923879532, T7Z, T7u);
			 Tk9 = FMA(KP923879532, Tk8, Tk7);
			 Tkf = FNMS(KP923879532, Tk8, Tk7);
			 Tby = FNMS(KP923879532, T7Z, T7u);
			 TbS = FNMS(KP923879532, TbR, TbO);
			 TjV = FMA(KP923879532, TjU, TjT);
			 Tk1 = FNMS(KP923879532, TjU, TjT);
			 Tck = FMA(KP923879532, TbR, TbO);
		    }
		    {
			 E T9a, Tbt, TbK, TbN;
			 T9a = FMA(KP980785280, T99, T80);
			 Tbt = Taj + Tbs;
			 cr[WS(rs, 31)] = FNMS(KP995184726, Tbt, T9a);
			 ci[0] = FMA(KP995184726, Tbt, T9a);
			 TbK = FNMS(KP980785280, TbB, Tby);
			 TbN = TbL + TbM;
			 cr[WS(rs, 23)] = FMA(KP773010453, TbN, TbK);
			 ci[WS(rs, 8)] = FNMS(KP773010453, TbN, TbK);
		    }
		    {
			 E Tkb, Tkc, Tkj, Tkk;
			 Tkb = FMA(KP831469612, Tka, Tk9);
			 Tkc = Tcx - Tcy;
			 cr[WS(rs, 35)] = FMS(KP956940335, Tkc, Tkb);
			 ci[WS(rs, 60)] = FMA(KP956940335, Tkc, Tkb);
			 Tkj = FNMS(KP831469612, Tkg, Tkf);
			 Tkk = Tce - Tc7;
			 cr[WS(rs, 43)] = FMS(KP881921264, Tkk, Tkj);
			 ci[WS(rs, 52)] = FMA(KP881921264, Tkk, Tkj);
		    }
		    {
			 E Tbu, Tbx, TbC, TbJ;
			 Tbu = FNMS(KP980785280, T99, T80);
			 Tbx = Tbv + Tbw;
			 ci[WS(rs, 16)] = FNMS(KP995184726, Tbx, Tbu);
			 cr[WS(rs, 15)] = FMA(KP995184726, Tbx, Tbu);
			 TbC = FMA(KP980785280, TbB, Tby);
			 TbJ = TbF + TbI;
			 ci[WS(rs, 24)] = FNMS(KP773010453, TbJ, TbC);
			 cr[WS(rs, 7)] = FMA(KP773010453, TbJ, TbC);
		    }
		    {
			 E Tkd, Tke, Tkh, Tki;
			 Tkd = FNMS(KP831469612, Tka, Tk9);
			 Tke = Tcu - Tcr;
			 cr[WS(rs, 51)] = FMS(KP956940335, Tke, Tkd);
			 ci[WS(rs, 44)] = FMA(KP956940335, Tke, Tkd);
			 Tkh = FMA(KP831469612, Tkg, Tkf);
			 Tki = Tci - Tch;
			 cr[WS(rs, 59)] = FMS(KP881921264, Tki, Tkh);
			 ci[WS(rs, 36)] = FMA(KP881921264, Tki, Tkh);
		    }
		    {
			 E Tc0, Tcf, Tcw, Tcz;
			 Tc0 = FMA(KP831469612, TbZ, TbS);
			 Tcf = Tc7 + Tce;
			 cr[WS(rs, 27)] = FNMS(KP881921264, Tcf, Tc0);
			 ci[WS(rs, 4)] = FMA(KP881921264, Tcf, Tc0);
			 Tcw = FNMS(KP831469612, Tcn, Tck);
			 Tcz = Tcx + Tcy;
			 cr[WS(rs, 19)] = FMA(KP956940335, Tcz, Tcw);
			 ci[WS(rs, 12)] = FNMS(KP956940335, Tcz, Tcw);
		    }
		    {
			 E TjX, TjY, Tk5, Tk6;
			 TjX = FMA(KP980785280, TjW, TjV);
			 TjY = Tbw - Tbv;
			 cr[WS(rs, 63)] = FMS(KP995184726, TjY, TjX);
			 ci[WS(rs, 32)] = FMA(KP995184726, TjY, TjX);
			 Tk5 = FNMS(KP980785280, Tk2, Tk1);
			 Tk6 = TbI - TbF;
			 cr[WS(rs, 55)] = FMS(KP773010453, Tk6, Tk5);
			 ci[WS(rs, 40)] = FMA(KP773010453, Tk6, Tk5);
		    }
		    {
			 E Tcg, Tcj, Tco, Tcv;
			 Tcg = FNMS(KP831469612, TbZ, TbS);
			 Tcj = Tch + Tci;
			 ci[WS(rs, 20)] = FNMS(KP881921264, Tcj, Tcg);
			 cr[WS(rs, 11)] = FMA(KP881921264, Tcj, Tcg);
			 Tco = FMA(KP831469612, Tcn, Tck);
			 Tcv = Tcr + Tcu;
			 ci[WS(rs, 28)] = FNMS(KP956940335, Tcv, Tco);
			 cr[WS(rs, 3)] = FMA(KP956940335, Tcv, Tco);
		    }
		    {
			 E TjZ, Tk0, Tk3, Tk4;
			 TjZ = FNMS(KP980785280, TjW, TjV);
			 Tk0 = Tbs - Taj;
			 cr[WS(rs, 47)] = FMS(KP995184726, Tk0, TjZ);
			 ci[WS(rs, 48)] = FMA(KP995184726, Tk0, TjZ);
			 Tk3 = FMA(KP980785280, Tk2, Tk1);
			 Tk4 = TbL - TbM;
			 cr[WS(rs, 39)] = FMS(KP773010453, Tk4, Tk3);
			 ci[WS(rs, 56)] = FMA(KP773010453, Tk4, Tk3);
		    }
	       }
	       {
		    E Thu, Ti8, Tj9, Tjf, ThF, Tjg, Tib, Tja, ThR, Til, Ti6, Tif, Ti2, Tim, Ti5;
		    E Tii;
		    {
			 E Thq, Tht, Tj7, Tj8;
			 Thq = Tm - TN;
			 Tht = Thr - Ths;
			 Thu = Thq - Tht;
			 Ti8 = Thq + Tht;
			 Tj7 = T1f - T1G;
			 Tj8 = TiV - TiP;
			 Tj9 = Tj7 + Tj8;
			 Tjf = Tj8 - Tj7;
		    }
		    {
			 E Thz, Ti9, ThE, Tia;
			 {
			      E Thv, Thy, ThA, ThD;
			      Thv = T29 - T2A;
			      Thy = Thw - Thx;
			      Thz = Thv + Thy;
			      Ti9 = Thv - Thy;
			      ThA = T32 - T3t;
			      ThD = ThB - ThC;
			      ThE = ThA - ThD;
			      Tia = ThA + ThD;
			 }
			 ThF = Thz + ThE;
			 Tjg = Tia - Ti9;
			 Tib = Ti9 + Tia;
			 Tja = Thz - ThE;
		    }
		    {
			 E ThL, Tid, ThQ, Tie;
			 {
			      E ThH, ThK, ThO, ThP;
			      ThH = T3X - T4o;
			      ThK = ThI - ThJ;
			      ThL = ThH - ThK;
			      Tid = ThH + ThK;
			      ThO = ThM - ThN;
			      ThP = T4Q - T5h;
			      ThQ = ThO - ThP;
			      Tie = ThO + ThP;
			 }
			 ThR = FMA(KP414213562, ThQ, ThL);
			 Til = FMA(KP414213562, Tid, Tie);
			 Ti6 = FNMS(KP414213562, ThL, ThQ);
			 Tif = FNMS(KP414213562, Tie, Tid);
		    }
		    {
			 E ThW, Tig, Ti1, Tih;
			 {
			      E ThS, ThV, ThZ, Ti0;
			      ThS = T5K - T6b;
			      ThV = ThT - ThU;
			      ThW = ThS - ThV;
			      Tig = ThS + ThV;
			      ThZ = ThX - ThY;
			      Ti0 = T74 - T6D;
			      Ti1 = ThZ + Ti0;
			      Tih = Ti0 - ThZ;
			 }
			 Ti2 = FNMS(KP414213562, Ti1, ThW);
			 Tim = FMA(KP414213562, Tig, Tih);
			 Ti5 = FMA(KP414213562, ThW, Ti1);
			 Tii = FNMS(KP414213562, Tih, Tig);
		    }
		    {
			 E ThG, Ti3, Tjh, Tji;
			 ThG = FMA(KP707106781, ThF, Thu);
			 Ti3 = ThR + Ti2;
			 ci[WS(rs, 27)] = FNMS(KP923879532, Ti3, ThG);
			 cr[WS(rs, 4)] = FMA(KP923879532, Ti3, ThG);
			 Tjh = FMA(KP707106781, Tjg, Tjf);
			 Tji = Ti6 + Ti5;
			 cr[WS(rs, 36)] = FMS(KP923879532, Tji, Tjh);
			 ci[WS(rs, 59)] = FMA(KP923879532, Tji, Tjh);
		    }
		    {
			 E Tjj, Tjk, Ti4, Ti7;
			 Tjj = FNMS(KP707106781, Tjg, Tjf);
			 Tjk = Ti2 - ThR;
			 cr[WS(rs, 52)] = FMS(KP923879532, Tjk, Tjj);
			 ci[WS(rs, 43)] = FMA(KP923879532, Tjk, Tjj);
			 Ti4 = FNMS(KP707106781, ThF, Thu);
			 Ti7 = Ti5 - Ti6;
			 cr[WS(rs, 20)] = FNMS(KP923879532, Ti7, Ti4);
			 ci[WS(rs, 11)] = FMA(KP923879532, Ti7, Ti4);
		    }
		    {
			 E Tic, Tij, Tjb, Tjc;
			 Tic = FMA(KP707106781, Tib, Ti8);
			 Tij = Tif + Tii;
			 cr[WS(rs, 28)] = FNMS(KP923879532, Tij, Tic);
			 ci[WS(rs, 3)] = FMA(KP923879532, Tij, Tic);
			 Tjb = FMA(KP707106781, Tja, Tj9);
			 Tjc = Tim - Til;
			 cr[WS(rs, 60)] = FMS(KP923879532, Tjc, Tjb);
			 ci[WS(rs, 35)] = FMA(KP923879532, Tjc, Tjb);
		    }
		    {
			 E Tjd, Tje, Tik, Tin;
			 Tjd = FNMS(KP707106781, Tja, Tj9);
			 Tje = Tii - Tif;
			 cr[WS(rs, 44)] = FMS(KP923879532, Tje, Tjd);
			 ci[WS(rs, 51)] = FMA(KP923879532, Tje, Tjd);
			 Tik = FNMS(KP707106781, Tib, Ti8);
			 Tin = Til + Tim;
			 ci[WS(rs, 19)] = FNMS(KP923879532, Tin, Tik);
			 cr[WS(rs, 12)] = FMA(KP923879532, Tin, Tik);
		    }
	       }
	       {
		    E Tf2, TjJ, Tgo, TjD, TgI, Tjv, Tha, Tjp, Tfp, Tjw, Tgr, Tjq, Th4, Tho, Th7;
		    E Thk, TfR, TgB, Tgl, Tgv, TgP, TjK, Thd, TjE, TgX, Thn, Th8, Thh, Tgi, TgC;
		    E Tgm, Tgy;
		    {
			 E TeQ, TjB, Tf1, TjC, TeV, Tf0;
			 TeQ = TeM + TeP;
			 TjB = Tjm - Tjl;
			 TeV = TeR - TeU;
			 Tf0 = TeW + TeZ;
			 Tf1 = TeV + Tf0;
			 TjC = Tf0 - TeV;
			 Tf2 = FNMS(KP707106781, Tf1, TeQ);
			 TjJ = FNMS(KP707106781, TjC, TjB);
			 Tgo = FMA(KP707106781, Tf1, TeQ);
			 TjD = FMA(KP707106781, TjC, TjB);
		    }
		    {
			 E TgE, Tjn, TgH, Tjo, TgF, TgG;
			 TgE = TeM - TeP;
			 Tjn = Tjl + Tjm;
			 TgF = TeR + TeU;
			 TgG = TeW - TeZ;
			 TgH = TgF + TgG;
			 Tjo = TgF - TgG;
			 TgI = FMA(KP707106781, TgH, TgE);
			 Tjv = FNMS(KP707106781, Tjo, Tjn);
			 Tha = FNMS(KP707106781, TgH, TgE);
			 Tjp = FMA(KP707106781, Tjo, Tjn);
		    }
		    {
			 E Tfd, Tgp, Tfo, Tgq;
			 {
			      E Tf7, Tfc, Tfi, Tfn;
			      Tf7 = Tf5 + Tf6;
			      Tfc = Tf8 + Tfb;
			      Tfd = FMA(KP414213562, Tfc, Tf7);
			      Tgp = FNMS(KP414213562, Tf7, Tfc);
			      Tfi = Tfg + Tfh;
			      Tfn = Tfj + Tfm;
			      Tfo = FNMS(KP414213562, Tfn, Tfi);
			      Tgq = FMA(KP414213562, Tfi, Tfn);
			 }
			 Tfp = Tfd - Tfo;
			 Tjw = Tgq - Tgp;
			 Tgr = Tgp + Tgq;
			 Tjq = Tfd + Tfo;
		    }
		    {
			 E Th0, Thi, Th3, Thj;
			 {
			      E TgY, TgZ, Th1, Th2;
			      TgY = TfS - TfV;
			      TgZ = Tgf + Tge;
			      Th0 = FMA(KP707106781, TgZ, TgY);
			      Thi = FNMS(KP707106781, TgZ, TgY);
			      Th1 = Tgc + Tg9;
			      Th2 = Tg6 - Tg1;
			      Th3 = FMA(KP707106781, Th2, Th1);
			      Thj = FNMS(KP707106781, Th2, Th1);
			 }
			 Th4 = FNMS(KP198912367, Th3, Th0);
			 Tho = FNMS(KP668178637, Thi, Thj);
			 Th7 = FMA(KP198912367, Th0, Th3);
			 Thk = FMA(KP668178637, Thj, Thi);
		    }
		    {
			 E TfH, Tgt, TfQ, Tgu;
			 {
			      E Tfv, TfG, TfM, TfP;
			      Tfv = Tfr + Tfu;
			      TfG = TfA + TfF;
			      TfH = FNMS(KP707106781, TfG, Tfv);
			      Tgt = FMA(KP707106781, TfG, Tfv);
			      TfM = TfK + TfL;
			      TfP = TfN + TfO;
			      TfQ = FNMS(KP707106781, TfP, TfM);
			      Tgu = FMA(KP707106781, TfP, TfM);
			 }
			 TfR = FMA(KP668178637, TfQ, TfH);
			 TgB = FMA(KP198912367, Tgt, Tgu);
			 Tgl = FNMS(KP668178637, TfH, TfQ);
			 Tgv = FNMS(KP198912367, Tgu, Tgt);
		    }
		    {
			 E TgL, Thc, TgO, Thb;
			 {
			      E TgJ, TgK, TgM, TgN;
			      TgJ = Tf8 - Tfb;
			      TgK = Tf5 - Tf6;
			      TgL = FMA(KP414213562, TgK, TgJ);
			      Thc = FNMS(KP414213562, TgJ, TgK);
			      TgM = Tfj - Tfm;
			      TgN = Tfg - Tfh;
			      TgO = FNMS(KP414213562, TgN, TgM);
			      Thb = FMA(KP414213562, TgM, TgN);
			 }
			 TgP = TgL + TgO;
			 TjK = TgL - TgO;
			 Thd = Thb - Thc;
			 TjE = Thc + Thb;
		    }
		    {
			 E TgT, Thf, TgW, Thg;
			 {
			      E TgR, TgS, TgU, TgV;
			      TgR = Tfr - Tfu;
			      TgS = TfN - TfO;
			      TgT = FMA(KP707106781, TgS, TgR);
			      Thf = FNMS(KP707106781, TgS, TgR);
			      TgU = TfK - TfL;
			      TgV = TfF - TfA;
			      TgW = FMA(KP707106781, TgV, TgU);
			      Thg = FNMS(KP707106781, TgV, TgU);
			 }
			 TgX = FMA(KP198912367, TgW, TgT);
			 Thn = FMA(KP668178637, Thf, Thg);
			 Th8 = FNMS(KP198912367, TgT, TgW);
			 Thh = FNMS(KP668178637, Thg, Thf);
		    }
		    {
			 E Tg8, Tgw, Tgh, Tgx;
			 {
			      E TfW, Tg7, Tgd, Tgg;
			      TfW = TfS + TfV;
			      Tg7 = Tg1 + Tg6;
			      Tg8 = FNMS(KP707106781, Tg7, TfW);
			      Tgw = FMA(KP707106781, Tg7, TfW);
			      Tgd = Tg9 - Tgc;
			      Tgg = Tge - Tgf;
			      Tgh = FNMS(KP707106781, Tgg, Tgd);
			      Tgx = FMA(KP707106781, Tgg, Tgd);
			 }
			 Tgi = FMA(KP668178637, Tgh, Tg8);
			 TgC = FMA(KP198912367, Tgw, Tgx);
			 Tgm = FNMS(KP668178637, Tg8, Tgh);
			 Tgy = FNMS(KP198912367, Tgx, Tgw);
		    }
		    {
			 E Tfq, Tgj, TgA, TgD;
			 Tfq = FMA(KP923879532, Tfp, Tf2);
			 Tgj = TfR + Tgi;
			 ci[WS(rs, 25)] = FNMS(KP831469612, Tgj, Tfq);
			 cr[WS(rs, 6)] = FMA(KP831469612, Tgj, Tfq);
			 TgA = FNMS(KP923879532, Tgr, Tgo);
			 TgD = TgB + TgC;
			 ci[WS(rs, 17)] = FNMS(KP980785280, TgD, TgA);
			 cr[WS(rs, 14)] = FMA(KP980785280, TgD, TgA);
		    }
		    {
			 E TjF, TjG, TjN, TjO;
			 TjF = FMA(KP923879532, TjE, TjD);
			 TjG = Th8 + Th7;
			 cr[WS(rs, 34)] = FMS(KP980785280, TjG, TjF);
			 ci[WS(rs, 61)] = FMA(KP980785280, TjG, TjF);
			 TjN = FNMS(KP923879532, TjK, TjJ);
			 TjO = Thk - Thh;
			 cr[WS(rs, 42)] = FMS(KP831469612, TjO, TjN);
			 ci[WS(rs, 53)] = FMA(KP831469612, TjO, TjN);
		    }
		    {
			 E Tgk, Tgn, Tgs, Tgz;
			 Tgk = FNMS(KP923879532, Tfp, Tf2);
			 Tgn = Tgl + Tgm;
			 cr[WS(rs, 22)] = FMA(KP831469612, Tgn, Tgk);
			 ci[WS(rs, 9)] = FNMS(KP831469612, Tgn, Tgk);
			 Tgs = FMA(KP923879532, Tgr, Tgo);
			 Tgz = Tgv + Tgy;
			 cr[WS(rs, 30)] = FNMS(KP980785280, Tgz, Tgs);
			 ci[WS(rs, 1)] = FMA(KP980785280, Tgz, Tgs);
		    }
		    {
			 E TjH, TjI, TjL, TjM;
			 TjH = FNMS(KP923879532, TjE, TjD);
			 TjI = Th4 - TgX;
			 cr[WS(rs, 50)] = FMS(KP980785280, TjI, TjH);
			 ci[WS(rs, 45)] = FMA(KP980785280, TjI, TjH);
			 TjL = FMA(KP923879532, TjK, TjJ);
			 TjM = Thn + Tho;
			 cr[WS(rs, 58)] = -(FMA(KP831469612, TjM, TjL));
			 ci[WS(rs, 37)] = FNMS(KP831469612, TjM, TjL);
		    }
		    {
			 E TgQ, Th5, Thm, Thp;
			 TgQ = FMA(KP923879532, TgP, TgI);
			 Th5 = TgX + Th4;
			 ci[WS(rs, 29)] = FNMS(KP980785280, Th5, TgQ);
			 cr[WS(rs, 2)] = FMA(KP980785280, Th5, TgQ);
			 Thm = FNMS(KP923879532, Thd, Tha);
			 Thp = Thn - Tho;
			 ci[WS(rs, 21)] = FNMS(KP831469612, Thp, Thm);
			 cr[WS(rs, 10)] = FMA(KP831469612, Thp, Thm);
		    }
		    {
			 E Tjr, Tjs, Tjz, TjA;
			 Tjr = FMA(KP923879532, Tjq, Tjp);
			 Tjs = TgC - TgB;
			 cr[WS(rs, 62)] = FMS(KP980785280, Tjs, Tjr);
			 ci[WS(rs, 33)] = FMA(KP980785280, Tjs, Tjr);
			 Tjz = FNMS(KP923879532, Tjw, Tjv);
			 TjA = Tgi - TfR;
			 cr[WS(rs, 54)] = FMS(KP831469612, TjA, Tjz);
			 ci[WS(rs, 41)] = FMA(KP831469612, TjA, Tjz);
		    }
		    {
			 E Th6, Th9, The, Thl;
			 Th6 = FNMS(KP923879532, TgP, TgI);
			 Th9 = Th7 - Th8;
			 cr[WS(rs, 18)] = FNMS(KP980785280, Th9, Th6);
			 ci[WS(rs, 13)] = FMA(KP980785280, Th9, Th6);
			 The = FMA(KP923879532, Thd, Tha);
			 Thl = Thh + Thk;
			 cr[WS(rs, 26)] = FNMS(KP831469612, Thl, The);
			 ci[WS(rs, 5)] = FMA(KP831469612, Thl, The);
		    }
		    {
			 E Tjt, Tju, Tjx, Tjy;
			 Tjt = FNMS(KP923879532, Tjq, Tjp);
			 Tju = Tgy - Tgv;
			 cr[WS(rs, 46)] = FMS(KP980785280, Tju, Tjt);
			 ci[WS(rs, 49)] = FMA(KP980785280, Tju, Tjt);
			 Tjx = FMA(KP923879532, Tjw, Tjv);
			 Tjy = Tgl - Tgm;
			 cr[WS(rs, 38)] = FMS(KP831469612, Tjy, Tjx);
			 ci[WS(rs, 57)] = FMA(KP831469612, Tjy, Tjx);
		    }
	       }
	       {
		    E Td1, Tkw, TdN, Tkq, Tdl, TdX, TdI, TdR, Teq, TeK, Tet, TeG, Tej, TeJ, Teu;
		    E TeD, Teb, TkK, Tez, TkE, TdE, TdY, TdH, TdU, TcM, TkD, TkJ, TdK, Te4, Tkp;
		    E Tkv, Tew;
		    {
			 E TcT, TdM, Td0, TdL;
			 {
			      E TcP, TcS, TcW, TcZ;
			      TcP = FMA(KP707106781, TcO, TcN);
			      TcS = FMA(KP707106781, TcR, TcQ);
			      TcT = FMA(KP198912367, TcS, TcP);
			      TdM = FNMS(KP198912367, TcP, TcS);
			      TcW = FMA(KP707106781, TcV, TcU);
			      TcZ = FMA(KP707106781, TcY, TcX);
			      Td0 = FNMS(KP198912367, TcZ, TcW);
			      TdL = FMA(KP198912367, TcW, TcZ);
			 }
			 Td1 = TcT + Td0;
			 Tkw = TcT - Td0;
			 TdN = TdL - TdM;
			 Tkq = TdM + TdL;
		    }
		    {
			 E Tdd, TdP, Tdk, TdQ;
			 {
			      E Td5, Tdc, Tdg, Tdj;
			      Td5 = FMA(KP707106781, Td4, Td3);
			      Tdc = Td8 + Tdb;
			      Tdd = FMA(KP923879532, Tdc, Td5);
			      TdP = FNMS(KP923879532, Tdc, Td5);
			      Tdg = FMA(KP707106781, Tdf, Tde);
			      Tdj = Tdh + Tdi;
			      Tdk = FMA(KP923879532, Tdj, Tdg);
			      TdQ = FNMS(KP923879532, Tdj, Tdg);
			 }
			 Tdl = FMA(KP098491403, Tdk, Tdd);
			 TdX = FMA(KP820678790, TdP, TdQ);
			 TdI = FNMS(KP098491403, Tdd, Tdk);
			 TdR = FNMS(KP820678790, TdQ, TdP);
		    }
		    {
			 E Tem, TeE, Tep, TeF;
			 {
			      E Tek, Tel, Ten, Teo;
			      Tek = FNMS(KP707106781, Tdn, Tdm);
			      Tel = TdB - TdA;
			      Tem = FNMS(KP923879532, Tel, Tek);
			      TeE = FMA(KP923879532, Tel, Tek);
			      Ten = FNMS(KP707106781, Tdy, Tdx);
			      Teo = Tdu - Tdr;
			      Tep = FMA(KP923879532, Teo, Ten);
			      TeF = FNMS(KP923879532, Teo, Ten);
			 }
			 Teq = FNMS(KP534511135, Tep, Tem);
			 TeK = FNMS(KP303346683, TeE, TeF);
			 Tet = FMA(KP534511135, Tem, Tep);
			 TeG = FMA(KP303346683, TeF, TeE);
		    }
		    {
			 E Tef, TeB, Tei, TeC;
			 {
			      E Ted, Tee, Teg, Teh;
			      Ted = FNMS(KP707106781, Td4, Td3);
			      Tee = Tdi - Tdh;
			      Tef = FNMS(KP923879532, Tee, Ted);
			      TeB = FMA(KP923879532, Tee, Ted);
			      Teg = FNMS(KP707106781, Tdf, Tde);
			      Teh = Td8 - Tdb;
			      Tei = FNMS(KP923879532, Teh, Teg);
			      TeC = FMA(KP923879532, Teh, Teg);
			 }
			 Tej = FMA(KP534511135, Tei, Tef);
			 TeJ = FMA(KP303346683, TeB, TeC);
			 Teu = FNMS(KP534511135, Tef, Tei);
			 TeD = FNMS(KP303346683, TeC, TeB);
		    }
		    {
			 E Te7, Tex, Tea, Tey;
			 {
			      E Te5, Te6, Te8, Te9;
			      Te5 = FNMS(KP707106781, TcR, TcQ);
			      Te6 = FNMS(KP707106781, TcO, TcN);
			      Te7 = FMA(KP668178637, Te6, Te5);
			      Tex = FNMS(KP668178637, Te5, Te6);
			      Te8 = FNMS(KP707106781, TcY, TcX);
			      Te9 = FNMS(KP707106781, TcV, TcU);
			      Tea = FNMS(KP668178637, Te9, Te8);
			      Tey = FMA(KP668178637, Te8, Te9);
			 }
			 Teb = Te7 - Tea;
			 TkK = Tey - Tex;
			 Tez = Tex + Tey;
			 TkE = Te7 + Tea;
		    }
		    {
			 E Tdw, TdS, TdD, TdT;
			 {
			      E Tdo, Tdv, Tdz, TdC;
			      Tdo = FMA(KP707106781, Tdn, Tdm);
			      Tdv = Tdr + Tdu;
			      Tdw = FMA(KP923879532, Tdv, Tdo);
			      TdS = FNMS(KP923879532, Tdv, Tdo);
			      Tdz = FMA(KP707106781, Tdy, Tdx);
			      TdC = TdA + TdB;
			      TdD = FMA(KP923879532, TdC, Tdz);
			      TdT = FNMS(KP923879532, TdC, Tdz);
			 }
			 TdE = FNMS(KP098491403, TdD, Tdw);
			 TdY = FNMS(KP820678790, TdS, TdT);
			 TdH = FMA(KP098491403, Tdw, TdD);
			 TdU = FMA(KP820678790, TdT, TdS);
		    }
		    {
			 E TcE, Te0, Tkn, TkB, TcL, TkC, Te3, Tko, TcD, Tkm;
			 TcD = TcB + TcC;
			 TcE = FMA(KP707106781, TcD, TcA);
			 Te0 = FNMS(KP707106781, TcD, TcA);
			 Tkm = T7s - T7l;
			 Tkn = FMA(KP707106781, Tkm, Tkl);
			 TkB = FNMS(KP707106781, Tkm, Tkl);
			 {
			      E TcH, TcK, Te1, Te2;
			      TcH = FMA(KP414213562, TcG, TcF);
			      TcK = FNMS(KP414213562, TcJ, TcI);
			      TcL = TcH + TcK;
			      TkC = TcH - TcK;
			      Te1 = FMA(KP414213562, TcI, TcJ);
			      Te2 = FNMS(KP414213562, TcF, TcG);
			      Te3 = Te1 - Te2;
			      Tko = Te2 + Te1;
			 }
			 TcM = FMA(KP923879532, TcL, TcE);
			 TkD = FMA(KP923879532, TkC, TkB);
			 TkJ = FNMS(KP923879532, TkC, TkB);
			 TdK = FNMS(KP923879532, TcL, TcE);
			 Te4 = FNMS(KP923879532, Te3, Te0);
			 Tkp = FMA(KP923879532, Tko, Tkn);
			 Tkv = FNMS(KP923879532, Tko, Tkn);
			 Tew = FMA(KP923879532, Te3, Te0);
		    }
		    {
			 E Td2, TdF, TdW, TdZ;
			 Td2 = FMA(KP980785280, Td1, TcM);
			 TdF = Tdl + TdE;
			 ci[WS(rs, 30)] = FNMS(KP995184726, TdF, Td2);
			 cr[WS(rs, 1)] = FMA(KP995184726, TdF, Td2);
			 TdW = FNMS(KP980785280, TdN, TdK);
			 TdZ = TdX - TdY;
			 ci[WS(rs, 22)] = FNMS(KP773010453, TdZ, TdW);
			 cr[WS(rs, 9)] = FMA(KP773010453, TdZ, TdW);
		    }
		    {
			 E TkF, TkG, TkN, TkO;
			 TkF = FMA(KP831469612, TkE, TkD);
			 TkG = TeJ + TeK;
			 cr[WS(rs, 61)] = -(FMA(KP956940335, TkG, TkF));
			 ci[WS(rs, 34)] = FNMS(KP956940335, TkG, TkF);
			 TkN = FNMS(KP831469612, TkK, TkJ);
			 TkO = Teq - Tej;
			 cr[WS(rs, 53)] = FMS(KP881921264, TkO, TkN);
			 ci[WS(rs, 42)] = FMA(KP881921264, TkO, TkN);
		    }
		    {
			 E TdG, TdJ, TdO, TdV;
			 TdG = FNMS(KP980785280, Td1, TcM);
			 TdJ = TdH - TdI;
			 cr[WS(rs, 17)] = FNMS(KP995184726, TdJ, TdG);
			 ci[WS(rs, 14)] = FMA(KP995184726, TdJ, TdG);
			 TdO = FMA(KP980785280, TdN, TdK);
			 TdV = TdR + TdU;
			 cr[WS(rs, 25)] = FNMS(KP773010453, TdV, TdO);
			 ci[WS(rs, 6)] = FMA(KP773010453, TdV, TdO);
		    }
		    {
			 E TkH, TkI, TkL, TkM;
			 TkH = FNMS(KP831469612, TkE, TkD);
			 TkI = TeG - TeD;
			 cr[WS(rs, 45)] = FMS(KP956940335, TkI, TkH);
			 ci[WS(rs, 50)] = FMA(KP956940335, TkI, TkH);
			 TkL = FMA(KP831469612, TkK, TkJ);
			 TkM = Teu + Tet;
			 cr[WS(rs, 37)] = FMS(KP881921264, TkM, TkL);
			 ci[WS(rs, 58)] = FMA(KP881921264, TkM, TkL);
		    }
		    {
			 E Tec, Ter, TeI, TeL;
			 Tec = FMA(KP831469612, Teb, Te4);
			 Ter = Tej + Teq;
			 ci[WS(rs, 26)] = FNMS(KP881921264, Ter, Tec);
			 cr[WS(rs, 5)] = FMA(KP881921264, Ter, Tec);
			 TeI = FNMS(KP831469612, Tez, Tew);
			 TeL = TeJ - TeK;
			 ci[WS(rs, 18)] = FNMS(KP956940335, TeL, TeI);
			 cr[WS(rs, 13)] = FMA(KP956940335, TeL, TeI);
		    }
		    {
			 E Tkr, Tks, Tkz, TkA;
			 Tkr = FMA(KP980785280, Tkq, Tkp);
			 Tks = TdI + TdH;
			 cr[WS(rs, 33)] = FMS(KP995184726, Tks, Tkr);
			 ci[WS(rs, 62)] = FMA(KP995184726, Tks, Tkr);
			 Tkz = FNMS(KP980785280, Tkw, Tkv);
			 TkA = TdU - TdR;
			 cr[WS(rs, 41)] = FMS(KP773010453, TkA, Tkz);
			 ci[WS(rs, 54)] = FMA(KP773010453, TkA, Tkz);
		    }
		    {
			 E Tes, Tev, TeA, TeH;
			 Tes = FNMS(KP831469612, Teb, Te4);
			 Tev = Tet - Teu;
			 cr[WS(rs, 21)] = FNMS(KP881921264, Tev, Tes);
			 ci[WS(rs, 10)] = FMA(KP881921264, Tev, Tes);
			 TeA = FMA(KP831469612, Tez, Tew);
			 TeH = TeD + TeG;
			 cr[WS(rs, 29)] = FNMS(KP956940335, TeH, TeA);
			 ci[WS(rs, 2)] = FMA(KP956940335, TeH, TeA);
		    }
		    {
			 E Tkt, Tku, Tkx, Tky;
			 Tkt = FNMS(KP980785280, Tkq, Tkp);
			 Tku = TdE - Tdl;
			 cr[WS(rs, 49)] = FMS(KP995184726, Tku, Tkt);
			 ci[WS(rs, 46)] = FMA(KP995184726, Tku, Tkt);
			 Tkx = FMA(KP980785280, Tkw, Tkv);
			 Tky = TdX + TdY;
			 cr[WS(rs, 57)] = -(FMA(KP773010453, Tky, Tkx));
			 ci[WS(rs, 38)] = FNMS(KP773010453, Tky, Tkx);
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 64},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 64, "hf_64", twinstr, &GENUS, {520, 126, 518, 0} };

void X(codelet_hf_64) (planner *p) {
     X(khc2hc_register) (p, hf_64, &desc);
}
#else

/* Generated by: ../../../genfft/gen_hc2hc.native -compact -variables 4 -pipeline-latency 4 -n 64 -dit -name hf_64 -include rdft/scalar/hf.h */

/*
 * This function contains 1038 FP additions, 500 FP multiplications,
 * (or, 808 additions, 270 multiplications, 230 fused multiply/add),
 * 176 stack variables, 15 constants, and 256 memory accesses
 */
#include "rdft/scalar/hf.h"

static void hf_64(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 126); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 126, MAKE_VOLATILE_STRIDE(128, rs)) {
	       E Tj, TcL, ThT, Tin, T6b, Taz, TgT, Thn, TG, Thm, TcO, TgO, T6m, Tim, TaC;
	       E ThQ, T14, Tfr, T6y, T9O, TaG, Tc0, TcU, TeE, T1r, Tfq, T6J, T9P, TaJ, Tc1;
	       E TcZ, TeF, T1Q, T2d, Tfu, Tfv, Tfw, Tfx, T6Q, TaM, Tdb, TeI, T71, TaQ, T7a;
	       E TaN, Td6, TeJ, T77, TaP, T2B, T2Y, Tfz, TfA, TfB, TfC, T7h, TaW, Tdm, TeL;
	       E T7s, TaU, T7B, TaX, Tdh, TeM, T7y, TaT, T5j, TfR, Tec, TeX, TfY, Tgy, T8D;
	       E Tbl, T8O, Tbx, T9l, Tbm, TdV, Tf0, T9i, Tbw, T3M, TfL, TdL, TeT, TfI, Tgt;
	       E T7K, Tbd, T7V, Tb3, T8s, Tbe, Tdu, TeQ, T8p, Tb2, T4x, TfJ, TdE, TdM, TfO;
	       E Tgu, T87, T8u, T8i, T8v, Tba, Tbh, Tdz, TdN, Tb7, Tbg, T64, TfZ, Te5, Ted;
	       E TfU, Tgz, T90, T9n, T9b, T9o, Tbt, TbA, Te0, Tee, Tbq, Tbz;
	       {
		    E T1, TgR, T6, TgQ, Tc, T68, Th, T69;
		    T1 = cr[0];
		    TgR = ci[0];
		    {
			 E T3, T5, T2, T4;
			 T3 = cr[WS(rs, 32)];
			 T5 = ci[WS(rs, 32)];
			 T2 = W[62];
			 T4 = W[63];
			 T6 = FMA(T2, T3, T4 * T5);
			 TgQ = FNMS(T4, T3, T2 * T5);
		    }
		    {
			 E T9, Tb, T8, Ta;
			 T9 = cr[WS(rs, 16)];
			 Tb = ci[WS(rs, 16)];
			 T8 = W[30];
			 Ta = W[31];
			 Tc = FMA(T8, T9, Ta * Tb);
			 T68 = FNMS(Ta, T9, T8 * Tb);
		    }
		    {
			 E Te, Tg, Td, Tf;
			 Te = cr[WS(rs, 48)];
			 Tg = ci[WS(rs, 48)];
			 Td = W[94];
			 Tf = W[95];
			 Th = FMA(Td, Te, Tf * Tg);
			 T69 = FNMS(Tf, Te, Td * Tg);
		    }
		    {
			 E T7, Ti, ThR, ThS;
			 T7 = T1 + T6;
			 Ti = Tc + Th;
			 Tj = T7 + Ti;
			 TcL = T7 - Ti;
			 ThR = Tc - Th;
			 ThS = TgR - TgQ;
			 ThT = ThR + ThS;
			 Tin = ThS - ThR;
		    }
		    {
			 E T67, T6a, TgP, TgS;
			 T67 = T1 - T6;
			 T6a = T68 - T69;
			 T6b = T67 - T6a;
			 Taz = T67 + T6a;
			 TgP = T68 + T69;
			 TgS = TgQ + TgR;
			 TgT = TgP + TgS;
			 Thn = TgS - TgP;
		    }
	       }
	       {
		    E To, T6d, Tt, T6e, T6c, T6f, Tz, T6i, TE, T6j, T6h, T6k;
		    {
			 E Tl, Tn, Tk, Tm;
			 Tl = cr[WS(rs, 8)];
			 Tn = ci[WS(rs, 8)];
			 Tk = W[14];
			 Tm = W[15];
			 To = FMA(Tk, Tl, Tm * Tn);
			 T6d = FNMS(Tm, Tl, Tk * Tn);
		    }
		    {
			 E Tq, Ts, Tp, Tr;
			 Tq = cr[WS(rs, 40)];
			 Ts = ci[WS(rs, 40)];
			 Tp = W[78];
			 Tr = W[79];
			 Tt = FMA(Tp, Tq, Tr * Ts);
			 T6e = FNMS(Tr, Tq, Tp * Ts);
		    }
		    T6c = To - Tt;
		    T6f = T6d - T6e;
		    {
			 E Tw, Ty, Tv, Tx;
			 Tw = cr[WS(rs, 56)];
			 Ty = ci[WS(rs, 56)];
			 Tv = W[110];
			 Tx = W[111];
			 Tz = FMA(Tv, Tw, Tx * Ty);
			 T6i = FNMS(Tx, Tw, Tv * Ty);
		    }
		    {
			 E TB, TD, TA, TC;
			 TB = cr[WS(rs, 24)];
			 TD = ci[WS(rs, 24)];
			 TA = W[46];
			 TC = W[47];
			 TE = FMA(TA, TB, TC * TD);
			 T6j = FNMS(TC, TB, TA * TD);
		    }
		    T6h = Tz - TE;
		    T6k = T6i - T6j;
		    {
			 E Tu, TF, TcM, TcN;
			 Tu = To + Tt;
			 TF = Tz + TE;
			 TG = Tu + TF;
			 Thm = Tu - TF;
			 TcM = T6i + T6j;
			 TcN = T6d + T6e;
			 TcO = TcM - TcN;
			 TgO = TcN + TcM;
		    }
		    {
			 E T6g, T6l, TaA, TaB;
			 T6g = T6c - T6f;
			 T6l = T6h + T6k;
			 T6m = KP707106781 * (T6g + T6l);
			 Tim = KP707106781 * (T6l - T6g);
			 TaA = T6c + T6f;
			 TaB = T6h - T6k;
			 TaC = KP707106781 * (TaA + TaB);
			 ThQ = KP707106781 * (TaA - TaB);
		    }
	       }
	       {
		    E TS, TcR, T6o, T6v, T13, TcS, T6r, T6w, T6s, T6x;
		    {
			 E TM, T6t, TR, T6u;
			 {
			      E TJ, TL, TI, TK;
			      TJ = cr[WS(rs, 4)];
			      TL = ci[WS(rs, 4)];
			      TI = W[6];
			      TK = W[7];
			      TM = FMA(TI, TJ, TK * TL);
			      T6t = FNMS(TK, TJ, TI * TL);
			 }
			 {
			      E TO, TQ, TN, TP;
			      TO = cr[WS(rs, 36)];
			      TQ = ci[WS(rs, 36)];
			      TN = W[70];
			      TP = W[71];
			      TR = FMA(TN, TO, TP * TQ);
			      T6u = FNMS(TP, TO, TN * TQ);
			 }
			 TS = TM + TR;
			 TcR = T6t + T6u;
			 T6o = TM - TR;
			 T6v = T6t - T6u;
		    }
		    {
			 E TX, T6p, T12, T6q;
			 {
			      E TU, TW, TT, TV;
			      TU = cr[WS(rs, 20)];
			      TW = ci[WS(rs, 20)];
			      TT = W[38];
			      TV = W[39];
			      TX = FMA(TT, TU, TV * TW);
			      T6p = FNMS(TV, TU, TT * TW);
			 }
			 {
			      E TZ, T11, TY, T10;
			      TZ = cr[WS(rs, 52)];
			      T11 = ci[WS(rs, 52)];
			      TY = W[102];
			      T10 = W[103];
			      T12 = FMA(TY, TZ, T10 * T11);
			      T6q = FNMS(T10, TZ, TY * T11);
			 }
			 T13 = TX + T12;
			 TcS = T6p + T6q;
			 T6r = T6p - T6q;
			 T6w = TX - T12;
		    }
		    T14 = TS + T13;
		    Tfr = TcR + TcS;
		    T6s = T6o - T6r;
		    T6x = T6v + T6w;
		    T6y = FNMS(KP382683432, T6x, KP923879532 * T6s);
		    T9O = FMA(KP923879532, T6x, KP382683432 * T6s);
		    {
			 E TaE, TaF, TcQ, TcT;
			 TaE = T6v - T6w;
			 TaF = T6o + T6r;
			 TaG = FMA(KP382683432, TaE, KP923879532 * TaF);
			 Tc0 = FNMS(KP923879532, TaE, KP382683432 * TaF);
			 TcQ = TS - T13;
			 TcT = TcR - TcS;
			 TcU = TcQ + TcT;
			 TeE = TcQ - TcT;
		    }
	       }
	       {
		    E T1f, TcW, T6B, T6E, T1q, TcX, T6C, T6H, T6D, T6I;
		    {
			 E T19, T6z, T1e, T6A;
			 {
			      E T16, T18, T15, T17;
			      T16 = cr[WS(rs, 60)];
			      T18 = ci[WS(rs, 60)];
			      T15 = W[118];
			      T17 = W[119];
			      T19 = FMA(T15, T16, T17 * T18);
			      T6z = FNMS(T17, T16, T15 * T18);
			 }
			 {
			      E T1b, T1d, T1a, T1c;
			      T1b = cr[WS(rs, 28)];
			      T1d = ci[WS(rs, 28)];
			      T1a = W[54];
			      T1c = W[55];
			      T1e = FMA(T1a, T1b, T1c * T1d);
			      T6A = FNMS(T1c, T1b, T1a * T1d);
			 }
			 T1f = T19 + T1e;
			 TcW = T6z + T6A;
			 T6B = T6z - T6A;
			 T6E = T19 - T1e;
		    }
		    {
			 E T1k, T6F, T1p, T6G;
			 {
			      E T1h, T1j, T1g, T1i;
			      T1h = cr[WS(rs, 12)];
			      T1j = ci[WS(rs, 12)];
			      T1g = W[22];
			      T1i = W[23];
			      T1k = FMA(T1g, T1h, T1i * T1j);
			      T6F = FNMS(T1i, T1h, T1g * T1j);
			 }
			 {
			      E T1m, T1o, T1l, T1n;
			      T1m = cr[WS(rs, 44)];
			      T1o = ci[WS(rs, 44)];
			      T1l = W[86];
			      T1n = W[87];
			      T1p = FMA(T1l, T1m, T1n * T1o);
			      T6G = FNMS(T1n, T1m, T1l * T1o);
			 }
			 T1q = T1k + T1p;
			 TcX = T6F + T6G;
			 T6C = T1k - T1p;
			 T6H = T6F - T6G;
		    }
		    T1r = T1f + T1q;
		    Tfq = TcW + TcX;
		    T6D = T6B + T6C;
		    T6I = T6E - T6H;
		    T6J = FMA(KP382683432, T6D, KP923879532 * T6I);
		    T9P = FNMS(KP923879532, T6D, KP382683432 * T6I);
		    {
			 E TaH, TaI, TcV, TcY;
			 TaH = T6E + T6H;
			 TaI = T6B - T6C;
			 TaJ = FNMS(KP382683432, TaI, KP923879532 * TaH);
			 Tc1 = FMA(KP923879532, TaI, KP382683432 * TaH);
			 TcV = T1f - T1q;
			 TcY = TcW - TcX;
			 TcZ = TcV - TcY;
			 TeF = TcV + TcY;
		    }
	       }
	       {
		    E T1y, T73, T1D, T74, T1E, Td7, T1J, T6N, T1O, T6O, T1P, Td8, T21, Td4, T6R;
		    E T6U, T2c, Td3, T6W, T6Z;
		    {
			 E T1v, T1x, T1u, T1w;
			 T1v = cr[WS(rs, 2)];
			 T1x = ci[WS(rs, 2)];
			 T1u = W[2];
			 T1w = W[3];
			 T1y = FMA(T1u, T1v, T1w * T1x);
			 T73 = FNMS(T1w, T1v, T1u * T1x);
		    }
		    {
			 E T1A, T1C, T1z, T1B;
			 T1A = cr[WS(rs, 34)];
			 T1C = ci[WS(rs, 34)];
			 T1z = W[66];
			 T1B = W[67];
			 T1D = FMA(T1z, T1A, T1B * T1C);
			 T74 = FNMS(T1B, T1A, T1z * T1C);
		    }
		    T1E = T1y + T1D;
		    Td7 = T73 + T74;
		    {
			 E T1G, T1I, T1F, T1H;
			 T1G = cr[WS(rs, 18)];
			 T1I = ci[WS(rs, 18)];
			 T1F = W[34];
			 T1H = W[35];
			 T1J = FMA(T1F, T1G, T1H * T1I);
			 T6N = FNMS(T1H, T1G, T1F * T1I);
		    }
		    {
			 E T1L, T1N, T1K, T1M;
			 T1L = cr[WS(rs, 50)];
			 T1N = ci[WS(rs, 50)];
			 T1K = W[98];
			 T1M = W[99];
			 T1O = FMA(T1K, T1L, T1M * T1N);
			 T6O = FNMS(T1M, T1L, T1K * T1N);
		    }
		    T1P = T1J + T1O;
		    Td8 = T6N + T6O;
		    {
			 E T1V, T6S, T20, T6T;
			 {
			      E T1S, T1U, T1R, T1T;
			      T1S = cr[WS(rs, 10)];
			      T1U = ci[WS(rs, 10)];
			      T1R = W[18];
			      T1T = W[19];
			      T1V = FMA(T1R, T1S, T1T * T1U);
			      T6S = FNMS(T1T, T1S, T1R * T1U);
			 }
			 {
			      E T1X, T1Z, T1W, T1Y;
			      T1X = cr[WS(rs, 42)];
			      T1Z = ci[WS(rs, 42)];
			      T1W = W[82];
			      T1Y = W[83];
			      T20 = FMA(T1W, T1X, T1Y * T1Z);
			      T6T = FNMS(T1Y, T1X, T1W * T1Z);
			 }
			 T21 = T1V + T20;
			 Td4 = T6S + T6T;
			 T6R = T1V - T20;
			 T6U = T6S - T6T;
		    }
		    {
			 E T26, T6X, T2b, T6Y;
			 {
			      E T23, T25, T22, T24;
			      T23 = cr[WS(rs, 58)];
			      T25 = ci[WS(rs, 58)];
			      T22 = W[114];
			      T24 = W[115];
			      T26 = FMA(T22, T23, T24 * T25);
			      T6X = FNMS(T24, T23, T22 * T25);
			 }
			 {
			      E T28, T2a, T27, T29;
			      T28 = cr[WS(rs, 26)];
			      T2a = ci[WS(rs, 26)];
			      T27 = W[50];
			      T29 = W[51];
			      T2b = FMA(T27, T28, T29 * T2a);
			      T6Y = FNMS(T29, T28, T27 * T2a);
			 }
			 T2c = T26 + T2b;
			 Td3 = T6X + T6Y;
			 T6W = T26 - T2b;
			 T6Z = T6X - T6Y;
		    }
		    T1Q = T1E + T1P;
		    T2d = T21 + T2c;
		    Tfu = T1Q - T2d;
		    Tfv = Td7 + Td8;
		    Tfw = Td4 + Td3;
		    Tfx = Tfv - Tfw;
		    {
			 E T6M, T6P, Td9, Tda;
			 T6M = T1y - T1D;
			 T6P = T6N - T6O;
			 T6Q = T6M - T6P;
			 TaM = T6M + T6P;
			 Td9 = Td7 - Td8;
			 Tda = T21 - T2c;
			 Tdb = Td9 - Tda;
			 TeI = Td9 + Tda;
		    }
		    {
			 E T6V, T70, T78, T79;
			 T6V = T6R - T6U;
			 T70 = T6W + T6Z;
			 T71 = KP707106781 * (T6V + T70);
			 TaQ = KP707106781 * (T70 - T6V);
			 T78 = T6R + T6U;
			 T79 = T6Z - T6W;
			 T7a = KP707106781 * (T78 + T79);
			 TaN = KP707106781 * (T78 - T79);
		    }
		    {
			 E Td2, Td5, T75, T76;
			 Td2 = T1E - T1P;
			 Td5 = Td3 - Td4;
			 Td6 = Td2 - Td5;
			 TeJ = Td2 + Td5;
			 T75 = T73 - T74;
			 T76 = T1J - T1O;
			 T77 = T75 + T76;
			 TaP = T75 - T76;
		    }
	       }
	       {
		    E T2j, T7u, T2o, T7v, T2p, Tdd, T2u, T7e, T2z, T7f, T2A, Tde, T2M, Tdk, T7i;
		    E T7l, T2X, Tdj, T7n, T7q;
		    {
			 E T2g, T2i, T2f, T2h;
			 T2g = cr[WS(rs, 62)];
			 T2i = ci[WS(rs, 62)];
			 T2f = W[122];
			 T2h = W[123];
			 T2j = FMA(T2f, T2g, T2h * T2i);
			 T7u = FNMS(T2h, T2g, T2f * T2i);
		    }
		    {
			 E T2l, T2n, T2k, T2m;
			 T2l = cr[WS(rs, 30)];
			 T2n = ci[WS(rs, 30)];
			 T2k = W[58];
			 T2m = W[59];
			 T2o = FMA(T2k, T2l, T2m * T2n);
			 T7v = FNMS(T2m, T2l, T2k * T2n);
		    }
		    T2p = T2j + T2o;
		    Tdd = T7u + T7v;
		    {
			 E T2r, T2t, T2q, T2s;
			 T2r = cr[WS(rs, 14)];
			 T2t = ci[WS(rs, 14)];
			 T2q = W[26];
			 T2s = W[27];
			 T2u = FMA(T2q, T2r, T2s * T2t);
			 T7e = FNMS(T2s, T2r, T2q * T2t);
		    }
		    {
			 E T2w, T2y, T2v, T2x;
			 T2w = cr[WS(rs, 46)];
			 T2y = ci[WS(rs, 46)];
			 T2v = W[90];
			 T2x = W[91];
			 T2z = FMA(T2v, T2w, T2x * T2y);
			 T7f = FNMS(T2x, T2w, T2v * T2y);
		    }
		    T2A = T2u + T2z;
		    Tde = T7e + T7f;
		    {
			 E T2G, T7j, T2L, T7k;
			 {
			      E T2D, T2F, T2C, T2E;
			      T2D = cr[WS(rs, 6)];
			      T2F = ci[WS(rs, 6)];
			      T2C = W[10];
			      T2E = W[11];
			      T2G = FMA(T2C, T2D, T2E * T2F);
			      T7j = FNMS(T2E, T2D, T2C * T2F);
			 }
			 {
			      E T2I, T2K, T2H, T2J;
			      T2I = cr[WS(rs, 38)];
			      T2K = ci[WS(rs, 38)];
			      T2H = W[74];
			      T2J = W[75];
			      T2L = FMA(T2H, T2I, T2J * T2K);
			      T7k = FNMS(T2J, T2I, T2H * T2K);
			 }
			 T2M = T2G + T2L;
			 Tdk = T7j + T7k;
			 T7i = T2G - T2L;
			 T7l = T7j - T7k;
		    }
		    {
			 E T2R, T7o, T2W, T7p;
			 {
			      E T2O, T2Q, T2N, T2P;
			      T2O = cr[WS(rs, 54)];
			      T2Q = ci[WS(rs, 54)];
			      T2N = W[106];
			      T2P = W[107];
			      T2R = FMA(T2N, T2O, T2P * T2Q);
			      T7o = FNMS(T2P, T2O, T2N * T2Q);
			 }
			 {
			      E T2T, T2V, T2S, T2U;
			      T2T = cr[WS(rs, 22)];
			      T2V = ci[WS(rs, 22)];
			      T2S = W[42];
			      T2U = W[43];
			      T2W = FMA(T2S, T2T, T2U * T2V);
			      T7p = FNMS(T2U, T2T, T2S * T2V);
			 }
			 T2X = T2R + T2W;
			 Tdj = T7o + T7p;
			 T7n = T2R - T2W;
			 T7q = T7o - T7p;
		    }
		    T2B = T2p + T2A;
		    T2Y = T2M + T2X;
		    Tfz = T2B - T2Y;
		    TfA = Tdd + Tde;
		    TfB = Tdk + Tdj;
		    TfC = TfA - TfB;
		    {
			 E T7d, T7g, Tdi, Tdl;
			 T7d = T2j - T2o;
			 T7g = T7e - T7f;
			 T7h = T7d - T7g;
			 TaW = T7d + T7g;
			 Tdi = T2p - T2A;
			 Tdl = Tdj - Tdk;
			 Tdm = Tdi - Tdl;
			 TeL = Tdi + Tdl;
		    }
		    {
			 E T7m, T7r, T7z, T7A;
			 T7m = T7i - T7l;
			 T7r = T7n + T7q;
			 T7s = KP707106781 * (T7m + T7r);
			 TaU = KP707106781 * (T7r - T7m);
			 T7z = T7i + T7l;
			 T7A = T7q - T7n;
			 T7B = KP707106781 * (T7z + T7A);
			 TaX = KP707106781 * (T7z - T7A);
		    }
		    {
			 E Tdf, Tdg, T7w, T7x;
			 Tdf = Tdd - Tde;
			 Tdg = T2M - T2X;
			 Tdh = Tdf - Tdg;
			 TeM = Tdf + Tdg;
			 T7w = T7u - T7v;
			 T7x = T2u - T2z;
			 T7y = T7w + T7x;
			 TaT = T7w - T7x;
		    }
	       }
	       {
		    E T4D, T9e, T4I, T9f, T4J, TdR, T4O, T8A, T4T, T8B, T4U, TdS, T56, Tea, T8E;
		    E T8H, T5h, Te9, T8J, T8M;
		    {
			 E T4A, T4C, T4z, T4B;
			 T4A = cr[WS(rs, 63)];
			 T4C = ci[WS(rs, 63)];
			 T4z = W[124];
			 T4B = W[125];
			 T4D = FMA(T4z, T4A, T4B * T4C);
			 T9e = FNMS(T4B, T4A, T4z * T4C);
		    }
		    {
			 E T4F, T4H, T4E, T4G;
			 T4F = cr[WS(rs, 31)];
			 T4H = ci[WS(rs, 31)];
			 T4E = W[60];
			 T4G = W[61];
			 T4I = FMA(T4E, T4F, T4G * T4H);
			 T9f = FNMS(T4G, T4F, T4E * T4H);
		    }
		    T4J = T4D + T4I;
		    TdR = T9e + T9f;
		    {
			 E T4L, T4N, T4K, T4M;
			 T4L = cr[WS(rs, 15)];
			 T4N = ci[WS(rs, 15)];
			 T4K = W[28];
			 T4M = W[29];
			 T4O = FMA(T4K, T4L, T4M * T4N);
			 T8A = FNMS(T4M, T4L, T4K * T4N);
		    }
		    {
			 E T4Q, T4S, T4P, T4R;
			 T4Q = cr[WS(rs, 47)];
			 T4S = ci[WS(rs, 47)];
			 T4P = W[92];
			 T4R = W[93];
			 T4T = FMA(T4P, T4Q, T4R * T4S);
			 T8B = FNMS(T4R, T4Q, T4P * T4S);
		    }
		    T4U = T4O + T4T;
		    TdS = T8A + T8B;
		    {
			 E T50, T8F, T55, T8G;
			 {
			      E T4X, T4Z, T4W, T4Y;
			      T4X = cr[WS(rs, 7)];
			      T4Z = ci[WS(rs, 7)];
			      T4W = W[12];
			      T4Y = W[13];
			      T50 = FMA(T4W, T4X, T4Y * T4Z);
			      T8F = FNMS(T4Y, T4X, T4W * T4Z);
			 }
			 {
			      E T52, T54, T51, T53;
			      T52 = cr[WS(rs, 39)];
			      T54 = ci[WS(rs, 39)];
			      T51 = W[76];
			      T53 = W[77];
			      T55 = FMA(T51, T52, T53 * T54);
			      T8G = FNMS(T53, T52, T51 * T54);
			 }
			 T56 = T50 + T55;
			 Tea = T8F + T8G;
			 T8E = T50 - T55;
			 T8H = T8F - T8G;
		    }
		    {
			 E T5b, T8K, T5g, T8L;
			 {
			      E T58, T5a, T57, T59;
			      T58 = cr[WS(rs, 55)];
			      T5a = ci[WS(rs, 55)];
			      T57 = W[108];
			      T59 = W[109];
			      T5b = FMA(T57, T58, T59 * T5a);
			      T8K = FNMS(T59, T58, T57 * T5a);
			 }
			 {
			      E T5d, T5f, T5c, T5e;
			      T5d = cr[WS(rs, 23)];
			      T5f = ci[WS(rs, 23)];
			      T5c = W[44];
			      T5e = W[45];
			      T5g = FMA(T5c, T5d, T5e * T5f);
			      T8L = FNMS(T5e, T5d, T5c * T5f);
			 }
			 T5h = T5b + T5g;
			 Te9 = T8K + T8L;
			 T8J = T5b - T5g;
			 T8M = T8K - T8L;
		    }
		    {
			 E T4V, T5i, Te8, Teb;
			 T4V = T4J + T4U;
			 T5i = T56 + T5h;
			 T5j = T4V + T5i;
			 TfR = T4V - T5i;
			 Te8 = T4J - T4U;
			 Teb = Te9 - Tea;
			 Tec = Te8 - Teb;
			 TeX = Te8 + Teb;
		    }
		    {
			 E TfW, TfX, T8z, T8C;
			 TfW = TdR + TdS;
			 TfX = Tea + Te9;
			 TfY = TfW - TfX;
			 Tgy = TfW + TfX;
			 T8z = T4D - T4I;
			 T8C = T8A - T8B;
			 T8D = T8z - T8C;
			 Tbl = T8z + T8C;
		    }
		    {
			 E T8I, T8N, T9j, T9k;
			 T8I = T8E - T8H;
			 T8N = T8J + T8M;
			 T8O = KP707106781 * (T8I + T8N);
			 Tbx = KP707106781 * (T8N - T8I);
			 T9j = T8E + T8H;
			 T9k = T8M - T8J;
			 T9l = KP707106781 * (T9j + T9k);
			 Tbm = KP707106781 * (T9j - T9k);
		    }
		    {
			 E TdT, TdU, T9g, T9h;
			 TdT = TdR - TdS;
			 TdU = T56 - T5h;
			 TdV = TdT - TdU;
			 Tf0 = TdT + TdU;
			 T9g = T9e - T9f;
			 T9h = T4O - T4T;
			 T9i = T9g + T9h;
			 Tbw = T9g - T9h;
		    }
	       }
	       {
		    E T36, T7G, T3b, T7H, T3c, TdH, T3h, T8m, T3m, T8n, T3n, TdI, T3z, Tds, T7L;
		    E T7O, T3K, Tdr, T7S, T7T;
		    {
			 E T33, T35, T32, T34;
			 T33 = cr[WS(rs, 1)];
			 T35 = ci[WS(rs, 1)];
			 T32 = W[0];
			 T34 = W[1];
			 T36 = FMA(T32, T33, T34 * T35);
			 T7G = FNMS(T34, T33, T32 * T35);
		    }
		    {
			 E T38, T3a, T37, T39;
			 T38 = cr[WS(rs, 33)];
			 T3a = ci[WS(rs, 33)];
			 T37 = W[64];
			 T39 = W[65];
			 T3b = FMA(T37, T38, T39 * T3a);
			 T7H = FNMS(T39, T38, T37 * T3a);
		    }
		    T3c = T36 + T3b;
		    TdH = T7G + T7H;
		    {
			 E T3e, T3g, T3d, T3f;
			 T3e = cr[WS(rs, 17)];
			 T3g = ci[WS(rs, 17)];
			 T3d = W[32];
			 T3f = W[33];
			 T3h = FMA(T3d, T3e, T3f * T3g);
			 T8m = FNMS(T3f, T3e, T3d * T3g);
		    }
		    {
			 E T3j, T3l, T3i, T3k;
			 T3j = cr[WS(rs, 49)];
			 T3l = ci[WS(rs, 49)];
			 T3i = W[96];
			 T3k = W[97];
			 T3m = FMA(T3i, T3j, T3k * T3l);
			 T8n = FNMS(T3k, T3j, T3i * T3l);
		    }
		    T3n = T3h + T3m;
		    TdI = T8m + T8n;
		    {
			 E T3t, T7M, T3y, T7N;
			 {
			      E T3q, T3s, T3p, T3r;
			      T3q = cr[WS(rs, 9)];
			      T3s = ci[WS(rs, 9)];
			      T3p = W[16];
			      T3r = W[17];
			      T3t = FMA(T3p, T3q, T3r * T3s);
			      T7M = FNMS(T3r, T3q, T3p * T3s);
			 }
			 {
			      E T3v, T3x, T3u, T3w;
			      T3v = cr[WS(rs, 41)];
			      T3x = ci[WS(rs, 41)];
			      T3u = W[80];
			      T3w = W[81];
			      T3y = FMA(T3u, T3v, T3w * T3x);
			      T7N = FNMS(T3w, T3v, T3u * T3x);
			 }
			 T3z = T3t + T3y;
			 Tds = T7M + T7N;
			 T7L = T3t - T3y;
			 T7O = T7M - T7N;
		    }
		    {
			 E T3E, T7Q, T3J, T7R;
			 {
			      E T3B, T3D, T3A, T3C;
			      T3B = cr[WS(rs, 57)];
			      T3D = ci[WS(rs, 57)];
			      T3A = W[112];
			      T3C = W[113];
			      T3E = FMA(T3A, T3B, T3C * T3D);
			      T7Q = FNMS(T3C, T3B, T3A * T3D);
			 }
			 {
			      E T3G, T3I, T3F, T3H;
			      T3G = cr[WS(rs, 25)];
			      T3I = ci[WS(rs, 25)];
			      T3F = W[48];
			      T3H = W[49];
			      T3J = FMA(T3F, T3G, T3H * T3I);
			      T7R = FNMS(T3H, T3G, T3F * T3I);
			 }
			 T3K = T3E + T3J;
			 Tdr = T7Q + T7R;
			 T7S = T7Q - T7R;
			 T7T = T3E - T3J;
		    }
		    {
			 E T3o, T3L, TdJ, TdK;
			 T3o = T3c + T3n;
			 T3L = T3z + T3K;
			 T3M = T3o + T3L;
			 TfL = T3o - T3L;
			 TdJ = TdH - TdI;
			 TdK = T3z - T3K;
			 TdL = TdJ - TdK;
			 TeT = TdJ + TdK;
		    }
		    {
			 E TfG, TfH, T7I, T7J;
			 TfG = TdH + TdI;
			 TfH = Tds + Tdr;
			 TfI = TfG - TfH;
			 Tgt = TfG + TfH;
			 T7I = T7G - T7H;
			 T7J = T3h - T3m;
			 T7K = T7I + T7J;
			 Tbd = T7I - T7J;
		    }
		    {
			 E T7P, T7U, T8q, T8r;
			 T7P = T7L + T7O;
			 T7U = T7S - T7T;
			 T7V = KP707106781 * (T7P + T7U);
			 Tb3 = KP707106781 * (T7P - T7U);
			 T8q = T7L - T7O;
			 T8r = T7T + T7S;
			 T8s = KP707106781 * (T8q + T8r);
			 Tbe = KP707106781 * (T8r - T8q);
		    }
		    {
			 E Tdq, Tdt, T8l, T8o;
			 Tdq = T3c - T3n;
			 Tdt = Tdr - Tds;
			 Tdu = Tdq - Tdt;
			 TeQ = Tdq + Tdt;
			 T8l = T36 - T3b;
			 T8o = T8m - T8n;
			 T8p = T8l - T8o;
			 Tb2 = T8l + T8o;
		    }
	       }
	       {
		    E T3X, Tdw, T7Z, T82, T4v, TdB, T8b, T8g, T48, Tdx, T80, T85, T4k, TdA, T8a;
		    E T8d;
		    {
			 E T3R, T7X, T3W, T7Y;
			 {
			      E T3O, T3Q, T3N, T3P;
			      T3O = cr[WS(rs, 5)];
			      T3Q = ci[WS(rs, 5)];
			      T3N = W[8];
			      T3P = W[9];
			      T3R = FMA(T3N, T3O, T3P * T3Q);
			      T7X = FNMS(T3P, T3O, T3N * T3Q);
			 }
			 {
			      E T3T, T3V, T3S, T3U;
			      T3T = cr[WS(rs, 37)];
			      T3V = ci[WS(rs, 37)];
			      T3S = W[72];
			      T3U = W[73];
			      T3W = FMA(T3S, T3T, T3U * T3V);
			      T7Y = FNMS(T3U, T3T, T3S * T3V);
			 }
			 T3X = T3R + T3W;
			 Tdw = T7X + T7Y;
			 T7Z = T7X - T7Y;
			 T82 = T3R - T3W;
		    }
		    {
			 E T4p, T8e, T4u, T8f;
			 {
			      E T4m, T4o, T4l, T4n;
			      T4m = cr[WS(rs, 13)];
			      T4o = ci[WS(rs, 13)];
			      T4l = W[24];
			      T4n = W[25];
			      T4p = FMA(T4l, T4m, T4n * T4o);
			      T8e = FNMS(T4n, T4m, T4l * T4o);
			 }
			 {
			      E T4r, T4t, T4q, T4s;
			      T4r = cr[WS(rs, 45)];
			      T4t = ci[WS(rs, 45)];
			      T4q = W[88];
			      T4s = W[89];
			      T4u = FMA(T4q, T4r, T4s * T4t);
			      T8f = FNMS(T4s, T4r, T4q * T4t);
			 }
			 T4v = T4p + T4u;
			 TdB = T8e + T8f;
			 T8b = T4p - T4u;
			 T8g = T8e - T8f;
		    }
		    {
			 E T42, T83, T47, T84;
			 {
			      E T3Z, T41, T3Y, T40;
			      T3Z = cr[WS(rs, 21)];
			      T41 = ci[WS(rs, 21)];
			      T3Y = W[40];
			      T40 = W[41];
			      T42 = FMA(T3Y, T3Z, T40 * T41);
			      T83 = FNMS(T40, T3Z, T3Y * T41);
			 }
			 {
			      E T44, T46, T43, T45;
			      T44 = cr[WS(rs, 53)];
			      T46 = ci[WS(rs, 53)];
			      T43 = W[104];
			      T45 = W[105];
			      T47 = FMA(T43, T44, T45 * T46);
			      T84 = FNMS(T45, T44, T43 * T46);
			 }
			 T48 = T42 + T47;
			 Tdx = T83 + T84;
			 T80 = T42 - T47;
			 T85 = T83 - T84;
		    }
		    {
			 E T4e, T88, T4j, T89;
			 {
			      E T4b, T4d, T4a, T4c;
			      T4b = cr[WS(rs, 61)];
			      T4d = ci[WS(rs, 61)];
			      T4a = W[120];
			      T4c = W[121];
			      T4e = FMA(T4a, T4b, T4c * T4d);
			      T88 = FNMS(T4c, T4b, T4a * T4d);
			 }
			 {
			      E T4g, T4i, T4f, T4h;
			      T4g = cr[WS(rs, 29)];
			      T4i = ci[WS(rs, 29)];
			      T4f = W[56];
			      T4h = W[57];
			      T4j = FMA(T4f, T4g, T4h * T4i);
			      T89 = FNMS(T4h, T4g, T4f * T4i);
			 }
			 T4k = T4e + T4j;
			 TdA = T88 + T89;
			 T8a = T88 - T89;
			 T8d = T4e - T4j;
		    }
		    {
			 E T49, T4w, TdC, TdD;
			 T49 = T3X + T48;
			 T4w = T4k + T4v;
			 T4x = T49 + T4w;
			 TfJ = T49 - T4w;
			 TdC = TdA - TdB;
			 TdD = T4k - T4v;
			 TdE = TdC - TdD;
			 TdM = TdD + TdC;
		    }
		    {
			 E TfM, TfN, T81, T86;
			 TfM = TdA + TdB;
			 TfN = Tdw + Tdx;
			 TfO = TfM - TfN;
			 Tgu = TfN + TfM;
			 T81 = T7Z + T80;
			 T86 = T82 - T85;
			 T87 = FMA(KP923879532, T81, KP382683432 * T86);
			 T8u = FNMS(KP382683432, T81, KP923879532 * T86);
		    }
		    {
			 E T8c, T8h, Tb8, Tb9;
			 T8c = T8a + T8b;
			 T8h = T8d - T8g;
			 T8i = FNMS(KP382683432, T8h, KP923879532 * T8c);
			 T8v = FMA(KP382683432, T8c, KP923879532 * T8h);
			 Tb8 = T8d + T8g;
			 Tb9 = T8a - T8b;
			 Tba = FNMS(KP382683432, Tb9, KP923879532 * Tb8);
			 Tbh = FMA(KP923879532, Tb9, KP382683432 * Tb8);
		    }
		    {
			 E Tdv, Tdy, Tb5, Tb6;
			 Tdv = T3X - T48;
			 Tdy = Tdw - Tdx;
			 Tdz = Tdv + Tdy;
			 TdN = Tdv - Tdy;
			 Tb5 = T7Z - T80;
			 Tb6 = T82 + T85;
			 Tb7 = FMA(KP382683432, Tb5, KP923879532 * Tb6);
			 Tbg = FNMS(KP382683432, Tb6, KP923879532 * Tb5);
		    }
	       }
	       {
		    E T5u, Te2, T8Q, T8X, T62, TdY, T94, T99, T5F, Te3, T8T, T8Y, T5R, TdX, T93;
		    E T96;
		    {
			 E T5o, T8V, T5t, T8W;
			 {
			      E T5l, T5n, T5k, T5m;
			      T5l = cr[WS(rs, 3)];
			      T5n = ci[WS(rs, 3)];
			      T5k = W[4];
			      T5m = W[5];
			      T5o = FMA(T5k, T5l, T5m * T5n);
			      T8V = FNMS(T5m, T5l, T5k * T5n);
			 }
			 {
			      E T5q, T5s, T5p, T5r;
			      T5q = cr[WS(rs, 35)];
			      T5s = ci[WS(rs, 35)];
			      T5p = W[68];
			      T5r = W[69];
			      T5t = FMA(T5p, T5q, T5r * T5s);
			      T8W = FNMS(T5r, T5q, T5p * T5s);
			 }
			 T5u = T5o + T5t;
			 Te2 = T8V + T8W;
			 T8Q = T5o - T5t;
			 T8X = T8V - T8W;
		    }
		    {
			 E T5W, T97, T61, T98;
			 {
			      E T5T, T5V, T5S, T5U;
			      T5T = cr[WS(rs, 11)];
			      T5V = ci[WS(rs, 11)];
			      T5S = W[20];
			      T5U = W[21];
			      T5W = FMA(T5S, T5T, T5U * T5V);
			      T97 = FNMS(T5U, T5T, T5S * T5V);
			 }
			 {
			      E T5Y, T60, T5X, T5Z;
			      T5Y = cr[WS(rs, 43)];
			      T60 = ci[WS(rs, 43)];
			      T5X = W[84];
			      T5Z = W[85];
			      T61 = FMA(T5X, T5Y, T5Z * T60);
			      T98 = FNMS(T5Z, T5Y, T5X * T60);
			 }
			 T62 = T5W + T61;
			 TdY = T97 + T98;
			 T94 = T5W - T61;
			 T99 = T97 - T98;
		    }
		    {
			 E T5z, T8R, T5E, T8S;
			 {
			      E T5w, T5y, T5v, T5x;
			      T5w = cr[WS(rs, 19)];
			      T5y = ci[WS(rs, 19)];
			      T5v = W[36];
			      T5x = W[37];
			      T5z = FMA(T5v, T5w, T5x * T5y);
			      T8R = FNMS(T5x, T5w, T5v * T5y);
			 }
			 {
			      E T5B, T5D, T5A, T5C;
			      T5B = cr[WS(rs, 51)];
			      T5D = ci[WS(rs, 51)];
			      T5A = W[100];
			      T5C = W[101];
			      T5E = FMA(T5A, T5B, T5C * T5D);
			      T8S = FNMS(T5C, T5B, T5A * T5D);
			 }
			 T5F = T5z + T5E;
			 Te3 = T8R + T8S;
			 T8T = T8R - T8S;
			 T8Y = T5z - T5E;
		    }
		    {
			 E T5L, T91, T5Q, T92;
			 {
			      E T5I, T5K, T5H, T5J;
			      T5I = cr[WS(rs, 59)];
			      T5K = ci[WS(rs, 59)];
			      T5H = W[116];
			      T5J = W[117];
			      T5L = FMA(T5H, T5I, T5J * T5K);
			      T91 = FNMS(T5J, T5I, T5H * T5K);
			 }
			 {
			      E T5N, T5P, T5M, T5O;
			      T5N = cr[WS(rs, 27)];
			      T5P = ci[WS(rs, 27)];
			      T5M = W[52];
			      T5O = W[53];
			      T5Q = FMA(T5M, T5N, T5O * T5P);
			      T92 = FNMS(T5O, T5N, T5M * T5P);
			 }
			 T5R = T5L + T5Q;
			 TdX = T91 + T92;
			 T93 = T91 - T92;
			 T96 = T5L - T5Q;
		    }
		    {
			 E T5G, T63, Te1, Te4;
			 T5G = T5u + T5F;
			 T63 = T5R + T62;
			 T64 = T5G + T63;
			 TfZ = T5G - T63;
			 Te1 = T5u - T5F;
			 Te4 = Te2 - Te3;
			 Te5 = Te1 - Te4;
			 Ted = Te1 + Te4;
		    }
		    {
			 E TfS, TfT, T8U, T8Z;
			 TfS = TdX + TdY;
			 TfT = Te2 + Te3;
			 TfU = TfS - TfT;
			 Tgz = TfT + TfS;
			 T8U = T8Q - T8T;
			 T8Z = T8X + T8Y;
			 T90 = FNMS(KP382683432, T8Z, KP923879532 * T8U);
			 T9n = FMA(KP923879532, T8Z, KP382683432 * T8U);
		    }
		    {
			 E T95, T9a, Tbr, Tbs;
			 T95 = T93 + T94;
			 T9a = T96 - T99;
			 T9b = FMA(KP382683432, T95, KP923879532 * T9a);
			 T9o = FNMS(KP382683432, T9a, KP923879532 * T95);
			 Tbr = T96 + T99;
			 Tbs = T93 - T94;
			 Tbt = FNMS(KP382683432, Tbs, KP923879532 * Tbr);
			 TbA = FMA(KP923879532, Tbs, KP382683432 * Tbr);
		    }
		    {
			 E TdW, TdZ, Tbo, Tbp;
			 TdW = T5R - T62;
			 TdZ = TdX - TdY;
			 Te0 = TdW + TdZ;
			 Tee = TdZ - TdW;
			 Tbo = T8X - T8Y;
			 Tbp = T8Q + T8T;
			 Tbq = FMA(KP382683432, Tbo, KP923879532 * Tbp);
			 Tbz = FNMS(KP382683432, Tbp, KP923879532 * Tbo);
		    }
	       }
	       {
		    E T1t, Tgn, TgK, TgL, TgV, Th1, T30, Th0, T66, TgX, Tgw, TgE, TgB, TgF, Tgq;
		    E TgM;
		    {
			 E TH, T1s, TgI, TgJ;
			 TH = Tj + TG;
			 T1s = T14 + T1r;
			 T1t = TH + T1s;
			 Tgn = TH - T1s;
			 TgI = Tgy + Tgz;
			 TgJ = Tgt + Tgu;
			 TgK = TgI - TgJ;
			 TgL = TgJ + TgI;
		    }
		    {
			 E TgN, TgU, T2e, T2Z;
			 TgN = Tfr + Tfq;
			 TgU = TgO + TgT;
			 TgV = TgN + TgU;
			 Th1 = TgU - TgN;
			 T2e = T1Q + T2d;
			 T2Z = T2B + T2Y;
			 T30 = T2e + T2Z;
			 Th0 = T2e - T2Z;
		    }
		    {
			 E T4y, T65, Tgs, Tgv;
			 T4y = T3M + T4x;
			 T65 = T5j + T64;
			 T66 = T4y + T65;
			 TgX = T65 - T4y;
			 Tgs = T3M - T4x;
			 Tgv = Tgt - Tgu;
			 Tgw = Tgs + Tgv;
			 TgE = Tgs - Tgv;
		    }
		    {
			 E Tgx, TgA, Tgo, Tgp;
			 Tgx = T5j - T64;
			 TgA = Tgy - Tgz;
			 TgB = Tgx - TgA;
			 TgF = Tgx + TgA;
			 Tgo = TfA + TfB;
			 Tgp = Tfv + Tfw;
			 Tgq = Tgo - Tgp;
			 TgM = Tgp + Tgo;
		    }
		    {
			 E T31, TgW, TgY, TgH;
			 T31 = T1t + T30;
			 ci[WS(rs, 31)] = T31 - T66;
			 cr[0] = T31 + T66;
			 TgW = TgM + TgV;
			 cr[WS(rs, 32)] = TgL - TgW;
			 ci[WS(rs, 63)] = TgL + TgW;
			 TgY = TgV - TgM;
			 cr[WS(rs, 48)] = TgX - TgY;
			 ci[WS(rs, 47)] = TgX + TgY;
			 TgH = T1t - T30;
			 cr[WS(rs, 16)] = TgH - TgK;
			 ci[WS(rs, 15)] = TgH + TgK;
		    }
		    {
			 E Tgr, TgC, TgZ, Th2;
			 Tgr = Tgn - Tgq;
			 TgC = KP707106781 * (Tgw + TgB);
			 ci[WS(rs, 23)] = Tgr - TgC;
			 cr[WS(rs, 8)] = Tgr + TgC;
			 TgZ = KP707106781 * (TgB - Tgw);
			 Th2 = Th0 + Th1;
			 cr[WS(rs, 56)] = TgZ - Th2;
			 ci[WS(rs, 39)] = TgZ + Th2;
		    }
		    {
			 E Th3, Th4, TgD, TgG;
			 Th3 = KP707106781 * (TgF - TgE);
			 Th4 = Th1 - Th0;
			 cr[WS(rs, 40)] = Th3 - Th4;
			 ci[WS(rs, 55)] = Th3 + Th4;
			 TgD = Tgn + Tgq;
			 TgG = KP707106781 * (TgE + TgF);
			 cr[WS(rs, 24)] = TgD - TgG;
			 ci[WS(rs, 7)] = TgD + TgG;
		    }
	       }
	       {
		    E T6L, T9x, ThV, Ti1, T7E, Ti0, T9A, ThO, T8y, T9K, T9u, T9E, T9r, T9L, T9v;
		    E T9H;
		    {
			 E T6n, T6K, ThP, ThU;
			 T6n = T6b + T6m;
			 T6K = T6y + T6J;
			 T6L = T6n - T6K;
			 T9x = T6n + T6K;
			 ThP = T9O - T9P;
			 ThU = ThQ + ThT;
			 ThV = ThP + ThU;
			 Ti1 = ThU - ThP;
		    }
		    {
			 E T7c, T9y, T7D, T9z;
			 {
			      E T72, T7b, T7t, T7C;
			      T72 = T6Q + T71;
			      T7b = T77 + T7a;
			      T7c = FMA(KP195090322, T72, KP980785280 * T7b);
			      T9y = FNMS(KP195090322, T7b, KP980785280 * T72);
			      T7t = T7h + T7s;
			      T7C = T7y + T7B;
			      T7D = FNMS(KP980785280, T7C, KP195090322 * T7t);
			      T9z = FMA(KP980785280, T7t, KP195090322 * T7C);
			 }
			 T7E = T7c + T7D;
			 Ti0 = T9z - T9y;
			 T9A = T9y + T9z;
			 ThO = T7c - T7D;
		    }
		    {
			 E T8k, T9D, T8x, T9C;
			 {
			      E T7W, T8j, T8t, T8w;
			      T7W = T7K + T7V;
			      T8j = T87 + T8i;
			      T8k = T7W - T8j;
			      T9D = T7W + T8j;
			      T8t = T8p + T8s;
			      T8w = T8u + T8v;
			      T8x = T8t - T8w;
			      T9C = T8t + T8w;
			 }
			 T8y = FMA(KP634393284, T8k, KP773010453 * T8x);
			 T9K = FMA(KP995184726, T9D, KP098017140 * T9C);
			 T9u = FNMS(KP773010453, T8k, KP634393284 * T8x);
			 T9E = FNMS(KP098017140, T9D, KP995184726 * T9C);
		    }
		    {
			 E T9d, T9G, T9q, T9F;
			 {
			      E T8P, T9c, T9m, T9p;
			      T8P = T8D + T8O;
			      T9c = T90 + T9b;
			      T9d = T8P - T9c;
			      T9G = T8P + T9c;
			      T9m = T9i + T9l;
			      T9p = T9n + T9o;
			      T9q = T9m - T9p;
			      T9F = T9m + T9p;
			 }
			 T9r = FNMS(KP634393284, T9q, KP773010453 * T9d);
			 T9L = FNMS(KP995184726, T9F, KP098017140 * T9G);
			 T9v = FMA(KP773010453, T9q, KP634393284 * T9d);
			 T9H = FMA(KP098017140, T9F, KP995184726 * T9G);
		    }
		    {
			 E T7F, T9s, ThZ, Ti2;
			 T7F = T6L + T7E;
			 T9s = T8y + T9r;
			 ci[WS(rs, 24)] = T7F - T9s;
			 cr[WS(rs, 7)] = T7F + T9s;
			 ThZ = T9v - T9u;
			 Ti2 = Ti0 + Ti1;
			 cr[WS(rs, 39)] = ThZ - Ti2;
			 ci[WS(rs, 56)] = ThZ + Ti2;
		    }
		    {
			 E Ti3, Ti4, T9t, T9w;
			 Ti3 = T9r - T8y;
			 Ti4 = Ti1 - Ti0;
			 cr[WS(rs, 55)] = Ti3 - Ti4;
			 ci[WS(rs, 40)] = Ti3 + Ti4;
			 T9t = T6L - T7E;
			 T9w = T9u + T9v;
			 cr[WS(rs, 23)] = T9t - T9w;
			 ci[WS(rs, 8)] = T9t + T9w;
		    }
		    {
			 E T9B, T9I, ThN, ThW;
			 T9B = T9x + T9A;
			 T9I = T9E + T9H;
			 cr[WS(rs, 31)] = T9B - T9I;
			 ci[0] = T9B + T9I;
			 ThN = T9L - T9K;
			 ThW = ThO + ThV;
			 cr[WS(rs, 63)] = ThN - ThW;
			 ci[WS(rs, 32)] = ThN + ThW;
		    }
		    {
			 E ThX, ThY, T9J, T9M;
			 ThX = T9H - T9E;
			 ThY = ThV - ThO;
			 cr[WS(rs, 47)] = ThX - ThY;
			 ci[WS(rs, 48)] = ThX + ThY;
			 T9J = T9x - T9A;
			 T9M = T9K + T9L;
			 ci[WS(rs, 16)] = T9J - T9M;
			 cr[WS(rs, 15)] = T9J + T9M;
		    }
	       }
	       {
		    E Tft, Tg7, Tgh, Tgl, Th9, Thf, TfE, Th6, TfQ, Tg4, Tga, The, Tge, Tgk, Tg1;
		    E Tg5;
		    {
			 E Tfp, Tfs, Tgf, Tgg;
			 Tfp = Tj - TG;
			 Tfs = Tfq - Tfr;
			 Tft = Tfp - Tfs;
			 Tg7 = Tfp + Tfs;
			 Tgf = TfY + TfZ;
			 Tgg = TfR + TfU;
			 Tgh = FMA(KP382683432, Tgf, KP923879532 * Tgg);
			 Tgl = FNMS(KP923879532, Tgf, KP382683432 * Tgg);
		    }
		    {
			 E Th7, Th8, Tfy, TfD;
			 Th7 = T14 - T1r;
			 Th8 = TgT - TgO;
			 Th9 = Th7 + Th8;
			 Thf = Th8 - Th7;
			 Tfy = Tfu + Tfx;
			 TfD = Tfz - TfC;
			 TfE = KP707106781 * (Tfy + TfD);
			 Th6 = KP707106781 * (Tfy - TfD);
		    }
		    {
			 E TfK, TfP, Tg8, Tg9;
			 TfK = TfI - TfJ;
			 TfP = TfL - TfO;
			 TfQ = FMA(KP382683432, TfK, KP923879532 * TfP);
			 Tg4 = FNMS(KP923879532, TfK, KP382683432 * TfP);
			 Tg8 = Tfu - Tfx;
			 Tg9 = Tfz + TfC;
			 Tga = KP707106781 * (Tg8 + Tg9);
			 The = KP707106781 * (Tg9 - Tg8);
		    }
		    {
			 E Tgc, Tgd, TfV, Tg0;
			 Tgc = TfL + TfO;
			 Tgd = TfI + TfJ;
			 Tge = FNMS(KP382683432, Tgd, KP923879532 * Tgc);
			 Tgk = FMA(KP923879532, Tgd, KP382683432 * Tgc);
			 TfV = TfR - TfU;
			 Tg0 = TfY - TfZ;
			 Tg1 = FNMS(KP382683432, Tg0, KP923879532 * TfV);
			 Tg5 = FMA(KP923879532, Tg0, KP382683432 * TfV);
		    }
		    {
			 E TfF, Tg2, Thd, Thg;
			 TfF = Tft + TfE;
			 Tg2 = TfQ + Tg1;
			 ci[WS(rs, 27)] = TfF - Tg2;
			 cr[WS(rs, 4)] = TfF + Tg2;
			 Thd = Tg5 - Tg4;
			 Thg = The + Thf;
			 cr[WS(rs, 36)] = Thd - Thg;
			 ci[WS(rs, 59)] = Thd + Thg;
		    }
		    {
			 E Thh, Thi, Tg3, Tg6;
			 Thh = Tg1 - TfQ;
			 Thi = Thf - The;
			 cr[WS(rs, 52)] = Thh - Thi;
			 ci[WS(rs, 43)] = Thh + Thi;
			 Tg3 = Tft - TfE;
			 Tg6 = Tg4 + Tg5;
			 cr[WS(rs, 20)] = Tg3 - Tg6;
			 ci[WS(rs, 11)] = Tg3 + Tg6;
		    }
		    {
			 E Tgb, Tgi, Th5, Tha;
			 Tgb = Tg7 + Tga;
			 Tgi = Tge + Tgh;
			 cr[WS(rs, 28)] = Tgb - Tgi;
			 ci[WS(rs, 3)] = Tgb + Tgi;
			 Th5 = Tgl - Tgk;
			 Tha = Th6 + Th9;
			 cr[WS(rs, 60)] = Th5 - Tha;
			 ci[WS(rs, 35)] = Th5 + Tha;
		    }
		    {
			 E Thb, Thc, Tgj, Tgm;
			 Thb = Tgh - Tge;
			 Thc = Th9 - Th6;
			 cr[WS(rs, 44)] = Thb - Thc;
			 ci[WS(rs, 51)] = Thb + Thc;
			 Tgj = Tg7 - Tga;
			 Tgm = Tgk + Tgl;
			 ci[WS(rs, 19)] = Tgj - Tgm;
			 cr[WS(rs, 12)] = Tgj + Tgm;
		    }
	       }
	       {
		    E TeH, Tf9, TeO, Thk, Thp, Thv, Tfc, Thu, Tf3, Tfn, Tf7, Tfj, TeW, Tfm, Tf6;
		    E Tfg;
		    {
			 E TeD, TeG, Tfa, Tfb;
			 TeD = TcL + TcO;
			 TeG = KP707106781 * (TeE + TeF);
			 TeH = TeD - TeG;
			 Tf9 = TeD + TeG;
			 {
			      E TeK, TeN, Thl, Tho;
			      TeK = FMA(KP923879532, TeI, KP382683432 * TeJ);
			      TeN = FNMS(KP923879532, TeM, KP382683432 * TeL);
			      TeO = TeK + TeN;
			      Thk = TeK - TeN;
			      Thl = KP707106781 * (TcU - TcZ);
			      Tho = Thm + Thn;
			      Thp = Thl + Tho;
			      Thv = Tho - Thl;
			 }
			 Tfa = FNMS(KP382683432, TeI, KP923879532 * TeJ);
			 Tfb = FMA(KP382683432, TeM, KP923879532 * TeL);
			 Tfc = Tfa + Tfb;
			 Thu = Tfb - Tfa;
			 {
			      E TeZ, Tfh, Tf2, Tfi, TeY, Tf1;
			      TeY = KP707106781 * (Te5 + Te0);
			      TeZ = TeX - TeY;
			      Tfh = TeX + TeY;
			      Tf1 = KP707106781 * (Ted + Tee);
			      Tf2 = Tf0 - Tf1;
			      Tfi = Tf0 + Tf1;
			      Tf3 = FNMS(KP555570233, Tf2, KP831469612 * TeZ);
			      Tfn = FMA(KP980785280, Tfh, KP195090322 * Tfi);
			      Tf7 = FMA(KP555570233, TeZ, KP831469612 * Tf2);
			      Tfj = FNMS(KP980785280, Tfi, KP195090322 * Tfh);
			 }
			 {
			      E TeS, Tfe, TeV, Tff, TeR, TeU;
			      TeR = KP707106781 * (TdN + TdM);
			      TeS = TeQ - TeR;
			      Tfe = TeQ + TeR;
			      TeU = KP707106781 * (Tdz + TdE);
			      TeV = TeT - TeU;
			      Tff = TeT + TeU;
			      TeW = FMA(KP831469612, TeS, KP555570233 * TeV);
			      Tfm = FNMS(KP195090322, Tff, KP980785280 * Tfe);
			      Tf6 = FNMS(KP831469612, TeV, KP555570233 * TeS);
			      Tfg = FMA(KP195090322, Tfe, KP980785280 * Tff);
			 }
		    }
		    {
			 E TeP, Tf4, Tht, Thw;
			 TeP = TeH + TeO;
			 Tf4 = TeW + Tf3;
			 ci[WS(rs, 25)] = TeP - Tf4;
			 cr[WS(rs, 6)] = TeP + Tf4;
			 Tht = Tf7 - Tf6;
			 Thw = Thu + Thv;
			 cr[WS(rs, 38)] = Tht - Thw;
			 ci[WS(rs, 57)] = Tht + Thw;
		    }
		    {
			 E Thx, Thy, Tf5, Tf8;
			 Thx = Tf3 - TeW;
			 Thy = Thv - Thu;
			 cr[WS(rs, 54)] = Thx - Thy;
			 ci[WS(rs, 41)] = Thx + Thy;
			 Tf5 = TeH - TeO;
			 Tf8 = Tf6 + Tf7;
			 cr[WS(rs, 22)] = Tf5 - Tf8;
			 ci[WS(rs, 9)] = Tf5 + Tf8;
		    }
		    {
			 E Tfd, Tfk, Thj, Thq;
			 Tfd = Tf9 - Tfc;
			 Tfk = Tfg + Tfj;
			 ci[WS(rs, 17)] = Tfd - Tfk;
			 cr[WS(rs, 14)] = Tfd + Tfk;
			 Thj = Tfj - Tfg;
			 Thq = Thk + Thp;
			 cr[WS(rs, 62)] = Thj - Thq;
			 ci[WS(rs, 33)] = Thj + Thq;
		    }
		    {
			 E Thr, Ths, Tfl, Tfo;
			 Thr = Tfn - Tfm;
			 Ths = Thp - Thk;
			 cr[WS(rs, 46)] = Thr - Ths;
			 ci[WS(rs, 49)] = Thr + Ths;
			 Tfl = Tf9 + Tfc;
			 Tfo = Tfm + Tfn;
			 cr[WS(rs, 30)] = Tfl - Tfo;
			 ci[WS(rs, 1)] = Tfl + Tfo;
		    }
	       }
	       {
		    E Td1, Ten, Tdo, ThA, ThD, ThJ, Teq, ThI, Teh, TeB, Tel, Tex, TdQ, TeA, Tek;
		    E Teu;
		    {
			 E TcP, Td0, Teo, Tep;
			 TcP = TcL - TcO;
			 Td0 = KP707106781 * (TcU + TcZ);
			 Td1 = TcP - Td0;
			 Ten = TcP + Td0;
			 {
			      E Tdc, Tdn, ThB, ThC;
			      Tdc = FNMS(KP923879532, Tdb, KP382683432 * Td6);
			      Tdn = FMA(KP923879532, Tdh, KP382683432 * Tdm);
			      Tdo = Tdc + Tdn;
			      ThA = Tdn - Tdc;
			      ThB = KP707106781 * (TeF - TeE);
			      ThC = Thn - Thm;
			      ThD = ThB + ThC;
			      ThJ = ThC - ThB;
			 }
			 Teo = FMA(KP382683432, Tdb, KP923879532 * Td6);
			 Tep = FNMS(KP382683432, Tdh, KP923879532 * Tdm);
			 Teq = Teo + Tep;
			 ThI = Teo - Tep;
			 {
			      E Te7, Tew, Teg, Tev, Te6, Tef;
			      Te6 = KP707106781 * (Te0 - Te5);
			      Te7 = TdV - Te6;
			      Tew = TdV + Te6;
			      Tef = KP707106781 * (Ted - Tee);
			      Teg = Tec - Tef;
			      Tev = Tec + Tef;
			      Teh = FMA(KP555570233, Te7, KP831469612 * Teg);
			      TeB = FMA(KP980785280, Tew, KP195090322 * Tev);
			      Tel = FNMS(KP831469612, Te7, KP555570233 * Teg);
			      Tex = FNMS(KP195090322, Tew, KP980785280 * Tev);
			 }
			 {
			      E TdG, Tet, TdP, Tes, TdF, TdO;
			      TdF = KP707106781 * (Tdz - TdE);
			      TdG = Tdu - TdF;
			      Tet = Tdu + TdF;
			      TdO = KP707106781 * (TdM - TdN);
			      TdP = TdL - TdO;
			      Tes = TdL + TdO;
			      TdQ = FNMS(KP555570233, TdP, KP831469612 * TdG);
			      TeA = FNMS(KP980785280, Tes, KP195090322 * Tet);
			      Tek = FMA(KP831469612, TdP, KP555570233 * TdG);
			      Teu = FMA(KP195090322, Tes, KP980785280 * Tet);
			 }
		    }
		    {
			 E Tdp, Tei, ThH, ThK;
			 Tdp = Td1 + Tdo;
			 Tei = TdQ + Teh;
			 cr[WS(rs, 26)] = Tdp - Tei;
			 ci[WS(rs, 5)] = Tdp + Tei;
			 ThH = Tel - Tek;
			 ThK = ThI + ThJ;
			 cr[WS(rs, 58)] = ThH - ThK;
			 ci[WS(rs, 37)] = ThH + ThK;
		    }
		    {
			 E ThL, ThM, Tej, Tem;
			 ThL = Teh - TdQ;
			 ThM = ThJ - ThI;
			 cr[WS(rs, 42)] = ThL - ThM;
			 ci[WS(rs, 53)] = ThL + ThM;
			 Tej = Td1 - Tdo;
			 Tem = Tek + Tel;
			 ci[WS(rs, 21)] = Tej - Tem;
			 cr[WS(rs, 10)] = Tej + Tem;
		    }
		    {
			 E Ter, Tey, Thz, ThE;
			 Ter = Ten + Teq;
			 Tey = Teu + Tex;
			 ci[WS(rs, 29)] = Ter - Tey;
			 cr[WS(rs, 2)] = Ter + Tey;
			 Thz = TeB - TeA;
			 ThE = ThA + ThD;
			 cr[WS(rs, 34)] = Thz - ThE;
			 ci[WS(rs, 61)] = Thz + ThE;
		    }
		    {
			 E ThF, ThG, Tez, TeC;
			 ThF = Tex - Teu;
			 ThG = ThD - ThA;
			 cr[WS(rs, 50)] = ThF - ThG;
			 ci[WS(rs, 45)] = ThF + ThG;
			 Tez = Ten - Teq;
			 TeC = TeA + TeB;
			 cr[WS(rs, 18)] = Tez - TeC;
			 ci[WS(rs, 13)] = Tez + TeC;
		    }
	       }
	       {
		    E Tc3, Tcv, TiD, TiJ, Tca, TiI, Tcy, TiA, Tci, TcI, Tcs, TcC, Tcp, TcJ, Tct;
		    E TcF;
		    {
			 E TbZ, Tc2, TiB, TiC;
			 TbZ = Taz - TaC;
			 Tc2 = Tc0 + Tc1;
			 Tc3 = TbZ - Tc2;
			 Tcv = TbZ + Tc2;
			 TiB = TaG - TaJ;
			 TiC = Tin - Tim;
			 TiD = TiB + TiC;
			 TiJ = TiC - TiB;
		    }
		    {
			 E Tc6, Tcw, Tc9, Tcx;
			 {
			      E Tc4, Tc5, Tc7, Tc8;
			      Tc4 = TaP - TaQ;
			      Tc5 = TaM - TaN;
			      Tc6 = FMA(KP831469612, Tc4, KP555570233 * Tc5);
			      Tcw = FNMS(KP555570233, Tc4, KP831469612 * Tc5);
			      Tc7 = TaW - TaX;
			      Tc8 = TaT - TaU;
			      Tc9 = FNMS(KP831469612, Tc8, KP555570233 * Tc7);
			      Tcx = FMA(KP555570233, Tc8, KP831469612 * Tc7);
			 }
			 Tca = Tc6 + Tc9;
			 TiI = Tcx - Tcw;
			 Tcy = Tcw + Tcx;
			 TiA = Tc6 - Tc9;
		    }
		    {
			 E Tce, TcB, Tch, TcA;
			 {
			      E Tcc, Tcd, Tcf, Tcg;
			      Tcc = Tbd - Tbe;
			      Tcd = Tb7 - Tba;
			      Tce = Tcc - Tcd;
			      TcB = Tcc + Tcd;
			      Tcf = Tb2 - Tb3;
			      Tcg = Tbh - Tbg;
			      Tch = Tcf - Tcg;
			      TcA = Tcf + Tcg;
			 }
			 Tci = FMA(KP471396736, Tce, KP881921264 * Tch);
			 TcI = FMA(KP956940335, TcB, KP290284677 * TcA);
			 Tcs = FNMS(KP881921264, Tce, KP471396736 * Tch);
			 TcC = FNMS(KP290284677, TcB, KP956940335 * TcA);
		    }
		    {
			 E Tcl, TcE, Tco, TcD;
			 {
			      E Tcj, Tck, Tcm, Tcn;
			      Tcj = Tbl - Tbm;
			      Tck = TbA - Tbz;
			      Tcl = Tcj - Tck;
			      TcE = Tcj + Tck;
			      Tcm = Tbw - Tbx;
			      Tcn = Tbq - Tbt;
			      Tco = Tcm - Tcn;
			      TcD = Tcm + Tcn;
			 }
			 Tcp = FNMS(KP471396736, Tco, KP881921264 * Tcl);
			 TcJ = FNMS(KP956940335, TcD, KP290284677 * TcE);
			 Tct = FMA(KP881921264, Tco, KP471396736 * Tcl);
			 TcF = FMA(KP290284677, TcD, KP956940335 * TcE);
		    }
		    {
			 E Tcb, Tcq, TiH, TiK;
			 Tcb = Tc3 + Tca;
			 Tcq = Tci + Tcp;
			 ci[WS(rs, 26)] = Tcb - Tcq;
			 cr[WS(rs, 5)] = Tcb + Tcq;
			 TiH = Tct - Tcs;
			 TiK = TiI + TiJ;
			 cr[WS(rs, 37)] = TiH - TiK;
			 ci[WS(rs, 58)] = TiH + TiK;
		    }
		    {
			 E TiL, TiM, Tcr, Tcu;
			 TiL = Tcp - Tci;
			 TiM = TiJ - TiI;
			 cr[WS(rs, 53)] = TiL - TiM;
			 ci[WS(rs, 42)] = TiL + TiM;
			 Tcr = Tc3 - Tca;
			 Tcu = Tcs + Tct;
			 cr[WS(rs, 21)] = Tcr - Tcu;
			 ci[WS(rs, 10)] = Tcr + Tcu;
		    }
		    {
			 E Tcz, TcG, Tiz, TiE;
			 Tcz = Tcv + Tcy;
			 TcG = TcC + TcF;
			 cr[WS(rs, 29)] = Tcz - TcG;
			 ci[WS(rs, 2)] = Tcz + TcG;
			 Tiz = TcJ - TcI;
			 TiE = TiA + TiD;
			 cr[WS(rs, 61)] = Tiz - TiE;
			 ci[WS(rs, 34)] = Tiz + TiE;
		    }
		    {
			 E TiF, TiG, TcH, TcK;
			 TiF = TcF - TcC;
			 TiG = TiD - TiA;
			 cr[WS(rs, 45)] = TiF - TiG;
			 ci[WS(rs, 50)] = TiF + TiG;
			 TcH = Tcv - Tcy;
			 TcK = TcI + TcJ;
			 ci[WS(rs, 18)] = TcH - TcK;
			 cr[WS(rs, 13)] = TcH + TcK;
		    }
	       }
	       {
		    E TaL, TbJ, Tip, Tiv, Tb0, Tiu, TbM, Tik, Tbk, TbW, TbG, TbQ, TbD, TbX, TbH;
		    E TbT;
		    {
			 E TaD, TaK, Til, Tio;
			 TaD = Taz + TaC;
			 TaK = TaG + TaJ;
			 TaL = TaD - TaK;
			 TbJ = TaD + TaK;
			 Til = Tc1 - Tc0;
			 Tio = Tim + Tin;
			 Tip = Til + Tio;
			 Tiv = Tio - Til;
		    }
		    {
			 E TaS, TbK, TaZ, TbL;
			 {
			      E TaO, TaR, TaV, TaY;
			      TaO = TaM + TaN;
			      TaR = TaP + TaQ;
			      TaS = FNMS(KP980785280, TaR, KP195090322 * TaO);
			      TbK = FMA(KP195090322, TaR, KP980785280 * TaO);
			      TaV = TaT + TaU;
			      TaY = TaW + TaX;
			      TaZ = FMA(KP980785280, TaV, KP195090322 * TaY);
			      TbL = FNMS(KP195090322, TaV, KP980785280 * TaY);
			 }
			 Tb0 = TaS + TaZ;
			 Tiu = TbK - TbL;
			 TbM = TbK + TbL;
			 Tik = TaZ - TaS;
		    }
		    {
			 E Tbc, TbO, Tbj, TbP;
			 {
			      E Tb4, Tbb, Tbf, Tbi;
			      Tb4 = Tb2 + Tb3;
			      Tbb = Tb7 + Tba;
			      Tbc = Tb4 - Tbb;
			      TbO = Tb4 + Tbb;
			      Tbf = Tbd + Tbe;
			      Tbi = Tbg + Tbh;
			      Tbj = Tbf - Tbi;
			      TbP = Tbf + Tbi;
			 }
			 Tbk = FMA(KP634393284, Tbc, KP773010453 * Tbj);
			 TbW = FNMS(KP995184726, TbP, KP098017140 * TbO);
			 TbG = FNMS(KP634393284, Tbj, KP773010453 * Tbc);
			 TbQ = FMA(KP995184726, TbO, KP098017140 * TbP);
		    }
		    {
			 E Tbv, TbR, TbC, TbS;
			 {
			      E Tbn, Tbu, Tby, TbB;
			      Tbn = Tbl + Tbm;
			      Tbu = Tbq + Tbt;
			      Tbv = Tbn - Tbu;
			      TbR = Tbn + Tbu;
			      Tby = Tbw + Tbx;
			      TbB = Tbz + TbA;
			      TbC = Tby - TbB;
			      TbS = Tby + TbB;
			 }
			 TbD = FNMS(KP773010453, TbC, KP634393284 * Tbv);
			 TbX = FMA(KP098017140, TbR, KP995184726 * TbS);
			 TbH = FMA(KP773010453, Tbv, KP634393284 * TbC);
			 TbT = FNMS(KP098017140, TbS, KP995184726 * TbR);
		    }
		    {
			 E Tb1, TbE, Tit, Tiw;
			 Tb1 = TaL - Tb0;
			 TbE = Tbk + TbD;
			 ci[WS(rs, 22)] = Tb1 - TbE;
			 cr[WS(rs, 9)] = Tb1 + TbE;
			 Tit = TbD - Tbk;
			 Tiw = Tiu + Tiv;
			 cr[WS(rs, 57)] = Tit - Tiw;
			 ci[WS(rs, 38)] = Tit + Tiw;
		    }
		    {
			 E Tix, Tiy, TbF, TbI;
			 Tix = TbH - TbG;
			 Tiy = Tiv - Tiu;
			 cr[WS(rs, 41)] = Tix - Tiy;
			 ci[WS(rs, 54)] = Tix + Tiy;
			 TbF = TaL + Tb0;
			 TbI = TbG + TbH;
			 cr[WS(rs, 25)] = TbF - TbI;
			 ci[WS(rs, 6)] = TbF + TbI;
		    }
		    {
			 E TbN, TbU, Tij, Tiq;
			 TbN = TbJ + TbM;
			 TbU = TbQ + TbT;
			 ci[WS(rs, 30)] = TbN - TbU;
			 cr[WS(rs, 1)] = TbN + TbU;
			 Tij = TbX - TbW;
			 Tiq = Tik + Tip;
			 cr[WS(rs, 33)] = Tij - Tiq;
			 ci[WS(rs, 62)] = Tij + Tiq;
		    }
		    {
			 E Tir, Tis, TbV, TbY;
			 Tir = TbT - TbQ;
			 Tis = Tip - Tik;
			 cr[WS(rs, 49)] = Tir - Tis;
			 ci[WS(rs, 46)] = Tir + Tis;
			 TbV = TbJ - TbM;
			 TbY = TbW + TbX;
			 cr[WS(rs, 17)] = TbV - TbY;
			 ci[WS(rs, 14)] = TbV + TbY;
		    }
	       }
	       {
		    E T9R, Taj, Ti9, Tif, T9Y, Tie, Tam, Ti6, Ta6, Taw, Tag, Taq, Tad, Tax, Tah;
		    E Tat;
		    {
			 E T9N, T9Q, Ti7, Ti8;
			 T9N = T6b - T6m;
			 T9Q = T9O + T9P;
			 T9R = T9N - T9Q;
			 Taj = T9N + T9Q;
			 Ti7 = T6J - T6y;
			 Ti8 = ThT - ThQ;
			 Ti9 = Ti7 + Ti8;
			 Tif = Ti8 - Ti7;
		    }
		    {
			 E T9U, Tak, T9X, Tal;
			 {
			      E T9S, T9T, T9V, T9W;
			      T9S = T6Q - T71;
			      T9T = T77 - T7a;
			      T9U = FNMS(KP831469612, T9T, KP555570233 * T9S);
			      Tak = FMA(KP831469612, T9S, KP555570233 * T9T);
			      T9V = T7h - T7s;
			      T9W = T7y - T7B;
			      T9X = FMA(KP555570233, T9V, KP831469612 * T9W);
			      Tal = FNMS(KP555570233, T9W, KP831469612 * T9V);
			 }
			 T9Y = T9U + T9X;
			 Tie = Tak - Tal;
			 Tam = Tak + Tal;
			 Ti6 = T9X - T9U;
		    }
		    {
			 E Ta2, Tao, Ta5, Tap;
			 {
			      E Ta0, Ta1, Ta3, Ta4;
			      Ta0 = T8p - T8s;
			      Ta1 = T87 - T8i;
			      Ta2 = Ta0 - Ta1;
			      Tao = Ta0 + Ta1;
			      Ta3 = T7K - T7V;
			      Ta4 = T8v - T8u;
			      Ta5 = Ta3 - Ta4;
			      Tap = Ta3 + Ta4;
			 }
			 Ta6 = FMA(KP471396736, Ta2, KP881921264 * Ta5);
			 Taw = FNMS(KP956940335, Tap, KP290284677 * Tao);
			 Tag = FNMS(KP471396736, Ta5, KP881921264 * Ta2);
			 Taq = FMA(KP956940335, Tao, KP290284677 * Tap);
		    }
		    {
			 E Ta9, Tar, Tac, Tas;
			 {
			      E Ta7, Ta8, Taa, Tab;
			      Ta7 = T8D - T8O;
			      Ta8 = T9n - T9o;
			      Ta9 = Ta7 - Ta8;
			      Tar = Ta7 + Ta8;
			      Taa = T9i - T9l;
			      Tab = T9b - T90;
			      Tac = Taa - Tab;
			      Tas = Taa + Tab;
			 }
			 Tad = FNMS(KP881921264, Tac, KP471396736 * Ta9);
			 Tax = FMA(KP290284677, Tar, KP956940335 * Tas);
			 Tah = FMA(KP881921264, Ta9, KP471396736 * Tac);
			 Tat = FNMS(KP290284677, Tas, KP956940335 * Tar);
		    }
		    {
			 E T9Z, Tae, Tid, Tig;
			 T9Z = T9R - T9Y;
			 Tae = Ta6 + Tad;
			 ci[WS(rs, 20)] = T9Z - Tae;
			 cr[WS(rs, 11)] = T9Z + Tae;
			 Tid = Tad - Ta6;
			 Tig = Tie + Tif;
			 cr[WS(rs, 59)] = Tid - Tig;
			 ci[WS(rs, 36)] = Tid + Tig;
		    }
		    {
			 E Tih, Tii, Taf, Tai;
			 Tih = Tah - Tag;
			 Tii = Tif - Tie;
			 cr[WS(rs, 43)] = Tih - Tii;
			 ci[WS(rs, 52)] = Tih + Tii;
			 Taf = T9R + T9Y;
			 Tai = Tag + Tah;
			 cr[WS(rs, 27)] = Taf - Tai;
			 ci[WS(rs, 4)] = Taf + Tai;
		    }
		    {
			 E Tan, Tau, Ti5, Tia;
			 Tan = Taj + Tam;
			 Tau = Taq + Tat;
			 ci[WS(rs, 28)] = Tan - Tau;
			 cr[WS(rs, 3)] = Tan + Tau;
			 Ti5 = Tax - Taw;
			 Tia = Ti6 + Ti9;
			 cr[WS(rs, 35)] = Ti5 - Tia;
			 ci[WS(rs, 60)] = Ti5 + Tia;
		    }
		    {
			 E Tib, Tic, Tav, Tay;
			 Tib = Tat - Taq;
			 Tic = Ti9 - Ti6;
			 cr[WS(rs, 51)] = Tib - Tic;
			 ci[WS(rs, 44)] = Tib + Tic;
			 Tav = Taj - Tam;
			 Tay = Taw + Tax;
			 cr[WS(rs, 19)] = Tav - Tay;
			 ci[WS(rs, 12)] = Tav + Tay;
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 64},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 64, "hf_64", twinstr, &GENUS, {808, 270, 230, 0} };

void X(codelet_hf_64) (planner *p) {
     X(khc2hc_register) (p, hf_64, &desc);
}
#endif
