/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef GATOS_FI12XX_H
#define GATOS_FI12XX_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef GATOS_FI12XX_C
#define WHERE       
#else
#define WHERE	extern
#endif

#define MAXTUNERTYPE	0x12

#define FISTATUS	i2c_read(gatos.fi12xx.addr)

#define FREQ2K(F)	((F+gatos.Fpc+0.03125)*16.0)
#define K2FREQ(K)	(K/16.0-gatos.Fpc)
#define HAVESIGNAL	\
	( ((FISTATUS & 0x47) == 0x42) && (BTREAD(STATUS) & 0x80) )

/* FI12XX function declarations */

int	fi12xx_init(void) ;
void	fi12xx_setformat(void) ;
double	fi12xx_minfreq(void) ;
double	fi12xx_maxfreq(void) ;
int	fi12xx_tune(void) ;
double	fi12xx_scan(double, double, int(*)(double,char*), int(*)(double)) ;
void	fi12xx_dumpregs(void) ;

#ifdef GATOS_FI12XX_C
static u8	fi12xx_band(double) ;
static int	fi12xx_register(u8, int) ;
#endif

#ifdef __cplusplus
}
#endif

#undef WHERE
#endif
