# Export only named entry points from shared library.
function(target_shared_library_exports lib libname symbols)
  if (WIN32)
    file(WRITE "${CMAKE_CURRENT_BINARY_DIR}/${libname}.def" "LIBRARY ${libname}\n  EXPORTS\n")
    foreach (symbol IN LISTS symbols)
      file(APPEND "${CMAKE_CURRENT_BINARY_DIR}/${libname}.def" "    ${symbol}\n")
    endforeach ()
    target_sources(${lib} PRIVATE "${CMAKE_CURRENT_BINARY_DIR}/${libname}.def")
  elseif (APPLE)
    file(WRITE "${CMAKE_CURRENT_BINARY_DIR}/${libname}.syms" "")
    foreach (symbol IN LISTS symbols)
      file(APPEND "${CMAKE_CURRENT_BINARY_DIR}/${libname}.syms" "_${symbol}\n")
    endforeach ()
    target_sources(${lib} PRIVATE "${CMAKE_CURRENT_BINARY_DIR}/${libname}.syms")
    target_link_libraries(${lib} PRIVATE "-exported_symbols_list ${libname}.syms")
  elseif (UNIX)
    # Assume GNU ld.
    file(WRITE "${CMAKE_CURRENT_BINARY_DIR}/${libname}.ver" "{ global:\n")
    foreach (symbol IN LISTS symbols)
      file(APPEND "${CMAKE_CURRENT_BINARY_DIR}/${libname}.ver" "  ${symbol};\n")
    endforeach ()
    file(APPEND "${CMAKE_CURRENT_BINARY_DIR}/${libname}.ver" "local:\n  *;\n};\n")
    target_link_libraries(${lib} PRIVATE "-Wl,--version-script=getdns.ver")
  else ()
    message(WARNING "Unknown platform, ${lib} exports not set.")
  endif ()
endfunction ()
