#!/usr/bin/env python

"""
Internationalisation support.

Copyright (C) 2015, 2017 Paul Boddie <paul@boddie.org.uk>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from imiptools.config import settings
from os.path import abspath, exists, join, split
import gettext

LOCALE_DIR = settings["LOCALE_DIR"]
TRANS_DOMAIN = settings["TRANS_DOMAIN"]

def get_locale_dir():
    locale_dir = abspath(join(split(__file__)[0], "..", "locale"))
    if exists(locale_dir):
        return locale_dir
    else:
        return LOCALE_DIR

def get_translator(languages):
    return gettext.translation(TRANS_DOMAIN, get_locale_dir(), languages,
        fallback=True).ugettext

# vim: tabstop=4 expandtab shiftwidth=4
