# Programmatic Python API Usage

In addition to the powerful command line interface, isort exposes a complete Python API.

To use the Python API, `import isort` and then call the desired function call:

<script id="asciicast-346604" src="https://asciinema.org/a/346604.js" async></script>

Every function is fully type hinted and requires and returns only builtin Python objects.

Highlights include:

- `isort.code` - Takes a string containing code, and returns it with imports sorted.
- `isort.check_code` - Takes a string containing code, and returns `True` if all imports are sorted correctly, otherwise, `False`.
- `isort.stream` - Takes an input stream containing Python code and an output stream. Outputs code to output stream with all imports sorted.
- `isort.check_stream` - Takes an input stream containing Python code and returns `True` if all imports in the stream are sorted correctly, otherwise, `False`.
- `isort.file` - Takes the path of a Python source file and sorts the imports in-place.
- `isort.check_file` - Takes the path of a Python source file and returns `True` if all imports contained within are sorted correctly, otherwise, `False`.
- `isort.place_module` - Takes the name of a module as a string and returns the categorization determined for it.
- `isort.place_module_with_reason` - Takes the name of a module as a string and returns the categorization determined for it and why that categorization was given.

For a full definition of the API see the [API reference documentation](https://pycqa.github.io/isort/reference/isort/api) or try `help(isort)` from an interactive interpreter.
