/*
XPAGES pour WebJaxe

Copyright (C) 2007 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package xpages;

import java.awt.*;
import java.io.*;

/**
 * Seules les mthodes getWidth et getHeight sont implmentes pour MPEGAnim,
 * il n'y a pas de dcodage de la vido.
 */
public class MPEGAnim implements ImAnim {
	
    int largeur;
    int hauteur;
    
	// debugging
	public static void main(String[] args) {
		if (args.length != 1) {
			System.err.println("il faut 1 argument");
			return;
		}
		File forig = new File(args[0]);
		if (!forig.exists()) {
			System.err.println("le fichier n'existe pas");
			return;
		}
		MPEGAnim anim = new MPEGAnim();
		try {
			anim.open(forig);
			System.out.println("largeur: " + anim.getWidth());
			System.out.println("hauteur: " + anim.getHeight());
		} catch (IOException ex) {
			System.err.println("IOException : " + ex.getMessage());
			return;
		}
	}
	
	public void open(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        long signature = 0x000001B3;
        int b1,b2,b3,b4;
        int bi = 0;
        b1 = in.read();
        b2 = in.read();
        b3 = in.read();
        b4 = in.read();
        long v = ((b1 & 0xFF) << 24) | ((b2 & 0xFF) << 16) | ((b3 & 0xFF) << 8) | (b4 & 0xFF);
        while (bi != -1 && v != signature) {
            bi = in.read();
            if (bi != -1) {
                b1 = b2; b2 = b3; b3 = b4;
                b4 = bi;
                v = ((b1 & 0xFF) << 24) | ((b2 & 0xFF) << 16) | ((b3 & 0xFF) << 8) | (b4 & 0xFF);
            }
        }
        if (v == signature) {
            b1 = in.read();
            b2 = in.read();
            b3 = in.read();
            largeur = ((b1 & 0xFF) << 4) | ((b2 & 0xF0) >> 4);
            hauteur = ((b2 & 0x0F) << 8) | (b3 & 0xFF);
        } else
            System.err.println("Erreur: Dimensions non trouves pour " + f.getPath());
        in.close();
	}
	
	public int getWidth() {
		return(largeur);
	}
	
	public int getHeight() {
		return(hauteur);
	}
	
	public int getImageCount() {
        System.err.println("Erreur: getImageCount n'est pas implment pour les vido MPEG");
        return(0);
	}
	
	public Image getImage(int n) {
        System.err.println("Erreur: getImage n'est pas implment pour les vido MPEG");
        return(null);
	}
	
	public void rescale(File newf, int width, int height) throws IOException {
        throw new IOException("rescale n'est pas implment pour les vido MPEG");
	}
    
}
