/*
 * Copyright 2013-2015 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#pragma once

#include <functional>
#include <lomiri/download_manager/group_download.h>
#include <lomiri/download_manager/error.h>
#include <lomiri/download_manager/manager.h>

#include <QObject>
#include "local_tree_testcase.h"

using namespace Lomiri::DownloadManager;

class TestGroupManagerWatch : public LocalTreeTestCase {
    Q_OBJECT

 public:
    explicit TestGroupManagerWatch(QObject* parent = 0);

 private:
    void onSuccessCb(GroupDownload* down);
    void onErrorCb(GroupDownload* err);

 private Q_SLOTS:  // NOLINT(whitespace/indent)

    void init() override;
    void cleanup() override;
    void testCallbackIsExecuted();
    void testErrCallbackIsExecuted();

 private:
    bool _calledSuccess = false;
    bool _calledError = false;
    QString _algo;
    QVariantMap _metadata;
    QMap<QString, QString> _headers;
    Manager* _manager = nullptr;
};

