/***************************************************************************
 begin       : Sat Oct 18 2008
 copyright   : (C) 2018 by Martin Preuss
 email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "globals.h"

#include "aqebics/client/user.h"

#include <gwenhywfar/text.h>



int addSubUserFlags(AB_PROVIDER *pro,
                    GWEN_DB_NODE *dbArgs,
                    int argc,
                    char **argv,
                    int doAdd)
{
  GWEN_DB_NODE *db;
  uint32_t uid;
  AB_USER *u=NULL;
  uint32_t flags;
  int rv;
  const GWEN_ARGS args[]= {
    {
      GWEN_ARGS_FLAGS_HAS_ARGUMENT, /* flags */
      GWEN_ArgsType_Int,            /* type */
      "userId",                     /* name */
      0,                            /* minnum */
      1,                            /* maxnum */
      "u",                          /* short option */
      "user",                       /* long option */
      "Specify the unique user id",    /* short description */
      "Specify the unique user id"     /* long description */
    },
    {
      GWEN_ARGS_FLAGS_HAS_ARGUMENT, /* flags */
      GWEN_ArgsType_Char,           /* type */
      "flags",                      /* name */
      1,                            /* minnum */
      99,                            /* maxnum */
      "f",                          /* short option */
      "flags",                   /* long option */
      "Specify the user flags",    /* short description */
      "Specify the user flags"     /* long description */
    },
    {
      GWEN_ARGS_FLAGS_HELP | GWEN_ARGS_FLAGS_LAST, /* flags */
      GWEN_ArgsType_Int,            /* type */
      "help",                       /* name */
      0,                            /* minnum */
      0,                            /* maxnum */
      "h",                          /* short option */
      "help",                       /* long option */
      "Show this help screen",      /* short description */
      "Show this help screen"       /* long description */
    }
  };

  db=GWEN_DB_GetGroup(dbArgs, GWEN_DB_FLAGS_DEFAULT, "local");
  rv=AB_Cmd_Handle_Args(argc, argv, args, db);
  if (rv==GWEN_ARGS_RESULT_ERROR) {
    return 1;
  }
  else if (rv==GWEN_ARGS_RESULT_HELP) {
    return 0;
  }


  uid=(uint32_t) GWEN_DB_GetIntValue(db, "userId", 0, 0);
  if (uid==0) {
    fprintf(stderr, "ERROR: Invalid or missing unique user id\n");
    return 1;
  }

  flags=EBC_User_Flags_fromDb(db, "flags");

  rv=AB_Provider_GetUser(pro, uid, 1, 0, &u); /* don't lock to allow for AH_Provider_EndExclUseUser */
  if (rv<0) {
    fprintf(stderr, "ERROR: User with id %lu not found\n", (unsigned long int) uid);
    return 2;
  }
  else {
    /* modify */
    if (doAdd) {
      fprintf(stderr, "Adding flags: %08x\n", flags);
      EBC_User_AddFlags(u, flags);
    }
    else {
      fprintf(stderr, "Removing flags: %08x\n", flags);
      EBC_User_SubFlags(u, flags);
    }

    /* unlock user */
    rv=AB_Provider_EndExclUseUser(pro, u, 0);
    if (rv<0) {
      fprintf(stderr, "ERROR: Could not unlock user (%d)\n", rv);
      AB_Provider_EndExclUseUser(pro, u, 1); /* abort */
      AB_User_free(u);
      return 4;
    }
  }
  AB_User_free(u);


  return 0;
}



int addUserFlags(AB_PROVIDER *pro,
                 GWEN_DB_NODE *dbArgs,
                 int argc,
                 char **argv)
{
  return addSubUserFlags(pro, dbArgs, argc, argv, 1);
}



int subUserFlags(AB_PROVIDER *pro,
                 GWEN_DB_NODE *dbArgs,
                 int argc,
                 char **argv)
{
  return addSubUserFlags(pro, dbArgs, argc, argv, 0);
}



