/* ----- encode/857x1723round, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_857x1723round_checksums[] = {
  "c594e45623de22d6a6353b86c6ded45616e77d4d47101d80700e9dc975163966",
  "674a993b7f62eeefa79c7f0fe26c5b522e030c651c763e3dc097a280068a951f",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_857x1723round_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_857x1723round_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_857x1723round_ITEMBYTES

static void *storage_encode_857x1723round_s;
static unsigned char *test_encode_857x1723round_s;
static void *storage_encode_857x1723round_x;
static unsigned char *test_encode_857x1723round_x;
static void *storage_encode_857x1723round_s2;
static unsigned char *test_encode_857x1723round_s2;
static void *storage_encode_857x1723round_x2;
static unsigned char *test_encode_857x1723round_x2;

#define precomputed_encode_857x1723round_NUM 4

static const unsigned char precomputed_encode_857x1723round_s[precomputed_encode_857x1723round_NUM][crypto_encode_STRBYTES] = {
  {155,113,199,109,148,238,213,168,43,33,97,132,141,228,252,188,109,78,29,104,209,166,7,150,177,237,113,150,110,139,142,75,31,67,187,205,226,235,130,94,107,22,16,255,24,179,10,251,6,41,66,90,14,173,163,24,165,196,62,6,59,22,166,41,245,71,149,209,42,70,102,81,98,204,211,90,57,62,139,61,70,230,114,233,255,45,55,226,57,240,152,227,158,33,92,11,127,123,73,241,160,172,155,230,52,131,42,26,25,197,98,82,80,125,58,78,17,219,69,133,185,205,241,100,106,224,22,133,126,38,76,36,155,143,170,165,236,17,241,238,147,104,159,244,49,150,214,164,137,21,121,7,40,15,107,249,4,230,156,12,209,125,12,174,146,160,139,196,57,69,23,243,2,160,181,252,200,213,111,68,128,117,243,234,238,38,135,46,242,5,4,118,111,8,247,249,237,221,255,12,44,247,33,7,5,62,254,149,207,158,238,217,119,30,218,230,218,126,158,250,32,138,90,187,25,150,221,114,180,79,49,136,153,150,225,85,61,45,160,172,77,123,59,248,3,113,229,173,150,183,85,188,251,54,54,240,184,194,184,112,219,118,190,70,135,168,64,112,36,188,170,205,255,48,121,205,35,230,172,221,139,35,85,134,124,208,225,96,24,52,97,224,244,94,245,113,226,180,37,203,67,220,130,86,120,82,145,185,208,158,245,216,139,210,211,143,47,198,9,192,211,182,233,151,226,147,126,200,103,35,163,215,41,217,223,2,169,82,242,128,122,12,172,145,77,79,230,108,94,117,106,199,9,137,223,135,214,255,131,39,188,200,61,229,53,163,126,197,18,20,67,151,126,94,147,81,70,73,159,219,145,74,27,217,22,54,58,42,15,192,232,213,80,254,221,8,140,59,165,194,85,11,6,130,254,100,49,142,206,177,150,162,186,179,216,69,20,159,251,241,185,221,153,125,85,179,222,81,113,192,221,92,79,179,6,45,118,74,133,103,131,174,234,64,171,54,111,183,111,61,214,208,77,194,133,28,240,157,145,128,101,103,170,202,246,31,1,27,33,242,101,161,55,153,6,4,151,8,240,26,134,7,15,233,67,236,211,89,4,158,161,138,250,110,51,132,120,78,179,46,27,239,67,12,78,147,98,199,249,81,227,64,213,109,57,160,199,193,232,203,220,189,115,65,207,149,66,16,2,4,2,156,86,120,45,186,126,119,67,193,53,197,203,138,8,107,107,52,226,155,17,247,125,75,70,38,38,24,57,172,80,223,238,15,157,61,208,108,128,82,138,112,186,172,191,234,121,8,147,105,209,52,180,216,242,128,96,210,122,123,156,215,92,243,35,47,52,186,242,234,55,209,114,106,48,35,35,245,251,30,150,35,247,165,108,114,43,105,177,32,164,245,85,200,233,228,203,168,200,130,59,245,248,209,203,105,160,153,154,123,118,146,198,194,130,252,231,253,234,85,221,206,192,211,139,198,13,249,239,82,44,145,23,97,229,161,0,167,156,151,71,8,202,74,20,12,22,248,147,135,236,186,115,3,201,250,9,49,188,179,190,201,247,186,238,220,56,204,229,103,31,236,25,49,174,133,217,52,72,248,196,103,208,115,130,135,10,96,182,77,6,67,22,127,171,10,107,70,226,59,224,236,90,254,132,1,203,185,139,21,249,155,70,60,31,168,109,116,72,114,194,161,191,111,121,214,150,216,132,133,69,6,153,204,119,239,249,190,232,119,137,112,222,137,105,52,216,216,123,38,186,196,188,136,221,195,72,137,16,126,110,137,82,134,185,211,29,160,163,4,122,72,49,35,113,12,248,175,148,138,187,180,178,1,37,172,16,213,130,153,115,62,211,30,207,81,44,233,212,67,90,213,148,89,207,112,189,151,164,78,114,198,134,227,199,108,241,152,227,28,60,51,119,228,80,41,51,99,15,223,121,62,153,236,158,44,149,51,247,138,245,34,169,46,141,36,148,107,158,32,213,80,115,206,21,120,115,173,136,120,133,237,144,24,134,138,124,151,89,219,8,127,23,80,221,33,45,175,41,220,253,191,1,48,214,226,234,204,31,131,168,0,34,214,218,227,99,221,116,163,89,121,159,243,46,80,81,193,1,131,245,149,88,220,154,111,62,104,85,159,232,78,186,118,77,201,30,153,100,165,208,14,132,103,55,230,152,57,30,212,255,195,0,173,84,134,223,160,162,23,143,66,58,32,175,65,238,245,25,97,92,129,125,143,186,94,165,82,53,197,160,137,194,132,28,189,244,186,103,174,193,114,213,208,10,174,81,204,189,42,65,180,233,142,189,26,20,145,155,73,28,71,11,132,26,125,212,69,188,64,164,203,227,227,165,65,105,138,48,250,33,70,179,252,64,135,106,21,25,129,180,29,172,154,142,176,26,108,62,120,38,190,214,79,200,143,113,137,132,14,234,6,240,27,125,161,170,184,79,80,191,67,35,157,163,182,107,228,105,148,164,31,38,252,49,47,101,164,121,195,1,138,102,179,64,175,66,14,32,215,150,211,234,18,195,182,151,138,147,88,113,106,227,85,106,155,155,235,226,17,138,57,20,47,174,78,154,88,201,51,102,208},
  {229,229,142,253,159,5,235,59,238,245,75,3,14,184,144,48,16,6,124,167,59,14,41,220,41,97,9,7,163,235,89,199,114,2,112,179,172,59,194,255,21,121,31,132,52,14,2,167,197,20,175,29,29,194,175,24,184,247,75,219,67,17,100,131,197,143,127,3,160,213,175,210,215,208,192,175,172,139,211,56,1,184,79,11,125,235,17,15,226,50,74,69,115,0,185,231,170,87,126,8,204,128,48,226,13,71,98,138,249,181,45,199,67,30,42,137,134,217,103,122,94,130,81,38,118,80,77,183,147,168,161,83,41,212,45,134,207,127,251,233,9,136,143,26,219,223,229,80,147,138,55,145,129,12,221,101,106,84,80,205,210,210,25,142,34,16,197,173,64,51,158,211,207,172,247,95,24,105,128,135,11,125,106,232,138,191,46,38,87,8,73,116,116,30,252,51,174,136,112,78,32,245,251,250,31,118,97,62,8,129,91,215,58,159,5,171,202,248,125,136,125,249,10,80,220,245,41,177,19,221,77,51,181,217,48,97,211,202,102,122,132,44,37,4,241,181,187,253,78,118,21,211,178,240,145,44,244,126,203,178,157,55,145,207,118,223,243,195,216,195,40,3,215,167,16,216,178,17,180,82,152,12,12,128,176,59,105,255,115,234,75,89,44,249,169,247,100,49,60,190,255,31,42,63,254,123,229,239,114,170,24,54,31,192,255,64,209,202,39,147,84,89,10,228,249,214,134,129,179,133,214,127,126,187,0,75,253,37,201,206,99,2,189,220,179,237,56,170,19,101,143,95,252,102,136,117,113,13,77,90,139,254,181,67,77,185,63,168,253,49,177,139,207,31,46,244,241,128,197,77,211,9,90,38,104,74,143,9,61,217,169,186,232,17,208,48,204,220,40,200,51,168,139,177,186,169,117,236,120,242,100,211,131,209,135,190,254,20,221,53,226,64,24,111,80,219,200,8,70,196,158,229,155,9,61,224,244,29,161,178,42,97,18,107,206,43,224,130,134,151,64,12,19,170,148,52,212,56,4,93,98,15,183,72,184,63,83,139,170,57,74,123,106,229,35,60,46,199,186,77,99,239,253,178,164,50,22,76,5,4,164,147,60,71,222,156,183,187,114,185,200,101,75,40,188,133,157,79,225,208,231,222,214,18,75,205,253,60,5,17,177,21,193,37,215,180,118,140,168,149,8,137,217,104,118,216,157,7,116,170,202,213,16,110,123,84,162,15,24,95,179,152,1,52,84,112,196,172,230,8,27,58,181,157,133,112,252,137,72,234,115,2,58,127,61,93,123,1,143,191,65,68,57,20,211,98,251,187,108,73,227,234,220,224,176,17,109,150,123,139,5,71,48,6,201,170,31,97,80,18,22,51,240,121,3,217,158,210,254,29,201,86,207,17,107,175,128,176,5,5,115,118,126,173,154,162,195,20,128,60,70,229,201,186,54,251,36,68,118,196,51,174,51,67,67,153,12,107,60,128,165,138,189,17,3,209,87,181,111,189,139,248,36,235,59,204,191,210,48,154,134,255,131,169,135,222,7,78,37,145,207,110,16,140,179,22,18,73,41,214,111,73,31,75,39,252,39,22,14,243,136,112,72,219,106,116,200,86,127,80,92,111,216,42,109,138,214,72,189,115,255,107,53,122,24,63,210,236,18,117,87,240,140,245,16,213,117,15,194,243,110,133,37,34,229,12,120,23,199,33,78,186,18,36,230,40,4,9,220,204,143,31,118,170,107,142,20,150,210,82,8,196,125,65,49,112,83,15,50,112,20,152,199,46,236,78,211,195,19,188,206,149,161,70,179,118,139,136,123,160,242,51,22,235,244,199,19,130,223,42,63,222,230,216,162,85,25,86,142,88,120,29,142,148,130,45,98,102,53,233,167,235,51,44,135,123,21,153,82,102,102,124,136,223,230,23,228,25,166,158,136,194,55,91,156,164,109,169,186,48,98,4,247,247,28,97,138,130,183,178,240,62,113,107,77,101,156,106,183,163,14,16,147,56,252,93,73,72,208,21,55,120,213,202,148,86,162,68,253,110,196,32,83,168,40,244,137,183,41,56,156,35,190,79,27,82,193,25,150,79,247,175,38,93,109,158,49,82,35,184,114,139,48,81,23,208,124,145,201,90,225,26,169,61,53,181,211,165,203,133,103,77,35,221,202,176,45,60,142,120,106,250,10,28,102,92,18,240,226,34,32,34,78,204,26,118,146,209,36,3,162,28,236,165,211,16,120,204,241,200,158,107,242,44,7,79,38,138,5,78,4,153,61,152,114,29,25,214,223,244,6,125,230,72,211,240,155,0,38,71,215,87,247,131,89,23,254,58,134,4,110,73,166,31,223,108,83,23,177,32,128,128,33,51,143,180,222,173,184,47,115,199,155,92,24,75,238,253,218,47,209,242,133,241,122,21,65,186,105,31,120,48,120,164,176,125,47,32,231,34,56,156,111,76,132,219,234,196,149,25,213,190,95,126,0,147,246,172,134,141,45,208,160,151,133,140,45,68,207,41,248,175,133,146,233,136,56,1,3,22,71,178,103,255,63,172,156,183,43,60,223,16,169,230,166,191,109,1,189,154,162,122},
  {169,2,197,229,79,32,156,105,193,137,230,213,115,71,243,14,62,57,206,169,110,191,93,17,195,73,128,88,216,18,104,62,220,65,246,23,221,243,157,204,126,170,178,12,94,245,159,220,135,136,26,160,113,0,25,43,149,223,160,43,251,109,90,71,64,150,106,48,102,111,149,248,80,75,129,69,249,219,24,84,84,77,73,35,240,100,127,185,202,123,78,188,212,48,158,149,89,54,26,73,227,2,252,45,62,255,162,169,232,87,90,176,134,58,184,63,58,166,24,69,54,17,129,241,58,72,121,202,62,109,53,103,85,187,73,200,236,58,26,177,216,9,198,138,253,211,249,67,192,30,168,150,74,181,202,87,56,216,118,69,80,85,52,32,113,241,194,214,149,148,83,124,248,131,63,64,25,54,60,229,234,110,133,175,99,143,253,64,83,65,244,168,110,161,78,72,146,152,190,30,0,172,51,247,131,159,226,68,77,183,219,29,232,136,125,30,107,53,106,33,199,224,54,143,201,31,234,52,199,22,235,185,234,68,249,36,254,38,212,228,38,26,32,203,138,222,16,132,14,8,171,200,127,98,215,253,57,65,249,81,172,53,208,74,18,240,207,155,178,87,79,79,214,30,184,61,79,217,177,123,104,72,18,163,15,183,129,14,0,70,60,66,228,140,95,14,120,160,30,88,122,227,168,14,214,239,21,21,34,28,233,41,254,137,140,190,245,48,13,99,193,85,115,254,0,110,252,4,10,73,191,87,165,199,228,117,220,217,137,120,12,222,102,232,201,45,47,12,100,85,162,94,220,79,106,234,24,164,192,15,189,185,91,223,238,117,235,253,9,172,24,230,0,249,79,145,40,126,235,180,67,171,147,217,194,196,145,235,196,138,237,34,178,196,121,123,59,106,130,62,208,5,192,190,107,43,5,244,227,133,17,225,127,203,140,170,168,134,108,85,114,187,58,45,236,59,18,24,126,173,160,18,210,114,147,197,34,145,90,126,195,24,219,63,220,79,15,185,82,205,217,213,101,52,60,251,178,228,49,202,14,152,116,250,245,43,120,11,36,10,239,16,218,65,34,187,221,76,220,228,3,11,173,158,87,87,200,232,32,85,121,223,210,171,7,188,88,65,50,234,173,94,78,131,191,84,47,179,255,223,63,191,100,248,192,23,201,195,142,23,62,230,76,171,240,22,73,167,154,220,162,87,249,243,40,124,132,72,217,251,240,57,63,148,180,240,6,108,109,89,175,81,198,20,116,110,229,123,36,160,111,219,106,125,197,47,183,101,175,107,96,49,85,243,116,205,119,17,244,3,157,232,145,70,69,194,5,95,239,85,4,185,79,111,54,231,8,117,174,52,0,116,15,248,216,54,137,166,20,137,179,154,202,218,248,195,232,149,48,47,199,181,193,26,34,124,152,94,58,189,93,217,27,125,120,84,167,248,115,169,16,242,43,226,159,96,221,70,166,227,4,229,215,239,192,122,112,247,193,136,12,222,242,192,189,17,58,201,111,113,197,200,175,73,190,250,10,149,28,224,249,224,204,120,52,107,9,246,165,182,105,147,213,208,68,83,96,34,204,71,9,234,97,203,246,46,78,201,189,91,140,167,202,133,30,10,211,185,38,66,126,62,180,244,41,45,6,210,191,206,166,28,145,42,53,122,218,20,76,81,174,108,192,100,12,80,135,146,201,81,0,119,98,103,113,117,203,96,168,148,179,164,6,107,98,247,171,125,47,13,152,196,35,199,175,193,68,118,47,38,7,48,187,206,136,146,47,7,255,211,18,80,152,253,126,220,184,170,183,46,131,20,48,85,88,246,184,248,203,230,53,40,190,92,77,230,162,106,251,17,46,228,169,241,87,183,236,79,132,223,152,174,88,147,219,109,213,31,108,211,199,107,245,221,135,210,98,102,129,136,56,102,62,239,147,19,114,194,70,207,34,31,18,9,214,85,235,70,113,217,175,109,42,225,80,134,88,185,193,156,199,35,174,246,89,173,18,179,116,1,180,217,252,56,205,205,88,182,27,26,243,215,214,104,164,122,214,241,36,164,174,47,176,28,168,199,151,23,95,128,164,34,206,45,70,20,119,231,85,88,59,187,112,170,186,61,189,161,250,241,223,42,53,121,127,153,48,111,128,147,8,18,245,143,220,181,105,185,104,233,91,111,188,124,143,72,132,47,7,50,171,166,143,239,175,199,152,146,17,157,200,114,100,90,79,11,182,163,209,53,27,49,156,138,59,31,40,109,87,65,120,203,254,35,13,237,13,141,118,138,66,148,240,25,247,83,250,160,41,185,255,185,94,93,82,172,98,218,14,109,121,71,245,76,19,137,86,11,162,19,131,122,51,167,11,248,149,58,51,47,224,38,147,107,135,176,114,74,98,38,109,99,248,11,220,158,188,155,233,163,230,35,236,207,83,68,36,114,240,203,20,129,25,33,52,112,182,246,92,176,129,114,67,96,42,62,193,52,212,44,191,74,51,203,62,155,128,164,163,12,235,116,113,72,186,19,139,19,44,187,95,91,161,0,70,190,187,131,58,182,51,167,57,22,246,23,75,220,50,210,115,246,105,74,158,219,88,186,29,144,128,176},
  {233,175,119,41,202,231,176,10,239,216,85,183,211,9,106,198,73,68,88,202,254,18,243,111,58,124,111,184,212,75,193,150,222,244,71,121,121,80,12,128,157,87,176,189,147,153,54,91,173,15,173,54,102,64,125,108,180,161,129,77,197,235,149,32,225,18,214,168,159,117,242,8,150,126,255,185,115,69,42,135,117,252,60,198,255,222,72,233,134,197,122,136,3,43,125,70,163,224,99,41,6,15,124,210,126,142,132,177,34,195,251,44,248,205,75,74,98,164,153,104,21,44,87,238,242,59,211,79,49,3,197,28,195,56,21,41,74,43,62,218,19,37,196,62,212,139,212,102,11,163,81,151,72,38,238,54,67,159,138,128,168,239,169,136,162,222,54,165,212,94,47,73,84,211,82,234,171,247,28,120,112,119,82,53,19,171,68,17,40,176,221,229,136,186,228,231,130,93,13,55,30,66,208,183,37,226,196,146,199,80,57,196,48,69,102,108,128,237,49,70,233,147,74,158,124,255,13,165,108,143,142,98,104,205,240,186,196,169,227,57,232,33,190,19,164,162,17,113,116,229,245,117,109,196,60,152,235,234,72,151,93,139,184,5,83,87,93,251,198,246,83,2,44,164,96,185,161,94,198,181,81,205,208,255,51,36,17,207,29,54,83,199,86,158,23,252,90,96,19,244,89,68,108,227,39,40,138,234,96,16,140,22,15,147,75,219,247,6,62,72,102,0,158,176,203,187,220,37,177,107,95,124,218,45,107,124,207,144,83,118,153,8,7,24,212,106,74,166,94,148,184,45,241,230,78,116,175,7,125,123,208,67,166,42,63,243,1,12,251,63,156,80,47,78,211,161,35,179,45,193,7,230,253,12,34,251,80,24,215,239,4,59,62,236,96,178,138,43,207,131,25,31,88,17,63,61,41,7,202,205,209,18,71,202,251,28,133,178,237,141,197,145,223,40,93,17,12,120,118,108,36,135,224,44,68,1,92,163,66,199,50,186,25,51,126,236,4,38,123,74,148,150,61,44,156,163,18,254,6,163,224,199,3,77,225,50,121,134,236,62,76,119,61,31,59,73,29,27,35,87,58,8,102,45,74,86,161,74,66,192,111,18,28,4,6,27,160,158,204,67,183,10,243,246,156,28,112,214,175,45,218,89,224,117,80,172,76,33,49,48,37,67,9,159,66,142,19,146,106,95,133,180,254,153,172,88,37,148,226,186,120,51,19,227,109,129,3,217,180,106,150,139,162,183,18,132,209,177,122,162,87,133,230,121,230,146,200,226,161,138,70,93,20,42,174,212,18,59,142,118,15,172,99,82,227,254,81,156,185,97,149,13,26,23,36,232,249,178,29,135,126,77,126,177,31,62,75,128,157,179,79,202,130,94,103,39,9,73,18,175,156,95,130,31,20,104,95,184,202,64,173,174,164,68,57,124,87,86,109,170,32,171,249,220,92,199,215,231,240,13,218,28,192,7,11,237,158,201,33,38,180,50,9,107,184,214,61,82,108,110,190,238,132,58,188,30,60,106,246,41,159,27,166,204,182,165,112,217,54,240,118,166,145,47,110,62,9,103,134,64,41,120,110,3,205,144,172,233,230,0,20,177,124,223,230,159,255,75,42,220,188,247,232,133,220,159,167,72,111,41,173,233,206,158,181,121,176,69,35,178,94,83,84,173,103,246,174,56,87,157,165,172,127,102,10,202,195,168,55,69,28,103,106,29,125,183,136,55,186,138,221,192,22,15,125,109,106,18,124,150,130,25,123,80,196,73,226,175,226,153,105,177,166,136,245,119,198,120,85,23,49,47,120,197,74,126,198,179,67,150,187,21,228,15,172,25,57,229,254,8,123,213,35,139,250,62,189,174,230,44,180,106,100,26,106,100,92,84,24,164,71,142,17,103,155,88,23,219,165,180,135,163,155,151,86,33,157,192,182,128,26,158,65,119,154,115,223,133,102,42,84,170,91,106,157,143,125,159,49,139,211,233,120,108,48,167,254,174,253,116,35,54,104,177,222,87,101,3,177,117,15,160,71,108,239,185,40,146,181,162,99,92,50,149,55,49,73,176,171,147,4,71,237,174,218,70,112,65,65,21,183,64,244,236,9,237,185,95,125,101,65,19,117,185,31,255,196,126,89,159,58,32,18,115,249,90,148,96,11,39,159,103,162,217,205,39,232,103,245,29,46,68,37,90,75,43,30,106,246,85,3,208,235,112,29,54,182,136,9,158,99,73,112,199,72,64,85,47,160,172,115,162,6,106,126,255,114,244,66,33,208,97,246,156,211,87,138,34,29,169,150,2,50,169,204,82,222,74,36,220,113,141,61,213,212,188,118,213,124,218,219,216,18,117,205,77,66,78,253,85,76,116,120,248,201,53,158,225,3,108,221,178,205,165,75,230,187,20,11,254,203,186,55,50,217,159,47,10,150,81,26,80,228,204,123,153,115,141,124,76,137,115,171,167,98,75,123,92,34,18,122,46,43,183,157,105,68,203,138,249,26,108,32,76,253,88,171,141,181,80,207,74,109,155,46,30,149,228,93,164,237,249,190,145,6,30,6,22,22,6,82,36,0,20,156,103,57,9,112,30,23,94},
} ;

static const int16_t precomputed_encode_857x1723round_x[precomputed_encode_857x1723round_NUM][crypto_encode_ITEMS] = {
  {7056,9160,17754,23893,18143,-2294,-5411,-20452,-10776,20036,7957,16726,25073,-15151,-26703,-27806,32173,16477,-27133,-4479,-10986,-4640,27090,-13814,17886,26053,24296,9747,-18961,-6099,-31045,-32065,-1404,6957,-24010,-25793,19349,-4819,-13614,-808,-26731,-3045,-6559,-24133,5309,-2392,31502,28530,29414,-449,1166,-10564,-16845,6758,-8879,10558,10240,-18616,12258,-8861,-25896,-8751,10104,21439,20856,9562,-24690,-7428,20444,32054,-6129,-25453,-22460,-19467,-14712,16548,-1915,659,25707,-488,-10212,-858,19262,-9516,-30136,29849,21566,13523,26580,-28775,-7137,31060,-21709,-20493,-19104,1437,-5165,5318,-12867,-26013,-10149,-30438,-21585,807,2807,-29170,-2473,-6607,31571,-30214,26144,-3073,-20086,446,-783,-22663,12858,30740,25026,8297,11225,-17620,32404,-7861,-13923,-15561,18921,-17389,9125,15152,24863,26569,-5326,-12563,-9731,-27520,22628,16310,-28707,-10615,16837,13707,7094,-6519,-30466,-7336,22814,-7303,19506,-6048,14389,6504,14807,31043,1304,27367,24747,-5378,-20391,-16202,-6977,6146,31115,-19939,-26137,25406,-25278,-13867,1016,5473,6561,2789,11342,-31176,1759,-18579,17057,2181,-6104,-22282,-856,11650,-27105,3959,6102,-11679,25608,-8099,-29541,29654,-30679,-9783,19387,-6982,-12927,-20773,20764,-20637,31289,-27707,5450,-5245,6583,-23135,18626,-18745,-17680,-1006,-25561,-24591,24333,-14290,-11796,-14947,2837,26813,20299,-18025,-15136,25971,17662,4235,31052,29939,31933,29963,4310,-29320,-5219,-18401,-21484,7553,11389,5577,-12037,-13064,-3487,-26879,11787,19170,-22129,-1165,4122,-11221,10326,-28227,21138,24232,27476,-15833,20785,-14477,-9735,-12333,-29773,-27593,-22684,-32698,18266,-11567,-17033,-24717,-7302,-10051,-17876,-6246,20933,11583,-12518,23016,5210,-15855,-29394,20189,32606,-9660,9726,11330,2868,9462,11153,10520,12789,26797,-29235,-4436,32248,-17777,2463,11569,-2571,-8532,-7506,-24506,-20211,18345,-27770,-14500,31601,31263,31180,27790,21504,3562,-17068,20761,-18566,-29978,-10142,4263,7786,28668,-31377,30976,1975,-312,30346,352,11343,-17338,-9331,-27672,29010,23067,24818,1917,4854,20369,21231,-28191,18328,-15891,-19484,-20009,-27194,-15073,9997,8962,15418,8411,17103,15485,-3022,-10086,-22072,27708,8590,7390,-15133,-30581,31437,20620,-14070,7186,10100,-21228,-22343,21867,-29615,-4305,-27123,-5341,30573,-10050,-21467,-16181,-1703,-9370,20181,-3703,-11979,18286,-4824,-30720,-23863,30227,11846,-18221,-5123,3216,21803,-16101,-31719,27975,-4451,-13173,27854,-30392,-6142,-23407,-7118,3478,-19531,-27526,-15583,149,-20630,29686,30405,-26441,5350,4354,-5814,21930,-25218,9562,-4847,2117,-16895,21700,14852,-16948,-16355,-20540,-22915,-18679,2842,19792,-31039,-31587,18976,17652,8277,29400,18043,-846,5718,-9375,-26180,15430,22849,1623,20789,-2045,-24181,-32577,-10082,-12944,-7007,-27883,21395,-19680,26637,17822,-14394,-30877,-6124,-17508,-26134,11762,4801,29819,24969,1475,10556,-9264,3147,-3721,11596,-25763,6208,27472,1807,17554,14066,-4222,-14611,25412,2401,-3665,21202,-21554,-22164,-11221,-2023,5259,-24933,-8839,-32477,14081,7545,-23808,-19671,-24108,-1409,20605,-16331,6627,32304,23939,24133,-9248,31987,16023,-3626,25214,25154,-1400,-18932,4533,16657,-5504,-9628,26118,3952,-27395,-19636,257,-10088,-29956,1159,-2093,-24287,-22764,23647,-16038,-13647,31868,29313,14458,-17674,6799,15920,-10625,29110,-10526,4723,7860,166,-8860,-5301,-17216,31676,14179,-20458,-6801,29375,27838,27591,-3727,-27704,1839,7127,-302,18241,32264,14296,27541,8749,31458,-24631,26458,18532,2260,23512,-8060,-12843,24102,31176,-12026,-6032,-18305,-16600,-6110,-13206,20471,7460,7564,-12925,-13607,12941,-20962,-11941,-12051,30038,-20023,-22851,7660,-29360,-24045,-4137,5162,-26679,-31215,4954,20845,25363,-15175,4046,-19770,21391,-25181,-241,-30982,-31113,-7783,28377,-4900,-6339,28725,-5461,-27118,25746,1633,-15123,1987,7248,-20340,6371,-13598,26747,-24244,26624,26993,-6726,24778,-19396,20670,19162,1428,-792,19081,-11704,-13226,-27855,-19764,-7539,-17229,-8477,-3363,-12414,26969,25795,11345,2048,20983,19264,9718,8895,-12407,-31723,16973,-2105,11497,-20573,-4939,3130,-24197,11183,18456,-10416,-28618,-25982,3668,-4969,-27063,-7479,-28273,16787,-29397,-15043,-21798,21767,5025,7956,-2343,-30119,14948,-203,15297,28117,-30566,25722,-22927,-26551,28952,6742,13192,18199,-11329,-5827,12182,-7049,23857,-758,25430,21415,8953,-32228,-10977,17830,10617,-17079,-5324,-16603,26842,-17128,16341,-6717,24860,14593,22613,6385,-32522,-3941,-2310,-3330,6799,25851,25410,23044,16568,31448,-25355,31462,9846,21292,25437,-3731,6929,-21671,-13232,20657,26380,-30584,-22258,-3424,23378,1839,-25626,32301,27259,-4582,1715,-31611,26681,-13446,-10117,10562,18032,-23051,-9174,21944,-3874,17586,-174,4682,14739,21107,7546,23110,-28849,6152,-25118,-6192,-26886,-9978,-16227,-23089,-22391,-7193,-20447,-27907,626,18625,6469,-19318,-27433,3289,-9166,-8576,10177,21779,-27990,32308,22880,24138,628,22619,12007,-404,2090,32653,-29222,25288,12684,-20919,30460,25022,24708,15861,-13261,-18476,12523,-11625,3765,15846,-25977,-5549,31906,15005,-4339,27141,-9202,1936,21614,24388,4409,-24182,1340,27114,-20957,-26505,-7665,-18209,-6227,-2141,-10132,-6045,-3047,26290,-20538,-5076,-12139,-16133,-21913,9528,-10583,-22837,20552,-14912,-19143,10784,-12618,16334,-828,20782,10796,-5404,18674,9920,-13774,-8050,159,6057,19932,29339,-548,13046,15149,11513,7042,-18304,-5989,-12778,7898,12501},
  {-16546,-432,-26183,-3215,2574,-24148,14882,-330,-29030,26376,22193,18241,29290,-14167,10503,-29195,6435,7066,21465,10285,19867,17160,12867,25992,16022,8066,-21817,-16907,8461,-22205,-29364,1542,23779,-6613,32712,12357,-17440,23402,7326,-17238,-11756,16131,16443,20695,15854,22368,-20775,21884,13544,24875,-7338,-18657,37,19849,29921,-21913,-2962,-3115,12309,-1320,18082,8127,-9821,-7311,29112,12659,-15876,31108,-25119,-23462,-798,1353,22283,-15644,-28812,-31771,-27532,-1099,12143,-26641,5963,10173,-13828,9584,-542,28745,-22071,9747,2996,6488,30458,1572,-27364,-15488,9298,21570,26476,18830,31609,-32580,23107,19282,-7182,-28823,-15914,22381,-17970,19951,20186,-28685,19026,-14596,2419,-28584,4367,30021,10568,9947,-11254,-10182,3346,-15556,-30532,-14634,4963,31827,8614,-29694,13598,21028,-962,-31000,2406,30186,13297,28880,-17837,-14381,25013,8901,11565,9013,-8345,4406,-28428,24734,-4525,29851,8244,26874,-18664,22013,23350,14880,4449,6227,-17180,-17045,-26495,-21900,10036,9731,-6371,-9109,-23460,17055,7315,11986,21606,21278,20191,-16868,21884,14141,-22659,-6262,-1981,22426,-28446,6485,21015,20191,30508,-22692,3263,-14256,-12585,-23436,-25165,13129,10265,-30152,3120,15649,9983,-3371,-606,7837,27889,-18149,24151,22124,26158,-6548,-17711,-10681,-18361,13980,-8699,16577,12658,24448,-32694,25680,9651,31013,12875,-26109,23638,-3359,-29502,12537,24817,25216,18434,-660,3915,18771,-13930,-4660,31978,-4442,14447,-6976,2947,29601,-1468,8292,6827,-2118,31124,-30262,-2264,28994,-14225,-13881,31197,15863,-17252,-3988,-17954,-31854,24610,12050,17123,27565,29603,25321,-16244,-7425,-18133,-30057,-24338,-14624,11596,6179,25582,-3488,-22898,8136,-19810,-27138,6183,27144,10175,-7812,-19674,-30290,22372,-22867,38,-7888,1374,-24922,31859,-8542,11071,17094,-308,16774,7311,2525,30768,-12267,20498,-1599,-18616,-10576,-30533,30949,-12916,-3888,7012,5509,18684,12063,-13928,-12705,24027,-14864,13839,-27683,-27742,-20873,-7697,-7085,5504,-9101,-18354,-7102,-11030,-6561,-22066,-6952,417,-271,-12424,-6645,-3184,-27720,-23288,-2587,-14094,20688,-24787,32077,30071,25044,-27070,-4746,32142,26925,-29322,-27433,3191,-18010,23704,15641,-25989,-5607,9296,19768,-16476,12723,5443,-7824,22023,-31785,-4827,-17064,-10091,30302,-32062,15536,9081,29205,1085,353,12162,-16597,-30623,-63,-31477,7533,-29528,-24145,25767,6325,-24405,7282,6515,1496,-9490,-8192,-18043,2945,-31650,1709,-4267,23810,-7575,-28262,-28515,-399,17744,-32415,22162,-11026,-16933,11945,-1691,5831,23410,-30578,16897,4452,-25591,2367,1076,-9076,32727,9337,-4778,-22124,10177,9185,8601,12704,-12150,10721,-17516,1185,29104,30275,30447,13524,29418,28579,-23771,28940,10362,5433,-19165,-17692,-26567,24972,29259,-3776,-13390,23015,24235,27449,-10239,-25305,25297,19244,6797,-21347,6494,12388,4410,6580,-24532,-9763,-21107,32543,-10900,9388,-11880,23957,26357,-18498,-2063,-10367,-12765,-11459,-2524,-12440,18189,11090,6829,20234,-30615,-23124,179,-6668,22741,17757,20072,-13637,-17048,679,23917,-23059,-22149,29974,-27349,-17292,11766,-13861,32118,22259,9211,-5813,26100,-813,11962,-26725,26693,-32495,-7079,9420,-27951,20722,6695,24958,-28036,-10468,13552,-30557,-12626,-30304,27457,21301,-24394,8557,-15788,-14765,20451,-32667,-22082,-25302,-30043,-12448,21322,23744,-18129,21987,4806,9384,-14695,-23453,370,25420,-16433,31303,2559,10528,-14232,4121,21403,-24099,19004,-15584,-6860,-23072,-20981,13322,-4247,-13344,-21841,-6948,-30322,15738,11699,10401,-1413,-4633,30719,-9079,24779,4783,14851,-14654,19593,-6373,105,1258,-27459,-21050,-3589,-6056,16979,-30397,-16979,15468,-1414,18767,26404,-20027,7187,-16212,-17878,19457,-262,17696,-11880,-16046,3724,-14618,-15355,-32202,-19541,-1057,7766,-20598,-14425,5739,17950,-29140,-26567,-14598,-28983,-6921,-15429,15522,2527,1472,28927,12885,-8530,-2258,-28022,21390,10868,-2787,21507,-574,6886,-10032,-1788,-19420,-14514,23492,-15666,1860,-31963,-12414,514,29896,-16146,27997,-29511,11016,-12573,16457,-7521,-30931,23596,-22802,-5605,-12121,-27546,-14695,-17829,673,21374,32177,-6256,11637,12252,-1241,-14546,-13977,-2019,-15514,-31921,-10208,24792,6830,-9366,31439,-20208,-6799,15911,6479,22061,23252,-19476,-1673,8492,-20620,-4509,-8315,-20106,9045,-17334,30889,-16479,-18093,26669,-30913,-6917,30827,27479,-29269,-15279,11807,7547,-4835,-14777,-18692,1061,-775,25457,-31392,-20269,18994,1812,-31304,-16974,-2871,19358,27413,-26327,-21215,23558,28364,-27529,22579,2427,-21245,-18632,-6756,-2555,4942,-15955,931,-23802,9233,23050,-28053,-6886,-2764,-28059,-15352,-15013,-29951,19689,-875,29823,-2370,19015,29592,6289,24652,23635,-23741,25572,4120,-24698,-4540,-23246,-5686,11440,-14866,-14651,5059,-17149,20627,7140,-12290,-3664,11086,-17141,-22771,-20684,-3056,-641,-13631,25804,-7861,18868,30170,22085,10577,1351,-2728,-30394,-30695,-12807,-32278,3370,21472,31461,11336,-18816,-30018,-27504,-9923,-22533,11131,-23093,7015,26424,-22786,10960,-4478,2816,4976,-4348,-10118,30226,-18696,16680,17662,-15059,554,6752,-6773,8053,17203,-4430,13548,-5853,-30813,-27479,-27506,9751,-16802,23647,-17751,23761,-19871,-23457,31960,-11199,-9074,-15540,-27896,-12944,-14098,22805,-15373,10078,-29092,19555,17092,7263,-8745,-32700,-24066,-7262,22787,-12821,-24607,16518,-28639,16962,-14527,26634,654,-8033,-26287,6442,-13183,-4441,25126,-4255,14546,7893,-3830,18908,-24386,-32099,-15825,-31381},
  {310,16776,7136,-22731,-8120,-25694,-2811,-16026,7911,22342,26178,9972,-26961,9752,-21304,22539,21858,-24175,-16785,-16690,-11855,-4626,1421,-14375,32126,15352,30797,-24400,-1911,-11643,4808,4647,-10011,-3657,17670,9368,32332,-23139,24362,-6164,-28853,-5252,-21122,-15430,20907,21502,-15999,-6401,21980,-20735,-1719,27946,10496,19105,4643,25602,23105,-13588,6505,21792,-8447,32302,31148,-24863,-7173,8899,-24561,27480,-21293,-22354,-21054,-19370,31348,28379,-14502,1811,398,31724,-22871,-8721,-21173,-7413,-21451,29613,-5251,-23727,25743,18026,-9799,-13273,1422,27896,15220,-22757,21391,-18986,1368,-30722,15642,-30952,17789,-20242,15055,-13167,13205,16507,31816,28873,3409,-27561,-9093,19897,844,432,23617,-1560,-8973,-25728,-1575,22542,17961,5969,-20522,-23116,-20997,14853,23236,23096,-13268,-7690,-9058,-4671,-6339,-20867,18686,32669,443,-31079,-17514,-29632,25589,5828,-138,-3380,9050,4996,16353,-9093,-2843,7283,25580,23296,-30993,25006,12675,-16162,-10784,19762,-11311,23269,21926,-31316,-22581,-1267,30876,31315,-27291,5190,-20871,-23149,1120,-4691,-24350,-6512,22829,22563,26657,-4497,14839,23228,643,21580,-32600,22226,-25311,27740,-19023,30886,21965,10974,11646,31176,5513,134,12538,-2432,-20583,-12343,-24365,28549,26058,9640,25476,-6688,-19876,25770,3293,4479,-28651,-29822,21112,-19370,884,-17831,4940,19391,19296,-29436,-11927,-20592,26184,21868,5327,14933,-28202,28513,-25660,7038,4506,-8098,-7975,-27389,5271,19946,4088,-14735,17135,18179,-12310,-18827,-5956,-20759,-20455,1805,21586,30105,-20183,-17842,-22247,31964,12173,8659,30157,8333,-16112,18820,15735,11668,27400,-10014,-17420,31307,-17507,13505,28187,23925,-18919,23990,30370,4285,-31108,-8908,1365,-398,24265,-27529,30673,7753,8050,-21922,-26934,-13612,15264,-8005,32637,-8266,268,13724,3158,372,27273,-4532,-11428,7377,-20196,-7374,-22098,1297,29855,-32501,28666,-25679,-24731,-21065,-10530,-14329,16264,31681,20831,-14188,23525,12903,-11734,-24528,-32666,-19659,-10568,-24868,-21410,1200,19887,29869,29701,-6428,3677,-26256,-15820,-8871,3002,-32033,13726,-25126,-15114,-32007,-17031,786,-18377,-13676,-183,17725,-14421,-13039,21466,-19260,30311,-12409,-26856,-20672,-2596,-28503,31770,-3175,17185,-23436,-31687,16268,-9240,-10069,-25919,1239,20743,2504,-1496,27470,9253,-7002,16252,2832,-9341,17164,3410,-13053,-2107,29335,-12816,-21637,-12253,-20040,22502,18767,-3239,-6059,7393,8028,855,-24897,16411,10861,-31317,15561,-27657,-15473,17681,1063,-1846,1852,-10917,3636,-10590,23983,17903,15275,-32007,-28562,16552,14553,-26693,29132,21173,16965,-18218,-23391,14226,-28295,-8246,32096,8955,-32356,-5113,-9970,5225,2072,-22766,-7444,-7973,3009,-15330,-32553,20529,-3602,-11941,-17884,10983,-19451,23463,31971,8013,-1066,-26359,-1842,4436,-4202,31773,-26140,-24301,29342,6026,-7462,10106,-19913,-31577,21680,2302,24391,17668,31965,-21292,2644,28826,31870,-22346,-12322,17599,3097,27760,30878,23151,-23995,-24409,-23056,-15322,2309,4923,-26779,13466,-6870,21474,-14680,-26737,31846,-6559,-15047,-8063,-21355,19284,12510,-4883,22679,2394,18210,5997,-22321,-245,-26711,19803,-13699,102,-9568,22081,-16087,-12099,-1388,-2683,8542,10148,1692,-25832,23865,19264,14228,19010,-1194,13565,10827,25135,12815,30732,-4300,8099,-19436,-12967,26726,18472,-17910,10439,-28914,-16510,24385,14448,-16275,32433,-14091,8396,30835,-16857,-6810,-32296,10553,-18336,-4568,-19156,-15083,-4126,22407,11367,-25928,2480,14720,200,17474,-17599,-20749,19324,-7847,21839,-11269,-26831,30322,-4358,11246,9113,23950,-1771,-13126,29140,-18020,-24161,21548,-31942,29835,-3937,-29496,24553,32450,-24411,21050,22581,21165,-9602,20280,27171,-19809,-19918,6875,-4156,15823,24742,-3152,20206,-25677,2871,958,-16103,-10247,-32318,-13464,20792,-9907,28836,6247,-24775,-15311,-32686,12406,17428,-30460,22660,25894,23370,-19547,-447,14970,-23605,-22913,-10330,16977,-18767,-31795,-26972,-31231,-30420,13239,24693,9515,25370,21417,18427,23668,24096,-9274,-21200,4970,-14697,-6815,30389,27639,-28416,31487,14516,11671,-17847,28501,32406,11826,6881,-2296,-7612,-30886,-14638,1854,29785,15321,19683,-20192,4492,21896,-7007,1184,-8048,16940,-17055,-18466,32331,-15211,22679,-26221,-2516,25716,-7209,16057,29791,6036,-14446,-32388,10189,-7325,30140,-5834,-17452,-22676,26807,-28414,-18332,-325,-1102,17570,-17612,-21048,-7856,15213,-19973,-26157,16714,1964,449,-25186,16803,3334,-7321,20189,20568,-20152,-6792,2254,2587,-12958,15829,693,5046,22445,9879,6681,-10903,16322,26841,24067,-26797,8152,17479,-20758,20861,-23144,549,31047,-29218,30026,-31124,31471,-27940,-32434,-5594,15640,9903,-5205,-12328,-28028,1127,31998,-26310,28984,26329,26737,-25071,-4146,-27451,-25627,16391,24693,-27264,-5262,23466,-19064,-28999,-12497,-16033,-12619,16973,-23258,-16116,4406,-31431,-4053,26667,-26466,-8657,30583,6097,-25449,18060,18953,-10839,-19900,10609,27567,-20447,-8753,-19819,17557,28091,9984,-7988,-12228,-14831,-16468,13986,17304,-8093,548,23470,1659,-8499,-20041,-19681,4085,-12911,-32205,31259,20389,15584,5109,-24305,-11391,11312,-32687,-18013,-21642,-8338,19770,23377,-10396,-24400,-11965,5797,-18520,15466,13347,26613,29016,22441,30949,25304,-13336,4757,27501,7046,17687,17851,-3800,-17117,8302,-1680,-27552,21462,-24126,7924,513,-3722,516,464,-8386,-2195,6835,-32501,255,-2185,4566,-1202,32162,24911,-21862,-22883,23786,-23691,-31183,-5408,-31692,19542},
  {-4207,-26507,7592,-15999,-23254,21217,16441,8250,-17068,-6804,20433,16872,-20023,13124,-4855,-13309,21919,-1987,24251,-32734,-12215,25660,12393,-14584,-11277,15674,-15328,21591,-26565,17877,4356,18334,23931,-10342,20285,15942,5798,4648,-15843,-29124,-11775,-2588,-8176,-5720,-11348,3250,-4480,1706,-30587,1369,25115,-22523,-20546,6186,-21664,-16071,4532,28921,-19180,-12168,5575,20155,-7705,-29191,12659,28582,6182,29924,-16271,-13210,-10395,-30021,-25807,-16783,-9383,17744,-16856,-16976,17171,8958,-23999,-15023,11199,22535,-24426,21834,29786,-19631,-20092,27440,9839,16502,-982,22538,17745,25019,3830,17093,-15043,-29850,4027,8234,-11410,-5391,24743,24954,-20924,-27741,9029,6038,1699,-31139,23427,26679,-28933,-16743,27768,-31634,30319,22537,26620,15328,17997,17302,-7422,-8721,-16272,-29991,12835,27272,-7,-26741,17545,879,-8891,-12827,-18308,-25329,-27429,4037,-5159,-31964,31051,10297,-22960,-16233,-31091,10596,-30321,228,10736,-26460,-10214,8390,8445,17386,-13661,-3108,-30944,28541,-2203,-13967,-1558,4768,-17278,31332,8621,-6591,-4472,-31221,-26997,-15816,-4313,24063,32234,-30085,-3086,-26530,24890,9079,28975,30690,-18318,-12006,544,-4174,12252,29875,-6729,-3000,10191,26606,-11835,7732,-20651,-26207,27574,5182,30070,-45,8377,-5374,-27502,16898,10105,22216,31849,26874,-30336,13511,8820,9173,10603,4313,-27226,-28070,2,2061,-28675,-10106,5843,8860,25476,-26244,12099,-32330,1274,21018,5472,-5495,-29148,-30964,-1278,-32573,1025,31154,20369,27926,15071,-27132,-19001,-22568,4624,-27867,-6493,667,290,9370,-30644,-28945,19677,25272,16625,-10464,28002,-32018,22954,21056,3712,8082,-10246,29635,-28828,15667,28396,23901,-17978,10751,12842,21905,-15099,-2294,-10229,-189,16225,30796,22799,1753,9588,27971,20429,26253,-25035,7559,-25629,24998,-21047,13103,13701,-31605,11881,7214,30683,13286,-9127,-30447,10458,-13446,22201,-12507,12073,12740,7304,7561,-3181,1682,11583,3454,-18556,7262,-18692,25613,-32226,-10165,-23404,-10451,5956,30580,-32323,-13829,-19101,15724,-5817,-11718,2281,23582,22507,-13237,392,-29089,1735,26320,-7923,-13065,-10240,-18702,12938,11222,-24846,-26508,11395,-18041,16160,9479,-19259,-14685,4843,11217,31494,-10536,-10381,9286,31040,19016,-27682,24710,14627,27660,19337,20789,-6214,-8457,-10859,-1301,26277,15327,17780,31831,12221,24279,8006,4386,5188,18465,-14149,-24450,-16433,-31639,20464,23284,-26368,-29385,-22547,12050,16113,-10367,-8113,-27453,-27020,4628,22902,13766,-12700,-26916,2391,-30760,3352,-7226,24597,25642,5118,-14872,-16781,18116,4811,10559,-18640,-30976,19113,-24208,-28227,16934,16216,19851,1587,12141,10337,-25663,-16306,21851,-32516,19596,12945,-30824,6889,10765,-16030,2956,-11358,-6983,-6947,25280,19228,15233,13591,-24805,30867,-5113,12246,3529,-2150,-8230,-3625,8731,-10625,-21207,8925,3386,11787,-26941,-7998,2951,18894,9334,31802,23779,8360,-9163,15115,32434,-28851,-16062,23453,-23915,-23637,8145,-1830,-14101,10688,10064,9474,-13480,16733,-2715,24522,-2947,-16991,-10222,27095,19267,-10823,29192,21819,4722,30541,-360,-25061,1383,16801,-29625,24302,14962,13269,22223,4778,12,9470,-934,-608,-21304,-3015,-18534,4097,9051,-12990,-23735,30260,13403,9951,-28345,18853,-23984,-21143,21877,-17288,5100,-26218,28679,-15341,-20620,-12061,-24076,6820,7853,-31924,17716,-5753,28308,-28403,-29709,10719,5285,-8168,22279,27584,22284,24533,-4306,-16568,-11607,16710,7395,26786,16628,-28120,-25672,8492,-28317,-8430,8530,21436,-25485,-837,5772,-17228,-8884,-15001,-2779,6102,2655,5842,16091,-18780,2208,-8952,22209,-16787,7723,-21875,24146,-28601,29069,-24190,12772,8292,22688,3737,5498,11705,-20272,23088,453,2700,-4127,1238,17127,14923,-29650,-22996,14494,5075,-19722,18362,28869,-8078,-12123,-12148,-15539,-21230,-23378,-24236,2849,20753,6408,5609,-13821,-1390,-8840,19222,1858,29846,4748,-29540,18645,-26130,235,16068,-4402,21472,-26488,-16419,5483,-29927,27738,-13821,8420,-29631,9570,13820,22247,-31733,2848,-20541,29634,10186,19040,14721,29462,-23027,27166,25368,20008,5418,29879,4195,6012,23983,-3288,31286,-10266,-29249,-24027,-27168,4949,15293,7678,-2663,-27316,-19116,29426,10961,8518,-28619,2873,18026,28724,-26157,-12969,2066,-20160,1212,-21954,8707,-15449,-28919,-25356,-4989,8,-9327,10218,-4398,-11805,17551,-18911,-13834,-31867,-13676,31575,-31310,-13908,1413,-7249,-16923,22499,-27811,-20655,1767,-22399,31961,-15475,-14600,3595,-29716,-32253,2248,28408,-739,-10478,32506,-15629,15107,32259,10644,19951,27321,32463,-7129,3204,-5754,-16742,9041,29710,-2072,3353,-12875,-18460,32370,-22419,-5554,-32397,-8313,12765,-28841,-975,-2157,-19525,-14525,24484,-6692,-15475,29442,-32046,-2839,-14407,11886,-24188,-29539,-22789,-14174,14098,-25051,15037,18448,11150,28986,-26967,-19658,-11438,18381,3709,24115,16666,4317,-22971,-10716,3791,-19663,-30836,-2340,-1135,-9014,15105,-31131,24045,-24802,26687,-22849,-5037,23201,-6709,-6005,11372,15845,-31059,-25707,-14311,8680,-24099,3408,10501,3028,-26193,-4466,16045,-23318,-20026,16462,7042,17305,-2715,22723,14765,9406,5748,-28880,16885,-3896,8330,-31446,-16763,14975,-25550,18451,-5812,-20905,-3910,219,-13458,2916,-12305,-17899,4646,-18701,-5484,-1679,-32521,26313,-29587,-31139,-24211,9446,5260,1204,28265,-1605,-7819,-13332,1129,930,27859,26667,-27479,-22563,15006,-26113,-4005,27363,17258,-21476,8623,-27918,-23121,27097,-28087,-5488,-28770,-15911},
} ;

static void test_encode_857x1723round_impl(long long impl)
{
  unsigned char *s = test_encode_857x1723round_s;
  unsigned char *x = test_encode_857x1723round_x;
  unsigned char *s2 = test_encode_857x1723round_s2;
  unsigned char *x2 = test_encode_857x1723round_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_857x1723round_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_857x1723round(impl);
    printf("encode_857x1723round %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_857x1723round_implementation(impl),ntruprime_dispatch_encode_857x1723round_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_857x1723round;
    printf("encode_857x1723round selected implementation %s compiler %s\n",ntruprime_encode_857x1723round_implementation(),ntruprime_encode_857x1723round_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_857x1723round_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_857x1723round_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_857x1723round_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_857x1723round_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_857x1723round_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_857x1723round_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_857x1723round(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"857x1723round")) return;
  storage_encode_857x1723round_s = callocplus(crypto_encode_STRBYTES);
  test_encode_857x1723round_s = aligned(storage_encode_857x1723round_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_857x1723round_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_857x1723round_x = aligned(storage_encode_857x1723round_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_857x1723round_s2 = callocplus(maxalloc);
  test_encode_857x1723round_s2 = aligned(storage_encode_857x1723round_s2,crypto_encode_STRBYTES);
  storage_encode_857x1723round_x2 = callocplus(maxalloc);
  test_encode_857x1723round_x2 = aligned(storage_encode_857x1723round_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_857x1723round offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_857x1723round();++impl)
      forked(test_encode_857x1723round_impl,impl);
    ++test_encode_857x1723round_s;
    ++test_encode_857x1723round_x;
    ++test_encode_857x1723round_s2;
    ++test_encode_857x1723round_x2;
  }
  free(storage_encode_857x1723round_x2);
  free(storage_encode_857x1723round_s2);
  free(storage_encode_857x1723round_x);
  free(storage_encode_857x1723round_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

