# SPDX-License-Identifier: MIT

from enum import IntEnum
from m1n1.utils import *


class R_USB2PHY_USBCTL(Register32):
    MODE_HOST = 1
    MODE_ISOLATION = 2


class R_USB2PHY_CTL(Register32):
    RESET = 0
    PORT_RESET = 1
    APB_RESETN = 2
    SIDDQ = 3


class R_USB2PHY_SIG(Register32):
    VBUSDET_FORCE_VAL = 0
    VBUSDET_FORCE_EN = 1
    VBUSVLDEXT_FORCE_VAL = 2
    VBUSVLDEXT_FORCE_EN = 3
    MODE_HOST = 19, 12


class R_USB2PHY_MISCTUNE(Register32):
    APBCLK_GATE_OFF = 29
    REFCLK_GATE_OFF = 30


class Usb2PhyRegs(RegMap):
    USB2PHY_USBCTL = 0x00, R_USB2PHY_USBCTL
    USB2PHY_CTL = 0x04, R_USB2PHY_CTL
    USB2PHY_SIG = 0x08, R_USB2PHY_SIG
    USB2PHY_MISCTUNE = 0x1C, R_USB2PHY_MISCTUNE


class R_AUSPLL_DCO_EFUSE_SPARE(Register32):
    RODCO_ENCAP_EFUSE = 10, 9
    RODCO_BIAS_ADJUST_EFUSE = 14, 12


class R_AUSPLL_FRACN_CAN(Register32):
    DLL_START_CAPCODE = 18, 17


class R_AUSPLL_FSM_CTRL(Register32):
    APBREQ_OVSEL = 21, 13


class R_AUSPLL_CMD_OVERRIDE(Register32):
    APB_OVERRIDE = 28


class R_AUSPLL_CLKOUT_DTC_VREG(Register32):
    DTC_VREG_ADJUST = 16, 14


class R_AUS_COMMON_SHIM_BLK_VREG(Register32):
    VREG_TRIM = 6, 2


class R_CIO3PLL_CLK_CTRL(Register32):
    PCLK_EN = 1
    REFCLK_EN = 5


class R_CIO3PLL_DCO_NCTRL(Register32):
    DCO_COARSEBIN_EFUSE0 = 6, 0
    DCO_COARSEBIN_EFUSE1 = 23, 17


class R_CIO3PLL_FRACN_CAN(Register32):
    DLL_CAL_START_CAPCODE = 18, 17


class R_CIO3PLL_DTC_VREG(Register32):
    DTC_VREG_ADJUST = 16, 14


class E_ACIOPHY_CROSSBAR_PROTOCOL(IntEnum):
    USB4 = 0
    USB3 = 5
    USB3_DP = 8
    DP = 10


class R_ACIOPHY_CROSSBAR(Register32):
    PROTOCOL_SWAPPED = 0
    PROTOCOL = 4, 1, E_ACIOPHY_CROSSBAR_PROTOCOL
    DPMODE = 17, 5


class E_ACIOPHY_LANE_MODE(IntEnum):
    USB4 = 0
    USB3 = 1
    DP = 2
    OFF = 3


class R_ACIOPHY_LANE_MODE(Register32):
    RX0 = 2, 0, E_ACIOPHY_LANE_MODE
    TX0 = 5, 3, E_ACIOPHY_LANE_MODE
    RX1 = 8, 6, E_ACIOPHY_LANE_MODE
    TX1 = 11, 9, E_ACIOPHY_LANE_MODE


class R_ATCPHY_POWER(Register32):
    SLEEP_SMALL = 0
    SLEEP_BIG = 1
    CLAMP_EN = 2
    APB_RESET_N = 3
    PHY_RESET_N = 4


class R_ATCPHY_MISC(Register32):
    RESET_N = 0
    LANE_SWAP = 2


class R_AUSPMA_TX_SHM_TXA_CFG_MAIN_REG0(Register32):
    PMA_TXA_BYTECLK_RESET_SYNC_EN_OV = 2
    PMA_TXA_BYTECLK_RESET_SYNC_EN = 3
    PMA_TXA_BYTECLK_RESET_SYNC_CLR_OV = 4
    PMA_TXA_BYTECLK_RESET_SYNC_CLR = 5
    PMA_TXA_BYTECLK_RESET_SYNC_SEL_OV = 6


class R_AUSPMA_TX_SHM_TXA_CFG_MAIN_REG1(Register32):
    PMA_TXA_DIV2_EN_OV = 8
    PMA_TXA_DIV2_EN = 9
    PMA_TXA_DIV2_RESET_OV = 10
    PMA_TXA_DIV2_RESET = 11
    PMA_TXA_CLK_EN_OV = 22
    PMA_TXA_CLK_EN = 23


class R_AUSPMA_TX_SHM_TXA_IMP_REG0(Register32):
    PMA_TXA_CAL_CTRL_OV = 0
    PMA_TXA_CAL_CTRL = 18, 1
    PMA_TXA_CAL_CTRL_BASE_OV = 19
    PMA_TXA_CAL_CTRL_BASE = 23, 20
    PMA_TXA_HIZ_OV = 29
    PMA_TXA_HIZ = 30


class R_AUSPMA_TX_SHM_TXA_IMP_REG2(Register32):
    PMA_TXA_MARGIN_OV = 0
    PMA_TXA_MARGIN = 18, 1
    PMA_TXA_MARGIN_2R_OV = 19
    PMA_TXA_MARGIN_2R = 20


class R_AUSPMA_TX_SHM_TXA_IMP_REG3(Register32):
    PMA_TXA_MARGIN_POST_OV = 0
    PMA_TXA_MARGIN_POST = 10, 1
    PMA_TXA_MARGIN_POST_2R_OV = 11
    PMA_TXA_MARGIN_POST_2R = 12
    PMA_TXA_MARGIN_POST_4R_OV = 13
    PMA_TXA_MARGIN_POST_4R = 14
    PMA_TXA_MARGIN_PRE_OV = 15
    PMA_TXA_MARGIN_PRE = 21, 16
    PMA_TXA_MARGIN_PRE_2R_OV = 22
    PMA_TXA_MARGIN_PRE_2R = 23
    PMA_TXA_MARGIN_PRE_4R_OV = 24
    PMA_TXA_MARGIN_PRE_4R = 25


class R_AUSPMA_TX_SHM_TXA_LDOCLK(Register32):
    PMA_TXA_LDOCLK_BYPASS_SML_OV = 8
    PMA_TXA_LDOCLK_BYPASS_SML = 9
    PMA_TXA_LDOCLK_BYPASS_BIG_OV = 10
    PMA_TXA_LDOCLK_BYPASS_BIG = 11
    PMA_TXA_LDOCLK_EN_SML_OV = 12
    PMA_TXA_LDOCLK_EN_SML = 13
    PMA_TXA_LDOCLK_EN_BIG_OV = 14
    PMA_TXA_LDOCLK_EN_BIG = 15


class R_AUSPMA_RX_SHM_TJ_RXA_CTLE_CTRL0(Register32):
    PMA_RXA_TX_CLK_EN = 20
    PMA_RXA_TX_CLK_EN_OV = 21


class R_AUSPMA_RX_SHM_TJ_RXA_AFE_CTRL1(Register32):
    CLK_LANE_RX_DIV20_SYNC_RESET_N_OV = 29
    CLK_LANE_RX_DIV20_SYNC_RESET_N_VAL = 30


class R_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL10(Register32):
    PMA_RXA_DTVREG_ADJUST = 31, 27


class R_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL11(Register32):
    PMA_RXA_DTVREG_BIG_EN = 23
    PMA_RXA_DTVREG_BIG_EN_OV = 24
    PMA_RXA_DTVREG_SML_EN = 25
    PMA_RXA_DTVREG_SML_EN_OV = 26


class R_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL12(Register32):
    PMA_RXA_TX_BYTECLK_RESET_SYNC_CLR = 22
    PMA_RXA_TX_BYTECLK_RESET_SYNC_CLR_OV = 23
    PMA_RXA_TX_BYTECLK_RESET_SYNC_EN = 24
    PMA_RXA_TX_BYTECLK_RESET_SYNC_EN_OV = 25
    PMA_RXA_TX_HRCLK_SEL = 28
    PMA_RXA_TX_HRCLK_SEL_OV = 29
    PMA_RXA_TX_PBIAS_EN = 30
    PMA_RXA_TX_PBIAS_EN_OV = 31


class R_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL13(Register32):
    PMA_RXA_TX_PRE_EN = 0
    PMA_RXA_TX_PRE_EN_OV = 1
    PMA_RXA_TX_PST1_EN = 2
    PMA_RXA_TX_PST1_EN_OV = 3
    PMA_RXA_DTVREG_ADJUST_OV = 15


class R_AUSPMA_RX_SHM_TJ_RXA_SAVOS_CTRL16(Register32):
    PMA_RXA_RXTERM_EN = 21
    PMA_RXA_RXTERM_EN_OV = 22
    PMA_RXA_RXTERM_PULLUP_LEAK_EN = 23
    PMA_RXA_RXTERM_PULLUP_LEAK_EN_OV = 24
    PMA_RXA_TX_CAL_CODE = 29, 25
    PMA_RXA_TX_CAL_CODE_OV = 30


class R_AUSPMA_RX_SHM_TJ_RXA_TX_CTRL17(Register32):
    PMA_RXA_TX_MARGIN = 19, 15
    PMA_RXA_TX_MARGIN_OV = 20
    PMA_RXA_TX_MARGIN_LSB = 21
    PMA_RXA_TX_MARGIN_LSB_OV = 22
    PMA_RXA_TX_MARGIN_P1 = 26, 23
    PMA_RXA_TX_MARGIN_P1_OV = 27
    PMA_RXA_TX_MARGIN_P1_LSB = 29, 28
    PMA_RXA_TX_MARGIN_P1_LSB_OV = 30


class R_AUSPMA_RX_SHM_TJ_RXA_TX_CTRL18(Register32):
    PMA_RXA_TX_P1_CODE = 3, 0
    PMA_RXA_TX_P1_CODE_OV = 4
    PMA_RXA_TX_P1_LSB_CODE = 6, 5
    PMA_RXA_TX_P1_LSB_CODE_OV = 7
    PMA_RXA_TX_MARGIN_PRE = 10, 8
    PMA_RXA_TX_MARGIN_PRE_OV = 11
    PMA_RXA_TX_MARGIN_PRE_LSB = 13, 12
    PMA_RXA_TX_MARGIN_PRE_LSB_OV = 14
    PMA_RXA_TX_PRE_LSB_CODE = 16, 15
    PMA_RXA_TX_PRE_LSB_CODE_OV = 17
    PMA_RXA_TX_PRE_CODE = 21, 18
    PMA_RXA_TX_PRE_CODE_OV = 22


class R_AUSPMA_RX_SHM_TJ_RXA_TERM_CTRL19(Register32):
    PMA_RXA_TX_TEST_EN = 21
    PMA_RXA_TX_TEST_EN_OV = 22
    PMA_RXA_TX_EN = 23
    PMA_RXA_TX_EN_OV = 24
    PMA_RXA_TX_CLK_DLY_CTRL_TAPGEN = 27, 25
    PMA_RXA_TX_CLK_DIV2_EN = 28
    PMA_RXA_TX_CLK_DIV2_EN_OV = 29
    PMA_RXA_TX_CLK_DIV2_RST = 30
    PMA_RXA_TX_CLK_DIV2_RST_OV = 31


class R_AUSPMA_RX_SHM_TJ_RXA_VREF_CTRL22(Register32):
    PMA_RXA_VREF_ADJUST_GRAY = 11, 7
    PMA_RXA_VREF_ADJUST_GRAY_OV = 12
    PMA_RXA_VREF_BIAS_SEL = 14, 13
    PMA_RXA_VREF_BIAS_SEL_OV = 15
    PMA_RXA_VREF_BOOST_EN = 16
    PMA_RXA_VREF_BOOST_EN_OV = 17
    PMA_RXA_VREF_EN = 18
    PMA_RXA_VREF_EN_OV = 19
    LPBKIN_RECOVERED_DATA = 29, 28
    PMA_RXA_TEST_RXLPBKDT_EN = 30
    PMA_RXA_TEST_RXLPBKDT_EN_OV = 31


class R_AUSPMA_RX_TOP_TJ_CFG_RX_TXMODE(Register32):
    RX_TXMODE = 0

class R_ACIOPHY_LANE_DP_CFG_BLK_TX_DP_CTRL0(Register32):
    DP_PMA_BYTECLK_RESET = 0
    DP_MAC_DIV20_CLK_SEL = 1
    DPTXPHY_PMA_LANE_RESET_N = 2
    DPTXPHY_PMA_LANE_RESET_N_OV = 3
    DPTX_PCLK1_SELECT = 6, 4
    DPTX_PCLK2_SELECT = 9, 7
    DPRX_PCLK_SELECT = 12, 10
    DPTX_PCLK1_ENABLE = 13
    DPTX_PCLK2_ENABLE = 14
    DPRX_PCLK_ENABLE = 15


class AtcPhyRegs(RegMap):
    ACIOPHY_CFG0 = 0x08, Register32
    ACIOPHY_LANE_MODE = 0x48, R_ACIOPHY_LANE_MODE
    ACIOPHY_CROSSBAR = 0x4C, R_ACIOPHY_CROSSBAR
    ACIOPHY_BIST_EN = 0x84, Register32
    ACIOPHY_BIST_OV = 0x8C, Register32
    ACIOPHY_BIST_CFG0 = 0x90, Register32
    ACIOPHY_BIST_STAT = 0x9C, Register32
    ACIOPHY_BIST_RESET = 0xA8, Register32
    ACIOPHY_BIST_CFG1 = 0xAC, Register32
    ACIOPHY_SLEEP_CTRL = 0x1B0, Register32

    AUS_COMMON_SHIM_BLK_VREG = 0x0A04, R_AUS_COMMON_SHIM_BLK_VREG

    AUSPLL_FSM_CTRL = 0x1014, R_AUSPLL_FSM_CTRL
    AUSPLL_CMD_OVERRIDE = 0x2000, R_AUSPLL_CMD_OVERRIDE
    AUSPLL_CLKOUT_DTC_VREG = 0x2220, R_AUSPLL_CLKOUT_DTC_VREG
    AUSPLL_DCO_EFUSE_SPARE = 0x222C, R_AUSPLL_DCO_EFUSE_SPARE
    AUSPLL_FRACN_CAN = 0x22A4, R_AUSPLL_FRACN_CAN

    CIO3PLL_CLK_CTRL = 0x2A00, R_CIO3PLL_CLK_CTRL
    CIO3PLL_DTC_VREG = 0x2A20, R_CIO3PLL_DTC_VREG
    CIO3PLL_DCO_NCTRL = 0x2A38, R_CIO3PLL_DCO_NCTRL
    CIO3PLL_FRACN_CAN = 0x2AA4, R_CIO3PLL_FRACN_CAN

    ATCPHY_POWER_CTRL = 0x20000, R_ATCPHY_POWER
    ATCPHY_POWER_STAT = 0x20004, R_ATCPHY_POWER
    ATCPHY_MISC = 0x20008, R_ATCPHY_MISC

    ACIOPHY_LANE_DP_CFG_BLK_TX_DP_CTRL0 = 0x7000, R_ACIOPHY_LANE_DP_CFG_BLK_TX_DP_CTRL0
    DPPHY_UNK_1028 = 0x1028, Register32
    USB2PHY_AUX_CFG_BLK_AUX_POWER_DOWN_CONTROL_0 = 0x54000, Register32

    FABRIC_TUNABLES = irange(0x45000, 0x1000 // 4, 4), Register32

    LPDPTX_AUX_CFG_BLK = irange(0x50000, 0x1000 // 4, 4), Register32
    LPDPTX_AUX_CFG_BLK_AUX_CTRL = 0x50000, Register32
    LPDPTX_AUX_CFG_BLK_AUX_LDO_CTRL = 0x50008, Register32
    LPDPTX_AUX_CFG_BLK_AUX_MARGIN = 0x5000c, Register32
    LPDPTX_AUX_SHM_CFG_BLK_AUX_CTRL_REG0 = 0x50204, Register32
    LPDPTX_AUX_SHM_CFG_BLK_AUX_CTRL_REG1 = 0x50208, Register32

    LN0_AUSPMA_RX_TOP = irange(0x9000, 0x1000 // 4, 4), Register32
    LN0_AUSPMA_RX_TOP_TJ_CFG_RX_TXMODE = 0x90F0, R_AUSPMA_RX_TOP_TJ_CFG_RX_TXMODE

    LN0_AUSPMA_RX_EQ = irange(0xA000, 0x1000 // 4, 4), Register32

    LN0_AUSPMA_RX_SHM = irange(0xB000, 0x1000 // 4, 4), Register32
    LN0_AUSPMA_RX_SHM_TJ_RXA_CTLE_CTRL0 = 0xB000, R_AUSPMA_RX_SHM_TJ_RXA_CTLE_CTRL0
    LN0_AUSPMA_RX_SHM_TJ_RXA_AFE_CTRL1 = 0xB004, R_AUSPMA_RX_SHM_TJ_RXA_AFE_CTRL1
    LN0_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL2 = 0xB008, Register32
    LN0_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL3 = 0xB00C, Register32
    LN0_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL4 = 0xB010, Register32
    LN0_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL5 = 0xB014, Register32
    LN0_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL6 = 0xB018, Register32
    LN0_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL7 = 0xB01C, Register32
    LN0_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL8 = 0xB020, Register32
    LN0_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL9 = 0xB024, Register32
    LN0_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL10 = 0xB028, R_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL10
    LN0_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL11 = 0xB02C, R_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL11
    LN0_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL12 = 0xB030, R_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL12
    LN0_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL13 = 0xB034, R_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL13
    LN0_AUSPMA_RX_SHM_TJ_UNK_CTRL14A = 0xB038, Register32
    LN0_AUSPMA_RX_SHM_TJ_UNK_CTRL14B = 0xB03C, Register32
    LN0_AUSPMA_RX_SHM_TJ_UNK_CTRL15A = 0xB040, Register32
    LN0_AUSPMA_RX_SHM_TJ_UNK_CTRL15B = 0xB044, Register32
    LN0_AUSPMA_RX_SHM_TJ_RXA_SAVOS_CTRL16 = 0xB048, R_AUSPMA_RX_SHM_TJ_RXA_SAVOS_CTRL16
    LN0_AUSPMA_RX_SHM_TJ_RXA_TX_CTRL17 = 0xB04C, R_AUSPMA_RX_SHM_TJ_RXA_TX_CTRL17
    LN0_AUSPMA_RX_SHM_TJ_RXA_TX_CTRL18 = 0xB050, R_AUSPMA_RX_SHM_TJ_RXA_TX_CTRL18
    LN0_AUSPMA_RX_SHM_TJ_RXA_TERM_CTRL19 = 0xB054, R_AUSPMA_RX_SHM_TJ_RXA_TERM_CTRL19
    LN0_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL20 = 0xB058, Register32
    LN0_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL21 = 0xB05C, Register32
    LN0_AUSPMA_RX_SHM_TJ_RXA_VREF_CTRL22 = 0xB060, R_AUSPMA_RX_SHM_TJ_RXA_VREF_CTRL22

    LN0_AUSPMA_TX_TOP = irange(0xC000, 0x1000 // 4, 4), Register32

    LN0_AUSPMA_TX_SHM = irange(0xD000, 0x1000 // 4, 4), Register32
    LN0_AUSPMA_TX_SHM_TXA_CFG_MAIN_REG0 = 0xD000, R_AUSPMA_TX_SHM_TXA_CFG_MAIN_REG0
    LN0_AUSPMA_TX_SHM_TXA_CFG_MAIN_REG1 = 0xD004, R_AUSPMA_TX_SHM_TXA_CFG_MAIN_REG1
    LN0_AUSPMA_TX_SHM_TXA_IMP_REG0 = 0xD008, R_AUSPMA_TX_SHM_TXA_IMP_REG0
    LN0_AUSPMA_TX_SHM_TXA_IMP_REG1 = 0xD00C, Register32
    LN0_AUSPMA_TX_SHM_TXA_IMP_REG2 = 0xD010, R_AUSPMA_TX_SHM_TXA_IMP_REG2
    LN0_AUSPMA_TX_SHM_TXA_IMP_REG3 = 0xD014, R_AUSPMA_TX_SHM_TXA_IMP_REG3
    LN0_AUSPMA_TX_SHM_TXA_UNK_REG0 = 0xD018, Register32
    LN0_AUSPMA_TX_SHM_TXA_UNK_REG1 = 0xD01C, Register32
    LN0_AUSPMA_TX_SHM_TXA_UNK_REG2 = 0xD020, Register32
    LN0_AUSPMA_TX_SHM_TXA_LDOCLK = 0xD024, R_AUSPMA_TX_SHM_TXA_LDOCLK

    LN1_AUSPMA_RX_TOP = irange(0x10000, 0x1000 // 4, 4), Register32
    LN1_AUSPMA_RX_TOP_TJ_CFG_RX_TXMODE = 0x100F0, R_AUSPMA_RX_TOP_TJ_CFG_RX_TXMODE

    LN1_AUSPMA_RX_EQ = irange(0x11000, 0x1000 // 4, 4), Register32

    LN1_AUSPMA_RX_SHM = irange(0x12000, 0x1000 // 4, 4), Register32
    LN1_AUSPMA_RX_SHM_TJ_RXA_CTLE_CTRL0 = 0x12000, R_AUSPMA_RX_SHM_TJ_RXA_CTLE_CTRL0
    LN1_AUSPMA_RX_SHM_TJ_RXA_AFE_CTRL1 = 0x12004, R_AUSPMA_RX_SHM_TJ_RXA_AFE_CTRL1
    LN1_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL2 = 0x12008, Register32
    LN1_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL3 = 0x1200C, Register32
    LN1_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL4 = 0x12010, Register32
    LN1_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL5 = 0x12014, Register32
    LN1_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL6 = 0x12018, Register32
    LN1_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL7 = 0x1201C, Register32
    LN1_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL8 = 0x12020, Register32
    LN1_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL9 = 0x12024, Register32
    LN1_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL10 = 0x12028, R_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL10
    LN1_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL11 = 0x1202C, R_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL11
    LN1_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL12 = 0x12030, R_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL12
    LN1_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL13 = 0x12034, R_AUSPMA_RX_SHM_TJ_RXA_DFE_CTRL13
    LN1_AUSPMA_RX_SHM_TJ_UNK_CTRL14A = 0x12038, Register32
    LN1_AUSPMA_RX_SHM_TJ_UNK_CTRL14B = 0x1203C, Register32
    LN1_AUSPMA_RX_SHM_TJ_UNK_CTRL15A = 0x12040, Register32
    LN1_AUSPMA_RX_SHM_TJ_UNK_CTRL15B = 0x12044, Register32
    LN1_AUSPMA_RX_SHM_TJ_RXA_SAVOS_CTRL16 = 0x12048, R_AUSPMA_RX_SHM_TJ_RXA_SAVOS_CTRL16
    LN1_AUSPMA_RX_SHM_TJ_RXA_TX_CTRL17 = 0x1204C, R_AUSPMA_RX_SHM_TJ_RXA_TX_CTRL17
    LN1_AUSPMA_RX_SHM_TJ_RXA_TX_CTRL18 = 0x12050, R_AUSPMA_RX_SHM_TJ_RXA_TX_CTRL18
    LN1_AUSPMA_RX_SHM_TJ_RXA_TERM_CTRL19 = 0x12054, R_AUSPMA_RX_SHM_TJ_RXA_TERM_CTRL19
    LN1_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL20 = 0x12058, Register32
    LN1_AUSPMA_RX_SHM_TJ_RXA_UNK_CTRL21 = 0x1205C, Register32
    LN1_AUSPMA_RX_SHM_TJ_RXA_VREF_CTRL22 = 0x12060, R_AUSPMA_RX_SHM_TJ_RXA_VREF_CTRL22

    LN1_AUSPMA_TX_TOP = irange(0x13000, 0x1000 // 4, 4), Register32

    LN1_AUSPMA_TX_SHM = irange(0x14000, 0x1000 // 4, 4), Register32
    LN1_AUSPMA_TX_SHM_TXA_CFG_MAIN_REG0 = 0x14000, R_AUSPMA_TX_SHM_TXA_CFG_MAIN_REG0
    LN1_AUSPMA_TX_SHM_TXA_CFG_MAIN_REG1 = 0x14004, R_AUSPMA_TX_SHM_TXA_CFG_MAIN_REG1
    LN1_AUSPMA_TX_SHM_TXA_IMP_REG0 = 0x14008, R_AUSPMA_TX_SHM_TXA_IMP_REG0
    LN1_AUSPMA_TX_SHM_TXA_IMP_REG1 = 0x1400C, Register32
    LN1_AUSPMA_TX_SHM_TXA_IMP_REG2 = 0x14010, R_AUSPMA_TX_SHM_TXA_IMP_REG2
    LN1_AUSPMA_TX_SHM_TXA_IMP_REG3 = 0x14014, R_AUSPMA_TX_SHM_TXA_IMP_REG3
    LN1_AUSPMA_TX_SHM_TXA_UNK_REG0 = 0x14018, Register32
    LN1_AUSPMA_TX_SHM_TXA_UNK_REG1 = 0x1401C, Register32
    LN1_AUSPMA_TX_SHM_TXA_UNK_REG2 = 0x14020, Register32
    LN1_AUSPMA_TX_SHM_TXA_LDOCLK = 0x14024, R_AUSPMA_TX_SHM_TXA_LDOCLK

    ACIOPHY_TOP_TUNABLE_118 = 0x118, Register32
    ACIOPHY_TOP_TUNABLE_11c = 0x11C, Register32
    ACIOPHY_TOP_TUNABLE_124 = 0x124, Register32
    ACIOPHY_TOP_TUNABLE_a00 = 0xA00, Register32
    ACIOPHY_TOP_TUNABLE_808 = 0x808, Register32

    AUSPLL_TOP_FREQ_DESC_0A = 0x2080, Register32
    AUSPLL_TOP_FREQ_DESC_0B = 0x2084, Register32
    AUSPLL_TOP_FREQ_DESC_0C = 0x2088, Register32

    AUSPLL_TOP_TUNABLE_2094 = 0x2094, Register32
    AUSPLL_TOP_TUNABLE_20a0 = 0x20A0, Register32
    AUSPLL_TOP_TUNABLE_20ac = 0x20AC, Register32
    AUSPLL_TOP_TUNABLE_20b8 = 0x20B8, Register32

    CIO3PLL_TOP_TUNABLE_10 = 0x2810, Register32
    CIO3PLL_TOP_TUNABLE_88 = 0x2888, Register32
    CIO3PLL_TOP_TUNABLE_94 = 0x2894, Register32

    CIO3PLL_CORE_TUNABLE_1c = 0x2A1C, Register32
    CIO3PLL_CORE_TUNABLE_28 = 0x2A28, Register32
    CIO3PLL_CORE_TUNABLE_9c = 0x2A9C, Register32

    AUSPLL_CORE_TUNABLE_78 = 0x2278, Register32
