/* This file creates LTTNG tracepoints probes. These are the actual trace
 * implementations that will be called when LTTNG is enabled and its shared
 * object is loaded.
 *
 * This file compiles into libntirpc_tracepoints.so, which can be dynamically
 * loaded when we want to enable LTTNG. It must include every trace header file
 * once (and only once).
 * When libntirpc_tracepoints.so is loaded, the functions generated here
 * overload the weak functions generated by lttng_defines, and allows for LTTNG
 * traces to be sent.
 */

#define TRACEPOINT_CREATE_PROBES

#ifndef LTTNG_PARSING
#include "lttng/generated_traces/generated_lttng.h"
#endif /* LTTNG_PARSING */
