/*******************************************************************************
* Copyright 2019-2021 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include "cpu/x64/jit_generator.hpp"

#include "cpu/x64/gemm/f32/common_f32.hpp"
#include "cpu/x64/gemm/f32/jit_avx_kernel_b0_sgemm_kern_autogen.hpp"

namespace dnnl {
namespace impl {
namespace cpu {
namespace x64 {

jit_avx_kernel_b0_sgemm_kern::jit_avx_kernel_b0_sgemm_kern()
    : jit_generator(nullptr, F32_COMPUTE_KERNEL_CODE_SIZE) {}

void jit_avx_kernel_b0_sgemm_kern::generate() {
    Xbyak::Label l259c;
    Xbyak::Label l2774;
    Xbyak::Label l2834;
    Xbyak::Label l2cf4;

    preamble();
    auto stacksize = get_size_of_abi_save_regs();
#ifdef _WIN32
    mov(A, ptr[OLD_A]);
    mov(B, ptr[OLD_B]);
#endif
    mov(C, ptr[OLD_C]);
    mov(LDC, ptr[OLD_LDC]);

    mov(M, qword[M]);
    mov(N, qword[N]);
    mov(K, qword[K]);

    generate_part1(l2cf4, l2834, l2774, l259c);
    generate_part2(l2cf4, l2834, l2774, l259c);

    postamble();
}

void jit_avx_kernel_b0_sgemm_kern::generate_part1(const Xbyak::Label &l2cf4,
        const Xbyak::Label &l2834, const Xbyak::Label &l2774,
        const Xbyak::Label &l259c) {
    std::vector<Xbyak::Label> labels(55);

    shl(LDC, 0x2);
    sub(A, -128);
    sub(B, -128);
    mov(J, M);
    cmp(J, 0x10);
    jl(labels[0], T_NEAR);
    align(4);

    L(labels[19]);
    mov(AA, K);
    imul(AA, AA, 0x40);
    add(AA, A);
    mov(CO1, C);
    add(C, 0x40);
    mov(BO, B);
    mov(I, N);
    cmp(I, 0x4);
    jl(labels[17], T_NEAR);
    align(4);

    L(labels[15]);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[21], T_NEAR);
    sub(H, 0x1e);
    jle(labels[23], T_NEAR);
    align(4);

    L(labels[6]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO + 0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO + 0x60]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO + 0x80]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0xa0]);
    sub(AO, -256);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[6], T_NEAR);
    align(4);

    L(labels[23]);
    prefetcht0(byte[CO1 + 0x3c]);
    prefetcht0(byte[CO1 + LDC * 1 + 0x3c]);
    prefetcht0(byte[CO2 + 0x3c]);
    prefetcht0(byte[CO2 + LDC * 1 + 0x3c]);
    add(H, 0x1e);
    align(4);

    L(labels[22]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO + 0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO + 0x60]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO + 0x80]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0xa0]);
    sub(AO, -256);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[22], T_NEAR);
    align(4);

    L(labels[21]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[18], T_NEAR);
    align(4);

    L(labels[20]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x40]);
    vmovups(ymm1, yword[AO - 0x20]);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    sub(AO, -64);
    sub(BO, -16);
    dec(H);
    jg(labels[20], T_NEAR);
    align(4);

    L(labels[18]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vblendps(ymm0, ymm12, ymm13, 0xaa);
    vblendps(ymm1, ymm12, ymm13, 0x55);
    vblendps(ymm2, ymm14, ymm15, 0xaa);
    vblendps(ymm3, ymm14, ymm15, 0x55);
    vblendps(ymm12, ymm0, ymm2, 0xcc);
    vblendps(ymm13, ymm1, ymm3, 0xcc);
    vblendps(ymm14, ymm0, ymm2, 0x33);
    vblendps(ymm15, ymm1, ymm3, 0x33);
    vmovups(yword[CO1 + 0x0], ymm8);
    vmovups(yword[CO1 + 0x20], ymm12);
    vmovups(yword[CO1 + LDC * 1 + 0x0], ymm9);
    vmovups(yword[CO1 + LDC * 1 + 0x20], ymm13);
    vmovups(yword[CO2], ymm10);
    vmovups(yword[CO2 + 0x20], ymm14);
    vmovups(yword[CO2 + LDC * 1], ymm11);
    vmovups(yword[CO2 + LDC * 1 + 0x20], ymm15);
    lea(CO1, ptr[CO1 + LDC * 4 + 0x0]);
    sub(I, 0x4);
    cmp(I, 0x4);
    jge(labels[15], T_NEAR);
    align(4);

    L(labels[17]);
    test(I, 0x2);
    jle(labels[9], T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[12], T_NEAR);
    sub(H, 0x1e);
    jle(labels[14], T_NEAR);
    align(4);

    L(labels[16]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO + 0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO + 0x60]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO + 0x80]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0xa0]);
    sub(AO, -256);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[16], T_NEAR);
    align(4);

    L(labels[14]);
    prefetcht0(byte[CO1 + 0x3c]);
    prefetcht0(byte[CO1 + LDC * 1 + 0x3c]);
    add(H, 0x1e);
    align(4);

    L(labels[13]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO + 0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO + 0x60]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO + 0x80]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0xa0]);
    sub(AO, -256);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[13], T_NEAR);
    align(4);

    L(labels[12]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[10], T_NEAR);
    align(4);

    L(labels[11]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x40]);
    vmovups(ymm1, yword[AO - 0x20]);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    sub(AO, -64);
    sub(BO, -8);
    dec(H);
    jg(labels[11], T_NEAR);
    align(4);

    L(labels[10]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vblendps(ymm0, ymm12, ymm13, 0xaa);
    vblendps(ymm1, ymm12, ymm13, 0x55);
    vblendps(ymm2, ymm14, ymm15, 0xaa);
    vblendps(ymm3, ymm14, ymm15, 0x55);
    vblendps(ymm12, ymm0, ymm2, 0xcc);
    vblendps(ymm13, ymm1, ymm3, 0xcc);
    vblendps(ymm14, ymm0, ymm2, 0x33);
    vblendps(ymm15, ymm1, ymm3, 0x33);
    vmovups(yword[CO1 + 0x0], ymm8);
    vmovups(yword[CO1 + 0x20], ymm12);
    vmovups(yword[CO1 + LDC * 1 + 0x0], ymm9);
    vmovups(yword[CO1 + LDC * 1 + 0x20], ymm13);
    lea(CO1, ptr[CO1 + LDC * 2 + 0x0]);
    align(4);

    L(labels[9]);
    test(I, 0x1);
    jle(labels[1], T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[4], T_NEAR);
    sub(H, 0x1e);
    jle(labels[7], T_NEAR);
    align(4);

    L(labels[8]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO + 0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO + 0x60]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO + 0x80]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0xa0]);
    sub(AO, -256);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[8], T_NEAR);
    align(4);

    L(labels[7]);
    prefetcht0(byte[CO1 + 0x3c]);
    add(H, 0x1e);
    align(4);

    L(labels[5]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO + 0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO + 0x60]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO + 0x80]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0xa0]);
    sub(AO, -256);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[5], T_NEAR);
    align(4);

    L(labels[4]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[2], T_NEAR);
    align(4);

    L(labels[3]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x40]);
    vmovups(ymm1, yword[AO - 0x20]);
    vbroadcastf128(ymm2, xword[BO - 0x7c]);
    sub(AO, -64);
    sub(BO, -4);
    dec(H);
    jg(labels[3], T_NEAR);
    align(4);

    L(labels[2]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vblendps(ymm0, ymm12, ymm13, 0xaa);
    vblendps(ymm1, ymm12, ymm13, 0x55);
    vblendps(ymm2, ymm14, ymm15, 0xaa);
    vblendps(ymm3, ymm14, ymm15, 0x55);
    vblendps(ymm12, ymm0, ymm2, 0xcc);
    vblendps(ymm13, ymm1, ymm3, 0xcc);
    vblendps(ymm14, ymm0, ymm2, 0x33);
    vblendps(ymm15, ymm1, ymm3, 0x33);
    vmovups(yword[CO1 + 0x0], ymm8);
    vmovups(yword[CO1 + 0x20], ymm12);
    lea(CO1, ptr[CO1 + LDC * 1 + 0x0]);
    align(4);

    L(labels[1]);
    mov(A, AO);
    sub(J, 0x10);
    cmp(J, 0x10);
    jge(labels[19], T_NEAR);
    align(4);

    L(labels[0]);
    test(J, 0x8);
    jle(labels[32], T_NEAR);
    mov(AA, K);
    imul(AA, AA, 0x20);
    add(AA, A);
    mov(CO1, C);
    add(C, 0x20);
    mov(BO, B);
    mov(I, N);
    cmp(I, 0x4);
    jl(labels[47], T_NEAR);
    align(4);

    L(labels[54]);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[50], T_NEAR);
    sub(H, 0x1e);
    jle(labels[52], T_NEAR);
    align(4);

    L(labels[53]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x20]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0x20]);
    sub(AO, -128);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[53], T_NEAR);
    align(4);

    L(labels[52]);
    prefetcht0(byte[CO1 + 0x1c]);
    prefetcht0(byte[CO1 + LDC * 1 + 0x1c]);
    prefetcht0(byte[CO2 + 0x1c]);
    prefetcht0(byte[CO2 + LDC * 1 + 0x1c]);
    add(H, 0x1e);
    align(4);

    L(labels[51]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x20]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0x20]);
    sub(AO, -128);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[51], T_NEAR);
    align(4);

    L(labels[50]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[48], T_NEAR);
    align(4);

    L(labels[49]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x60]);
    vmovups(ymm1, yword[AO - 0x40]);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    sub(AO, -32);
    sub(BO, -16);
    dec(H);
    jg(labels[49], T_NEAR);
    align(4);

    L(labels[48]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovups(yword[CO1 + 0x0], ymm8);
    vmovups(yword[CO1 + LDC * 1 + 0x0], ymm9);
    vmovups(yword[CO2], ymm10);
    vmovups(yword[CO2 + LDC * 1], ymm11);
    lea(CO1, ptr[CO1 + LDC * 4 + 0x0]);
    sub(I, 0x4);
    cmp(I, 0x4);
    jge(labels[54], T_NEAR);
    align(4);

    L(labels[47]);
    test(I, 0x2);
    jle(labels[40], T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[43], T_NEAR);
    sub(H, 0x1e);
    jle(labels[45], T_NEAR);
    align(4);

    L(labels[46]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x20]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0x20]);
    sub(AO, -128);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[46], T_NEAR);
    align(4);

    L(labels[45]);
    prefetcht0(byte[CO1 + 0x1c]);
    prefetcht0(byte[CO1 + LDC * 1 + 0x1c]);
    add(H, 0x1e);
    align(4);

    L(labels[44]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x20]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0x20]);
    sub(AO, -128);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[44], T_NEAR);
    align(4);

    L(labels[43]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[41], T_NEAR);
    align(4);

    L(labels[42]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x60]);
    vmovups(ymm1, yword[AO - 0x40]);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    sub(AO, -32);
    sub(BO, -8);
    dec(H);
    jg(labels[42], T_NEAR);
    align(4);

    L(labels[41]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovups(yword[CO1 + 0x0], ymm8);
    vmovups(yword[CO1 + LDC * 1 + 0x0], ymm9);
    lea(CO1, ptr[CO1 + LDC * 2 + 0x0]);
    align(4);

    L(labels[40]);
    test(I, 0x1);
    jle(labels[33], T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[36], T_NEAR);
    sub(H, 0x1e);
    jle(labels[38], T_NEAR);
    align(4);

    L(labels[39]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x20]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0x20]);
    sub(AO, -128);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[39], T_NEAR);
    align(4);

    L(labels[38]);
    prefetcht0(byte[CO1 + 0x1c]);
    add(H, 0x1e);
    align(4);

    L(labels[37]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x20]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO + 0x20]);
    sub(AO, -128);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[37], T_NEAR);
    align(4);

    L(labels[36]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[34], T_NEAR);
    align(4);

    L(labels[35]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x60]);
    vmovups(ymm1, yword[AO - 0x40]);
    vbroadcastf128(ymm2, xword[BO - 0x7c]);
    sub(AO, -32);
    sub(BO, -4);
    dec(H);
    jg(labels[35], T_NEAR);
    align(4);

    L(labels[34]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovups(yword[CO1 + 0x0], ymm8);
    lea(CO1, ptr[CO1 + LDC * 1 + 0x0]);
    align(4);

    L(labels[33]);
    mov(A, AO);
    align(4);

    L(labels[32]);
    test(J, 0x4);
    jle(l2cf4, T_NEAR);
    mov(AA, K);
    imul(AA, AA, 0x10);
    add(AA, A);
    mov(CO1, C);
    add(C, 0x10);
    mov(BO, B);
    mov(I, N);
    cmp(I, 0x4);
    jl(labels[24], T_NEAR);
    align(4);

    L(labels[31]);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(labels[27], T_NEAR);
    sub(H, 0x1e);
    jle(labels[29], T_NEAR);
    align(4);

    L(labels[30]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x50]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x30]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    sub(AO, -64);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[30], T_NEAR);
    align(4);

    L(labels[29]);
    prefetcht0(byte[CO1 + 0xc]);
    prefetcht0(byte[CO1 + LDC * 1 + 0xc]);
    prefetcht0(byte[CO2 + 0xc]);
    prefetcht0(byte[CO2 + LDC * 1 + 0xc]);
    add(H, 0x1e);
    align(4);

    L(labels[28]);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO + 0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x70]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA - 0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO + 0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO - 0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO - 0x50]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO - 0x30]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO + 0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO - 0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO - 0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO - 0x20]);
    sub(AO, -64);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(labels[28], T_NEAR);
    align(4);

    L(labels[27]);
    mov(H, K);
    and_(H, 0x3);
    je(labels[25], T_NEAR);
    align(4);

    L(labels[26]);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO - 0x70]);
    vmovups(ymm1, yword[AO - 0x50]);
    vbroadcastf128(ymm2, xword[BO - 0x70]);
    sub(AO, -16);
    sub(BO, -16);
    dec(H);
    jg(labels[26], T_NEAR);
    align(4);

    L(labels[25]);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovups(xword[CO1 + 0x0], xmm8);
    vmovups(xword[CO1 + LDC * 1 + 0x0], xmm9);
    vmovups(xword[CO2], xmm10);
    vmovups(xword[CO2 + LDC * 1], xmm11);
    lea(CO1, ptr[CO1 + LDC * 4 + 0x0]);
    sub(I, 0x4);
    cmp(I, 0x4);
    jge(labels[31], T_NEAR);
    align(4);

    L(labels[24]);
    test(I, 0x2);
    jle(l2834, T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO - 0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A - 0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A - 0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(l2774, T_NEAR);
    sub(H, 0x1e);
    jle(l259c, T_NEAR);
    align(4);
}

} // namespace x64
} // namespace cpu
} // namespace impl
} // namespace dnnl
