
''' Generated by OTF2 Template Engine '''

import ctypes

from .Config import conf, StrParam
from .ErrorCodes import ErrorCode, HandleErrorCode
from .GeneralDefinitions import *
from .Definitions import *
from .AttributeValue import AttributeValue


class GlobalDefWriter(ctypes.Structure):
    pass

def GlobalDefWriter_GetNumberOfDefinitions(writerHandle, numberOfDefinitions = ctypes.c_uint64()):
    c_GetNumberOfDefinitions = conf.lib.OTF2_GlobalDefWriter_GetNumberOfDefinitions
    c_GetNumberOfDefinitions.argtypes = [ ctypes.POINTER(GlobalDefWriter), ctypes.POINTER(ctypes.c_uint64) ]
    c_GetNumberOfDefinitions.restype = ErrorCode
    c_GetNumberOfDefinitions.errcheck = HandleErrorCode
    c_GetNumberOfDefinitions(writerHandle, ctypes.byref(numberOfDefinitions))
    return numberOfDefinitions.value

def GlobalDefWriter_GetNumberOfLocations(writerHandle, numberOfLocations = ctypes.c_uint64()):
    c_GetNumberOfLocations = conf.lib.OTF2_GlobalDefWriter_GetNumberOfLocations
    c_GetNumberOfLocations.argtypes = [ ctypes.POINTER(GlobalDefWriter), ctypes.POINTER(ctypes.c_uint64) ]
    c_GetNumberOfLocations.restype = ErrorCode
    c_GetNumberOfLocations.errcheck = HandleErrorCode
    c_GetNumberOfLocations(writerHandle, ctypes.byref(numberOfLocations))
    return numberOfLocations.value

@otf2 for def in defs:
@otf2  if def == IoParadigm:
def GlobalDefWriter_WriteIoParadigm(writerHandle, self, identification, name, ioParadigmClass, ioParadigmFlags, properties, types, values):
    numberOfProperties = len(properties)
    assert numberOfProperties == len(types) == len(values)
    properties_array = (IoParadigmProperty * numberOfProperties)()
    properties_array[:] = properties
    types_array = (Type * numberOfProperties)()
    types_array[:] = types
    values_array = (AttributeValue * numberOfProperties)()
    values_array[:] = values

    c_WriteIoParadigm = conf.lib.OTF2_GlobalDefWriter_WriteIoParadigm
    c_WriteIoParadigm.argtypes = [ ctypes.POINTER(GlobalDefWriter), IoParadigmRef, StringRef, StringRef, IoParadigmClass, IoParadigmFlag, ctypes.c_uint8, ctypes.POINTER(IoParadigmProperty), ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_WriteIoParadigm.restype = ErrorCode
    c_WriteIoParadigm.errcheck = HandleErrorCode
    c_WriteIoParadigm(writerHandle, self, identification, name, ioParadigmClass, ioParadigmFlags,
                      numberOfProperties, properties_array, types_array, values_array)

@otf2  elif def == Group:
def GlobalDefWriter_WriteGroup(writerHandle, self, name, groupType, paradigm, groupFlags, members):
    numberOfMembers = len(members)
    array_type = ctypes.c_uint64 * numberOfMembers
    members_array = array_type()
    members_array[:] = members

    c_WriteGroup = conf.lib.OTF2_GlobalDefWriter_WriteGroup
    c_WriteGroup.argtypes = [ ctypes.POINTER(GlobalDefWriter), GroupRef, StringRef, GroupType, Paradigm, GroupFlag,
                              ctypes.c_uint32, array_type ]
    c_WriteGroup.restype = ErrorCode
    c_WriteGroup.errcheck = HandleErrorCode
    c_WriteGroup(writerHandle, self, name, groupType, paradigm, groupFlags, numberOfMembers, members_array)

@otf2  elif def == MetricClass:
def GlobalDefWriter_WriteMetricClass(writerHandle, self, metricMembers, metricOccurrence, recorderKind):
    numberOfMetrics = len(metricMembers)
    array_type = MetricMemberRef * numberOfMetrics
    metric_member_array = array_type()
    metric_member_array[:] = metricMembers

    c_WriteMetricClass = conf.lib.OTF2_GlobalDefWriter_WriteMetricClass
    c_WriteMetricClass.argtypes = [ ctypes.POINTER(GlobalDefWriter), MetricRef, ctypes.c_uint8, array_type,
                                    MetricOccurrence, RecorderKind ]
    c_WriteMetricClass.restype = ErrorCode
    c_WriteMetricClass.errcheck = HandleErrorCode
    c_WriteMetricClass(writerHandle, MetricRef(self), numberOfMetrics, metric_member_array,
                       metricOccurrence, recorderKind)

@otf2  elif def == CartTopology:
def GlobalDefWriter_WriteCartTopology(writerHandle, self, name, communicator, cartDimensions):
    numberOfDimensions = len(cartDimensions)
    array_type = CartDimensionRef * numberOfDimensions
    cart_dimensions_array = array_type()
    cart_dimensions_array[:] = cartDimensions

    c_WriteCartTopology = conf.lib.OTF2_GlobalDefWriter_WriteCartTopology
    c_WriteCartTopology.argtypes = [ ctypes.POINTER(GlobalDefWriter), CartTopologyRef, StringRef, CommRef,
                                     ctypes.c_uint8, array_type ]
    c_WriteCartTopology.restype = ErrorCode
    c_WriteCartTopology.errcheck = HandleErrorCode
    c_WriteCartTopology(writerHandle, self, name, communicator, numberOfDimensions, cart_dimensions_array)

@otf2  elif def == CartCoordinate:
def GlobalDefWriter_WriteCartCoordinate(writerHandle, cartTopology, rank, coordinates):
    numberOfDimensions = len(coordinates)
    array_type = ctypes.c_uint32 * numberOfDimensions
    coordinates_array = array_type()
    coordinates_array[:] = coordinates

    c_WriteCartCoordinate = conf.lib.OTF2_GlobalDefWriter_WriteCartCoordinate
    c_WriteCartCoordinate.argtypes = [ ctypes.POINTER(GlobalDefWriter), CartTopologyRef, ctypes.c_uint32,
                                       ctypes.c_uint8, array_type ]
    c_WriteCartCoordinate.restype = ErrorCode
    c_WriteCartCoordinate.errcheck = HandleErrorCode
    c_WriteCartCoordinate(writerHandle, cartTopology, rank, numberOfDimensions, coordinates_array)

@otf2  else:
def GlobalDefWriter_Write@@def.name@@(writerHandle@@def.py_funcargs()@@):
    c_Write@@def.name@@ = conf.lib.OTF2_GlobalDefWriter_Write@@def.name@@
    c_Write@@def.name@@.argtypes = [ ctypes.POINTER(GlobalDefWriter)@@def.py_funcargtypes()@@ ]
    c_Write@@def.name@@.restype = ErrorCode
    c_Write@@def.name@@.errcheck = HandleErrorCode
    c_Write@@def.name@@(writerHandle@@def.py_callargs(pass_by_ref=True)@@)

@otf2  endif
@otf2 endfor
__all__ = [
    'GlobalDefWriter',
    'GlobalDefWriter_GetNumberOfDefinitions',
    'GlobalDefWriter_GetNumberOfLocations',
    @otf2 for def in defs|global_defs:
    'GlobalDefWriter_Write@@def.name@@',
    @otf2 endfor
]
