% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findMutualNN.R
\name{findMutualNN}
\alias{findMutualNN}
\title{Find mutual nearest neighbors}
\usage{
findMutualNN(data1, data2, k1, k2 = k1, BNINDEX1 = NULL, BNINDEX2 = NULL, ...)
}
\arguments{
\item{data1}{A numeric matrix containing points in the rows and variables/dimensions in the columns.}

\item{data2}{A numeric matrix like \code{data1} for another dataset with the same variables/dimensions.}

\item{k1}{Integer scalar specifying the number of neighbors to search for in \code{data1}.}

\item{k2}{Integer scalar specifying the number of neighbors to search for in \code{data2}.}

\item{BNINDEX1}{A pre-built index for \code{data1}.
If \code{NULL}, this is constructed from \code{data1} within the internal \code{\link{queryKNN}} call.}

\item{BNINDEX2}{A pre-built index for \code{data2}.
If \code{NULL}, this is constructed from \code{data2} within the internal \code{\link{queryKNN}} call.}

\item{...}{Other arguments to be passed to the underlying \code{\link{queryKNN}} calls, e.g., \code{BNPARAM}, .}
}
\value{
A list containing the integer vectors \code{first} and \code{second}, containing row indices from \code{data1} and \code{data2} respectively.
Corresponding entries in \code{first} and \code{second} specify a MNN pair consisting of the specified rows from each matrix.
}
\description{
Find mutual nearest neighbors (MNN) across two data sets.
}
\details{
For each point in dataset 1, the set of \code{k2} nearest points in dataset 2 is identified.
For each point in dataset 2, the set of \code{k1} nearest points in dataset 1 is similarly identified.
Two points in different datasets are considered to be part of an MNN pair if each point lies in the other's set of neighbors.
This concept allows us to identify matching points across datasets, which is useful for, e.g., batch correction.

Any values for the \code{BNINDEX1} and \code{BNINDEX2} arguments should be equal to the output of \code{\link{buildIndex}} for the respective matrices,
using the algorithm specified with \code{BNPARAM}.
These arguments are only provided to improve efficiency during repeated searches on the same datasets (e.g., for comparisons between all pairs).
The specification of these arguments should not, generally speaking, alter the output of the function.
}
\examples{
B1 <- matrix(rnorm(10000), ncol=50) # Batch 1 
B2 <- matrix(rnorm(10000), ncol=50) # Batch 2
out <- findMutualNN(B1, B2, k1=20)
head(out$first)
head(out$second)

}
\seealso{
\code{\link{queryKNN}} for the underlying neighbor search code.

\code{fastMNN} and related functions from the \pkg{batchelor} package, from which this code was originally derived.
}
\author{
Aaron Lun
}
