% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{GenExtremeValue}
\alias{GenExtremeValue}
\alias{dgen_extreme_value}
\alias{pgen_extreme_value}
\alias{rgen_extreme_value}
\title{The Generalized Extreme Value Distribution}
\usage{
dgen_extreme_value(x, mu = 0, sigma = 1, xi = 0, log = FALSE)

pgen_extreme_value(
  q,
  mu = 0,
  sigma = 1,
  xi = 0,
  lower.tail = TRUE,
  log.p = FALSE
)

rgen_extreme_value(n, mu = 0, sigma = 1, xi = 0)
}
\arguments{
\item{x, q}{Vector of quantiles.}

\item{mu}{Vector of locations.}

\item{sigma}{Vector of scales.}

\item{xi}{Vector of shapes.}

\item{log}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{lower.tail}{Logical; If \code{TRUE} (default), return P(X <= x). 
Else, return P(X > x) .}

\item{log.p}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{n}{Number of samples to draw from the distribution.}
}
\description{
Density, distribution function, and random generation 
for the generalized extreme value distribution with 
location \code{mu}, scale \code{sigma} and shape \code{xi}.
}
\details{
See \code{vignette("brms_families")} for details
on the parameterization.
}
