% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/literal_coercion_linter.R
\name{literal_coercion_linter}
\alias{literal_coercion_linter}
\title{Require usage of correctly-typed literals over literal coercions}
\usage{
literal_coercion_linter()
}
\description{
\code{as.integer(1)} (or \code{rlang::int(1)}) is the same as \code{1L} but the latter is
more concise and gets typed correctly at compilation.
}
\details{
The same applies to missing sentinels like \code{NA} -- typically, it is not
necessary to specify the storage type of \code{NA}, but when it is, prefer
using the typed version (e.g. \code{NA_real_}) instead of a coercion
(like \code{as.numeric(NA)}).
}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}, \link[=efficiency_linters]{efficiency}
}
