% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression.R
\name{RRSE}
\alias{RRSE}
\title{Root Relative Squared Error Loss}
\usage{
RRSE(y_pred, y_true)
}
\arguments{
\item{y_pred}{Estimated target values vector}

\item{y_true}{Ground truth (correct) target values vector}
}
\value{
Root Relative Squared Error Loss
}
\description{
Compute the root relative squared error regression loss.
}
\examples{
data(cars)
reg <- lm(log(dist) ~ log(speed), data = cars)
RRSE(y_pred = exp(reg$fitted.values), y_true = cars$dist)
}

