% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wk-utils.R
\name{wk_handle.s2_geography}
\alias{wk_handle.s2_geography}
\alias{s2_geography_writer}
\alias{wk_writer.s2_geography}
\alias{s2_trans_point}
\alias{s2_trans_lnglat}
\alias{s2_projection_plate_carree}
\alias{s2_projection_mercator}
\alias{s2_hemisphere}
\alias{s2_world_plate_carree}
\alias{s2_projection_orthographic}
\title{Low-level wk filters and handlers}
\usage{
\method{wk_handle}{s2_geography}(
  handleable,
  handler,
  ...,
  s2_projection = s2_projection_plate_carree(),
  s2_tessellate_tol = Inf
)

s2_geography_writer(
  oriented = FALSE,
  check = TRUE,
  projection = s2_projection_plate_carree(),
  tessellate_tol = Inf
)

\method{wk_writer}{s2_geography}(handleable, ...)

s2_trans_point()

s2_trans_lnglat()

s2_projection_plate_carree(x_scale = 180)

s2_projection_mercator(x_scale = 20037508.3427892)

s2_hemisphere(centre)

s2_world_plate_carree(epsilon_east_west = 0, epsilon_north_south = 0)

s2_projection_orthographic(centre = s2_lnglat(0, 0))
}
\arguments{
\item{handleable}{A geometry vector (e.g., \code{\link[wk:wkb]{wkb()}}, \code{\link[wk:wkt]{wkt()}}, \code{\link[wk:xy]{xy()}},
\code{\link[wk:rct]{rct()}}, or \code{\link[sf:sfc]{sf::st_sfc()}}) for which \code{\link[wk:wk_handle]{wk_handle()}} is defined.}

\item{handler}{A \link[wk:wk_handle]{wk_handler} object.}

\item{...}{Passed to the \code{\link[wk:wk_handle]{wk_handle()}} method.}

\item{oriented}{TRUE if polygon ring directions are known to be correct
(i.e., exterior rings are defined counter clockwise and interior
rings are defined clockwise).}

\item{check}{Use \code{check = FALSE} to skip error on invalid geometries}

\item{projection, s2_projection}{One of \code{\link[=s2_projection_plate_carree]{s2_projection_plate_carree()}} or
\code{\link[=s2_projection_mercator]{s2_projection_mercator()}}}

\item{tessellate_tol, s2_tessellate_tol}{An angle in radians.
Points will not be added if a line segment is within this
distance of a point.}

\item{x_scale}{The maximum x value of the projection}

\item{centre}{The center point of the orthographic projection}

\item{epsilon_east_west, epsilon_north_south}{Use a positive number to
define the edges of a Cartesian world slightly inward from -180, -90,
180, 90. This may be used to define a world outline for a projection where
projecting at the extreme edges of the earth results in a non-finite value.}
}
\value{
\itemize{
\item \code{s2_projection_plate_carree()}, \code{s2_projection_mercator()}: An external pointer
to an S2 projection.
}
}
\description{
Low-level wk filters and handlers
}
