% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{use_github_links}
\alias{use_github_links}
\title{Use GitHub links in URL and BugReports}
\usage{
use_github_links(
  auth_token = deprecated(),
  host = deprecated(),
  overwrite = FALSE
)
}
\arguments{
\item{host, auth_token}{\lifecycle{defunct}: No longer consulted now that
usethis consults the current project's GitHub remotes to get the \code{host} and
then relies on gh to discover an appropriate token.}

\item{overwrite}{By default, \code{use_github_links()} will not overwrite existing
fields. Set to \code{TRUE} to overwrite existing links.}
}
\description{
Populates the \code{URL} and \code{BugReports} fields of a GitHub-using R package with
appropriate links. The GitHub repo to link to is determined from the current
project's GitHub remotes:
\itemize{
\item If we are not working with a fork, this function expects \code{origin} to be a
GitHub remote and the links target that repo.
\item If we are working in a fork, this function expects to find two GitHub
remotes: \code{origin} (the fork) and \code{upstream} (the fork's parent) remote. In
an interactive session, the user can confirm which repo to use for the
links. In a noninteractive session, links are formed using \code{upstream}.
}
}
\examples{
\dontrun{
use_github_links()
}

}
