.TH READSTAT 1 "23 January 2019"
.SH NAME
readstat \- read and write data set files from SAS, SPSS, and Stata
.SH SYNOPSIS
.B readstat
.IR input-file
.P
.B readstat
[\fB-f\fR]
.IR input-file
.IR output-file
.P
.B readstat
[\fB-f\fR]
.IR input-file
.IR metadata-file
.IR output-file
.SH DESCRIPTION
.B readstat
converts data set files from popular statistics packages stored in both plain-text and binary formats.
.PP
In the first invocation style,
.B readstat
displays metadata from \fIinput\-file\fR, including the row count, column count, text encoding, and timestamp.
.IR input\-file
should be a file with one of the following extensions:
.TP
.IR sas7bdat
SAS binary file, created with SAS version 7 or newer
.TP
.IR xpt
SAS portable file, version 5 or version 8, created with the SAS XPORT command
.TP
.IR sav
SPSS uncompressed binary file
.TP
.IR zsav
SPSS compressed binary file
.TP
.IR por
SPSS portable file
.TP
.IR dta
Stata binary file, version 104 or newer
.PP
If the row count cannot be determined from the file header, which is sometimes the case with SPSS binary files and always the case with SPSS portable files,
.B readstat
will report a value of -1.
.PP
In the second invocation style,
.B readstat
converts
.IR input-file
to \fIoutput-file\fR, e.g. a SAS portable file to a Stata binary file. 
In addition to the preceding extension list, \fIoutput-file\fR may have extension
.IR csv
or
\fIxlsx\fR, which creates a CSV or Excel file, respectively.
.PP
The third invocation style is used when additional metadata about the input
file, such as value labels or column widths, is stored in a separate file.
Several types of metadata file are supported:
.TP
.IR sas7bcat
SAS binary "catalog" file, created with SAS version 7 or newer, containing
value labels
.TP
.IR json
JavaScript Object Notation (JSON) file, containing column metadata that
cannot be gleaned from the input CSV. For details, see the manual page for 
the \fBextract_metadata\fR command.
.TP
.IR dct
Stata dictionary file, containing the data layout and column metadata for
a plain-text input file.
.TP
.IR sps
SPSS command file, describing the data layout and column metadata for a
plain-text input file.
.TP
.IR sps
SAS command file, describing the data layout and column metadata for a
plain-text input file.
.PP
The last three formats can be used for both fixed-width and delimiter-separated
(e.g. tab-separated) input files. These are commonly distributed along with
plain-text ASCII data sets.
.PP
Both input and output formats are implied by the file extension.
.SH OPTIONS
.TP
.BR \-f
Overwrite any existing \fIoutput-file\fR.
.SH BUGS
SAS binary files created by \fBreadstat\fR do not open with current versions of
SAS.
.PP
The finer details of format strings (e.g. "%8.2g") are not properly
converted between file formats.
.SH AUTHOR
Copyright (C) 2012-2019 Evan Miller, and others where indicated.
