/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import spec.jbb.JBButil;
import spec.reporter.ReportProps;
import spec.reporter.Table;

public class TableGroup {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2000-2005 Hewlett-Packard,All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    public static final int MAXGROUPS = 10;
    public static final int MAXROWS = 10;
    public static final int MAXCOLUMNS = 3;
    Table[][][] tables = new Table[10][3][10];
    int[][] rows = new int[10][3];
    boolean[][] anyEntry = new boolean[10][3];
    private ReportProps props;
    private static String tableBegin = "<TABLE WIDTH=\"100%\" BORDER=0 CELLSPACING=0 CELLPADDING=2>\n";
    private static String firstColumn = "<TR><TD WIDTH=\"50%\" VALIGN=\"TOP\">\n";
    private static String otherColumn = "</TD><TD WIDTH=\"50%\" VALIGN=\"TOP\">\n";
    private static String tableEnd = "</TD></TR></TABLE>";

    TableGroup(BufferedReader bufferedReader, ReportProps reportProps, ReportProps reportProps2) throws IllegalArgumentException {
        this.props = reportProps;
        String string = "Untitled";
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                boolean bl;
                if (string2.startsWith("Title")) {
                    string = string2.substring(5).trim();
                    continue;
                }
                if (!string2.startsWith("Table")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(5));
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                boolean bl2 = bl = Integer.parseInt(stringTokenizer.nextToken()) == 1;
                if (n2 < 0 || n2 >= 10 || n3 < 0 || n3 >= 3) {
                    throw new IllegalArgumentException(string);
                }
                int[] nArray = this.rows[n2];
                int n4 = n3;
                nArray[n4] = nArray[n4] + 1;
                if (n < 0 || n >= 10) {
                    throw new IllegalArgumentException(string);
                }
                this.tables[n2][n3][n] = new Table(string, bufferedReader, reportProps, reportProps2, bl);
                this.anyEntry[n2][n3] = true;
            }
        }
        catch (IOException iOException) {
            JBButil.getLog().log(Level.WARNING, "Error: " + iOException, iOException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(tableBegin);
        for (int i = 0; i < 10; ++i) {
            Table table;
            int n;
            if (!this.anyEntry[i][0]) continue;
            stringBuffer.append(firstColumn);
            for (n = 0; n < 10; ++n) {
                table = this.tables[i][0][n];
                if (table == null) continue;
                stringBuffer.append(table.toString());
            }
            for (n = 1; n < 3; ++n) {
                if (!this.anyEntry[i][n]) continue;
                stringBuffer.append(otherColumn);
                for (int j = 0; j < 10; ++j) {
                    table = this.tables[i][n][j];
                    if (table == null) continue;
                    stringBuffer.append(table.toString());
                }
            }
        }
        stringBuffer.append(tableEnd);
        return stringBuffer.toString();
    }
}

