/*
 * SFDoubleItem.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include "SFDoubleItem.h"
#include "SFDouble.h"
#include "FieldView.h"
#include "swt.h"

SFDoubleItem::SFDoubleItem(FieldView *view)
  : FieldViewItem(view)
{
}

FieldValue *
SFDoubleItem::OnMouseMove(FieldValue *value, int /* index */, int delta)
{
    return new SFDouble(((SFDouble *) value)->getValue() + delta * 0.02f);
}

void
SFDoubleItem::Draw(SDC dc, int x, int y)
{
    char buf[128];

    mysnprintf(buf, 128, "%g", ((SFDouble *) _value)->getValue());
    swDrawText(dc, x, y+_view->GetItemHeight() - 3, buf);
}


void
SFDoubleItem::StartEditing(MyString &str, int /* offset */)
{
    char buf[128];

    mysnprintf(buf, 128, "%g", ((SFDouble *) _value)->getValue());
    str = buf;
}

FieldValue *
SFDoubleItem::StopEditing(const char *str, int /* offset */)
{
    return new SFDouble(atof(str));
}
