.TH XXGDB 1.10 "November 1994" "X Version 11"
.SH NAME
xxgdb \- X window system interface to the gdb debugger.
.SH SYNOPSIS
.B xxgdb
[ \fI-toolkitoption ... \fP] [\fI-xxgdboption ... \fP] [\fI-gdboption ... \fP] [\fIobjfile\fP 
[ \fIcorefile\fP ]]
.SH DESCRIPTION
\fIXxgdb\fP is a graphical user interface to the \fIgdb\fP debugger under the
X Window System.  It provides visual feedback and mouse input for the
user to control program execution through breakpoints, to examine and
traverse the function call stack, to display values of
variables and data structures, and to browse source files and functions.
.LP
\fIXxgdb\fP allows initial gdb commands stored in the file \fI.gdbinit\fP 
to be executed immediately after the symbolic information is 
read.  If \fI.gdbinit\fP does not exist in the current directory, the 
user's home directory is searched (\fI~/.gdbinit\fP). Option -nx
can be used to prevent xxgdb from executing this file. Option -i
can be used to change the file name of command file.
.LP
\fIObjfile\fP is an object file produced by a compiler with the
appropriate option (-g) specified to produce symbol table
information for gdb.
.LP
If a file named \fIcore\fP exists in the current directory or a
\fIcorefile\fP is specified, \fIxxgdb\fP can be used to examine the
state of the program when the core dump occurred.
.LP
The name of the debugger invoked by \fIxxgdb\fP is, by default, gdb, but
it can be overridden with the environment variable XXGDB_DEBUGGER or with
the db_name option.
.SH OPTIONS
\fIXxgdb\fP accepts all of the standard X Toolkit command line options 
(see \fIX\fP(1)), and all the gdb options (see \fIgdb\fP(1)), plus
the following xxgdb specific options:
.IP -db_name debuggername
Specify the name of the debugger to override the default "gdb".
WARNING : by default prompt is the name of the debugger enclosed in
parenthesis followed by a space. So if the prompt is still "(gdb) ",
you HAVE TO use -db_prompt "gdb"
.IP -db_prompt promptstring
Specify to xxgdb what is the debugger prompt. The default is to
expect the prompt to be the name of the debugger enclosed in
parenthesis followed by a space (eg, "(gdb) ").
.IP -i filename
Specify the filename of initial gdb command file. The default
is ".gdbinit".
.IP -nx
Do not execute .gdbinit file (or file specified with -i)
.IP -bigicon
Uses a 64x64 icon instead of the default 48x48 icon.
.SH SUBWINDOWS
\fIXxgdb\fP consists of the following subwindows:
.IP "File Window" 20
Display the full pathname of the file displayed in the source window,
and the line number of the caret.
.IP "Source Window" 20
Display the contents of a source file.
.IP "Message Window" 20
Display the execution status and error messages of \fIxxgdb\fP .
.IP "Command Window" 20
Provide a list of the common gdb commands which are invoked by simply
clicking the LEFT mouse button.
.IP "Dialogue Window" 20
Provide a typing interface to gdb.
.IP "Display Window" 20
Provide a window for displaying variables each time execution stops.
.IP "Popup Windows" 20
Provide windows for displaying variables (see "Displaying C Data
Structures" below).
.LP
The relative sizes of the source window, command window, and the dialogue
window can be adjusted by dragging the grip (a small square near the
right edge of a horizontal border) with the LEFT mouse button down.
.SH SELECTION
Text selection in the source window is modified to make it easier to
select C expressions.  LEFT mouse button down selects a C expression by
highlighting it in reverse-video.  LEFT mouse button down also positions the
caret and updates the line label accordingly.
.LP
C expression selection is based on the resource \fIdelimiters\fP which
determines the set of characters that delimits a C expression.  (The
default word selection behavior in the Athena text widget selects a
word delimited by white spaces.)  Text selection adjustment is possible
by holding the LEFT mouse button down and dragging.
.LP
A LEFT mouse button click with the SHIFT button down prints the value
of the expression selected.
.LP
.SH SCROLLBAR
Pressing the LEFT mouse button scrolls the text forward, whereas
pressing the RIGHT mouse button scrolls the text backward.  The amount
of scrolling depends on the distance of the pointer button away from
the top of the scrollbar.  If the button is pressed at the top of the
scrollbar, only one line of text is scrolled.  If the button is pressed
at the bottom of the scrollbar, one screenful of text is scrolled.
.LP
Pressing the MIDDLE mouse button changes the thumb position of the
scrollbar.  Dragging the MIDDLE mouse button down moves the thumb along
and changes the text displayed.

.SH IOWIN COMMAND
If compiled, with the right option, xxgdb can use a separate io window
to talk to gdb, so program output is not confused with gdb output.
Type command 'iowin' in Dialogue Window to create io window. If you
get 'Undefined command' error message, then xxgdb was not compiled for
that feature. The program xxgdbiowin is used for this io window.

.SH COMMAND BUTTONS
.SS "Execution Commands"
.IP "\fBrun\fP" 12
Begin program execution.
.IP "\fBcont\fP"
Continue execution from where it stopped.
.IP "\fBnext\fP"
Execute one source line, without stepping into any function call.
.IP "\fBstep\fP"
Execute one source line, stepping into a function if the source line
contains a function call.
.IP "\fBfinish\fP"
Continue execution until the selected procedure
returns; the current procedure is used if none is selected.

.LP
.SS "Breakpoint Commands"
.IP "\fBbreak\fP" 10
Stop program execution at the line or in the function selected.  To
set a breakpoint in 
the program, place the caret at the start of the source line or on the
function name and click
the \fBbreak\fP button.  A stop sign will appear next to the source line.
.IP "\fBtbreak\fP" 10
Set a breakpoint enabled only for one stop.  This is the same as the
\fBbreak\fP button except the breakpoint is automatically disabled the
first time it hit.
.IP "\fBdelete\fP"
Remove the breakpoint on the source line selected or the breakpoint
number selected.
.IP "\fBshow brkpts\fP"
Show the current breakpoints (both active and inactive).

.LP
.SS "Stack Commands"
.IP "\fBstack\fP" 10
Show a stack trace of the functions called.
.IP "\fBup\fP"
Move up one level on the call stack.
.IP "\fBdown\fP"
Move down one level on the call stack.

.LP
.SS "Data Display Commands"
.IP "\fBprint\fP" 10
Print the value of a selected expression. (also see "Displaying C Data
Structures" below)
.IP "\fBprint *\fP"
Print the value of the object the selected expression is pointing to.
(also see "Displaying C Data Structures" below)
.IP "\fBdisplay\fP"
Display the value of a selected expression in the display window,
updating its value every time execution stops.
.IP "\fBundisplay\fP"
Stop displaying the value of the selected expression in the display
window.  If the selected expression is a constant, it refers to the
display number associated with an expression in the display window.
.IP "\fBargs\fP"
Print the arguments of the selected frame.
.IP "\fBshow display\fP"
Show the names of currently displayed expressions.
	.IP "\fBlocals\fP"
Print the local variables of the selected frame.
.IP "\fBstack\fP"
Print a backtrace of the entire stack.

.LP
.SS "Miscellaneous Commands"
.IP "\fBsearch\fP"
Pop up a search panel which allows both forward (>>) and reverse (<<)
search of text strings in the source file.  Hitting carriage return
after entering the search string will begin a forward search and pop
down the search panel.
.IP "\fBfile\fP"
Pop up a directory browser that allows the user to move up and down
in the directory tree, to select a text file to be displayed, to
select an executable file to debug, or to select a core file to debug.
Directory entries are marked with a trailing slash (`/') and executables
with a trailing asterisk (`*').  Filenames beginning with a dot (`.')
or ending with a tilde (`~') are not listed in the menu.
.IP "\fBsearch\fP"
Pop up a search panel which allows both forward (>>) and reverse (<<)
search of text strings in the source file.  Hitting carriage return
after entering the search string will begin a forward search and pop
down the search panel.
.IP "\fByes\fP"
Send 'y' (yes) to gdb. To be used when gdb requires a yes/no response.
.IP "\fBno\fP"
Send 'n' (no) to gdb. To be used when gdb requires a yes/no response.
.IP "\fBquit\fP"
Exit \fIxxgdb\fP.

.LP
.SS "Displaying C Data Structures
\fIXxgdb\fP provides some primitive support for graphically displaying C
structures and the ability of following pointers.  Pressing the RIGHT
mouse button on the \fBprint\fP (or \fBprint *\fP) command button
displays the value of the selected expression (or the value the
selected expression is pointing to) in a popup.  If the value is a
pointer or a structure containing pointers, the user can examine the
value of the object that pointer is pointing to by clicking the pointer
value.  This will create another popup that displays the object the
pointer points to.  Clicking the label of the popup pops down itself
and all of its descendants.
.SH X DEFAULTS
To change the default values of widget resources used in \fIxxgdb\fP,
you need to reference the widgets by name or by class.  The widget
hierarchies for the main window, the file menu, the search dialog box,
and the popup data display used in xxgdb are shown as follows, with the
name of the widget followed by the name of its class in parentheses:
.nf

Main window:
    toplevel (ToplevelShell)
      vpane (Paned)
	fileWindow (Form)
	  fileLabel (Label)
	  lineLabel (Label)
	sourceForm (Form)
	  sourceWindow (AsciiText)
	messageWindow (Label)
	commandWindow (Box)
	  run (Command)
	  cont (Command)
	  next (Command)
	  step (Command)
	  finish (Command)
	  break (Command)
	  tbreak (Command)
	  delete (Command)
	  up (Command)
	  down (Command)
	  print (Command)
	  print * (Command)
	  display (Command)
	  undisplay (Command)
	  args (Command)
	  locals (Command)
	  stack (Command)
	  search (Command)
	  file (Command)
	  show display (Command)
	  show brkpts (Command)
	  yes (Command)
	  no (Command)
	  quit (Command)
	dialogWindow (AsciiText)
	displayWindow (AsciiText)
   
File menu:
    File Directory (TransientShell)
      popup (Paned)
	fileMenuLabel (Label)
	fileMenu (List)
	cancelButton (Command)

Search dialog box:
    Search (TransientShell)
      searchPopup (Dialog)
	<< (Command)
	>> (Command)
	DONE (Command)

Data display popup:
    Data Popup (TransientShell)
      popup (Form)
	label (Label)
	dataDpyWindow (AsciiText)
.LP
.fi
In addition to the standard X resources, \fIxxgdb\fP uses the following
application-specific resources for user customization.  The value in
parentheses is the default value.
.IP \fBbell\fP
If True, the bell is on. (True)
.IP \fBdisplayWindow\fP
If True, the display window appears on start up. (False)
.IP \fBdelimiters\fP
The set of delimiters for word selection. (" !%^&*()+=~|;:{},/#<?\"\n\t")
.IP \fBstop_color\fP
Color of the stop sign. (Red)
.IP \fBarrow_color\fP
Color of the arrow sign. (Blue)
.IP \fBupdown_color\fP
Color of the updown sign. (Blue)
.IP \fBbomb_color\fP
Color of the bomb sign. (Red)
.IP \fBdataDpyMaxHeight\fP
Maximum height of the data display window. (300)
.IP \fBdataDpyMaxWidth\fP
Maximum width of the data display window. (600)
.IP \fBprompt\fP
The prompt string used in xxgdb. ("(xxgdb) ")
.IP \fBdb_name\fP
The name of the debugger program. ("gdb")
.IP \fBdb_prompt\fP
The prompt string of the debugger program. ("(gdb) ")
.IP \fBgdbinit\fP
The filename of initial command file. (".gdbinit")
.IP \fBnx\fP
If True, xxgdb will not execute .gdbinit at start-up. (False)
.IP \fBtabstop\fP
When displaying source code, the width (in spaces) of a tab. (8)
.LP

.SH FILES
.nf
a.out 		default object file
core 		default core file
~/XDbx		resources file (or /usr/lib/X11/app-defaults/XDbx)
\&.gdbinit 		local initial commands file
~/.gdbinit 	user's initial commands file
.SH SEE ALSO
X(1), gdb(1)
.SH COPYRIGHT
Copyright 1989 The University of Texas at Austin.
Copyright 1990 Microelectronics and Computer Technology Corporation.
Copyright 1990-1994 Thomson Consumer Electronics, Inc.
.SH AUTHOR
Po Cheung.
Pierre Willard.

